/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cmpBudget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.data.ColumnAttributes;
import com.kingdee.shr.validaterule.formula.base.data.DataRow;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.data.DataTable;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CmpBudgetBusinessDataCommon
extends CalculatorBusinessDataCommon {
    private static final Logger logger = Logger.getLogger(CmpBudgetBusinessDataCommon.class);

    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        Map<String, Map<String, Map<String, Object>>> groupByCalIdAndCostOrgIdMap;
        List<String> standingBookTableFieldSn = this.getStandingBookTableFieldSn(initCalData);
        initCalData.getAssTable().remove("T_HR_SCmpStandingBook");
        Map assTable = initCalData.getAssTable();
        String mainTableName = initCalData.getMainTableName();
        String assTableV = (String)assTable.get(mainTableName);
        assTable.put(mainTableName, null == assTableV ? mainTableName + ".S1" : assTableV + "," + mainTableName + ".S1");
        DataSet dataSet = super.initCalData(initCalData);
        try {
            List<List<Map<String, Object>>> segmDataList = this.initCostBearData(initCalData);
            groupByCalIdAndCostOrgIdMap = this.groupByCalIdAndCostOrgId(segmDataList);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DataTable mainTable = dataSet.getTables(initCalData.getMainTableName());
        DataTable dataTable = this.genCostBearDataRow(initCalData, mainTable, groupByCalIdAndCostOrgIdMap, standingBookTableFieldSn);
        for (int i = 0; i < dataSet.tableCount(); ++i) {
            DataTable table = dataSet.getTables(i);
            table.datas = dataTable.datas;
        }
        return dataSet;
    }

    protected DataTable genCostBearDataRow(InitCalData initCalData, DataTable mainTable, Map<String, Map<String, Map<String, Object>>> groupByCalIdAndCostOrgIdMap, List<String> standingBookTableFieldSn) throws EASBizException {
        DataTable cloneDataTable = new DataTable();
        ArrayList cloneColumns = cloneDataTable.columns = mainTable.columns;
        this.reBuildColAttrs(cloneDataTable, cloneColumns, standingBookTableFieldSn);
        String mainTableAlias = initCalData.getMainTableAlias();
        cloneDataTable.datas = Lists.newArrayList();
        cloneDataTable.tablename = mainTable.tablename;
        cloneDataTable.datasIndexMap = Maps.newHashMap();
        for (DataRow dataRow : mainTable.datas) {
            String cmpCalTableId = (String)dataRow.getValue("FID");
            if (groupByCalIdAndCostOrgIdMap.get(cmpCalTableId) == null) continue;
            Map<String, Map<String, Object>> groupByCostOrgIdMap = groupByCalIdAndCostOrgIdMap.get(cmpCalTableId);
            for (Map.Entry<String, Map<String, Object>> entry : groupByCostOrgIdMap.entrySet()) {
                String costOrgId = entry.getKey();
                Map<String, Object> costBearMap = entry.getValue();
                String id = (String)costBearMap.get("FID");
                DataRow cloneDataRow = new DataRow();
                cloneDataRow.columns = cloneColumns;
                cloneDataTable.addRow(cloneDataRow, id);
                for (ColumnAttributes colAttr : cloneColumns) {
                    String colName = colAttr.getName();
                    colName = colName.toUpperCase(Locale.ENGLISH);
                    int index = colAttr.getIndex();
                    if (colName.equals("FID")) {
                        cloneDataRow.add((Object)id);
                        continue;
                    }
                    if (colName.equals("FCALID")) {
                        cloneDataRow.add((Object)cmpCalTableId);
                        continue;
                    }
                    if (colName.equals("CAL_COSTORG.ID")) {
                        cloneDataRow.add((Object)costOrgId);
                        continue;
                    }
                    if (colName.startsWith(mainTableAlias + ".S")) {
                        String fieldSn = colName.replace(mainTableAlias + ".", "");
                        Object fieldV = costBearMap.get(fieldSn + "C");
                        cloneDataRow.add(fieldV);
                        continue;
                    }
                    if (colName.startsWith("T_HR_SCMPSTANDINGBOOK")) {
                        cloneDataRow.add(null);
                        continue;
                    }
                    cloneDataRow.add(dataRow.getValue(colName));
                }
            }
        }
        if (logger.isDebugEnabled()) {
            List columnNames = Arrays.stream(((DataRow)cloneDataTable.datas.get(0)).getAllColumns()).map(m -> m.getName()).collect(Collectors.toList());
            logger.debug((Object)("cloneDataTable: " + ((DataRow)cloneDataTable.datas.get(0)).getDatarow() + "column: " + columnNames));
        }
        return cloneDataTable;
    }

    protected void reBuildColAttrs(DataTable cloneDataTable, ArrayList<ColumnAttributes> cloneColumns, List<String> standingBookTableFieldSn) {
        ColumnAttributes calAttr = cloneDataTable.newColumn("FCALID", 20, null);
        calAttr.setIndex(cloneColumns.size());
        cloneColumns.add(calAttr);
        calAttr = cloneDataTable.newColumn("CAL_COSTORG.ID", 20, null);
        calAttr.setIndex(cloneColumns.size());
        cloneColumns.add(calAttr);
        for (String fieldSn : standingBookTableFieldSn) {
            calAttr = cloneDataTable.newColumn("T_HR_SCMPSTANDINGBOOK_" + fieldSn, 10, null);
            calAttr.setIndex(cloneColumns.size());
            cloneColumns.add(calAttr);
        }
        for (ColumnAttributes attr : cloneColumns) {
            attr.setReturn(Boolean.TRUE.booleanValue());
        }
    }

    protected Map<String, Map<String, Map<String, Object>>> groupByCalIdAndCostOrgId(List<List<Map<String, Object>>> segmDataList) {
        HashMap groupByCalIdAndCostOrgIdMap = Maps.newHashMap();
        for (List<Map<String, Object>> segmData : segmDataList) {
            for (Map<String, Object> tableMap : segmData) {
                String cmpCalTableId = (String)tableMap.get("FCmpCalTableID");
                String costBearOrgId = (String)tableMap.get("FCOSTBEARORGID");
                groupByCalIdAndCostOrgIdMap.putIfAbsent(cmpCalTableId, Maps.newHashMap());
                Map groupByCostOrgIdMap = (Map)groupByCalIdAndCostOrgIdMap.get(cmpCalTableId);
                groupByCostOrgIdMap.putIfAbsent(costBearOrgId, Maps.newHashMap());
                Map costBearMap = (Map)groupByCostOrgIdMap.get(costBearOrgId);
                tableMap.forEach((k, v) -> {
                    if (!k.equals("FCmpCalTableID") && !k.equals("FCOSTBEARORGID")) {
                        costBearMap.put(k, v);
                    }
                });
            }
        }
        return groupByCalIdAndCostOrgIdMap;
    }

    protected List<String> getMainTableFieldSn(InitCalData initCalData) {
        Map assTable = initCalData.getAssTable();
        if (assTable == null || assTable.get(initCalData.getMainTable()) == null) {
            return Lists.newArrayList();
        }
        String[] formulas = ((String)assTable.get(initCalData.getMainTable())).split(",");
        ArrayList fieldSnList = Lists.newArrayList();
        for (String formula : formulas) {
            String fieldSn = formula.split("\\.")[1];
            fieldSnList.add(fieldSn);
        }
        return fieldSnList;
    }

    protected List<String> getStandingBookTableFieldSn(InitCalData initCalData) {
        Map assTable = initCalData.getAssTable();
        if (assTable == null || assTable.get("T_HR_SCmpStandingBook") == null) {
            return Lists.newArrayList();
        }
        String[] formulas = ((String)assTable.get("T_HR_SCmpStandingBook")).split(",");
        ArrayList fieldSnList = Lists.newArrayList();
        for (String formula : formulas) {
            String fieldSn = formula.split("\\.")[1];
            fieldSnList.add(fieldSn);
        }
        return fieldSnList;
    }

    protected List<List<Map<String, Object>>> initCostBearData(InitCalData initCalData) throws Exception {
        Context ctx = initCalData.getCtx();
        String condition = initCalData.getCondition();
        ArrayList columnList = Lists.newArrayList();
        for (String field : this.getMainTableFieldSn(initCalData)) {
            columnList.add(field + "C");
        }
        String columnInSql = "('" + StringUtils.join((Object[])columnList.toArray(), (String)"','") + "')";
        String cmpSegmSql = "select t.FTable, segm.FColumn from T_HR_SCmpSegmColumn segm left join T_HR_SCmpSegmTable t on segm.FCmpSegmTableID = t.FID where segm.FColumn in " + columnInSql + " group by t.FTable, segm.FColumn ";
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, cmpSegmSql);
        HashMap table2Column = Maps.newHashMap();
        while (rs.next()) {
            String table = rs.getString("FTable");
            table2Column.putIfAbsent(table, new ArrayList());
            ((List)table2Column.get(table)).add(rs.getString("FColumn"));
        }
        ArrayList segmDataList = Lists.newArrayList();
        String sqlFormat = "select {0} from {1} where FCmpCalTableID in ({2})";
        for (Map.Entry entry : table2Column.entrySet()) {
            segmDataList.add(this.queryTableData(ctx, (String)entry.getKey(), (List)entry.getValue(), sqlFormat, condition));
        }
        return segmDataList;
    }

    protected List<Map<String, Object>> queryTableData(Context ctx, String table, List<String> columns, String sqlFormat, String condition) throws Exception {
        columns.add("FCmpCalTableID");
        columns.add("FCOSTBEARORGID");
        columns.add("FSEGMCOSTID");
        String columnInSql = StringUtils.join((Object[])columns.toArray(), (String)",");
        String sql = MessageFormat.format(sqlFormat, columnInSql, table, condition);
        ArrayList tableDataList = Lists.newArrayList();
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
        while (rs.next()) {
            HashMap tableData = Maps.newHashMap();
            for (String column : columns) {
                if (column.equals("FSEGMCOSTID")) {
                    tableData.put("FID", rs.getObject(column));
                    continue;
                }
                tableData.put(column, rs.getObject(column));
            }
            tableDataList.add(tableData);
        }
        return tableDataList;
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        FilterInfo filter = new FilterInfo("CMP_CTB.id in (" + initCalData.getCondition() + ")");
        SqlParam sqlParam = new SqlParam();
        Map<String, String> selectMapping = this.buildSelector(initCalData);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setSortStr("cmp_CTB.id");
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        return FilterUtil.getSql((Context)initCalData.getCtx(), (SqlParam)sqlParam);
    }

    protected Map<String, String> buildSelector(InitCalData initCalData) throws BOSException {
        Map selectorMap = super.buildSelector(initCalData);
        selectorMap.put("cal_adminOrg.id", "cal_adminOrg.id");
        selectorMap.put("cal_cmpEPOR.id", "cal_cmpEPOR.id");
        return selectorMap;
    }

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        StringBuilder sql = new StringBuilder();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append(" SELECT ");
        sql.append(" ITEM.FID ITEMID,ITEM.FNAME_").append(l).append(" ITEMNAME,ITEM.FNUMBER ITEMNUMBER, ");
        sql.append(" ITEM.FIELDSN,ITEM.FDATADOT,ITEM.FDATATYPE,ITEM.FDATALENGTH ");
        sql.append(" FROM ");
        sql.append(" T_HR_SStandingBookItem ITEM ");
        sql.append(" WHERE FSTATE = 1  ");
        sql.append(" ORDER BY FIELDSN ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                int dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                int fieldSn = rs.getInt("FIELDSN");
                if (fieldSn <= 0) continue;
                String fieldName = "s" + fieldSn;
                sn.add(fieldName);
                cn.add(name);
                dataDotMap.put(fieldName, dataDot);
                dataTypeMap.put(fieldName, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldName, rs.getInt("FDATALENGTH"));
                }
                idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        return res;
    }
}

