/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.currency.repCurrency;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetFactory;
import com.kingdee.shr.compensation.app.currencyReport.ReportCurrencySetInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpItemUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RepCurrencyInitHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.currency.repCurrency.RepCurrencyInitHelper");
    public Context ctx;

    public RepCurrencyInitHelper(Context ctx) {
        this.ctx = ctx;
    }

    public void initSchemeRepData() throws Exception {
        int calTime;
        String calSchemeId;
        ReportCurrencySetInfo reportCurrencySetInfo = ReportCurrencySetFactory.getLocalInstance((Context)this.ctx).getReportCurrencySetInfo((IObjectPK)new ObjectUuidPK("6vS7SKM/TBCPlQIB4S/8Uy3awhY="));
        Date beginDate = reportCurrencySetInfo.getBeginDate();
        Calendar c = Calendar.getInstance();
        c.setTime(beginDate);
        int year = c.get(1);
        int month = c.get(2);
        String lang = this.ctx.getLocale().getLanguage();
        String label = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpIntelResource", (String)"label94", (Locale)LocaleUtils.locale_l2);
        StringBuffer sql = new StringBuffer();
        sql.append("select FCALSCHEMEID ,FPERIODYEAR ,FPERIODMONTH ,FCALTIME,FENDDATE,FBEGINDATE,FCURRENCYID ");
        sql.append(" from t_hr_scmpcaltable where FCALSTATE = 20 and fdescription_").append(lang).append(" <> '" + label + "'");
        sql.append(" and ((FPERIODYEAR = ").append(year).append(" and FPERIODMONTH >= ").append(month);
        sql.append(") or FPERIODYEAR > ").append(year).append(")");
        sql.append(" group by FCALSCHEMEID ,FPERIODYEAR ,FPERIODMONTH ,FCALTIME,FENDDATE ,FBEGINDATE,FCURRENCYID");
        StringBuffer hisSql = new StringBuffer();
        hisSql.append("select FCALSCHEMEID ,FPERIODYEAR ,FPERIODMONTH ,FCALTIME,FCURRENCYID ");
        hisSql.append(" from t_hr_scmpcaltable where FCALSTATE = 20 and fdescription_").append(lang).append(" = '" + label + "'");
        hisSql.append(" and ((FPERIODYEAR = ").append(year).append(" and FPERIODMONTH >= ").append(month);
        hisSql.append(") or FPERIODYEAR > ").append(year).append(")");
        hisSql.append(" group by FCALSCHEMEID ,FPERIODYEAR ,FPERIODMONTH ,FCALTIME,FCURRENCYID");
        StringBuffer tempKey = new StringBuffer();
        HashSet<String> tempSet = new HashSet<String>();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = null;
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        while (rowSet.next()) {
            calSchemeId = rowSet.getString("FCALSCHEMEID");
            year = rowSet.getInt("FPERIODYEAR");
            month = rowSet.getInt("FPERIODMONTH");
            calTime = rowSet.getInt("FCALTIME");
            tempKey.setLength(0);
            tempKey.append(calSchemeId).append("_");
            tempKey.append(year).append("_");
            tempKey.append(month).append("_");
            tempKey.append(calTime);
            if (tempSet.contains(tempKey.toString())) continue;
            tempSet.add(tempKey.toString());
            param = new Object[]{calSchemeId, year, month, calTime, rowSet.getString("FCURRENCYID"), CmpDateUtil.toSqlDate(rowSet.getDate("FBEGINDATE")), CmpDateUtil.toSqlDate(rowSet.getDate("FENDDATE"))};
            paramList.add(param);
        }
        ArrayList<Object[]> otherParamList = new ArrayList<Object[]>();
        HashSet<String> schemeRange = new HashSet<String>();
        rowSet = DbUtil.executeQuery((Context)this.ctx, (String)hisSql.toString());
        while (rowSet.next()) {
            calSchemeId = rowSet.getString("FCALSCHEMEID");
            year = rowSet.getInt("FPERIODYEAR");
            month = rowSet.getInt("FPERIODMONTH");
            calTime = rowSet.getInt("FCALTIME");
            tempKey.setLength(0);
            if (tempSet.contains(tempKey.toString())) continue;
            tempSet.add(tempKey.toString());
            schemeRange.add(calSchemeId);
            param = new Object[]{calSchemeId, year, month, calTime, rowSet.getString("FCURRENCYID"), null, null};
            otherParamList.add(param);
        }
        this.mergeParamList(otherParamList, schemeRange);
        paramList.addAll(otherParamList);
        String nowDateStr = CmpDateUtil.toKSqlDate(new Date());
        String userId = HRFilterUtils.getCurrentUserId((Context)this.ctx);
        sql = new StringBuffer();
        sql.append("insert into T_HR_SCalSchemeRep(fcalschemeid,fperiodyear,fperiodmonth,fcaltime,fcalcurrencyid,frepcurrencyid,");
        sql.append("frepcalstate,fbegindate,fenddate,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fid) ");
        sql.append("values(?,?,?,?,?,'").append(reportCurrencySetInfo.getCurrency().getId());
        sql.append("',0,?,?,'" + userId + "'," + nowDateStr + ",'" + userId + "'," + nowDateStr + ",newbosid('1624E1C0'))");
        DbUtil.execute((Context)this.ctx, (String)"delete from T_HR_SCalSchemeRep");
        DbUtil.executeBatch((Context)this.ctx, (String)sql.toString(), paramList);
    }

    private void mergeParamList(List<Object[]> otherParamList, Set<String> schemeRange) throws BOSException, EASBizException {
        String ksql = "select cmpPeriodType,beginDate,endDate,periodYear,periodMonth,periodTime where id in (" + CmpStrUtil.convertCollectionToSql(schemeRange) + ")";
        CalSchemeCollection coll = CalSchemeFactory.getLocalInstance(this.ctx).getCalSchemeCollection(ksql);
        if (coll == null || coll.size() < 1) {
            return;
        }
        HashMap<String, CalSchemeInfo> schemeFn = new HashMap<String, CalSchemeInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            CalSchemeInfo info = coll.get(i);
            schemeFn.put(info.getId().toString(), info);
        }
        for (Object[] param : otherParamList) {
            String calSchemeId = (String)param[0];
            int year = (Integer)param[1];
            int month = (Integer)param[2];
            Map<String, Date> preSchemeDateWithPeriod = this.getPreSchemeDateWithPeriod((CalSchemeInfo)schemeFn.get(calSchemeId), year, month);
            param[5] = CmpDateUtil.toSqlDate(preSchemeDateWithPeriod.get("beginDate"));
            param[6] = CmpDateUtil.toSqlDate(preSchemeDateWithPeriod.get("endDate"));
        }
    }

    public Map<String, Date> getPreSchemeDateWithPeriod(CalSchemeInfo calSchemeInfo, int targetYear, int targetMonth) throws EASBizException, BOSException {
        HashMap<String, Date> res = new HashMap<String, Date>();
        if (calSchemeInfo == null) {
            return res;
        }
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        CmpPeriodTypeEnum periodType = calSchemeInfo.getCmpPeriodType();
        Date schemeBeginDate = calSchemeInfo.getBeginDate();
        if (periodType == CmpPeriodTypeEnum.halfmonth && 2 == calSchemeInfo.getPeriodTime()) {
            Date endDate = calSchemeInfo.getEndDate();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.add(2, -1);
            calendar.add(5, 1);
            schemeBeginDate = calendar.getTime();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(schemeBeginDate);
        int betMonth = (targetYear - periodYear) * 12 + targetMonth - periodMonth;
        calendar.add(2, betMonth);
        Date beginDate = calendar.getTime();
        int k = periodType.equals((Object)CmpPeriodTypeEnum.yeay) ? 12 : (periodType.equals((Object)CmpPeriodTypeEnum.half) ? 6 : (periodType.equals((Object)CmpPeriodTypeEnum.quarter) ? 3 : 1));
        calendar.add(2, k);
        calendar.add(5, -1);
        Date endDate = CmpDateUtil.toDate(calendar.getTime());
        res.put("beginDate", beginDate);
        res.put("endDate", endDate);
        return res;
    }

    public Map<String, Date> getPreSchemeDateWithPeriod(String schemeId, int targetYear, int targetMonth) throws EASBizException, BOSException {
        String ksql = "select cmpPeriodType,beginDate,endDate,periodYear,periodMonth,periodTime where id = '" + schemeId + "'";
        CalSchemeInfo calSchemeInfo = CalSchemeFactory.getLocalInstance(this.ctx).getCalSchemeInfo(ksql);
        return this.getPreSchemeDateWithPeriod(calSchemeInfo, targetYear, targetMonth);
    }

    public void sysRepTableConstruct() {
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("T_HR_SCmpCalTableRep");
        tableList.add("T_HR_SCmpCalTable");
        try {
            new CmpItemUtil().selectItemColumns(this.ctx, tableList);
        }
        catch (EASBizException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
    }
}

