/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.dataplatform.budgetstatistic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemBoard;
import com.kingdee.shr.compensation.dataplatform.budgetstatistic.dto.BudgetItemDTO;
import com.kingdee.shr.compensation.service.budget.BudgetTableService;
import com.kingdee.shr.compensation.service.budget.CreateTableWithPartitionService;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class BudgetAmountUtil {
    private static final String UTIL_FIX_DATA_KEY = "budget.amount.Unit";
    private static final String UTIL_FIX_DATA_VALUE = "budget.fixData";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean budgetInit(Context ctx) throws BOSException {
        String sql = "select 1 from KSQL_UserColumns where KSQL_COL_NAME ='T1' and KSQL_COL_TabName='T_HR_SBudgetManage'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            return true;
        }
        boolean flag = CmpDistributedLockUtils.tryLock(ctx, UTIL_FIX_DATA_KEY, UTIL_FIX_DATA_VALUE);
        if (!flag) {
            return false;
        }
        try {
            CreateTableWithPartitionService.createExpenseDetailsSubmitBill(ctx);
            CreateTableWithPartitionService.createExpenseDetailsCmp(ctx);
            BudgetTableService.fixData(ctx);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, UTIL_FIX_DATA_KEY, UTIL_FIX_DATA_VALUE);
        }
        return true;
    }

    public static void putIntoBudgetItem(Map<BudgetItemDTO, BudgetItemBoard> mergedBudgetItemBoardMap, BudgetItemDTO budgetItem, BudgetItemBoard budgetItemBoard) {
        BudgetItemBoard board = mergedBudgetItemBoardMap.get(budgetItem);
        if (board == null) {
            mergedBudgetItemBoardMap.put(budgetItem, budgetItemBoard);
            return;
        }
        board.merge(budgetItemBoard);
    }

    public static BudgetItemBoard mergeAllItemBoard(Map<BudgetItemDTO, BudgetItemBoard> budgetItemBoardMap) {
        BudgetItemBoard bid = new BudgetItemBoard();
        budgetItemBoardMap.forEach((key, value) -> bid.merge((BudgetItemBoard)value));
        bid.valueOperation();
        return bid;
    }

    public static int templateYearCalibration(Context ctx, String templateId, int year) throws SQLException, BOSException {
        int realYear = -1;
        String sql = "select FBudgetYear from T_HR_SCmpBudgetScheme cbs inner join T_HR_SBudgetTemplate bdt on cbs.FTemplateID = bdt.fid where FEffectDate <= ? and FExpiryDate >= ?  and bdt.fid = ?";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(1, year);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        java.sql.Date date = new java.sql.Date(calendar.getTimeInMillis());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{date, date, templateId});
        if (rs.next()) {
            realYear = rs.getInt("FBudgetYear");
        }
        return realYear;
    }
}

