/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.SchemeBizKeyDefineInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitElementCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitElementFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitSchemeType;
import com.kingdee.shr.compensation.util.CmpCollectionHelper;
import com.kingdee.shr.compensation.util.integrate.IntegrateFunctionUtil;
import com.kingdee.shr.compensation.util.integrate.SubmitBizKeyHelper;
import com.kingdee.shr.compensation.util.integrate.SubmitCycleHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CalFunctionIntegrateCycleFilterService
extends SalaryCalFunction {
    private static final double SUM_TYPE = 1.0;
    private static final double RELATION_TYPE = 3.0;
    private static final String DEFAULT_CALSCHEMEID = "YvUYBi3h/Ei6MSRBTt2eXf/N8rE=";
    private SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
    private SimpleDateFormat yearMonthDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public String getValue(Map<String, Object> paramMap, HashMap<String, Object> tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String elementItemNum, String valueItem, double type) {
        Context ctx = Tools.getInstance().getCtx();
        String cacheKey = "getFillterSubmitDataForCycle-" + calScheme.getNumber() + "-" + calSubmitScheme + "--" + valueItem + "-" + elementItemNum;
        String relyKey = cacheKey + "-Rely";
        String curCalSchemeId = calScheme.getId() == null ? "" : calScheme.getId().toString();
        Map<String, String> salaryMap = new HashMap();
        HashMap relyMap = new HashMap();
        String calItem = (String)paramMap.get("CALITEM");
        if (tempMap.get(cacheKey) == null) {
            SchemeBizKeyDefineInfo schemeBizKeyDefine;
            String entryTableName = IntegrateFunctionUtil.initSubmitSchemeTable(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (null == entryTableName) {
                tempMap.put(cacheKey, salaryMap);
                return "0.00";
            }
            SubmitElementInfo elementInfo = this.initElementItem(ctx, tempMap, elementItemNum);
            if (null == elementInfo) {
                tempMap.put(cacheKey, salaryMap);
                return "0.00";
            }
            String elementId = elementInfo.getId().toString();
            CalSubmitItemInfo valueItemInfo = IntegrateFunctionUtil.initSubmitItem(ctx, tempMap, valueItem);
            if (null == valueItemInfo) {
                tempMap.put(cacheKey, salaryMap);
                return "0.00";
            }
            String valueItemSn = "S" + valueItemInfo.getFieldSn();
            Set<String> schemeItemSet = IntegrateFunctionUtil.initSchemeItem(ctx, tempMap, calSubmitScheme, SubmitSchemeType.NORMAL_SUBMIT);
            if (!schemeItemSet.contains(valueItemInfo.getFieldSn() + "")) {
                tempMap.put(cacheKey, salaryMap);
                return "0.00";
            }
            try {
                schemeBizKeyDefine = SubmitBizKeyHelper.getSchemeBizKeyDefineInfoBySchemeNumber(ctx, calSubmitScheme, elementItemNum);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "0.00";
            }
            String queryFilterCycleDataSql = "SELECT t_hr_scmpcaltable.FID calTableID, t_hr_scmpcaltable.FPersonId personId,CASE WHEN entry.FLastUpdateTime IS NULL THEN entry.FCreateTime ELSE entry.FLastUpdateTime END AS FLastUpdateTime,entry.FPersonID,entry.FAdminOrgUnitID,entry.FCmpEmpORelationID,entry.FSubmitElementID,entry.FSalaryPeriod,entry.FID,entry.FCurrencyID,entry." + valueItemSn + " FROM " + entryTableName + " entry LEFT JOIN T_HR_SubmitEntryCycleExtend cycleExtend ON entry.FID = cycleExtend.FEntryId LEFT JOIN T_HR_SCmpEmpORelation cmor ON cmor.FID = entry.FCmpEmpORelationID LEFT JOIN T_HR_SCmpCalTable t_hr_scmpcaltable ON %s WHERE " + this.getPersonFilterSql(calScheme, mainTableRowFilter) + " AND " + this.getTransferSalaryPeriodFilterSql(calScheme) + " AND entry.FSubmitElementID = '" + elementId + "' AND entry.FCALSTATE = '03' AND (entry.FCALSCHEMEID = '" + DEFAULT_CALSCHEMEID + "' or entry.FCALSCHEMEID = '" + curCalSchemeId + "') ORDER BY entry.FPersonId,cycleExtend.FSalaryStartPeriod desc,cmor.FUseDefault desc,cmor.FEffectDate desc";
            String bizKeyJoinFilterSql = this.getSchemeBizKeyJoinFilterSql(schemeBizKeyDefine, type);
            queryFilterCycleDataSql = String.format(queryFilterCycleDataSql, bizKeyJoinFilterSql);
            try {
                DecimalFormat df = new DecimalFormat(null == valueItemInfo.getDataDot() ? "0" : valueItemInfo.getDataDot().toString());
                HashSet<String> repeatPersonIdCheckSet = new HashSet<String>();
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryFilterCycleDataSql);
                while (rowSet.next()) {
                    boolean isNumber;
                    String personId = rowSet.getString("personId");
                    boolean bl = isNumber = CalSubmitItemDataType.number == valueItemInfo.getDataType();
                    if (!repeatPersonIdCheckSet.add(personId)) {
                        if (1.0 != type) continue;
                        if (!isNumber) {
                            salaryMap.put(personId, "-1");
                            continue;
                        }
                    }
                    String submitItemValue = this.getSubmitItemValue(rowSet, valueItemSn, valueItemInfo, df);
                    if (CalSubmitItemDataType.F7.equals((Object)valueItemInfo.getDataType())) {
                        Map map = (Map)tempMap.get("CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_VAL_" + valueItem);
                        submitItemValue = (String)map.get(submitItemValue);
                        salaryMap.put(personId, submitItemValue);
                    }
                    HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                    personRelyMap.put("SUBMITITEMID", elementId);
                    personRelyMap.put("SUBMITITEMTABLE", "T_HR_SSubmitElement");
                    personRelyMap.put("SUBMITMONEY", submitItemValue);
                    personRelyMap.put("SUBMITTABLE", entryTableName);
                    personRelyMap.put("SUBMITTABLEID", rowSet.getString("FID"));
                    personRelyMap.put("CALITEM", calItem);
                    personRelyMap.put("ISBASIC", 1);
                    personRelyMap.put("SUBMITNUMBER", valueItem);
                    CmpCollectionHelper.getListFromMapIfAbsent(relyMap, personId).add(personRelyMap);
                    if (isNumber) {
                        String currencyId = rowSet.getString("FCURRENCYID");
                        BigDecimal rate = null == currencyMap.get(currencyId) ? new BigDecimal(1) : currencyMap.get(currencyId);
                        this.handleAndAssembleNumberValue(salaryMap, submitItemValue, personId, type, rate, df);
                        continue;
                    }
                    salaryMap.put(personId, submitItemValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(cacheKey, salaryMap);
            tempMap.put(relyKey, relyMap);
        }
        salaryMap = (Map)tempMap.get(cacheKey);
        IntegrateFunctionUtil.putSubmitDataToParam(ctx, paramMap, tempMap, calItem, relyKey);
        String personID = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        return salaryMap.get(personID) != null ? (String)salaryMap.get(personID) : "0.00";
    }

    protected String getSubmitItemValue(IRowSet rowSet, String valueItemSn, CalSubmitItemInfo valueItemInfo, DecimalFormat df) throws SQLException {
        String submitItemValue;
        if (CalSubmitItemDataType.number == valueItemInfo.getDataType()) {
            submitItemValue = df.format(rowSet.getBigDecimal(valueItemSn));
        } else if (CalSubmitItemDataType.Date == valueItemInfo.getDataType()) {
            Date date = rowSet.getDate(valueItemSn);
            if (date != null) {
                java.util.Date utilDate = new java.util.Date(date.getTime());
                submitItemValue = valueItemInfo.getDateType() != null && DateTypeEnum.yyyyMM == valueItemInfo.getDateType() ? this.yearMonthDateFormat.format(utilDate) : this.yearMonthFormat.format(utilDate);
            } else {
                submitItemValue = "";
            }
        } else {
            submitItemValue = rowSet.getString(valueItemSn);
        }
        return submitItemValue;
    }

    protected void handleAndAssembleNumberValue(Map<String, String> salaryMap, String submitItemValue, String personId, double type, BigDecimal rate, DecimalFormat df) {
        BigDecimal numberValue = new BigDecimal(submitItemValue);
        BigDecimal sum = numberValue.multiply(rate);
        String lastValue = salaryMap.get(personId);
        if (lastValue != null) {
            BigDecimal lastSum = new BigDecimal(salaryMap.get(personId));
            sum = 1.0 == type ? sum.add(lastSum) : lastSum;
        }
        salaryMap.put(personId, df.format(sum));
    }

    protected String getSchemeBizKeyJoinFilterSql(SchemeBizKeyDefineInfo schemeBizKeyDefine, double type) {
        ArrayList<String> bizKeyFilterList = new ArrayList<String>();
        if (schemeBizKeyDefine.isIsUsePerson()) {
            bizKeyFilterList.add("entry.FPersonId = t_hr_scmpcaltable.FPersonId");
        }
        if (3.0 == type) {
            if (schemeBizKeyDefine.isIsUseAdminOrg()) {
                bizKeyFilterList.add("entry.FAdminOrgUnitID = t_hr_scmpcaltable.FAdminOrgUnitID");
            }
            if (schemeBizKeyDefine.isIsUseEmpRelation()) {
                bizKeyFilterList.add("entry.FCmpEmpORelationID = t_hr_scmpcaltable.FCmpEmpORelationID");
            }
        }
        return org.apache.commons.lang3.StringUtils.join(bizKeyFilterList, (String)" AND ");
    }

    protected String getPersonFilterSql(CalSchemeInfo calScheme, String mainTableRowFilter) {
        String calschemeId = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String sql = "t_hr_scmpcaltable.FCalSchemeID = '%s' AND t_hr_scmpcaltable.FPeriodYear=%s AND t_hr_scmpcaltable.FPeriodMonth=%s AND t_hr_scmpcaltable.FCalTime=%s";
        sql = String.format(sql, calschemeId, periodYear, periodMonth, calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            sql = sql + " AND " + mainTableRowFilter;
        }
        return sql;
    }

    public SubmitElementInfo initElementItem(Context ctx, HashMap tempMap, String elementItemNum) {
        SubmitElementInfo submitElementInfo;
        String key = "INITELEMENTITEM_SERVICE_SUBMITITEM";
        Map<String, SubmitElementInfo> itemMap = new HashMap();
        if (null == tempMap.get(key)) {
            SubmitElementCollection itemColl = null;
            try {
                itemColl = SubmitElementFactory.getLocalInstance((Context)ctx).getSubmitElementCollection("select id, number, name ");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            if (itemColl != null) {
                for (int i = 0; i < itemColl.size(); ++i) {
                    submitElementInfo = itemColl.get(i);
                    itemMap.put(submitElementInfo.getNumber(), submitElementInfo);
                }
            }
            tempMap.put(key, itemMap);
        } else {
            itemMap = (Map)tempMap.get(key);
        }
        submitElementInfo = (SubmitElementInfo)itemMap.get(elementItemNum);
        if (null == submitElementInfo) {
            return null;
        }
        return (SubmitElementInfo)itemMap.get(elementItemNum);
    }

    protected String getTransferSalaryPeriodFilterSql(CalSchemeInfo calScheme) {
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        String calPeriod = SubmitCycleHelper.getTransferSalaryFormatDateStr(periodYear, periodMonth, calTime);
        return "(cycleExtend.FSalaryStartPeriod <= '" + calPeriod + "' AND (CASE WHEN FSalaryExpirePeriod IS NULL OR FSalaryExpirePeriod='' THEN FSalaryEndPeriod ELSE FSalaryExpirePeriod END) >= '" + calPeriod + "')";
    }
}

