/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.service.SHRCodingRuleApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalState;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.integrate.dto.ExternalSubmitBill;
import com.kingdee.shr.compensation.integrate.dto.ExternalSubmitBillEntry;
import com.kingdee.shr.compensation.integrate.dto.TempBatchSubmitEntry;
import com.kingdee.shr.compensation.service.BatchSubmitBillService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class BaseBatchSubmitBillService
implements BatchSubmitBillService {
    private static final Logger LOG = Logger.getLogger(BaseBatchSubmitBillService.class);
    protected static final String RMB_CURRENCY_ID = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
    protected String schemeNumber;
    protected String schemeId;
    protected String adminOrgUnitId;
    protected String entryTable;
    protected boolean isEnableSubmitElement;
    protected Map<String, Object> returnMap;
    protected Map<String, TempBatchSubmitEntry> entryInfoMap = new HashMap<String, TempBatchSubmitEntry>();
    protected Map<String, CalSubmitItemInfo> calSubmitItemMap = new HashMap<String, CalSubmitItemInfo>();
    protected List<CalSubmitItemInfo> calSubmitItemList = new ArrayList<CalSubmitItemInfo>();
    protected Map<String, Map<String, String>> billStateMap = new HashMap<String, Map<String, String>>();
    protected Map<String, String> submitElementMap = new HashMap<String, String>();
    protected Map<String, String> currenctMap = new HashMap<String, String>();
    protected static final int SUCCESS = 1;
    protected static final int FAILED = 0;
    protected Context ctx;

    @Override
    public void setSchemeNumber(String schemeNumber) {
        this.schemeNumber = schemeNumber;
    }

    @Override
    public void generateSubmitBill(Context ctx, List<ExternalSubmitBill> dataList) throws BOSException, EASBizException {
        this.ctx = ctx;
        if (StringUtils.isEmpty((String)this.schemeNumber)) {
            String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label44", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("00", errMsg));
        }
        this.checkRequiredFields(dataList);
        this.initSubmitData(this.schemeNumber, dataList);
        Set<String> existedBills = this.beforeSaveData(dataList);
        this.saveData(dataList, existedBills);
        this.afterSaveData(dataList);
    }

    protected void afterSaveData(List<ExternalSubmitBill> dataList) {
    }

    public void saveData(List<ExternalSubmitBill> dataList, Set<String> existedBills) throws EASBizException, BOSException {
        HashMap<String, String> billMap = new HashMap<String, String>();
        this.deleteLast(existedBills);
        this.filterAndSplit(dataList);
        this.saveBill(dataList, billMap);
        this.saveBillEntry(dataList, billMap);
    }

    protected void filterAndSplit(List<ExternalSubmitBill> dataList) {
        ArrayList<ExternalSubmitBill> newBills = new ArrayList<ExternalSubmitBill>();
        for (ExternalSubmitBill submitBill : dataList) {
            if (submitBill.getState() == 0) continue;
            List<ExternalSubmitBillEntry> entries = submitBill.getEntry();
            Map<String, List<ExternalSubmitBillEntry>> groups = this.groupEntryByHrOrgUnit(entries);
            int index = 0;
            for (Map.Entry<String, List<ExternalSubmitBillEntry>> group : groups.entrySet()) {
                if (StringUtils.isEmpty((String)submitBill.getAdminOrgUnit())) {
                    submitBill.setAdminOrgUnit(this.adminOrgUnitId);
                }
                if (index == 0) {
                    submitBill.setEntry(group.getValue());
                    submitBill.setHrOrgUnit(group.getKey());
                    ++index;
                    continue;
                }
                ExternalSubmitBill vo = new ExternalSubmitBill();
                BeanUtils.copyProperties((Object)submitBill, (Object)vo);
                vo.setHrOrgUnit(group.getKey());
                vo.setEntry(group.getValue());
                vo.setBill(null);
                newBills.add(vo);
            }
        }
        if (!newBills.isEmpty()) {
            dataList.addAll(newBills);
        }
    }

    protected Map<String, List<ExternalSubmitBillEntry>> groupEntryByHrOrgUnit(List<ExternalSubmitBillEntry> entries) {
        HashMap<String, List<ExternalSubmitBillEntry>> groups = new HashMap<String, List<ExternalSubmitBillEntry>>();
        for (ExternalSubmitBillEntry entry : entries) {
            String personNumber = entry.getPerson();
            TempBatchSubmitEntry personInfo = this.entryInfoMap.get(personNumber);
            String hrOrgUnitId = personInfo.getHrOrgUnitId();
            ArrayList<ExternalSubmitBillEntry> list = (ArrayList<ExternalSubmitBillEntry>)groups.get(hrOrgUnitId);
            if (null == list) {
                list = new ArrayList<ExternalSubmitBillEntry>();
                groups.put(hrOrgUnitId, list);
            }
            list.add(entry);
        }
        return groups;
    }

    protected void deleteLast(Set<String> existedBills) throws BOSException {
        if (existedBills.isEmpty()) {
            return;
        }
        String deleteEntrySQL = "delete from " + this.entryTable + " where fBillId in (select fid from T_HR_SBatchSubmitShemeBill where fNumber = ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String num : existedBills) {
            Object[] param = new Object[]{num};
            params.add(param);
        }
        DbUtil.executeBatch((Context)this.ctx, (String)deleteEntrySQL, params);
        String deleteBillSQL = "delete from T_HR_SBatchSubmitShemeBill where fNumber = ?";
        DbUtil.executeBatch((Context)this.ctx, (String)deleteBillSQL, params);
    }

    protected void saveBill(List<ExternalSubmitBill> dataList, Map<String, String> billMap) throws BOSException, EASBizException {
        this.setBillNumber(dataList);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int index = 0;
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        for (ExternalSubmitBill submitBill : dataList) {
            if (submitBill.getState() == 0) continue;
            String submitterNum = submitBill.getSubmitter();
            TempBatchSubmitEntry submitEntry = this.entryInfoMap.get(submitterNum);
            String billNumber = this.getBillNumber(submitBill);
            if (billMap.containsKey(billNumber)) {
                billNumber = billNumber + "-" + index;
            }
            String hrOrgId = submitBill.getHrOrgUnit();
            Object[] param = new Object[13];
            param[0] = this.schemeId;
            param[1] = createTime;
            param[2] = submitEntry.getPersonId();
            param[3] = 2;
            param[4] = submitBill.getAdminOrgUnit();
            param[5] = null == hrOrgId ? submitEntry.getHrOrgUnitId() : hrOrgId;
            param[6] = 3;
            param[7] = 0;
            param[8] = billNumber;
            param[9] = submitBill.getRemark();
            param[10] = submitEntry.getPersonId();
            param[11] = createTime;
            String billId = BOSUuid.create((String)"B11DBA5C").toString();
            param[12] = billId;
            billMap.put(billNumber, billId);
            paramsList.add(param);
            ++index;
        }
        if (!paramsList.isEmpty()) {
            String billSql = this.getBillInsertSql();
            DbUtil.executeBatch((Context)this.ctx, (String)billSql, paramsList);
        }
    }

    protected void setBillNumber(List<ExternalSubmitBill> dataList) throws BOSException, EASBizException {
        ArrayList<ExternalSubmitBill> list = new ArrayList<ExternalSubmitBill>();
        String hrOrgUnitId = null;
        for (ExternalSubmitBill bill : dataList) {
            if (bill.getState() != 1 || !StringUtils.isEmpty((String)bill.getBill())) continue;
            list.add(bill);
            hrOrgUnitId = bill.getHrOrgUnit();
        }
        if (!list.isEmpty()) {
            String[] billNumbers = BaseBatchSubmitBillService.createBillNumbers(this.ctx, (IObjectValue)new BatchSubmitShemeBillInfo(), hrOrgUnitId, list.size());
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            for (ExternalSubmitBill bill : list) {
                String number = billNumbers[list.indexOf(bill)];
                boolean existed = BatchSubmitShemeBillFactory.getLocalInstance((Context)this.ctx).exists("where number = '" + number + "'");
                if (existed) {
                    BatchSubmitShemeBillInfo model = new BatchSubmitShemeBillInfo();
                    number = iCodingRuleManager.getNonbreakNumber((IObjectValue)model, hrOrgUnitId);
                }
                bill.setBill(number);
            }
        }
    }

    public static String[] createBillNumbers(Context ctx, IObjectValue coreBase, String hrOrgUnitId, int count) throws BOSException, EASBizException {
        String currentCUID = HRFilterUtils.getCurrentCUID((Context)ctx);
        String codeOrgId = StringUtils.isEmpty((String)hrOrgUnitId) ? currentCUID : hrOrgUnitId;
        boolean isUseCodingRule = SHRCodingRuleApi.hasCodingRule((Context)ctx, (IObjectValue)coreBase, (String)codeOrgId);
        if (isUseCodingRule) {
            return CodingRuleManagerFactory.getLocalInstance((Context)ctx).getBatchNumber(coreBase, codeOrgId, count);
        }
        String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label45", (Locale)ctx.getLocale());
        throw new EASBizException(new NumericExceptionSubItem("00", errMsg));
    }

    protected String getBillNumber(ExternalSubmitBill submitBill) throws BOSException, EASBizException {
        return submitBill.getBill();
    }

    protected String getBillInsertSql() {
        return " INSERT INTO T_HR_SBatchSubmitShemeBill( FSUBMITSCHEMEID, FAPPLYDATE, FPROPOSERID, FDATASOURCE,  FADMINORGUNITID, FHRORGUNITID, FBILLSTATE, FAPPROVETYPE, FNUMBER,  FDESCRIPTION, FCREATORID, FCREATETIME, FID, FIsSsc) values(?, ?, ?, ?,  ?, ?, ?, ?, ?,  ?, ?, ?, ?, 0)";
    }

    protected void saveBillEntry(List<ExternalSubmitBill> dataList, Map<String, String> billMap) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Calendar calendar = Calendar.getInstance();
        String itemSql = this.getBillEntryInsertSql();
        for (ExternalSubmitBill submitBill : dataList) {
            if (submitBill.getState() == 0) continue;
            List<ExternalSubmitBillEntry> entries = submitBill.getEntry();
            for (ExternalSubmitBillEntry entry : entries) {
                String person = entry.getPerson();
                String billNumber = submitBill.getBill();
                TempBatchSubmitEntry tempBatchSubmitEntry = this.entryInfoMap.get(person);
                String month = entry.getMonth();
                String submitElementNumber = entry.getSubmitElement();
                calendar.set(Integer.parseInt(month.substring(0, 4)), Integer.parseInt(month.substring(5, 7)) - 1, 1, 0, 0, 0);
                if (!billMap.containsKey(billNumber)) continue;
                Object[] param = new Object[13 + this.calSubmitItemList.size() + 3];
                param[0] = billMap.get(billNumber);
                param[1] = CmpDateUtil.toSqlDate(calendar.getTime());
                param[2] = tempBatchSubmitEntry.getAdminOrgId();
                param[3] = tempBatchSubmitEntry.getPositionId();
                param[4] = tempBatchSubmitEntry.getCmpEmpId();
                String currencyISO = entry.getCurrency();
                param[5] = this.getCurrencyId(currencyISO);
                param[6] = null == submitElementNumber ? null : this.submitElementMap.get(submitElementNumber);
                param[7] = submitBill.getHrOrgUnit();
                param[8] = "01";
                param[9] = 10;
                param[10] = this.getInitialBillState();
                param[11] = tempBatchSubmitEntry.getPersonId();
                param[12] = BOSUuid.create((String)"7F647776").toString();
                Map<String, Object> item = entry.getItem();
                for (int k = 0; k < this.calSubmitItemList.size(); ++k) {
                    CalSubmitItemInfo calSubmitItemInfo = this.calSubmitItemList.get(k);
                    CalSubmitItemDataType dataType = calSubmitItemInfo.getDataType();
                    String submitItemNumber = calSubmitItemInfo.getNumber();
                    Object value = item.get(submitItemNumber);
                    param[13 + k] = null == value ? null : (CalSubmitItemDataType.number == dataType ? new BigDecimal(value.toString()) : value);
                }
                Map<String, String> descMap = entry.getDescription();
                if (null != descMap) {
                    String desc_l1 = descMap.get("L1");
                    String desc_l2 = descMap.get("L2");
                    String desc_l3 = descMap.get("L3");
                    param[13 + this.calSubmitItemList.size()] = desc_l1;
                    param[13 + this.calSubmitItemList.size() + 1] = desc_l2;
                    param[13 + this.calSubmitItemList.size() + 2] = desc_l3;
                }
                paramsList.add(param);
            }
        }
        if (!paramsList.isEmpty()) {
            DbUtil.executeBatch((Context)this.ctx, (String)itemSql, paramsList);
        }
    }

    protected int getInitialBillState() {
        return 3;
    }

    protected String getCurrencyId(String currencyISO) {
        return StringUtils.isEmpty((String)currencyISO) || !this.currenctMap.containsKey(currencyISO) ? RMB_CURRENCY_ID : this.currenctMap.get(currencyISO);
    }

    protected String getBillEntryInsertSql() {
        StringBuilder str = new StringBuilder();
        str.append(" INSERT INTO ").append(this.entryTable).append("(");
        str.append(" FBILLID, FEFFECTDATE, FADMINORGUNITID, FPOSITIONID, FCMPEMPORELATIONID, ");
        str.append(" FCURRENCYID, FSUBMITELEMENTID, FHRORGUNITID, FCALSTATE, FISCAL, ");
        str.append(" FBILLSTATE, FPERSONID, FID");
        for (CalSubmitItemInfo calSubmitItemInfo : this.calSubmitItemList) {
            str.append(",").append("S").append(calSubmitItemInfo.getFieldSn());
        }
        str.append(" , fdescription_l1, fdescription_l2, fdescription_l3 ");
        str.append(")");
        str.append(" values(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ? ");
        for (int i = 0; i < this.calSubmitItemList.size(); ++i) {
            str.append(",?");
        }
        str.append(" , ?, ?, ? ");
        str.append(")");
        return str.toString();
    }

    protected Set<String> beforeSaveData(List<ExternalSubmitBill> dataList) {
        HashSet<String> existedBills = new HashSet<String>();
        for (ExternalSubmitBill submitBill : dataList) {
            if (submitBill.getState() == 0) continue;
            if (!this.isEditable(submitBill)) {
                submitBill.setState(0);
                continue;
            }
            List<ExternalSubmitBillEntry> entries = submitBill.getEntry();
            int billState = 1;
            for (ExternalSubmitBillEntry entry : entries) {
                String personNumber = entry.getPerson();
                if (!this.entryInfoMap.containsKey(personNumber)) {
                    entry.setState(0);
                    String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label46", (Locale)this.ctx.getLocale());
                    entry.setErrMsg(errMsg);
                    billState = 0;
                }
                if (this.isEnableSubmitElement) {
                    String errMsg;
                    String submitElement = entry.getSubmitElement();
                    if (StringUtils.isEmpty((String)submitElement)) {
                        entry.setState(0);
                        errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label47", (Locale)this.ctx.getLocale());
                        entry.setErrMsg(errMsg);
                        billState = 0;
                    } else if (!this.submitElementMap.containsKey(submitElement)) {
                        entry.setState(0);
                        errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label48", (Locale)this.ctx.getLocale());
                        entry.setErrMsg(errMsg);
                        billState = 0;
                    }
                }
                Map<String, Object> item = entry.getItem();
                for (Map.Entry<String, Object> submitItem : item.entrySet()) {
                    if (this.calSubmitItemMap.containsKey(submitItem.getKey())) continue;
                    entry.setState(0);
                    String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label49", (Locale)this.ctx.getLocale());
                    entry.setErrMsg(MessageFormat.format(errMsg, submitItem.getKey()));
                    billState = 0;
                }
            }
            submitBill.setState(billState);
            if (billState != 1 || StringUtils.isEmpty((String)submitBill.getBill())) continue;
            existedBills.add(submitBill.getBill());
        }
        this.validOtherInfo(dataList, existedBills);
        return existedBills;
    }

    protected void validOtherInfo(List<ExternalSubmitBill> dataList, Set<String> existedBills) {
    }

    protected boolean isEditable(ExternalSubmitBill externalSubmitBill) {
        String billNumber = externalSubmitBill.getBill();
        if (StringUtils.isEmpty((String)billNumber)) {
            return true;
        }
        if (!this.billStateMap.containsKey(billNumber)) {
            return true;
        }
        Map<String, String> personMap = this.billStateMap.get(billNumber);
        boolean submitBillState = true;
        for (ExternalSubmitBillEntry entry : externalSubmitBill.getEntry()) {
            String personNumber = entry.getPerson();
            String billState = personMap.get(personNumber);
            if (StringUtils.isEmpty((String)billState) || billState.compareTo("01") <= 0) continue;
            entry.setState(0);
            String calStateName = CalState.getEnum((String)billState).getAlias();
            String errMsg1 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label64", (Locale)this.ctx.getLocale());
            entry.setErrMsg(MessageFormat.format(errMsg1, calStateName));
            submitBillState = false;
            String errMsg2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label65", (Locale)this.ctx.getLocale());
            externalSubmitBill.setMsg(errMsg2);
        }
        return submitBillState;
    }

    protected void checkRequiredFields(List<ExternalSubmitBill> dataList) {
        String regExp = "[1-9][0-9]{3}[-](0[1-9]|1[0-2])";
        for (ExternalSubmitBill externalSubmitBill : dataList) {
            externalSubmitBill.setState(1);
            if (StringUtils.isEmpty((String)externalSubmitBill.getSubmitter())) {
                String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label51", (Locale)this.ctx.getLocale());
                externalSubmitBill.setState(0);
                externalSubmitBill.setMsg(errMsg);
                continue;
            }
            List<ExternalSubmitBillEntry> entries = externalSubmitBill.getEntry();
            if (null == entries || entries.isEmpty()) {
                String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label52", (Locale)this.ctx.getLocale());
                externalSubmitBill.setState(0);
                externalSubmitBill.setMsg(errMsg);
                continue;
            }
            for (ExternalSubmitBillEntry entry : entries) {
                String errMsg;
                if (StringUtils.isEmpty((String)entry.getPerson())) {
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label53", (Locale)this.ctx.getLocale());
                    externalSubmitBill.setState(0);
                    externalSubmitBill.setMsg(errMsg);
                    entry.setState(0);
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label54", (Locale)this.ctx.getLocale());
                    entry.setErrMsg(errMsg);
                    continue;
                }
                if (StringUtils.isEmpty((String)entry.getMonth())) {
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label55", (Locale)this.ctx.getLocale());
                    externalSubmitBill.setState(0);
                    externalSubmitBill.setMsg(errMsg);
                    entry.setState(0);
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label56", (Locale)this.ctx.getLocale());
                    entry.setErrMsg(errMsg);
                    continue;
                }
                if (!entry.getMonth().matches(regExp)) {
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label57", (Locale)this.ctx.getLocale());
                    externalSubmitBill.setState(0);
                    externalSubmitBill.setMsg(errMsg);
                    entry.setState(0);
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label58", (Locale)this.ctx.getLocale());
                    entry.setErrMsg(errMsg);
                    continue;
                }
                Map<String, Object> item = entry.getItem();
                if (null != item && !item.isEmpty()) continue;
                String errMsg2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label59", (Locale)this.ctx.getLocale());
                externalSubmitBill.setState(0);
                externalSubmitBill.setMsg(errMsg2);
                entry.setState(0);
                errMsg2 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label60", (Locale)this.ctx.getLocale());
                entry.setErrMsg(errMsg2);
            }
        }
        this.checkOtherFields(dataList);
    }

    protected void checkOtherFields(List<ExternalSubmitBill> dataList) {
    }

    protected void initSubmitData(String schemeNumber, List<ExternalSubmitBill> dataList) throws BOSException, EASBizException {
        ArrayList<String> persons = new ArrayList<String>();
        ArrayList<String> billNumbers = new ArrayList<String>();
        for (ExternalSubmitBill externalSubmitBill : dataList) {
            if (externalSubmitBill.getState() == 0) continue;
            ArrayList<String> personList = new ArrayList<String>();
            for (ExternalSubmitBillEntry entry : externalSubmitBill.getEntry()) {
                if (personList.contains(entry.getPerson())) {
                    externalSubmitBill.setState(0);
                    String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label61", (Locale)this.ctx.getLocale());
                    externalSubmitBill.setMsg(errMsg);
                    entry.setState(0);
                    errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label62", (Locale)this.ctx.getLocale());
                    entry.setErrMsg(errMsg);
                    continue;
                }
                personList.add(entry.getPerson());
            }
            persons.addAll(personList);
            persons.add(externalSubmitBill.getSubmitter());
            String billNumber = externalSubmitBill.getBill();
            if (StringUtils.isEmpty((String)billNumber)) continue;
            if (billNumbers.contains(billNumber)) {
                externalSubmitBill.setState(0);
                String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)"label63", (Locale)this.ctx.getLocale());
                externalSubmitBill.setMsg(errMsg);
                continue;
            }
            billNumbers.add(billNumber);
        }
        this.initCalSubmitSchemeInfo(schemeNumber);
        this.initPersonInfo(persons);
        this.loadSubmitBillByNumber(billNumbers);
        this.loadSubmitElement();
        this.loadAllCurrency();
        this.loadOtherInfo(schemeNumber, dataList);
    }

    protected void loadOtherInfo(String schemeNumber, List<ExternalSubmitBill> dataList) {
    }

    protected void loadAllCurrency() throws BOSException {
        String sql = "SELECT FISOCODE, FID FROM T_BD_CURRENCY";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (rowSet.next()) {
                this.currenctMap.put(rowSet.getString("FISOCODE"), rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e);
        }
    }

    protected void loadSubmitElement() throws BOSException {
        if (this.isEnableSubmitElement) {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)"SELECT FID, FNUMBER FROM T_HR_SSUBMITELEMENT");
            try {
                while (rowSet.next()) {
                    this.submitElementMap.put(rowSet.getString("FNUMBER"), rowSet.getString("FID"));
                }
            }
            catch (SQLException e) {
                LOG.error((Object)e);
            }
        }
    }

    protected void loadSubmitBillByNumber(List<String> billNumbers) throws BOSException {
        if (billNumbers.isEmpty()) {
            return;
        }
        String str = " SELECT bill.FNumber billNumber, person.fNumber personNumber, entry.FCalState FROM T_HR_SBatchSubmitShemeBill bill  inner join " + this.entryTable + " entry on bill.fid = entry.FBillId inner join T_HR_SCmpEmpORelation rel on entry.FCmpEmpORelationID = rel.fid inner join t_bd_person person on rel.FPersonID = person.fid WHERE bill.FNumber IN (" + CmpStrUtil.convertListToString(billNumbers) + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)str);
        try {
            while (rowSet.next()) {
                String billNumber = rowSet.getString("billNumber");
                Map<String, String> personMap = this.billStateMap.get(billNumber);
                if (null == personMap) {
                    personMap = new HashMap<String, String>();
                    this.billStateMap.put(billNumber, personMap);
                }
                String personNumber = rowSet.getString("personNumber");
                String calState = rowSet.getString("FCalState");
                personMap.put(personNumber, calState);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"loadSubmitBillByNumber error: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPersonInfo(List<String> persons) throws BOSException {
        if (persons.isEmpty()) {
            return;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String inCondition = cmpInSql.createInSqlBaseOnFId(this.ctx, persons);
        String str = " SELECT PER.FNUMBER PERNUMBER, PER.FID PERSONID, CMPEMP.FID CMPEMPID, EMP.FADMINORGID ADMINORGID, FPOSITIONID POSITIONID,CMP.FHRORGUNITID FROM T_BD_PERSON PER  INNER JOIN T_HR_SCMPEMPORELATION CMPEMP ON PER.FID = CMPEMP.FPERSONID  INNER JOIN T_HR_SPERSONCMP CMP ON CMPEMP.FPERSONCMPID = CMP.FID  INNER JOIN T_HR_EMPORGRELATION EMP ON EMP.FID = CMPEMP.FEMPORGRELATIONID  WHERE PER.FNUMBER IN " + inCondition + " and emp.FAssignType = 1  order by EMP.FEFFDT desc, EMP.FCreateTime desc ";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)str);
        try {
            while (rowSet.next()) {
                String personNumber = rowSet.getString("PERNUMBER");
                if (this.entryInfoMap.containsKey(personNumber)) continue;
                TempBatchSubmitEntry entryInfo = new TempBatchSubmitEntry();
                entryInfo.setPersonId(rowSet.getString("PERSONID"));
                entryInfo.setCmpEmpId(rowSet.getString("CMPEMPID"));
                entryInfo.setAdminOrgId(rowSet.getString("ADMINORGID"));
                entryInfo.setPositionId(rowSet.getString("POSITIONID"));
                entryInfo.setHrOrgUnitId(rowSet.getString("FHRORGUNITID"));
                this.entryInfoMap.put(personNumber, entryInfo);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)e);
        }
        finally {
            cmpInSql.release(this.ctx);
        }
    }

    protected void initCalSubmitSchemeInfo(String schemeNumber) throws BOSException, EASBizException {
        String str = " SELECT SCHEME.FID SCHEMEID,SCHEME.FAdminOrgUnitId adminOrgUnitId,SCHEME.FNUMBER SCHEMENUMBER, REL.FBILLENTRYTABLENAME TABLENAME, ITEM.FID ITEMID, ITEM.FNUMBER ITEMNUMBER, ITEM.FDATATYPE ITEMDATATYPE, ITEM.FIELDSN,FISENABLESUBMITELEMENT  FROM T_HR_SCalSubmitScheme SCHEME  INNER JOIN T_HR_SCalShemeTableRelation REL ON SCHEME.FID = REL.FSUBMITSCHEMEID  INNER JOIN T_HR_SCalSubmitSchemeItem SCHEMEITEM ON SCHEMEITEM.FCALSUBMITSCHEMEID = SCHEME.FID  INNER JOIN T_HR_SCalSubmitItem ITEM ON ITEM.FID = SCHEMEITEM.FCALSUBMITITEMID  WHERE SCHEME.FNUMBER = '" + schemeNumber + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)str);
        if (rowSet.size() == 0) {
            String label381 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label38_1", (Locale)this.ctx.getLocale());
            String format = MessageFormat.format(label381, schemeNumber);
            throw new EASBizException(new NumericExceptionSubItem("00", format));
        }
        try {
            while (rowSet.next()) {
                CalSubmitItemInfo itemInfo = new CalSubmitItemInfo();
                itemInfo.setId(BOSUuid.read((String)rowSet.getString("ITEMID")));
                itemInfo.setNumber(rowSet.getString("ITEMNUMBER"));
                itemInfo.setDataType(CalSubmitItemDataType.getEnum((String)rowSet.getString("ITEMDATATYPE")));
                itemInfo.setFieldSn(rowSet.getInt("FIELDSN"));
                this.calSubmitItemMap.put(rowSet.getString("ITEMNUMBER"), itemInfo);
                this.calSubmitItemList.add(itemInfo);
                this.entryTable = rowSet.getString("TABLENAME");
                this.schemeId = rowSet.getString("SCHEMEID");
                this.adminOrgUnitId = rowSet.getString("adminOrgUnitId");
                this.isEnableSubmitElement = rowSet.getBoolean("FISENABLESUBMITELEMENT");
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"initCalSubmitSchemeInfo error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

