/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.AdultEduCollection;
import com.kingdee.shr.compensation.app.tax.AdultEduFactory;
import com.kingdee.shr.compensation.app.tax.AdultEduInfo;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.tax.service.TaxCommonService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AdultService
extends TaxCommonService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.tax.service.AdultService");

    @Override
    protected TaxTypeEnum getTaxTypeEnum() {
        return TaxTypeEnum.ADULT;
    }

    @Override
    public String saveInfo(Context ctx, String jsonParam) throws Exception {
        List attList;
        Map map = (Map)JSON.parseObject((String)jsonParam, Map.class);
        TaxBaseInfo bill = null;
        if (null == map.get("state")) {
            return TaxUtil.error(ctx, TaxExceptionEnum.STATE_NOT_NULL.getValue(), TaxExceptionEnum.STATE_NOT_NULL.getName());
        }
        Map objMap = (Map)map.get("adult");
        TaxStateEnum state = TaxStateEnum.getEnum((int)TaxUtil.getMapInt(map, "state"));
        String billIds = this.getTaxBaseInfoByState(ctx, 40, state.getValue());
        if (null != billIds) {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid in (" + billIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SAdultEdu where FBillId in (" + billIds + ")"));
        }
        AdultEduInfo adultInfo = (AdultEduInfo)TaxUtil.convertMapToInfo(ctx, objMap, "com.kingdee.shr.compensation.app.tax.AdultEdu", AdultEduInfo.class);
        adultInfo.setId(null);
        bill = this.setTaxBaseInfoForSave(ctx, state, adultInfo.getMoney());
        IObjectPK pk = TaxBaseFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bill);
        bill.setId(BOSUuid.read((String)pk.toString()));
        adultInfo.setBill(bill);
        IObjectPK adultPk = AdultEduFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)adultInfo);
        if (objMap.containsKey("attachment") && null != (attList = (List)objMap.get("attachment")) && attList.size() > 0) {
            this.saveAttactment(attList, adultPk.toString());
        }
        return TaxUtil.success(ctx, pk.toString());
    }

    @Override
    public String getInfo(Context ctx, String billId) {
        Map<Object, Object> map = new HashMap();
        if (StringUtils.isEmpty((String)billId)) {
            return TaxUtil.success(ctx, map);
        }
        String ksql = "select *, bill.* where bill.id = '" + billId + "'";
        AdultEduCollection coll = null;
        try {
            coll = AdultEduFactory.getLocalInstance((Context)ctx).getAdultEduCollection(ksql);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getValue(), TaxExceptionEnum.BILL_KEY_INVALID.getName());
        }
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, map);
        }
        map = this.convertInfoToJson(ctx, (CoreBaseInfo)coll.get(0));
        return TaxUtil.success(ctx, map);
    }

    @Override
    public String getHisInfo(Context ctx) throws Exception {
        String personId = TaxUtil.getPersonId(ctx);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String ksql = "select *, bill.* where bill.person.id = '" + personId + "' and bill.state in (20, 30, 40) order by bill.state asc";
        AdultEduCollection coll = AdultEduFactory.getLocalInstance((Context)ctx).getAdultEduCollection(ksql);
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, "");
        }
        for (int i = 0; i < coll.size(); ++i) {
            Map<String, Object> map = this.convertInfoToJson(ctx, (CoreBaseInfo)coll.get(i));
            list.add(map);
        }
        return TaxUtil.success(ctx, list);
    }

    @Override
    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseInfo coreInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<Object, Object> dataMap = new HashMap();
        AdultEduInfo info = (AdultEduInfo)coreInfo;
        dataMap = TaxUtil.getMapDataFromCoreInfo(ctx, (CoreBaseInfo)info, "com.kingdee.shr.compensation.app.tax.AdultEdu");
        this.setBillHeadMapForWeb(info.getBill(), map);
        map.put("adult", dataMap);
        return map;
    }
}

