/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.TaxExceptionEnum;
import com.kingdee.shr.compensation.app.tax.CountryInfo;
import com.kingdee.shr.compensation.app.tax.EducationCollection;
import com.kingdee.shr.compensation.app.tax.EducationFactory;
import com.kingdee.shr.compensation.app.tax.EducationInfo;
import com.kingdee.shr.compensation.app.tax.IEducation;
import com.kingdee.shr.compensation.app.tax.TaxBaseFactory;
import com.kingdee.shr.compensation.app.tax.TaxBaseInfo;
import com.kingdee.shr.compensation.app.tax.TaxStateEnum;
import com.kingdee.shr.compensation.app.tax.TaxTypeEnum;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.shr.compensation.tax.service.TaxCommonService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EducationService
extends TaxCommonService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.tax.service.EducationService");

    @Override
    protected TaxTypeEnum getTaxTypeEnum() {
        return TaxTypeEnum.EDUCATION;
    }

    @Override
    public String saveInfo(Context ctx, String jsonParam) throws Exception {
        IEducation eduInstance = EducationFactory.getLocalInstance((Context)ctx);
        double total = 0.0;
        Map map = (Map)JSON.parseObject((String)jsonParam, Map.class);
        TaxBaseInfo bill = null;
        if (null == map.get("state")) {
            return TaxUtil.error(ctx, TaxExceptionEnum.STATE_NOT_NULL.getValue(), TaxExceptionEnum.STATE_NOT_NULL.getName());
        }
        List list = (List)map.get("education");
        TaxStateEnum state = TaxStateEnum.getEnum((int)TaxUtil.getMapInt(map, "state"));
        String billIds = this.getTaxBaseInfoByState(ctx, 30, state.getValue());
        if (null != billIds) {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_STaxBase where fid in (" + billIds + ")"));
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SEducation where FBillId in (" + billIds + ")"));
        }
        for (int i = 0; i < list.size(); ++i) {
            EducationInfo eduInfo = (EducationInfo)TaxUtil.convertMapToInfo(ctx, (Map)list.get(i), "com.kingdee.shr.compensation.app.tax.Education", EducationInfo.class);
            total += eduInfo.getMoney();
        }
        bill = this.setTaxBaseInfoForSave(ctx, state, total);
        IObjectPK pk = TaxBaseFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)bill);
        bill.setId(BOSUuid.read((String)pk.toString()));
        for (int i = 0; i < list.size(); ++i) {
            List attList;
            CountryInfo c;
            String nationalityId;
            EducationInfo eduInfo = (EducationInfo)TaxUtil.convertMapToInfo(ctx, (Map)list.get(i), "com.kingdee.shr.compensation.app.tax.Education", EducationInfo.class);
            eduInfo.setId(null);
            String countryId = null == ((Map)list.get(i)).get("country") ? null : ((Map)list.get(i)).get("country").toString();
            String string = nationalityId = null == ((Map)list.get(i)).get("nationality") ? null : ((Map)list.get(i)).get("nationality").toString();
            if (null != countryId) {
                c = new CountryInfo();
                c.setId(BOSUuid.read((String)countryId));
                eduInfo.setCountry(c);
            }
            if (null != nationalityId) {
                c = new CountryInfo();
                c.setId(BOSUuid.read((String)nationalityId));
                eduInfo.setNationality(c);
            }
            eduInfo.setBill(bill);
            IObjectPK eduPk = eduInstance.save((CoreBaseInfo)eduInfo);
            if (!((Map)list.get(i)).containsKey("attachment") || null == (attList = (List)((Map)list.get(i)).get("attachment")) || attList.size() <= 0) continue;
            this.saveAttactment(attList, eduPk.toString());
        }
        return TaxUtil.success(ctx, pk.toString());
    }

    @Override
    public String getInfo(Context ctx, String billId) {
        Map<Object, Object> map = new HashMap();
        CoreBaseCollection dataColl = new CoreBaseCollection();
        if (StringUtils.isEmpty((String)billId)) {
            return TaxUtil.success(ctx, map);
        }
        String ksql = "select *, bill.*, country.id, country.name, nationality.id, nationality.name where bill.id = '" + billId + "'";
        EducationCollection coll = null;
        try {
            coll = EducationFactory.getLocalInstance((Context)ctx).getEducationCollection(ksql);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getValue(), TaxExceptionEnum.BILL_KEY_INVALID.getName());
        }
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, map);
        }
        for (int i = 0; i < coll.size(); ++i) {
            dataColl.add((CoreBaseInfo)coll.get(i));
        }
        map = this.convertInfoToJson(ctx, dataColl);
        return TaxUtil.success(ctx, map);
    }

    @Override
    protected Map<String, Object> convertInfoToJson(Context ctx, CoreBaseCollection coll) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < coll.size(); ++i) {
            EducationInfo info = (EducationInfo)coll.get(i);
            Map<String, Object> dataMap = TaxUtil.getMapDataFromCoreInfo(ctx, (CoreBaseInfo)info, "com.kingdee.shr.compensation.app.tax.Education");
            list.add(dataMap);
        }
        map.put("education", list);
        EducationInfo info = (EducationInfo)coll.get(0);
        this.setBillHeadMapForWeb(info.getBill(), map);
        return map;
    }

    @Override
    public String getHisInfo(Context ctx) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        CoreBaseCollection dataColl = new CoreBaseCollection();
        String personId = TaxUtil.getPersonId(ctx);
        String ksql = " select *, bill.*,country.*,nationality.* where bill.person.id = '" + personId + "' and bill.state in (20, 30, 40) order by bill.state asc, bill.id ";
        EducationCollection coll = EducationFactory.getLocalInstance((Context)ctx).getEducationCollection(ksql);
        if (null == coll || coll.size() < 1) {
            return TaxUtil.success(ctx, "");
        }
        String billId = coll.get(0).getBill().getId().toString();
        for (int i = 0; i < coll.size(); ++i) {
            String newBillId = coll.get(i).getBill().getId().toString();
            if (billId.equals(newBillId)) {
                dataColl.add((CoreBaseInfo)coll.get(i));
                continue;
            }
            Map<String, Object> map = this.convertInfoToJson(ctx, dataColl);
            list.add(map);
            dataColl = new CoreBaseCollection();
            billId = newBillId;
        }
        if (dataColl.size() > 0) {
            Map<String, Object> map = this.convertInfoToJson(ctx, dataColl);
            list.add(map);
        }
        return TaxUtil.success(ctx, list);
    }
}

