/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueFactory;
import com.kingdee.shr.compensation.app.tax.IncomeTaxIssueInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueHandleData;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueHandleResponse;
import com.kingdee.shr.compensation.app.taxCal.vo.IncomeTaxIssueHandleResponseVO;
import com.kingdee.shr.compensation.app.taxCal.vo.Ssmx;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class IncomeIssueHandleService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(IncomeIssueHandleService.class);
    private static final int HANDLE_SUCCESS = 0;

    @Override
    public boolean isData4Resolving(String code) {
        return "0000".equals(code) || "0612".equals(code);
    }

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        IncomeTaxIssueHandleResponseVO responseVO = (IncomeTaxIssueHandleResponseVO)JSON.parseObject((String)response, IncomeTaxIssueHandleResponseVO.class);
        IncomeTaxIssueHandleResponse responseData = responseVO.getData();
        String taskId = taskInfo.getId().toString();
        TaxCalTaskStateEnum status = "0000".equals(responseVO.getCode()) ? TaxCalTaskStateEnum.FINISHED : TaxCalTaskStateEnum.FAIDED;
        TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, status, responseVO.getMsg());
        if (null == responseData || responseData.getData() == null || responseData.getData().isEmpty()) {
            logger.error((Object)("_afterHandleIncomeTaxIssue: responseData is empty, taskId = " + taskInfo.getId().toString()));
            return;
        }
        List data = responseData.getData();
        String incomeBatchSQL = "update t_hr_sIncomeTaxIssue set fStatus = ?, fErrInfo = ? where fMessageId = ? and exists (select 1 from t_hr_sIncomeTaxIssueEntry e where e.fid = fEntryId and e.fIndex = ?)";
        String employBatchSQL = "update t_hr_sIncomeTaxIssue set fStatus = ?, fErrInfo = ? where fMessageId = ?";
        this.updateResult(ctx, data, incomeBatchSQL, employBatchSQL);
        ArrayList<Long> messageIds = new ArrayList<Long>();
        for (IncomeTaxIssueHandleData handleData : data) {
            messageIds.add(handleData.getId());
        }
        if (status == TaxCalTaskStateEnum.FINISHED) {
            this.sendMessage(ctx, taskId, messageIds);
        } else {
            this.sendMsg2Commander(ctx, taskInfo);
        }
    }

    private void sendMessage(Context ctx, String taskId, List<Long> messageIds) {
        String title = "\u7533\u8bc9\u5904\u7406\u7ed3\u679c\u4e0a\u4f20\u7684\u4efb\u52a1\u7f16\u7801[%s]\u4e0a\u4f20\u6210\u529f\uff0c\u8be6\u60c5\u67e5\u770b\u4e89\u8bae\u7533\u8bc9\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
        String content = "\u7eb3\u7a0e\u5355\u4f4d[%s][%s][%s]\u7533\u8bc9\u5904\u7406\u5b8c\u6210\u3002\u8bf7\u9488\u5bf9\u7533\u8bc9\u5c5e\u5b9e\u4eba\u5458\u8fdb\u884c\u66f4\u6b63\u7533\u62a5\u64cd\u4f5c\uff0c\u540e\u7eed\u5982\u679c\u9700\u8981\u5bf9\u5c5e\u5b9e\u4eba\u5458\u8fdb\u884c\u4e2a\u7a0e\u7533\u62a5\uff0c\u8bf7\u8fdb\u5165\u7533\u8bc9\u5c5e\u5b9e\u4eba\u5458\u5217\u8868\uff0c\u8c03\u7528\u7533\u8bc9\u5c5e\u5b9e\u4eba\u5458\u9080\u8bf7\u63a5\u53e3";
        String taxUnitName = "";
        HashSet<String> issueItems = new HashSet<String>();
        String yearMonth = CmpDateUtil.getDateStr(CmpDateUtil.getLastMonthEndDate(), "yyyyMM");
        try {
            String taskOql = "select creator.id, number where id = '" + taskId + "'";
            TaxCalTaskInfo taskInfo = TaxCalTaskFactory.getLocalInstance((Context)ctx).getTaxCalTaskInfo(taskOql);
            String oql = "select taxUnit.name, issueItem, lastUpdateUser.person.id where messageId in (" + this.combineByComma(messageIds) + ")";
            IncomeTaxIssueCollection issues = IncomeTaxIssueFactory.getLocalInstance((Context)ctx).getIncomeTaxIssueCollection(oql);
            for (int i = 0; i < issues.size(); ++i) {
                IncomeTaxIssueInfo issue = issues.get(i);
                taxUnitName = issue.getTaxUnit().getName();
                issueItems.add(issue.getIssueItem().getAlias());
            }
            title = String.format(title, taskInfo.getNumber());
            StringBuilder items = new StringBuilder();
            for (String str : issueItems) {
                if (items.length() > 0) {
                    items.append("\uff0c");
                }
                items.append(str);
            }
            content = String.format(content, taxUnitName, yearMonth, items);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, taskInfo.getCreator().getId().toString(), title, content, "\u85aa\u916c\u4e2a\u7a0e");
        }
        catch (Exception e) {
            logger.error((Object)"sendMessage error: ", (Throwable)e);
        }
    }

    private String combineByComma(List<Long> list) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Long o : list) {
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(o);
        }
        return sb.toString();
    }

    private void updateResult(Context ctx, List<IncomeTaxIssueHandleData> data, String incomeBatchSQL, String employBatchSQL) throws BOSException {
        ArrayList<Object[]> incomeBatchParams = new ArrayList<Object[]>();
        ArrayList<Object[]> employBatchParams = new ArrayList<Object[]>();
        for (IncomeTaxIssueHandleData handleData : data) {
            List items = handleData.getSsmxlb();
            int status = this.getHandleStatus(handleData.getStatus());
            if (items != null && !items.isEmpty()) {
                for (Ssmx item : items) {
                    Object[] param = new Object[4];
                    int itemStatus = this.getHandleStatus(item.getStatus());
                    param[0] = this.getStatus(status, itemStatus);
                    param[1] = StringUtils.isEmpty((String)item.getErrInfo()) ? handleData.getErrInfo() : item.getErrInfo();
                    param[2] = handleData.getId();
                    param[3] = item.getSsmxxh();
                    incomeBatchParams.add(param);
                }
                continue;
            }
            Object[] param = new Object[]{status, handleData.getErrInfo(), handleData.getId()};
            employBatchParams.add(param);
        }
        if (!incomeBatchParams.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)incomeBatchSQL, incomeBatchParams);
        }
        if (!employBatchParams.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)employBatchSQL, employBatchParams);
        }
    }

    private int getHandleStatus(int status) {
        return status == 0 ? 2 : 3;
    }

    private int getStatus(int status, int itemStatus) {
        if (status == 3) {
            return status;
        }
        return itemStatus;
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        String updateIssueSql = "update T_HR_SIncomeTaxIssue Set fStatus = ? where fid in (select r.fBizId from T_HR_STaskIncomeTaxRelation r left join T_HR_STaxCalTask t on r.fTaskId = t.fid where t.fid = ? and t.fCatalog = 160)";
        String taskId = taskInfo.getId().toString();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)errMsg) ? "\u7533\u8bc9\u4e89\u8bae\u5904\u7406\u5931\u8d25\uff1a" : errMsg, taskId};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        paramList.clear();
        param = new Object[]{3, taskId};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateIssueSql, paramList);
        this.sendMsg2Commander(ctx, taskInfo);
    }

    public void sendMsg2Commander(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String number = taxCalTaskInfo.getNumber();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            String title = "\u7533\u8bc9\u5904\u7406\u7ed3\u679c\u4e0a\u4f20\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u4e0a\u4f20\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u7533\u8bc9\u4e89\u8bae\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
            String msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}]\u7533\u8bc9\u5904\u7406\u5931\u8d25";
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            String msg = MessageFormat.format(msgTemplate, taxUnitName, taxCalTaskInfo.getPeriod());
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)"FailureHandler160 error: ", (Throwable)e);
        }
    }
}

