/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.task.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.vo.UpdateDeclareData;
import com.kingdee.shr.compensation.app.taxCal.vo.UpdateDeclareResponseData;
import com.kingdee.shr.compensation.app.taxCal.vo.UpdateDeclareResponseVO;
import com.kingdee.shr.compensation.helper.CmpConstants;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.taxCal.util.TaxCalcFileUtils;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.message.MessageUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class TaxDeclareUpdateService
implements ITaxTaskService {
    private static Logger logger = Logger.getLogger(TaxDeclareUpdateService.class);
    protected static final int DECLARE_NOT = 0;
    protected static final int DECLARE_WAITING = 1;
    protected static final int DECLARE_SUCCESS = 2;

    @Override
    public void onSuccess(Context ctx, TaxCalTaskInfo taskInfo, String response) throws BOSException {
        UpdateDeclareResponseVO responseVO = (UpdateDeclareResponseVO)JSON.parseObject((String)response, UpdateDeclareResponseVO.class);
        String taskId = taskInfo.getId().toString();
        String sql = "select d.fid as id, d.fTbType as tbType, fBatchNo as batchNo  from t_hr_sIncomeTaxDeclar d, t_hr_sTaskIncomeTaxRelation r, t_hr_sTaxCalTask t where d.fid = r.fBizId and r.fTaskId = t.fid and t.fid = '" + taskId + "' and t.fCatalog='" + 120 + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                throw new BOSException("\u901a\u8fc7acceptId[" + taskId + "]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7533\u62a5\u6570\u636e");
            }
            String tbType = null;
            String declareId = null;
            String batchNo = null;
            while (rowSet.next()) {
                tbType = rowSet.getString("tbType");
                declareId = rowSet.getString("id");
                batchNo = rowSet.getString("batchNo");
            }
            if (StringUtils.isEmpty(batchNo)) {
                batchNo = TaxCalcFileUtils.getUUID();
            }
            UpdateDeclareResponseData data = responseVO.getData();
            UpdateDeclareData result = "1".equals(tbType) ? data.getYkyjsbjg() : ("2".equals(tbType) ? data.getFlsdsbjg() : data.getFjmsbjg());
            Integer sbbz = result.getSbbz();
            if (sbbz != 1 && sbbz != 0) {
                logger.error((Object)("_afterUpdateDeclare sbbz=" + sbbz + ", \u7533\u62a5\u6807\u5fd7\u4e0d\u662f\u5f85\u7533\u62a5\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5904\u7406"));
                logger.error((Object)("_afterUpdateDeclare errorInfo: " + result.getErrorinfo()));
                return;
            }
            TaxCalTaskStateEnum taskState = TaxCalTaskStateEnum.FINISHED;
            String msg = result.getErrorinfo();
            msg = StringUtils.isEmpty((CharSequence)msg) ? "\u66f4\u6b63\u6210\u529f\uff01" : msg;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            String declareSQL = "update t_hr_sIncomeTaxDeclar set FDeclareType = ?, FDeclareStatus = ?, fBatchNo = ? where fid = ?";
            String newBatchNo = TaxCalcFileUtils.getUUID();
            Object[] param = new Object[]{1, "0", newBatchNo, declareId};
            params.add(param);
            List<String> configDetailIds = this.copyData(ctx, declareId, 2, batchNo, newBatchNo);
            this.updateBatchNo4ConfigData(ctx, configDetailIds, newBatchNo);
            DbUtil.executeBatch((Context)ctx, (String)declareSQL, params);
            TaxCalTaskFactory.getLocalInstance((Context)ctx).updateStateMsgById(taskId, taskState, msg);
            taskInfo.setState(taskState);
            this.sendMsg2Commander(ctx, taskInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_afterUpdateDeclare error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    protected void updateBatchNo4ConfigData(Context ctx, List<String> configDetailIds, String batchNo) throws BOSException {
        String sql = "update t_hr_sTaxCalConfigDetail set fBatchNo = ? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String id : configDetailIds) {
            Object[] param = new Object[]{batchNo, id};
            params.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    protected List<String> copyData(Context ctx, String declareId, int dataType, String batchNo, String newBatchNo) throws BOSException, SQLException {
        String selectSQL1 = "select * from t_hr_sIncomeTaxDeclar where fid = '" + declareId + "'";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)selectSQL1);
        ArrayList<String> columns1 = new ArrayList<String>();
        ArrayList<Object[]> values1 = new ArrayList<Object[]>();
        IRowSetMetaData metaData1 = rowSet1.getRowSetMetaData();
        String originalId = "";
        String tbType = "1";
        String taxUnitId = null;
        Date period = null;
        while (rowSet1.next()) {
            Object[] row = new Object[metaData1.getColumnCount() + 3];
            for (int i = 1; i <= metaData1.getColumnCount(); ++i) {
                int columnType = metaData1.getColumnType(i);
                String columnName = metaData1.getColumnName(i);
                Object val = ImplUtils.getDataFromDr((int)columnType, (ResultSet)rowSet1, (int)i);
                if ("fid".equalsIgnoreCase(columnName)) {
                    originalId = (String)val;
                    row[i - 1] = BOSUuid.create((String)"F9F65905").toString();
                } else if ("fBatchNo".equalsIgnoreCase(columnName)) {
                    row[i - 1] = batchNo;
                } else if ("fCreateTime".equalsIgnoreCase(columnName)) {
                    row[i - 1] = new Timestamp(System.currentTimeMillis());
                } else {
                    if ("fYearMonthDate".equalsIgnoreCase(columnName)) {
                        period = (Date)val;
                    }
                    if ("fTaxUnitId".equalsIgnoreCase(columnName)) {
                        taxUnitId = (String)val;
                    }
                    if ("fTbType".equalsIgnoreCase(columnName)) {
                        tbType = (String)val;
                    }
                    row[i - 1] = val;
                }
                columns1.add(columnName);
            }
            row[metaData1.getColumnCount()] = newBatchNo;
            row[metaData1.getColumnCount() + 1] = dataType;
            row[metaData1.getColumnCount() + 2] = originalId;
            values1.add(row);
            columns1.add("FUpdateBatchNo");
            columns1.add("FDataType");
            columns1.add("FOriginalId");
        }
        String taxDeclareBakSQL = this.genInsertSQL("t_hr_sIncomeTaxDeclareHis", columns1);
        DbUtil.executeBatch((Context)ctx, (String)taxDeclareBakSQL, values1);
        String payerType = CmpConstants.getPayerTypeByTbType(tbType);
        String taxCalInitSQL = "select t.* from t_hr_sTaxCalInitDetail t left join T_HR_STaxPersonRecordEntry tpr on t.fTaxUnitId = tpr.fTaxUnitId and t.fPersonId = tpr.fPersonId where t.fTaxUnitId = '" + taxUnitId + "' and t.fPeriodBegin = " + CmpDateUtil.toKSqlDate(period) + " and tpr.FPayerType = '" + payerType + "'";
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)taxCalInitSQL);
        ArrayList<String> columns2 = new ArrayList<String>();
        ArrayList<Object[]> values2 = new ArrayList<Object[]>();
        IRowSetMetaData metaData2 = rowSet2.getRowSetMetaData();
        this.setColumnsAndValues4InitData(rowSet2, columns2, values2, metaData2, batchNo);
        String taxCalInitBakSQL = this.genInsertSQL("t_hr_sTaxCalInitDetailHis", columns2);
        DbUtil.executeBatch((Context)ctx, (String)taxCalInitBakSQL, values2);
        String taxCalConfigSQL = "select t.* from t_hr_sTaxCalConfigDetail t left join T_HR_STaxPersonRecordEntry tpr on t.fTaxUnitId = tpr.fTaxUnitId and t.fPersonId = tpr.fPersonId where t.fTaxUnitId = '" + taxUnitId + "' and t.fPeriodBegin = " + CmpDateUtil.toKSqlDate(period) + " and tpr.FPayerType = '" + payerType + "'";
        IRowSet rowSet3 = DbUtil.executeQuery((Context)ctx, (String)taxCalConfigSQL);
        ArrayList<String> columns3 = new ArrayList<String>();
        ArrayList<Object[]> values3 = new ArrayList<Object[]>();
        IRowSetMetaData metaData3 = rowSet3.getRowSetMetaData();
        List<String> idList = this.setColumnsAndValues4ConfigData(rowSet3, columns3, values3, metaData3, batchNo);
        String taxCalConfigBakSQL = this.genInsertSQL("t_hr_sTaxCalConfigDetailHis", columns3);
        DbUtil.executeBatch((Context)ctx, (String)taxCalConfigBakSQL, values3);
        return idList;
    }

    protected List<String> setColumnsAndValues4ConfigData(IRowSet rowSet, List<String> columns, List<Object[]> values, IRowSetMetaData metaData, String batchNo) throws SQLException {
        ArrayList<String> idList = new ArrayList<String>();
        int index = 1;
        String originalId = "";
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        while (rowSet.next()) {
            Object[] row = new Object[metaData.getColumnCount() + 1];
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                int columnType = metaData.getColumnType(i);
                String columnName = metaData.getColumnName(i);
                Object val = ImplUtils.getDataFromDr((int)columnType, (ResultSet)rowSet, (int)i);
                if ("fid".equalsIgnoreCase(columnName)) {
                    row[i - 1] = BOSUuid.create((String)"BC2BCD93").toString();
                    originalId = (String)val;
                    idList.add(originalId);
                } else {
                    row[i - 1] = "fBatchNo".equalsIgnoreCase(columnName) ? batchNo : ("fCreateTime".equalsIgnoreCase(columnName) ? createTime : val);
                }
                if (index != 1) continue;
                columns.add(columnName);
            }
            row[row.length - 1] = originalId;
            values.add(row);
            ++index;
        }
        columns.add("FOriginalId");
        return idList;
    }

    protected void setColumnsAndValues4InitData(IRowSet rowSet, List<String> columns, List<Object[]> values, IRowSetMetaData metaData, String batchNo) throws SQLException {
        int index = 1;
        String originalId = "";
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        while (rowSet.next()) {
            Object[] row = new Object[metaData.getColumnCount() + 2];
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                int columnType = metaData.getColumnType(i);
                String columnName = metaData.getColumnName(i);
                Object val = ImplUtils.getDataFromDr((int)columnType, (ResultSet)rowSet, (int)i);
                if ("fid".equalsIgnoreCase(columnName)) {
                    row[i - 1] = BOSUuid.create((String)"CACAD085").toString();
                    originalId = (String)val;
                } else {
                    row[i - 1] = "fCreateTime".equalsIgnoreCase(columnName) ? createTime : val;
                }
                if (index != 1) continue;
                columns.add(columnName);
            }
            row[row.length - 2] = batchNo;
            row[row.length - 1] = originalId;
            values.add(row);
            ++index;
        }
        columns.add("fBatchNo");
        columns.add("FOriginalId");
    }

    protected String genInsertSQL(String tableName, List<String> columns) {
        StringBuilder fieldStr = new StringBuilder();
        StringBuilder valueStr = new StringBuilder();
        for (String column : columns) {
            if (fieldStr.length() > 0) {
                fieldStr.append(",");
                valueStr.append(",");
            }
            fieldStr.append(column);
            valueStr.append("?");
        }
        return "insert into " + tableName + "(" + fieldStr.toString() + ") values (" + valueStr.toString() + ")";
    }

    @Override
    public void onFailure(Context ctx, TaxCalTaskInfo taskInfo, String errMsg) throws BOSException {
        String updateSql = "update T_HR_STaxCalTask Set fSTATE = ? , fMsg = ? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = new Object[]{30, StringUtils.isEmpty((CharSequence)errMsg) ? "\u66f4\u6b63\u5931\u8d25" : errMsg, taskInfo.getId().toString()};
        paramList.add(param);
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        this.sendMsg2Commander(ctx, taskInfo);
    }

    protected void sendMsg2Commander(Context ctx, TaxCalTaskInfo taxCalTaskInfo) {
        try {
            String msgTemplate;
            String title;
            String declareSQL = "select d.fTbType from t_hr_sIncomeTaxDeclar d, t_hr_sTaskIncomeTaxRelation r, t_hr_sTaxCalTask t where d.fid = r.fBizId and r.fTaskId = t.fid and t.fid = '" + taxCalTaskInfo.getId().toString() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)declareSQL);
            String tbType = "1";
            while (rowSet.next()) {
                tbType = rowSet.getString(1);
            }
            String tbTypeStr = CmpConstants.getTbTypeDesc(tbType);
            String number = taxCalTaskInfo.getNumber();
            TaxCalTaskStateEnum state = taxCalTaskInfo.getState();
            String taxUnitName = taxCalTaskInfo.getTaxUnit().getName();
            String period = taxCalTaskInfo.getPeriod();
            String sendUserID = taxCalTaskInfo.getCreator().getId().toString();
            if (TaxCalTaskStateEnum.FINISHED.equals((Object)state)) {
                title = "\u66f4\u6b63\u7533\u62a5\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u66f4\u6b63\u6210\u529f\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}][{2}]\u66f4\u6b63\u5b8c\u6210\uff0c\u8bf7\u8fdb\u5165[\u4e2a\u7a0e\u670d\u52a1-\u4e2a\u7a0e\u7533\u62a5-\u66f4\u6b63\u5904\u7406]\u64cd\u4f5c";
            } else {
                title = "\u66f4\u6b63\u7533\u62a5\u7684\u4efb\u52a1\u7f16\u7801[{0}]\u66f4\u6b63\u5931\u8d25\uff0c\u8be6\u60c5\u67e5\u770b\u4e2a\u7a0e\u7533\u62a5\u5217\u8868\u6216\u4efb\u52a1\u6267\u884c\u76d1\u63a7\u5217\u8868";
                msgTemplate = "\u7eb3\u7a0e\u5355\u4f4d[{0}][{1}][{2}]\u66f4\u6b63\u5931\u8d25";
            }
            String category = "\u85aa\u916c\u4e2a\u7a0e";
            String titleStr = MessageFormat.format(title, number);
            String msg = MessageFormat.format(msgTemplate, taxUnitName, period, tbTypeStr);
            MessageUtil.setNeedSending(ctx);
            MessageUtil.sendMessage(ctx, sendUserID, titleStr, msg, category);
        }
        catch (Exception e) {
            logger.error((Object)"FailureHandler120 error: ", (Throwable)e);
        }
    }
}

