/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.taxCal.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.complexquery.QueryFieldInfo;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCatalogInfo;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemFactory;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.ml.util.MutilanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TaxItemUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.taxCal.util.TaxItemUtil");

    public static TaxItemCollection getAllTaxItem(Context ctx, boolean isNumber) {
        TaxItemCollection coll = null;
        String oql = "select dataType, fieldSn, dataDot, isSum, isSplit, name, number ";
        if (isNumber) {
            oql = oql + " where dataType = 0 ";
        }
        try {
            coll = TaxItemFactory.getLocalInstance((Context)ctx).getTaxItemCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return coll;
    }

    public static Map<String, TaxItemInfo> getAllTaxItemMap(Context ctx) {
        HashMap<String, TaxItemInfo> map = new HashMap<String, TaxItemInfo>();
        TaxItemCollection coll = TaxItemUtil.getAllTaxItem(ctx, false);
        for (int i = 0; i < coll.size(); ++i) {
            map.put("t" + coll.get(i).getFieldSn(), coll.get(i));
        }
        return map;
    }

    public static TaxItemCollection getUserTaxItemRange(Context ctx, String permItemId, boolean isAll) {
        TaxItemCollection taxColl = new TaxItemCollection();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String language = ctx.getLocale().getLanguage();
        StringBuilder str = new StringBuilder();
        str.append(" SELECT ITEM.FID ITEMID, ITEM.FDATATYPE, ITEM.FIELDSN, ITEM.FNAME_").append(language).append(" ITEMNAME, ITEM.FNUMBER, ");
        str.append(" CATALOG.FID CATALOGID, CATALOG.FNAME_").append(language).append(" CATALOGNAME, CATALOG.FNUMBER CATALOGNUMBER, ");
        str.append(" ITEM.FISSUM ");
        str.append(" FROM T_HR_STAXITEM ITEM ");
        str.append(" INNER JOIN T_HR_STAXITEMCATALOG CATALOG ON ITEM.FCATALOGID = CATALOG.FID ");
        if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(userId)) {
            String hrRange = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
            str.append(" WHERE EXISTS (");
            str.append(" SELECT 1 FROM T_HR_STAXITEMRELHR WHERE FBASEINFOID = ITEM.FID AND FSTATE=100 AND FHRORGUSEID IN (");
            str.append(hrRange);
            str.append(")) ");
        }
        if (!isAll) {
            str.append(" and ITEM.FDATATYPE = 0 ");
        }
        str.append(" ORDER BY FCATALOGID, FIELDSN ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            while (rowSet.next()) {
                TaxItemInfo itemInfo = new TaxItemInfo();
                TaxItemCatalogInfo catalogInfo = new TaxItemCatalogInfo();
                itemInfo.setId(BOSUuid.read((String)rowSet.getString("ITEMID")));
                itemInfo.setName(rowSet.getString("ITEMNAME"));
                itemInfo.setNumber(rowSet.getString("FNUMBER"));
                itemInfo.setDataType(CmpItemDataType.getEnum(rowSet.getInt("FDATATYPE")));
                itemInfo.setFieldSn(rowSet.getInt("FIELDSN"));
                itemInfo.setIsSum(rowSet.getBoolean("FISSUM"));
                catalogInfo.setId(BOSUuid.read((String)rowSet.getString("CATALOGID")));
                catalogInfo.setName(rowSet.getString("CATALOGNAME"));
                catalogInfo.setNumber(rowSet.getString("CATALOGNUMBER"));
                itemInfo.setCatalog(catalogInfo);
                taxColl.add(itemInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        return taxColl;
    }

    public static List<QueryFieldInfo> getTreeTaxItems(Context ctx, String permItemId, String strctureNumber) {
        TaxItemCollection taxColl = TaxItemUtil.getUserTaxItemRange(ctx, permItemId, true);
        return TaxItemUtil.assembleTree(taxColl, strctureNumber);
    }

    private static List<QueryFieldInfo> assembleTree(TaxItemCollection taxColl, String strctureNumber) {
        ArrayList<QueryFieldInfo> catalogList = new ArrayList<QueryFieldInfo>();
        LinkedHashMap<String, QueryFieldInfo> catalogMap = new LinkedHashMap<String, QueryFieldInfo>();
        for (int i = 0; i < taxColl.size(); ++i) {
            TaxItemInfo itemInfo = taxColl.get(i);
            String id = itemInfo.getId().toString();
            String name = itemInfo.getName();
            String number = itemInfo.getNumber();
            int fieldSn = itemInfo.getFieldSn();
            int dataType = itemInfo.getDataType().getValue();
            if (null == itemInfo.getCatalog()) continue;
            String catalogName = itemInfo.getCatalog().getName();
            String catalogNumber = itemInfo.getCatalog().getNumber();
            String catalogID = itemInfo.getCatalog().getId().toString();
            QueryFieldInfo queryFieldInfo = new QueryFieldInfo();
            if (dataType == 0) {
                queryFieldInfo.setDataType("Double");
            } else {
                queryFieldInfo.setDataType("String");
            }
            if (!catalogMap.containsKey(catalogID)) {
                ArrayList itemChildren = new ArrayList();
                QueryFieldInfo catalogQueryFieldInfo = new QueryFieldInfo();
                Map qcncmpItemCatalog = MutilanUtils.setMultiFieldValue((String)"name", (IObjectValue)itemInfo.getCatalog());
                catalogQueryFieldInfo.setNameMultiLan(qcncmpItemCatalog);
                catalogQueryFieldInfo.setQueryConfigNameMultiLan(qcncmpItemCatalog);
                catalogQueryFieldInfo.setDataType("String");
                catalogQueryFieldInfo.setEnumSource(null);
                catalogQueryFieldInfo.setF7FieldName(null);
                catalogQueryFieldInfo.setField(null);
                catalogQueryFieldInfo.setId(null);
                catalogQueryFieldInfo.setLeaf(false);
                catalogQueryFieldInfo.setName(catalogName);
                catalogQueryFieldInfo.setNumber(catalogNumber);
                catalogQueryFieldInfo.setUipk(null);
                catalogQueryFieldInfo.setChildren(itemChildren);
                catalogMap.put(catalogID, catalogQueryFieldInfo);
            }
            Map qcn = MutilanUtils.setMultiFieldValue((String)"name", (IObjectValue)itemInfo);
            queryFieldInfo.setNameMultiLan(qcn);
            queryFieldInfo.setQueryConfigNameMultiLan(qcn);
            queryFieldInfo.setEnumSource(null);
            queryFieldInfo.setF7FieldName(null);
            queryFieldInfo.setField(strctureNumber + "." + "T" + fieldSn);
            queryFieldInfo.setId(id);
            queryFieldInfo.setLeaf(true);
            queryFieldInfo.setName(name);
            queryFieldInfo.setNumber(number);
            queryFieldInfo.setUipk(null);
            queryFieldInfo.setChildren(null);
            ((QueryFieldInfo)catalogMap.get(catalogID)).getChildren().add(queryFieldInfo);
        }
        for (Map.Entry entry : catalogMap.entrySet()) {
            catalogList.add((QueryFieldInfo)entry.getValue());
        }
        return catalogList;
    }
}

