/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CardTypeEnum;
import com.kingdee.shr.compensation.app.entity.Pair;
import com.kingdee.shr.compensation.app.entity.TaxPersonEntity;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordEntryInfo;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonRecordInfo;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarCollection;
import com.kingdee.shr.compensation.app.tax.IncomeTaxDeclarFactory;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TaxReportUtil {
    private static final String YES = "\u662f";
    private static final String NO = "\u5426";

    public static CardTypeEnum convertCardType(String cardType) {
        if (StringUtils.isEmpty((String)cardType)) {
            return null;
        }
        for (Object e : CardTypeEnum.getEnumList()) {
            CardTypeEnum cardTypeEnum = (CardTypeEnum)((Object)e);
            if (!cardTypeEnum.getAlias().equals(cardType)) continue;
            return cardTypeEnum;
        }
        if (cardType.contains("\u9999\u6e2f") || cardType.contains("\u6fb3\u95e8")) {
            if (cardType.contains("\u901a\u884c\u8bc1")) {
                return CardTypeEnum.HongKongPass;
            }
            if (cardType.contains("\u5c45\u4f4f\u8bc1")) {
                return CardTypeEnum.ResidePermit;
            }
            return null;
        }
        if (cardType.contains("\u53f0\u6e7e")) {
            if (cardType.contains("\u901a\u884c\u8bc1")) {
                return CardTypeEnum.TaiWaPassPort;
            }
            if (cardType.contains("\u5c45\u4f4f\u8bc1")) {
                return CardTypeEnum.TaiWaPermit;
            }
            return null;
        }
        return CardTypeEnum.ForeignPassPort;
    }

    public static TaxPersonEntity taxPersonRecordEntryInfo2TaxPersonEntity(TaxPersonRecordEntryInfo taxPersonRecordEntryInfo) {
        TaxPersonEntity taxPersonEntity = new TaxPersonEntity();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        TaxPersonRecordInfo bill = taxPersonRecordEntryInfo.getBill();
        PersonInfo person = bill.getPerson();
        taxPersonEntity.setZzlx(null == bill.getCardType() ? null : bill.getCardType().getAlias());
        taxPersonEntity.setZzhm(bill.getCardNumber());
        String name = bill.getReportName();
        if (StringUtils.isEmpty((String)name)) {
            name = person.getName();
        }
        taxPersonEntity.setXm(name.trim());
        taxPersonEntity.setGj(null == bill.getNationality() ? null : bill.getNationality().getName());
        taxPersonEntity.setXb(null == bill.getGender() ? null : bill.getGender().getAlias());
        taxPersonEntity.setCsny(null == bill.getBirthday() ? null : format.format(bill.getBirthday()));
        taxPersonEntity.setXl(null == bill.getEduLevel() ? null : bill.getEduLevel().getName());
        taxPersonEntity.setSfcj(bill.isIsDisability() ? YES : NO);
        taxPersonEntity.setSfls(bill.isIsHero() ? YES : NO);
        taxPersonEntity.setSfgl(bill.isIsOld() ? YES : NO);
        taxPersonEntity.setCjzh(bill.getDisCardNumber());
        taxPersonEntity.setLszh(bill.getHeroCardNumber());
        taxPersonEntity.setZw(null == bill.getPosition() ? null : bill.getPosition().getName());
        taxPersonEntity.setBz(bill.getDesc());
        taxPersonEntity.setLxdz_sheng(bill.getAdsProvince());
        taxPersonEntity.setLxdz_shi(bill.getAddressCity());
        taxPersonEntity.setLxdz_qx(bill.getAddressCounty());
        taxPersonEntity.setLxdz(bill.getAddressDetailed());
        taxPersonEntity.setWjrlxdz_jd(bill.getAddressStreet());
        taxPersonEntity.setHjszd_sheng(bill.getHomeProvince());
        taxPersonEntity.setHjszd_shi(bill.getHometownCity());
        taxPersonEntity.setHjszd_qx(bill.getHometownCountry());
        taxPersonEntity.setHjszd_jd(bill.getHometownStreet());
        taxPersonEntity.setHjszd_xxdz(bill.getHometownDetailed());
        taxPersonEntity.setLxdh(bill.getPhoneNumber());
        taxPersonEntity.setDzyx(bill.getEmail());
        taxPersonEntity.setKhyh(null == bill.getHrBank() ? null : bill.getHrBank().getName());
        taxPersonEntity.setKhyh_sheng(bill.getBankCardProvince());
        taxPersonEntity.setYhzh(bill.getAccount());
        taxPersonEntity.setGrgbze(bill.getInvestmentTotal());
        taxPersonEntity.setGrtzbl(bill.getInvestmentRate());
        taxPersonEntity.setXmzw(bill.getChineseName());
        taxPersonEntity.setQtzzlx(null == bill.getOtherCardType() ? null : bill.getOtherCardType().getAlias());
        taxPersonEntity.setQtzzhm(bill.getOtherCardNumber());
        taxPersonEntity.setCsd(null == bill.getBirthPlace() ? null : bill.getBirthPlace().getName());
        taxPersonEntity.setSssy(null == bill.getTaxReason() ? null : bill.getTaxReason().getAlias());
        taxPersonEntity.setScrjsj(null == bill.getEntryDate() ? null : format.format(bill.getEntryDate()));
        taxPersonEntity.setYjljsj(null == bill.getLeaveDate() ? null : format.format(bill.getLeaveDate()));
        taxPersonEntity.setWjrlxdz_sheng(bill.getContactProvince());
        taxPersonEntity.setWjrlxdz_shi(bill.getContactCity());
        taxPersonEntity.setWjrlxdz_qx(bill.getContactCountry());
        taxPersonEntity.setWjrlxdz_jd(bill.getContactStreet());
        taxPersonEntity.setWjrlxdz_xxdz(bill.getContactDetailed());
        taxPersonEntity.setNsrzt(null == taxPersonRecordEntryInfo.getPersonStatus() ? null : taxPersonRecordEntryInfo.getPersonStatus().getAlias());
        taxPersonEntity.setSfkcjcfy(null == taxPersonRecordEntryInfo.getDeductFees() ? null : taxPersonRecordEntryInfo.getDeductFees().getAlias());
        taxPersonEntity.setSfgy(null == taxPersonRecordEntryInfo.getEmployedType() ? null : taxPersonRecordEntryInfo.getEmployedType().getAlias());
        taxPersonEntity.setRzsgrq(null == taxPersonRecordEntryInfo.getEmployedDate() ? null : format.format(taxPersonRecordEntryInfo.getEmployedDate()));
        taxPersonEntity.setLzrq(null == taxPersonRecordEntryInfo.getDepartureDate() ? null : format.format(taxPersonRecordEntryInfo.getDepartureDate()));
        taxPersonEntity.setRzndjyqk(null == taxPersonRecordEntryInfo.getSituation() ? null : taxPersonRecordEntryInfo.getSituation().getAlias());
        return taxPersonEntity;
    }

    public static String getCurrentYearMonth(String taxPeriodDate) {
        if (!taxPeriodDate.contains("-")) {
            return taxPeriodDate;
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM");
        Date parse = null;
        try {
            parse = sdf.parse(taxPeriodDate);
            sdf.applyPattern("yyyyMM");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sdf.format(parse);
    }

    public static String getServiceId(Context ctx) throws BOSException {
        return (String)TaxReportUtil.getCloudServiceConfigInfo(ctx).getFirst();
    }

    public static String getSecretKeyStr(Context ctx) throws BOSException {
        return (String)TaxReportUtil.getCloudServiceConfigInfo(ctx).getSecond();
    }

    private static Pair<String, String> getCloudServiceConfigInfo(Context ctx) throws BOSException {
        String cntSql = "select FServiceID,FSecretKey from T_CDS_CloudServiceConfig";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)cntSql);
        String serviceID = null;
        String secretKey = null;
        try {
            if (rowSet.size() == 0) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label118", (Locale)ctx.getLocale()));
            }
            if (rowSet.next()) {
                serviceID = rowSet.getString("FServiceID");
                secretKey = rowSet.getString("FSecretKey");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new Pair(serviceID, secretKey);
    }

    public static boolean isDeclared(Context ctx, String taxUnitId, Date periodDate) throws BOSException {
        String oql = "select id where taxUnit.id= '" + taxUnitId + "' and yearMonth = '" + CmpDateUtil.getDateStr(periodDate, "yyyy-MM") + "'  and declareStatus in ('" + "2" + "', '" + "1" + "')";
        IncomeTaxDeclarCollection collection = IncomeTaxDeclarFactory.getLocalInstance((Context)ctx).getIncomeTaxDeclarCollection(oql);
        return collection != null && !collection.isEmpty();
    }
}

