/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.budget;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CmpPeriodTypeEnum;
import com.kingdee.shr.compensation.app.budget.BudgetPeriodEnum;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateFactory;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateInfo;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemCollection;
import com.kingdee.shr.compensation.app.budget.BudgetTemplateItemFactory;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemDataDot;
import com.kingdee.shr.compensation.app.budget.CmpBudgetItemDataType;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.DeduNodeEnum;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigInfo;
import com.kingdee.shr.compensation.app.budget.UpdateNodeEnum;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetManageExpense;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.budget.dto.BudgetStandingBookColumnRel;
import com.kingdee.shr.compensation.budget.dto.PeriodUsedAmount;
import com.kingdee.shr.compensation.budget.dto.SubBudgetStandingBookColumnRel;
import com.kingdee.shr.compensation.budget.dto.SubStandingBookItemRel;
import com.kingdee.shr.compensation.pojo.budget.CmpBudgetSchemeItem;
import com.kingdee.shr.compensation.service.budget.DeductionParamSubmitBill;
import com.kingdee.shr.compensation.service.budget.impl.SubmitBillDeductionService;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;

public class BudgetUtil {
    private static final Logger LOG = Logger.getLogger(BudgetUtil.class);
    public static final String CMPBUDGETITEM = "CmpBudgetItem";
    public static final String STANDINGBOOKITEM = "StandingBookItem";

    private BudgetUtil() {
    }

    public static void verifyBudget(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        if (BudgetUtil.isApprovingTheFirstNode(ctx, info)) {
            SubmitBillDeductionService deductionService = new SubmitBillDeductionService();
            deductionService.setCheckingOnly(true);
            DeductionParamSubmitBill param = new DeductionParamSubmitBill();
            param.setBillId(info.getId().toString());
            param.setCalSchemeId(info.getSubmitScheme().getId().toString());
            param.setDeductNodeEnum(DeduNodeEnum.APPROVE);
            param.setUpdateNodeEnum(UpdateNodeEnum.APPROVED);
            BatchSubmitShemeBillEntryCollection coll = info.getEntry();
            HashSet<String> entries = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                entries.add(coll.get(i).getId().toString());
            }
            param.setEntries(entries);
            deductionService.deduct(ctx, param);
        }
    }

    public static boolean isApprovingTheFirstNode(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException {
        String oql = "select deduNode, calSubmitItem.id where calSubmitScheme.id = '" + info.getSubmitScheme().getId().toString() + "' order by calSubmitItem.id, deduNode";
        SchemeDeduConfigCollection collection = SchemeDeduConfigFactory.getLocalInstance((Context)ctx).getSchemeDeduConfigCollection(oql);
        if (collection.isEmpty()) {
            return false;
        }
        BOSUuid calSubmitItemId = null;
        for (int i = 0; i < collection.size(); ++i) {
            SchemeDeduConfigInfo configInfo = collection.get(i);
            BOSUuid currentId = configInfo.getCalSubmitItem().getId();
            DeduNodeEnum currentNode = configInfo.getDeduNode();
            if (null == calSubmitItemId) {
                calSubmitItemId = currentId;
                if (currentNode != DeduNodeEnum.APPROVE) continue;
                return true;
            }
            if (calSubmitItemId.equals((Object)currentId)) continue;
            if (currentNode == DeduNodeEnum.APPROVE) {
                return true;
            }
            calSubmitItemId = currentId;
        }
        return false;
    }

    public static List<BudgetManageExpense> getBudgetManageExpenseInfo(Context ctx, String budgetSchemeId, List<String> budgetManageIdList, boolean havingPeriods) throws BOSException {
        if (null == budgetManageIdList || budgetManageIdList.isEmpty()) {
            return null;
        }
        CmpInSql<String> inSqlObj = CmpInSqlFactory.getInstance();
        String budgetManageIds = inSqlObj.createInSqlBaseOnFId(ctx, budgetManageIdList);
        Map<String, List<String>> budgetExpenseMap = BudgetUtil.getBudgetItemExpenseInfo(ctx, budgetSchemeId);
        if (budgetExpenseMap == null) {
            return null;
        }
        List<BudgetManageExpense> budgetManageExpenses = BudgetUtil.getYearlyBudgetExpense(ctx, budgetManageIds, budgetExpenseMap);
        if (!havingPeriods) {
            return budgetManageExpenses;
        }
        BudgetUtil.loadPeriodBudgetExpense(ctx, budgetManageIds, budgetExpenseMap, budgetManageExpenses);
        return budgetManageExpenses;
    }

    public static List<BudgetManageExpense> getBudgetManageExpenseInfoWithCmpUsedAmount(Context ctx, CmpBudgetSchemeInfo budgetScheme, List<String> budgetManageIdList, boolean havingPeriods) throws BOSException {
        if (null == budgetManageIdList || budgetManageIdList.isEmpty() || budgetScheme == null || budgetScheme.getTemplate() == null || budgetScheme.getTemplate().getId() == null) {
            return null;
        }
        String budgetSchemeId = budgetScheme.getId().toString();
        CmpInSql<String> inSqlObj = CmpInSqlFactory.getInstance();
        String budgetManageIds = inSqlObj.createInSqlBaseOnFId(ctx, budgetManageIdList);
        Map<String, List<String>> budgetExpenseMap = BudgetUtil.getBudgetItemExpenseInfo(ctx, budgetSchemeId);
        if (budgetExpenseMap == null) {
            return null;
        }
        String templateId = budgetScheme.getTemplate().getId().toString();
        int budgetYear = budgetScheme.getBudgetYear();
        Map<String, Map<String, String>> initCmpUsedAmount = BudgetUtil.initCmpUsedAmountForItemId(ctx, templateId, budgetYear);
        List<BudgetManageExpense> budgetManageExpenses = BudgetUtil.getYearlyBudgetExpense(ctx, budgetManageIds, budgetExpenseMap);
        budgetManageExpenses = BudgetUtil.addUsedAmountToExpenses(budgetManageIdList, budgetExpenseMap, budgetManageExpenses, initCmpUsedAmount);
        if (!havingPeriods) {
            return budgetManageExpenses;
        }
        List<PeriodUsedAmount> initPeriodUsedAmountList = BudgetUtil.initPeriodUsedAmountListForItemId(ctx, templateId, budgetYear);
        BudgetUtil.loadPeriodBudgetExpense(ctx, budgetManageIds, budgetExpenseMap, budgetManageExpenses);
        BudgetUtil.addPeriodUsedAmountToExpenses(initPeriodUsedAmountList, budgetManageExpenses);
        return budgetManageExpenses;
    }

    private static void addPeriodUsedAmountToExpenses(List<PeriodUsedAmount> initPeriodUsedAmountList, List<BudgetManageExpense> budgetManageExpenses) {
        if (initPeriodUsedAmountList == null || initPeriodUsedAmountList.isEmpty() || budgetManageExpenses == null || budgetManageExpenses.isEmpty()) {
            return;
        }
        for (PeriodUsedAmount initPeriodUsedAmoun : initPeriodUsedAmountList) {
            BudgetManageExpense budgetManageExpense;
            String budgetManageId = initPeriodUsedAmoun.getBudgetManageId();
            String period = initPeriodUsedAmoun.getPeriod();
            Map<String, BigDecimal> itemAmountMap = initPeriodUsedAmoun.getBudgetAmount();
            if (StringUtils.isEmpty((String)budgetManageId) || itemAmountMap == null || itemAmountMap.isEmpty() || StringUtils.isEmpty((String)period)) continue;
            Optional<BudgetManageExpense> optional = budgetManageExpenses.stream().filter(e -> budgetManageId.equals(e.getBudgetManageId())).findFirst();
            if (optional.isPresent()) {
                budgetManageExpense = optional.get();
            } else {
                budgetManageExpense = new BudgetManageExpense();
                budgetManageExpense.setBudgetManageId(budgetManageId);
            }
            for (Map.Entry<String, BigDecimal> itemAmount : itemAmountMap.entrySet()) {
                HashMap<String, BigDecimal> periodExpenses;
                String budgetItemId = itemAmount.getKey();
                BigDecimal itemAmountValue = itemAmount.getValue();
                if (itemAmountValue == null || itemAmountValue.equals(BigDecimal.ZERO)) continue;
                HashMap subStandingBookExpenses = budgetManageExpense.getSubStandingBookExpenses();
                if (subStandingBookExpenses == null) {
                    subStandingBookExpenses = new HashMap();
                    budgetManageExpense.setSubStandingBookExpenses(subStandingBookExpenses);
                }
                if ((periodExpenses = (HashMap<String, BigDecimal>)subStandingBookExpenses.get(budgetItemId)) == null) {
                    periodExpenses = new HashMap<String, BigDecimal>();
                    subStandingBookExpenses.put(budgetItemId, periodExpenses);
                }
                BigDecimal periodValue = periodExpenses.get(period) == null ? BigDecimal.ZERO : (BigDecimal)periodExpenses.get(period);
                periodExpenses.put(period, periodValue.add(itemAmountValue));
            }
        }
    }

    private static List<BudgetManageExpense> addUsedAmountToExpenses(List<String> budgetManageIdList, Map<String, List<String>> budgetExpenseMap, List<BudgetManageExpense> budgetManageExpenses, Map<String, Map<String, String>> initCmpUsedAmount) {
        ArrayList<BudgetManageExpense> newExpenses = new ArrayList<BudgetManageExpense>();
        for (String budgetManageId : budgetManageIdList) {
            Optional<BudgetManageExpense> expenseFirst;
            BudgetManageExpense newExpense = null;
            if (budgetManageExpenses != null && (expenseFirst = budgetManageExpenses.stream().filter(e -> e.getBudgetManageId().equals(budgetManageId)).findFirst()).isPresent()) {
                newExpense = expenseFirst.get();
            }
            if (newExpense == null) {
                newExpense = new BudgetManageExpense();
                newExpense.setBudgetManageId(budgetManageId);
            }
            newExpenses.add(newExpense);
            if (initCmpUsedAmount == null || initCmpUsedAmount.get(budgetManageId) == null) continue;
            Map<String, String> itemUsedAmountMap = initCmpUsedAmount.get(budgetManageId);
            HashMap<String, BigDecimal> budgetItemMap = newExpense.getBudgetItemMap();
            if (budgetItemMap == null) {
                budgetItemMap = new HashMap<String, BigDecimal>();
                newExpense.setBudgetItemMap(budgetItemMap);
            }
            for (Map.Entry<String, String> entrySet : itemUsedAmountMap.entrySet()) {
                String budgetItemId = entrySet.getKey();
                if (StringUtils.isEmpty((String)entrySet.getValue())) continue;
                BigDecimal itemUsedAmount = new BigDecimal(entrySet.getValue());
                BigDecimal itemExpenseValue = budgetItemMap.get(budgetItemId) == null ? BigDecimal.ZERO : (BigDecimal)budgetItemMap.get(budgetItemId);
                budgetItemMap.put(budgetItemId, itemExpenseValue.add(itemUsedAmount));
            }
        }
        return newExpenses;
    }

    private static void loadPeriodBudgetExpense(Context ctx, String budgetManageIds, Map<String, List<String>> budgetExpenseMap, List<BudgetManageExpense> budgetManageExpenses) throws BOSException {
        Collection<List<String>> expenseFields = budgetExpenseMap.values();
        ArrayList allFields = new ArrayList();
        expenseFields.forEach(allFields::addAll);
        StringBuilder columns = new StringBuilder();
        for (String column : allFields) {
            if (columns.length() > 0) {
                columns.append(", ");
            }
            columns.append("sub.").append(column);
        }
        String subStandingBookQuery = "select " + columns + ", sbq.FPeriod period, csb.FBudgetManageID from T_HR_SubCmpStandingBook sub inner join T_HR_SCmpStandingBook csb on sub.FCmpStandingBookID = csb.fid inner join T_HR_SSubBudgetQuery sbq on sub.FSubBudgetQueryID = sbq.fid where csb.FBudgetManageID in " + budgetManageIds + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)subStandingBookQuery);
        try {
            while (rs.next()) {
                String budgetManageId = rs.getString("FBudgetManageID");
                Optional<BudgetManageExpense> optional = budgetManageExpenses.stream().filter(e -> e.getBudgetManageId().equals(budgetManageId)).findAny();
                if (!optional.isPresent()) {
                    LOG.error((Object)("\u627e\u4e0d\u5230\u5e74\u5ea6\u53f0\u8d26\u6570\u636e\uff0cbudgetManageId = " + budgetManageId));
                    continue;
                }
                BudgetManageExpense budgetManageExpense = optional.get();
                HashMap<String, Map> subStandingBookExpenses = budgetManageExpense.getSubStandingBookExpenses();
                if (null == subStandingBookExpenses) {
                    subStandingBookExpenses = new HashMap<String, Map>();
                    budgetManageExpense.setSubStandingBookExpenses(subStandingBookExpenses);
                }
                String period = rs.getString("period");
                for (Map.Entry<String, List<String>> entry : budgetExpenseMap.entrySet()) {
                    String budgetItemId = entry.getKey();
                    Map periodMap = subStandingBookExpenses.computeIfAbsent(budgetItemId, k -> new HashMap());
                    List<String> expenseColumns = entry.getValue();
                    BigDecimal total = BigDecimal.ZERO;
                    for (String column : expenseColumns) {
                        BigDecimal expense = rs.getBigDecimal(column);
                        expense = expense == null ? BigDecimal.ZERO : expense;
                        total = total.add(expense);
                    }
                    periodMap.put(period, total);
                }
            }
        }
        catch (SQLException e2) {
            throw new BOSException((Throwable)e2);
        }
    }

    private static List<BudgetManageExpense> getYearlyBudgetExpense(Context ctx, String budgetManageIds, Map<String, List<String>> budgetExpenseMap) throws BOSException {
        ArrayList<BudgetManageExpense> budgetManageExpenses = new ArrayList<BudgetManageExpense>();
        Collection<List<String>> expenseFields = budgetExpenseMap.values();
        ArrayList allFields = new ArrayList();
        expenseFields.forEach(allFields::addAll);
        String selectFields = String.join((CharSequence)",", allFields);
        String standingBookQuery = "select " + selectFields + ", FBudgetManageID from T_HR_SCmpStandingBook where FBudgetManageID in " + budgetManageIds + "";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)standingBookQuery);
        try {
            while (rs.next()) {
                String budgetManageId = rs.getString("FBudgetManageID");
                BudgetManageExpense budgetManageExpense = new BudgetManageExpense();
                budgetManageExpense.setBudgetManageId(budgetManageId);
                HashMap<String, BigDecimal> budgetItemMap = new HashMap<String, BigDecimal>();
                for (Map.Entry<String, List<String>> entry : budgetExpenseMap.entrySet()) {
                    String budgetItemId = entry.getKey();
                    List<String> columns = entry.getValue();
                    BigDecimal total = BigDecimal.ZERO;
                    for (String column : columns) {
                        BigDecimal expense = rs.getBigDecimal(column);
                        expense = expense == null ? BigDecimal.ZERO : expense;
                        total = total.add(expense);
                    }
                    budgetItemMap.put(budgetItemId, total);
                }
                budgetManageExpense.setBudgetItemMap(budgetItemMap);
                budgetManageExpenses.add(budgetManageExpense);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return budgetManageExpenses;
    }

    private static Map<String, List<String>> getBudgetItemExpenseInfo(Context ctx, String budgetSchemeId) throws BOSException {
        String sql = "select distinct budgetItem.fid budgetItemId, expendItem.FieldSn expendSn from T_HR_SBudgetTemplateSTBItem sbtItem left join T_HR_SCmpBudgetScheme sch on sbtItem.FTemplateID = sch.FTemplateID left join T_HR_SCmpBudgetItem budgetItem on sbtItem.FCmpBudgetItemId = budgetItem.Fid left join T_HR_SStandingBookItem expendItem on expendItem.fid = sbtItem.FStandingBookItemID left join T_HR_SStandingBookItem balanceItem on balanceItem.fid = sbtItem.FBalanceLedgerItemID where sch.Fid = ?";
        HashMap<String, List<String>> budgetExpenseMap = new HashMap<String, List<String>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetSchemeId});
            while (rs.next()) {
                String budgetItemId = rs.getString("budgetItemId");
                int expendSn = rs.getInt("expendSn");
                String expendField = "S" + expendSn;
                List expenseFields = budgetExpenseMap.computeIfAbsent(budgetItemId, k -> new ArrayList());
                expenseFields.add(expendField);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (budgetExpenseMap.isEmpty()) {
            return null;
        }
        return budgetExpenseMap;
    }

    public static List<CmpBudgetSchemeItem> getBudgetSchemeBudgetItem(Context ctx, String budgetSchemeId, boolean isSubBudgetAssign) throws BOSException {
        ArrayList<CmpBudgetSchemeItem> resultList = new ArrayList<CmpBudgetSchemeItem>();
        if (StringUtils.isEmpty((String)budgetSchemeId)) {
            return resultList;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" SELECT ti.FID as budgetSchemeItemId,s.FID as budgetSchemeId,ti.FTemplateID as templateId,c.FID as budgetItemId, ");
        sqlBuilder.append(" c.Fnumber as budgetItemNumber,c.Fname_l1 as budgetItemNameL1,c.Fname_l2 as budgetItemNameL2,c.Fname_l3 as budgetItemNameL3, ");
        sqlBuilder.append(" c.Fname_").append(l).append(" as budgetItemName, ");
        sqlBuilder.append(" c.FieldSn,c.FDataType,c.FDataLength,c.FDataDot ");
        sqlBuilder.append(" FROM T_HR_SBudgetTemplateItem ti ");
        sqlBuilder.append(" left join T_HR_SCmpBudgetScheme s on s.FTemplateID = ti.FTemplateID ");
        sqlBuilder.append(" left join T_HR_SCmpBudgetItem c on c.FID=ti.FBudgetItemID ");
        sqlBuilder.append(" where s.FID = ? ");
        if (isSubBudgetAssign) {
            sqlBuilder.append(" and ti.FIsSubBudgetAssign = 1 ");
        }
        sqlBuilder.append(" order by ti.FSortSn asc,c.FIndex asc ");
        String sql = sqlBuilder.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetSchemeId});
        try {
            while (rowSet.next()) {
                CmpBudgetSchemeItem schemeItem = new CmpBudgetSchemeItem();
                schemeItem.setBudgetSchemeItemId(rowSet.getString("budgetSchemeItemId"));
                schemeItem.setBudgetSchemeId(rowSet.getString("budgetSchemeId"));
                schemeItem.setTemplateId(rowSet.getString("templateId"));
                schemeItem.setBudgetItemId(rowSet.getString("budgetItemId"));
                schemeItem.setBudgetItemNumber(rowSet.getString("budgetItemNumber"));
                schemeItem.setBudgetItemNameL1(rowSet.getString("budgetItemNameL1"));
                schemeItem.setBudgetItemNameL2(rowSet.getString("budgetItemNameL2"));
                schemeItem.setBudgetItemNameL3(rowSet.getString("budgetItemNameL3"));
                schemeItem.setBudgetItemName(rowSet.getString("budgetItemName"));
                schemeItem.setFieldSn(rowSet.getInt("FieldSn"));
                int dataType = rowSet.getInt("FDataType");
                CmpBudgetItemDataType itemDataType = CmpBudgetItemDataType.getEnum((int)dataType);
                schemeItem.setDataType(itemDataType);
                schemeItem.setDataLen(rowSet.getInt("FDataLength"));
                int fDataDot = rowSet.getInt("FDataDot");
                CmpBudgetItemDataDot dataDot = CmpBudgetItemDataDot.getEnum((int)fDataDot);
                schemeItem.setDataDot(dataDot);
                resultList.add(schemeItem);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return resultList;
    }

    public static List<Map<String, Object>> getBudgetItemColModelByTemplate(Context ctx, String clientNumber, String budgetTemplateId, boolean isSub) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> colModels = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty((String)budgetTemplateId)) {
            return colModels;
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select distinct item.FName_").append(l).append(" as itemName, item.FieldSn, temp.FSortSn, item.FIndex, item.FDataType, item.FDataDot");
        sqlBuilder.append(" FROM T_HR_SBudgetTemplateItem temp");
        sqlBuilder.append(" left join T_HR_SCmpBudgetItem item on item.FID = temp.FBudgetItemID");
        sqlBuilder.append(" where temp.FTemplateID = ? ");
        BudgetTemplateInfo budgetTemplate = BudgetTemplateFactory.getLocalInstance((Context)ctx).getBudgetTemplateInfo("select budgetPeriod where id = '" + budgetTemplateId + "'");
        BudgetPeriodEnum budgetPeriod = budgetTemplate.getBudgetPeriod();
        if (BudgetPeriodEnum.YEAR != budgetPeriod && isSub) {
            sqlBuilder.append(" and temp.FIsSubBudgetAssign = 1");
        }
        sqlBuilder.append(" and temp.FIsShowInStanding = 1");
        sqlBuilder.append(" order by temp.FSortSn asc, item.FIndex asc");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString(), (Object[])new Object[]{budgetTemplateId});
        try {
            while (rowSet.next()) {
                HashMap<String, Object> gridIdMap = new HashMap<String, Object>();
                gridIdMap.put("rename", rowSet.getString("itemName"));
                gridIdMap.put("name", clientNumber + ".T" + rowSet.getInt("FieldSn"));
                gridIdMap.put("label", rowSet.getString("itemName"));
                if (rowSet.getInt("FDataType") == 1) {
                    gridIdMap.put("type", "String");
                } else {
                    HashMap extendOptions = new HashMap();
                    HashMap<String, Object> numberOptions = new HashMap<String, Object>();
                    gridIdMap.put("type", "Number");
                    numberOptions.put("decimalPrecision", rowSet.getString("FDataDot") == null ? 2 : rowSet.getInt("FDataDot"));
                    numberOptions.put("ignoreDecimalFormatter", false);
                    numberOptions.put("roundType", "round");
                    extendOptions.put("numberOptions", numberOptions);
                    gridIdMap.put("extendOptions", extendOptions);
                }
                colModels.add(gridIdMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return colModels;
    }

    public static int getBudgetYearByCalSubmitSchemeId(Context ctx, String calSubmitSchemeId) throws BOSException, SQLException {
        IRowSet rowSet = BudgetUtil.getBudgetManageInfo(ctx, calSubmitSchemeId);
        int budgetYear = 0;
        while (rowSet.next()) {
            budgetYear = rowSet.getInt("fBudgetYear");
        }
        return budgetYear;
    }

    public static String getNowDateStr() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return CmpDateUtil.toKSqlDate(calendar.getTime());
    }

    protected static IRowSet getBudgetManageInfo(Context ctx, String calSubmitSchemeId) throws BOSException {
        String nowDate = BudgetUtil.getNowDateStr();
        String queryBudgetYearSql = " select  budgetScheme.fBudgetYear, budgetScheme.fid FROM T_HR_SBudgetTemplate template inner join T_HR_SCmpBudgetScheme budgetScheme on budgetScheme.FTemplateID = template.fid inner join T_HR_SCalSubmitScheme submitScheme on submitScheme.FBudgetTemplateID = template.fid where submitScheme.fid = ?  and budgetScheme.FEffectDate <= " + nowDate + " and budgetScheme.FExpiryDate >= " + nowDate;
        return DbUtil.executeQuery((Context)ctx, (String)queryBudgetYearSql, (Object[])new Object[]{calSubmitSchemeId});
    }

    public static List<SubBudgetStandingBookColumnRel> initSubBudgetBookItemSumData(Context ctx, CmpBudgetSchemeInfo schemeInfo) throws BOSException {
        HashSet standingBookItemSet = Sets.newHashSet();
        ArrayList budgetBookItemList = Lists.newArrayList();
        String budgetTemplateId = schemeInfo.getTemplate().getId().toString();
        BudgetUtil.initBudgetBookItemMap(ctx, budgetTemplateId, standingBookItemSet, budgetBookItemList);
        ArrayList<SubBudgetStandingBookColumnRel> subStandingBookExpenseList = new ArrayList<SubBudgetStandingBookColumnRel>();
        String sql = "select manage.fid manageId, " + CmpStrUtil.join(standingBookItemSet, ",", null) + ", bookTable.fid bookTableId from T_HR_SubCmpStandingBook bookTable left join T_HR_SSubBudgetQuery queryTable on queryTable.fid = bookTable.FSubBudgetQueryID left join T_HR_SBudgetManage manage on manage.fid = queryTable.FBudgetManageID where manage.FBudgetSchemeID ='" + schemeInfo.getId().toString() + "' and manage.FBudgetYear = " + schemeInfo.getBudgetYear() + " order by queryTable.FEffectDate";
        try {
            IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
            while (rs.next()) {
                SubStandingBookItemRel subStandingBookItemRel;
                SubBudgetStandingBookColumnRel manageRel;
                String manageId = rs.getString("manageId");
                Optional<SubBudgetStandingBookColumnRel> optional = subStandingBookExpenseList.stream().filter(e -> e.getManageId().equals(manageId)).findAny();
                if (!optional.isPresent()) {
                    manageRel = new SubBudgetStandingBookColumnRel();
                    manageRel.setManageId(manageId);
                    subStandingBookExpenseList.add(manageRel);
                } else {
                    manageRel = optional.get();
                }
                String subStandingBookId = rs.getString("bookTableId");
                Optional<SubStandingBookItemRel> subOptional = manageRel.getSubStandingBookItemRelList().stream().filter(e -> e.getSubBookTableId().equals(subStandingBookId)).findAny();
                if (!subOptional.isPresent()) {
                    subStandingBookItemRel = new SubStandingBookItemRel();
                    subStandingBookItemRel.setSubBookTableId(subStandingBookId);
                    manageRel.getSubStandingBookItemRelList().add(subStandingBookItemRel);
                } else {
                    subStandingBookItemRel = subOptional.get();
                }
                for (BudgetStandingBookColumnRel rel : budgetBookItemList) {
                    BudgetStandingBookColumnRel subRel;
                    String budgetColumn = rel.getBudgetColumn();
                    List<BudgetStandingBookColumnRel> relList = subStandingBookItemRel.getBudgetStandingBookColumnRelList();
                    Optional<BudgetStandingBookColumnRel> relOptional = relList.stream().filter(e -> e.getBudgetColumn().equals(budgetColumn)).findAny();
                    if (!relOptional.isPresent()) {
                        subRel = new BudgetStandingBookColumnRel();
                        subRel.setBudgetColumn(budgetColumn);
                        relList.add(subRel);
                    } else {
                        subRel = relOptional.get();
                    }
                    BigDecimal subExpense = BigDecimal.ZERO;
                    for (String expenseCol : rel.getExpenseCols()) {
                        BigDecimal expenseVal = rs.getBigDecimal(expenseCol);
                        expenseVal = expenseVal == null ? BigDecimal.ZERO : expenseVal;
                        subExpense = subExpense.add(expenseVal);
                    }
                    subRel.getExpenseCols().addAll(rel.getExpenseCols());
                    subRel.setTotalExpense(subExpense);
                    subStandingBookExpenseList.add(manageRel);
                }
            }
            return subStandingBookExpenseList;
        }
        catch (BOSException | SQLException e2) {
            throw new BOSException(e2);
        }
    }

    public static void initBudgetBookItemMap(Context ctx, String budgetTemplateId, Set<String> expenseCols, List<BudgetStandingBookColumnRel> budgetBookItemList) throws BOSException {
        HashSet<String> budgetItemSet = new HashSet<String>();
        String oql = "select budgetItem.id where template.id = '" + budgetTemplateId + "'";
        BudgetTemplateItemCollection collection = BudgetTemplateItemFactory.getLocalInstance((Context)ctx).getBudgetTemplateItemCollection(oql);
        for (int i = 0; i < collection.size(); ++i) {
            budgetItemSet.add(collection.get(i).getBudgetItem().getId().toString());
        }
        String sql = "select distinct budgetItem.FieldSn budgetSn, expendItem.FieldSn expendSn, balanceItem.FieldSn balanceSn  from T_HR_SBudgetTemplateSTBItem sbtItem left join T_HR_SCmpBudgetItem budgetItem on sbtItem.FCmpBudgetItemId = budgetItem.Fid left join T_HR_SStandingBookItem expendItem on expendItem.fid = sbtItem.FStandingBookItemID left join T_HR_SStandingBookItem balanceItem on balanceItem.fid = sbtItem.FBalanceLedgerItemID where sbtItem.FTemplateID = '" + budgetTemplateId + "' and sbtItem.FCmpBudgetItemId in (" + CmpStrUtil.converCollectionToSql(budgetItemSet) + ") order by budgetSn asc";
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
        try {
            while (rs.next()) {
                BudgetStandingBookColumnRel rel;
                String budgetSn = "T" + rs.getString("budgetSn");
                String expenseCol = "S" + rs.getInt("expendSn");
                Optional<BudgetStandingBookColumnRel> optional = budgetBookItemList.stream().filter(e -> e.getBudgetColumn().equals(budgetSn)).findFirst();
                if (optional.isPresent()) {
                    rel = optional.get();
                } else {
                    rel = new BudgetStandingBookColumnRel();
                    rel.setBudgetColumn(budgetSn);
                    budgetBookItemList.add(rel);
                }
                rel.getExpenseCols().add(expenseCol);
                expenseCols.add(expenseCol);
            }
        }
        catch (SQLException e2) {
            throw new BOSException((Throwable)e2);
        }
    }

    public static List<PeriodUsedAmount> initPeriodUsedAmountList(Context ctx, String budgetTemplateId, int budgetYear) {
        String sql = "select pua.FAmount, cb.FieldSn, csb.fid, bm.fid budgetManageId,sbq.FPeriod period  from T_HR_SCmpPeriodUsedAmount pua left join T_HR_SubCmpStandingBook csb on pua.FSubStandingBookId = csb.fid  left join T_HR_SSubBudgetQuery sbq on csb.FSubBudgetQueryID = sbq.fid left join T_HR_SBudgetManage bm on bm.fid = sbq.FBudgetManageID left join T_HR_SCmpBudgetScheme cbs on bm.FBudgetSchemeID = cbs.fid left join T_HR_SCmpBudgetItem cb on pua.FCmpBudgetItemId = cb.fid where cbs.FTemplateID = ? and cbs.FBudgetYear = ?";
        ArrayList<PeriodUsedAmount> list = new ArrayList<PeriodUsedAmount>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetTemplateId, budgetYear});
            while (rs.next()) {
                PeriodUsedAmount periodUsedAmount;
                String subStandingBookId = rs.getString("fid");
                String manageId = rs.getString("budgetManageId");
                String period = rs.getString("period");
                String budgetCol = "T" + rs.getInt("FieldSn");
                BigDecimal amount = rs.getBigDecimal("FAmount");
                Optional<PeriodUsedAmount> optional = list.stream().filter(e -> e.getSubStandingBookId().equals(subStandingBookId)).findFirst();
                if (!optional.isPresent()) {
                    periodUsedAmount = new PeriodUsedAmount();
                    periodUsedAmount.setSubStandingBookId(subStandingBookId);
                    periodUsedAmount.setBudgetManageId(manageId);
                    periodUsedAmount.setPeriod(period);
                    list.add(periodUsedAmount);
                } else {
                    periodUsedAmount = optional.get();
                }
                Map<String, BigDecimal> budgetAmount = periodUsedAmount.getBudgetAmount();
                budgetAmount.put(budgetCol, amount);
            }
        }
        catch (BOSException | SQLException e2) {
            e2.printStackTrace();
        }
        return list;
    }

    public static List<PeriodUsedAmount> initPeriodUsedAmountListForItemId(Context ctx, String budgetTemplateId, int budgetYear) {
        String sql = "select pua.FAmount, cb.fid itemId, cb.FieldSn, csb.fid, bm.fid budgetManageId,sbq.FPeriod period  from T_HR_SCmpPeriodUsedAmount pua left join T_HR_SubCmpStandingBook csb on pua.FSubStandingBookId = csb.fid  left join T_HR_SSubBudgetQuery sbq on csb.FSubBudgetQueryID = sbq.fid left join T_HR_SBudgetManage bm on bm.fid = sbq.FBudgetManageID left join T_HR_SCmpBudgetScheme cbs on bm.FBudgetSchemeID = cbs.fid left join T_HR_SCmpBudgetItem cb on pua.FCmpBudgetItemId = cb.fid where cbs.FTemplateID = ? and cbs.FBudgetYear = ?";
        ArrayList<PeriodUsedAmount> list = new ArrayList<PeriodUsedAmount>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetTemplateId, budgetYear});
            while (rs.next()) {
                PeriodUsedAmount periodUsedAmount;
                String subStandingBookId = rs.getString("fid");
                String manageId = rs.getString("budgetManageId");
                String period = rs.getString("period");
                String budgetCol = rs.getString("itemId");
                BigDecimal amount = rs.getBigDecimal("FAmount");
                Optional<PeriodUsedAmount> optional = list.stream().filter(e -> e.getSubStandingBookId().equals(subStandingBookId)).findFirst();
                if (!optional.isPresent()) {
                    periodUsedAmount = new PeriodUsedAmount();
                    periodUsedAmount.setSubStandingBookId(subStandingBookId);
                    periodUsedAmount.setBudgetManageId(manageId);
                    periodUsedAmount.setPeriod(period);
                    list.add(periodUsedAmount);
                } else {
                    periodUsedAmount = optional.get();
                }
                Map<String, BigDecimal> budgetAmount = periodUsedAmount.getBudgetAmount();
                budgetAmount.put(budgetCol, amount);
            }
        }
        catch (BOSException | SQLException e2) {
            e2.printStackTrace();
        }
        return list;
    }

    public static Map<String, Map<String, String>> initCmpUsedAmount(Context ctx, String budgetTemplateId, int budgetYear) {
        HashMap cmpUsedAmountMap = Maps.newHashMap();
        String sql = "select amount.FBudgetManageID, item.FieldSn, amount.FUsedAmount from T_HR_SCmpUsedAmount amount left join T_HR_SCmpBudgetItem item on item.fid = amount.FCmpBudgetItemID where amount.FTemplateID = ? and FBudgetYear = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetTemplateId, budgetYear});
            while (rs.next()) {
                String manageId = rs.getString("FBudgetManageID");
                Map itemMap = cmpUsedAmountMap.containsKey(manageId) ? (Map)cmpUsedAmountMap.get(manageId) : new HashMap();
                itemMap.put("T" + rs.getInt("FieldSn"), rs.getString("FUsedAmount"));
                cmpUsedAmountMap.put(manageId, itemMap);
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return cmpUsedAmountMap;
    }

    public static Map<String, Map<String, String>> initCmpUsedAmountForItemId(Context ctx, String budgetTemplateId, int budgetYear) {
        HashMap cmpUsedAmountMap = Maps.newHashMap();
        String sql = "select amount.FBudgetManageID, item.fid itemId, amount.FUsedAmount from T_HR_SCmpUsedAmount amount left join T_HR_SCmpBudgetItem item on item.fid = amount.FCmpBudgetItemID where amount.FTemplateID = ? and FBudgetYear = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetTemplateId, budgetYear});
            while (rs.next()) {
                String manageId = rs.getString("FBudgetManageID");
                Map itemMap = cmpUsedAmountMap.containsKey(manageId) ? (Map)cmpUsedAmountMap.get(manageId) : new HashMap();
                itemMap.put(rs.getString("itemId"), rs.getString("FUsedAmount"));
                cmpUsedAmountMap.put(manageId, itemMap);
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return cmpUsedAmountMap;
    }

    public static Date getSchemeActualDate(Context ctx, String calSchemeId) throws EASBizException, BOSException {
        CalSchemeInfo scheme = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("where id = '" + calSchemeId + "'");
        int offset = scheme.getBudgetOffset();
        if (offset == 0) {
            return scheme.getBeginDate();
        }
        CmpPeriodTypeEnum periodType = scheme.getCmpPeriodType();
        Calendar endDateCal = Calendar.getInstance();
        endDateCal.setTime(scheme.getBeginDate());
        if (periodType == CmpPeriodTypeEnum.month) {
            endDateCal.add(2, offset);
        } else if (periodType == CmpPeriodTypeEnum.quarter) {
            endDateCal.add(2, 3 * offset);
        } else if (periodType == CmpPeriodTypeEnum.half) {
            endDateCal.add(2, 6 * offset);
        } else if (periodType == CmpPeriodTypeEnum.yeay) {
            endDateCal.add(1, offset);
        } else if (periodType == CmpPeriodTypeEnum.halfmonth) {
            endDateCal.add(5, 15 * offset);
        }
        return endDateCal.getTime();
    }

    public static Map<String, Integer> getCmpBudgetItemOrtandingBookItemDataDot(Context ctx, String type) throws BOSException, SQLException {
        String table;
        HashMap map = Maps.newHashMap();
        if (CMPBUDGETITEM.equals(type)) {
            table = " T_HR_SCmpBudgetItem ";
        } else if (STANDINGBOOKITEM.equals(type)) {
            table = " T_HR_SStandingBookItem ";
        } else {
            return map;
        }
        String lang = ctx.getLocale().getLanguage();
        String sql = "SELECT Fname_" + lang + " name ,FDataDot FROM " + table + " where FDataType = 0 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String name = rs.getString("name");
            int dataDot = rs.getInt("FDataDot");
            if (StringUtils.isEmpty((String)name)) continue;
            map.put(name, dataDot);
        }
        return map;
    }

    public static Map<Integer, Integer> getCmpBudgetSnOrtandingBookSnDataDot(Context ctx, String type) throws BOSException, SQLException {
        String table;
        HashMap map = Maps.newHashMap();
        if (CMPBUDGETITEM.equals(type)) {
            table = " T_HR_SCmpBudgetItem ";
        } else if (STANDINGBOOKITEM.equals(type)) {
            table = " T_HR_SStandingBookItem ";
        } else {
            return map;
        }
        String sql = "SELECT FieldSn ,FDataDot FROM " + table + " where FDataType = 0 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            Integer sn = rs.getInt("FieldSn");
            int dataDot = rs.getInt("FDataDot");
            map.put(sn, dataDot);
        }
        return map;
    }

    public static String getCurrentAndParentHRO(String hrSQL) {
        return "SELECT parent.fid FROM t_org_hro parent inner join t_org_hro child on (charindex(concat(parent.flongnumber,'!'),child.flongnumber) = 1 or parent.flongnumber = child.flongnumber) where child.fid in (" + hrSQL + ") ";
    }
}

