/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.http;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.compensation.CostBearXHCallConfigFactory;
import com.kingdee.shr.compensation.CostBearXHCallConfigInfo;
import com.kingdee.shr.compensation.util.AESUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RemoteServiceCallXHUtil {
    private static final String CostBearCalSchemeResources = "com.kingdee.shr.compensation.resource.CostBearCalSchemeResources";
    private static Logger logger = Logger.getLogger(RemoteServiceCallXHUtil.class);
    public static final String REMOTE_INVALID_ID = "S6nmzF8Ij1KSCV/ie5+sXA==";

    private RemoteServiceCallXHUtil() {
    }

    public static String callAiEvent(Context ctx, String route, Object param) throws BOSException, EASBizException {
        String oql = " select id, system, domains, appId, XhUserAccount, loginType, appSecret, url, accountId where id = 'R+THAGIWGESxSBK7x99OUIleU5M=' ";
        CostBearXHCallConfigInfo info = CostBearXHCallConfigFactory.getLocalInstance(ctx).getCostBearXHCallConfigInfo(oql);
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("appId", info.getAppId());
        try {
            tokenMap.put("appSecret", AESUtil.decrypt(info.getAppSecret(), REMOTE_INVALID_ID));
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        tokenMap.put("accountId", info.getAccountId());
        if (info.getXHUserAccount() == null || info.getLoginType() == null) {
            String msg = EASResource.getString((String)CostBearCalSchemeResources, (String)"label24", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("NOT_FOUND_INFO", msg));
        }
        tokenMap.put("user", info.getXHUserAccount());
        tokenMap.put("usertype", info.getLoginType().getValue());
        String result = RemoteServiceCallXHUtil.aiEventPost(ctx, info.getUrl(), route, tokenMap, param);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("XH result: " + result));
        }
        return result;
    }

    public static String getAppToken(Context ctx, String baseUrl, Map<String, String> param) throws EASBizException, BOSException {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(1000);
        requestFactory.setReadTimeout(1000);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json; charset=utf-8");
        try {
            HttpEntity entity = new HttpEntity((Object)JSONUtils.convertObjectToJson((Context)ctx, param), (MultiValueMap)headers);
            String result = (String)restTemplate.postForObject(baseUrl + "/api/getAppToken.do", (Object)entity, String.class, new Object[0]);
            if (CmpStrUtil.isEmpty(result)) {
                return null;
            }
            return RemoteServiceCallXHUtil.parseResult(JSONObject.parseObject((String)result), "app_token");
        }
        catch (Exception e) {
            logger.error((Object)e);
            String msg = EASResource.getString((String)CostBearCalSchemeResources, (String)"label24", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("NOT_FOUND_INFO", msg));
        }
    }

    public static String getAccessToken(Context ctx, String baseUrl, Map<String, String> param) throws BOSException, EASBizException {
        HashMap<String, String> appTokenMap = new HashMap<String, String>();
        appTokenMap.put("appId", param.get("appId"));
        appTokenMap.put("appSecret", param.get("appSecret"));
        appTokenMap.put("tenantid", "");
        appTokenMap.put("accountId", param.get("accountId"));
        String appToken = RemoteServiceCallXHUtil.getAppToken(ctx, baseUrl, appTokenMap);
        param.put("apptoken", appToken);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity entity = new HttpEntity((Object)JSONUtils.convertObjectToJson((Context)ctx, param), (MultiValueMap)headers);
        try {
            String result = (String)restTemplate.postForObject(baseUrl + "/api/login.do", (Object)entity, String.class, new Object[0]);
            if (CmpStrUtil.isEmpty(result)) {
                return null;
            }
            return RemoteServiceCallXHUtil.parseResult(JSONObject.parseObject((String)result), "access_token");
        }
        catch (Exception e) {
            logger.error((Object)e);
            String msg = EASResource.getString((String)CostBearCalSchemeResources, (String)"label24", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("NOT_FOUND_INFO", msg));
        }
    }

    public static String parseResult(JSONObject jsonObject, String tokenType) throws BOSException {
        if (jsonObject == null || jsonObject.getJSONObject("data") == null) {
            return null;
        }
        String state = jsonObject.getString("state");
        if (!"success".equalsIgnoreCase(state)) {
            throw new BOSException(jsonObject.getString("description_cn"));
        }
        JSONObject data = jsonObject.getJSONObject("data");
        try {
            if ("access_token".equalsIgnoreCase(tokenType)) {
                logger.info((Object)("XH accT\uff1a" + AESUtil.encrypt(data.getString(tokenType), REMOTE_INVALID_ID)));
            } else {
                logger.info((Object)("XH appT\uff1a" + AESUtil.encrypt(data.getString(tokenType), REMOTE_INVALID_ID)));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Boolean success = data.getBoolean("success");
        return success != false ? data.getString(tokenType) : null;
    }

    public static void logout(Context ctx, String baseUrl, Map<String, String> param) throws EASBizException {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity entity = new HttpEntity((Object)JSONUtils.convertObjectToJson((Context)ctx, param), (MultiValueMap)headers);
        try {
            restTemplate.postForObject(baseUrl + "/api/logout.do", (Object)entity, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            logger.error((Object)e);
            String msg = EASResource.getString((String)CostBearCalSchemeResources, (String)"label24", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("NOT_FOUND_INFO", msg));
        }
    }

    public static String aiEventPost(Context ctx, String baseUrl, String route, Map<String, String> baseMap, Object param) throws BOSException, EASBizException {
        String accessToken = RemoteServiceCallXHUtil.getAccessToken(ctx, baseUrl, baseMap);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json; charset=utf-8");
        headers.set("accesstoken", accessToken);
        HttpEntity entity = new HttpEntity((Object)JSONUtils.convertObjectToJson((Context)ctx, (Object)param), (MultiValueMap)headers);
        try {
            String result = (String)restTemplate.postForObject(baseUrl + route, (Object)entity, String.class, new Object[0]);
            logger.info((Object)("XH sava result\uff1a" + result));
            HashMap<String, String> logoutMap = new HashMap<String, String>();
            logoutMap.put("access_token", accessToken);
            RemoteServiceCallXHUtil.logout(ctx, baseUrl + "/api/logout.do", logoutMap);
            return result;
        }
        catch (RestClientException e) {
            logger.error((Object)e);
            String msg = EASResource.getString((String)CostBearCalSchemeResources, (String)"label24", (Locale)ctx.getLocale());
            throw new EASBizException(new NumericExceptionSubItem("NOT_FOUND_INFO", msg));
        }
    }
}

