/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.integrate;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorImpl;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationFactory;
import com.kingdee.shr.compensation.app.integrate.CalShemeTableRelationInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.IntegrateEntrySqlAttrs;
import com.kingdee.shr.compensation.util.integrate.IntegrateEntryTableAttrs;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CmpIntegrateEntryHelper {
    private static final String ENTRY_TABLE_NAME = "T_HR_SchemeBillEntry";

    private CmpIntegrateEntryHelper() {
    }

    public static List<String> getEntryIdsByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        BatchSubmitShemeBillInfo billInfo = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo(String.format("select billState,submitScheme.submitSchemeType where id = '%s'", billId));
        String billEntryTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId(ctx, billInfo.getSubmitScheme().getId().toString());
        ArrayList ids = Lists.newArrayList();
        String selectSql = "SELECT FID FROM %s WHERE FBillId = ?";
        selectSql = String.format(selectSql, billEntryTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)String.format(selectSql, billEntryTable), (Object[])new Object[]{billId});
        try {
            while (rs.next()) {
                ids.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("get entry ids error, sql:" + selectSql, (Throwable)e);
        }
        return ids;
    }

    public static String getIntegrateDynamicEntryTableNameByBillId(Context ctx, String billId) throws EASBizException, BOSException {
        String oqlTemplate = "select submitScheme where id = '%s'";
        BatchSubmitShemeBillInfo billInfo = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo(String.format(oqlTemplate, billId));
        return CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId(ctx, billInfo.getSubmitScheme().getId().toString());
    }

    public static String getIntegrateDynamicEntryTableNameBySubmitSchemeId(Context ctx, String submitSchemeId) throws EASBizException, BOSException {
        String oqlTemplate = "select billEntryTableName where submitScheme = '%s'";
        CalShemeTableRelationInfo relation = CalShemeTableRelationFactory.getLocalInstance((Context)ctx).getCalShemeTableRelationInfo(String.format(oqlTemplate, submitSchemeId));
        return relation.getBillEntryTableName();
    }

    public static String getIntegrateDynamicEntryTableNameBySubmitSchemeIdSQL(Context ctx, String submitSchemeIdSQL) throws BOSException {
        String sql = "select FBillEntryTableName from T_HR_SCalShemeTableRelation where FSubmitSchemeID = " + submitSchemeIdSQL;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return rs.getString(1);
            }
            throw new BOSException("cannot find BillEntryTable by: " + submitSchemeIdSQL);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static IntegrateEntryTableAttrs getIntegrateEntryTableAttrs(Context ctx, String submitSchemeId) throws BOSException, EASBizException {
        IntegrateEntryTableAttrs attrs = new IntegrateEntryTableAttrs();
        if (StringUtils.isEmpty((CharSequence)submitSchemeId)) {
            return attrs;
        }
        attrs.setTableName(CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId(ctx, submitSchemeId));
        String sql = "SELECT item.FieldSn fieldSn,item.FDataType dataType, item.FDataLength dataLength  FROM  T_HR_SCalSubmitScheme scheme  INNER JOIN  T_HR_SCalSubmitSchemeItem calItem ON calItem.FCalSubmitSchemeID = scheme.Fid  INNER JOIN T_HR_SCalSubmitItem item ON item.Fid = calItem.FCalSubmitItemID  WHERE scheme.Fid = '%s' ORDER BY calItem.FSortSn ";
        sql = String.format(sql, submitSchemeId);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                attrs.addColName("S" + rs.getString("fieldSn"));
                attrs.addColType(rs.getString("dataType"));
                attrs.setDataLength("S" + rs.getString("fieldSn"), rs.getInt("dataLength"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("get entry table attrs error, sql:" + sql, (Throwable)e);
        }
        return attrs;
    }

    public static Map<String, IntegrateEntryTableAttrs> getIntegrateEntryTableAttrs(Context ctx, Set<String> submitSchemeIds) throws BOSException {
        HashMap<String, IntegrateEntryTableAttrs> map = new HashMap<String, IntegrateEntryTableAttrs>();
        if (null == submitSchemeIds || submitSchemeIds.isEmpty()) {
            throw new BOSException("submitSchemeIds is empty!");
        }
        CmpInSql<String> instance = CmpInSqlFactory.getInstance();
        String inCondition = instance.createInSqlBaseOnFId(ctx, submitSchemeIds);
        String sql = "SELECT item.FieldSn fieldSn,item.FDataType dataType, scheme.fid submitSchemeId, rel.FBillEntryTableName  FROM  T_HR_SCalSubmitScheme scheme  INNER JOIN  T_HR_SCalShemeTableRelation rel ON scheme.fid = rel.FSubmitSchemeID  INNER JOIN  T_HR_SCalSubmitSchemeItem calItem ON calItem.FCalSubmitSchemeID = scheme.Fid  INNER JOIN T_HR_SCalSubmitItem item ON item.Fid = calItem.FCalSubmitItemID  WHERE scheme.Fid in " + inCondition;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String submitSchemeId = rs.getString("submitSchemeId");
                String tableName = rs.getString("FBillEntryTableName");
                IntegrateEntryTableAttrs attrs = (IntegrateEntryTableAttrs)map.get(submitSchemeId);
                if (null == attrs) {
                    attrs = new IntegrateEntryTableAttrs();
                    attrs.setTableName(tableName);
                    map.put(submitSchemeId, attrs);
                }
                attrs.addColName("S" + rs.getString("fieldSn"));
                attrs.addColType(rs.getString("dataType"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("getIntegrateEntryTableAttrs error: ", (Throwable)e);
        }
        return map;
    }

    public static BatchSubmitShemeBillInfo getBatchSubmitShemeBillInfo(Context ctx, String oql) throws EASBizException, BOSException {
        return BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo(oql);
    }

    public static BatchSubmitShemeBillCollection getBatchSubmitShemeBillCollection(Context ctx, String oql) throws BOSException, EASBizException {
        return BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillCollection(oql);
    }

    public static BatchSubmitShemeBillEntryCollection getBatchSubmitShemeBillEntryCollection(Context ctx, String billId, String oql) throws BOSException, EASBizException {
        IntegrateEntrySqlAttrs sqlAttrs;
        EntityViewInfo view;
        EntityObjectInfo batchEntryEntityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)new BatchSubmitShemeBillEntryInfo().getBOSType());
        try {
            view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        try {
            sqlAttrs = CmpIntegrateEntryHelper.getSQLAttrsByEntryView(batchEntryEntityObjectInfo, view, ctx);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        String dynamicEntryTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameByBillId(ctx, billId);
        String replacedSql = sqlAttrs.getSql().replaceAll("(?i)T_HR_SchemeBillEntry", dynamicEntryTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)replacedSql);
        try {
            return (BatchSubmitShemeBillEntryCollection)ImplUtils.fillObjectValue((ResultSet)rs, (EntityObjectInfo)batchEntryEntityObjectInfo, sqlAttrs.getFieldList(), sqlAttrs.getAliasMap(), (Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static BatchSubmitShemeBillEntryCollection getBatchSubmitShemeBillEntryCollection(Context ctx, String oql) throws BOSException, EASBizException {
        return BatchSubmitShemeBillEntryFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillEntryCollection(oql);
    }

    public static IntegrateEntrySqlAttrs getSQLAttrsByEntryView(EntityObjectInfo bo, EntityViewInfo view, Context ctx) throws InvalidDAOMetaDataException, SQLException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        SolutionInfo solution = loader.getSolution();
        EntityAccess ea = EntityAccess.getInstance((EntityObjectInfo)bo, (SolutionInfo)solution, (EntityViewInfo)view, (Context)ctx);
        IntegrateEntrySqlAttrs sqlAttrs = new IntegrateEntrySqlAttrs();
        sqlAttrs.setSql(new SQLGeneratorImpl(ea, ctx).selectSQLWithTrueValue(bo, true, null, false));
        sqlAttrs.setFieldList(ea.getFieldList());
        sqlAttrs.setAliasMap(ea.getAliasMapping());
        return sqlAttrs;
    }
}

