/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile;

import com.kingdee.shr.formulaplatform.compile.DynamicClassUtile;
import com.kingdee.shr.formulaplatform.compile.DynamicElement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DynamicMethod
extends DynamicElement {
    private Pattern methodSignatrueEndPattern = Pattern.compile("\\)[\\s\\r\\n]*\\{");
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private StringBuffer methodBody = new StringBuffer();

    public DynamicMethod() {
        if (StringUtils.isBlank((String)this.getType())) {
            this.setType("void");
        }
    }

    public DynamicMethod(String fullMethodString) {
        if (StringUtils.isBlank((String)this.getType())) {
            this.setType("void");
        }
        this.analyzeMethod(fullMethodString);
    }

    public void analyzeMethod(String fullMethodString) {
        int parameterStart;
        int bodyStart;
        Matcher matcher = this.methodSignatrueEndPattern.matcher(fullMethodString);
        if (!matcher.find()) {
            return;
        }
        String methodSignature = fullMethodString.substring(0, fullMethodString.indexOf("(")).trim();
        int methodNameInd = methodSignature.lastIndexOf(" ");
        this.setName(StringUtils.uncapitalize((String)methodSignature.substring(methodNameInd + 1)));
        methodSignature = methodSignature.substring(0, methodNameInd).trim();
        int returnTypeStartIndex = this.getReturnTypeStartIndex(methodSignature);
        this.setType(methodSignature.substring(returnTypeStartIndex));
        this.setAccessModel(DynamicClassUtile.getAccessModel(methodSignature));
        if (this.getAccessModel() != null) {
            methodSignature = methodSignature.substring(this.getAccessModel().length(), returnTypeStartIndex);
        }
        if (returnTypeStartIndex > 0) {
            this.addModifierByExpression(methodSignature);
        }
        if ((bodyStart = matcher.start()) > (parameterStart = fullMethodString.indexOf("(") + 1)) {
            this.addParameter(fullMethodString.substring(parameterStart, bodyStart));
        }
        this.setMethodBody(fullMethodString.substring(matcher.end() + 1, fullMethodString.lastIndexOf("}")));
    }

    protected int getReturnTypeStartIndex(String methodSignature) {
        if ((methodSignature = methodSignature.trim()).charAt(methodSignature.length() - 1) != '>') {
            return methodSignature.lastIndexOf(" ") + 1;
        }
        int count = 0;
        for (int i = methodSignature.length() - 1; i > 0; --i) {
            if (methodSignature.charAt(i) == '>') {
                ++count;
            }
            if (methodSignature.charAt(i) == '<') {
                --count;
            }
            if (count != 0) continue;
            methodSignature = methodSignature.substring(0, i).trim();
            break;
        }
        return methodSignature.lastIndexOf(" ") + 1;
    }

    public DynamicMethod generateCallMethod(String methodName) {
        DynamicMethod method = new DynamicMethod();
        method.setName(methodName);
        Map<String, String> parameterMap = this.getParameters();
        StringBuffer params = new StringBuffer();
        for (String parameter : parameterMap.keySet()) {
            method.addParameter(parameter, parameterMap.get(parameter));
            params.append(parameter).append(",");
        }
        if (params.length() > 0) {
            params.setLength(params.length() - 1);
        }
        if (!this.isVoidMethod()) {
            method.getMethodBody().append(this.getType()).append(" $res = ");
            method.setType(this.getType());
        }
        method.getMethodBody().append(this.getName()).append("(").append(params).append(");");
        if (!this.isVoidMethod()) {
            method.getMethodBody().append("\r\nreturn $res;");
        }
        return method;
    }

    public void insertBefore(String beforExpression) {
        this.getMethodBody().insert(0, beforExpression + "\r\n");
    }

    protected boolean isVoidMethod() {
        return "void".equalsIgnoreCase(this.getType());
    }

    public String removeParameter(String parameterName) {
        return this.parameters.remove(parameterName);
    }

    public void addParameter(String parameterName, String parameterType) {
        this.parameters.put(parameterName, parameterType);
    }

    public void addParameter(String parametersExpressioin) {
        if (StringUtils.isBlank((String)parametersExpressioin)) {
            return;
        }
        if (parametersExpressioin.charAt(parametersExpressioin.length() - 1) == ')' && parametersExpressioin.charAt(0) == '(') {
            parametersExpressioin = parametersExpressioin.substring(1, parametersExpressioin.length() - 1);
        }
        if (StringUtils.isBlank((String)parametersExpressioin)) {
            return;
        }
        for (String parameterExpr : parametersExpressioin.split(",")) {
            String[] parameterArr = parameterExpr.trim().split(" ");
            if (parameterArr.length != 2) {
                throw new IllegalArgumentException("illegal parametersExpressioin :" + parametersExpressioin);
            }
            this.parameters.put(parameterArr[1], parameterArr[0]);
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public StringBuffer getMethodBody() {
        return this.methodBody;
    }

    public DynamicMethod setMethodBody(StringBuffer methodBody) {
        this.methodBody = methodBody;
        return this;
    }

    public DynamicMethod setMethodBody(String methodBody) {
        this.methodBody.setLength(0);
        this.methodBody.append(methodBody);
        return this;
    }

    public String getSignature() {
        StringBuffer content = new StringBuffer();
        content.append(this.getName());
        content.append("(");
        for (String parameterName : this.parameters.keySet()) {
            content.append(parameterName).append(" ").append(this.parameters.get(parameterName)).append(",");
        }
        if (this.parameters.size() > 0) {
            content.setLength(content.length() - 1);
        }
        content.append(")");
        return content.toString();
    }

    @Override
    public String getContent() {
        StringBuffer content = new StringBuffer();
        content.append(super.getContent());
        content.append("(");
        for (String parameterName : this.parameters.keySet()) {
            content.append(this.parameters.get(parameterName)).append(" ").append(parameterName).append(",");
        }
        if (this.parameters.size() > 0) {
            content.setLength(content.length() - 1);
        }
        content.append("){\r\n");
        content.append(this.methodBody);
        content.append("\r\n}\r\n");
        return content.toString();
    }

    public String toString() {
        return this.getContent();
    }
}

