/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile;

import com.alibaba.fastjson.util.TypeUtils;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.formulaplatform.FormulaException;
import com.kingdee.shr.formulaplatform.FormulaFuncInfo;
import com.kingdee.shr.formulaplatform.FormulaItemInfo;
import com.kingdee.shr.formulaplatform.compile.AgeClass;
import com.kingdee.shr.formulaplatform.compile.DynamicClass;
import com.kingdee.shr.formulaplatform.compile.DynamicMethod;
import com.kingdee.shr.formulaplatform.compile.TextClassLoader;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.FormulaExprProcessor;
import com.kingdee.shr.formulaplatform.formulaexecutor.AbsCompareTo;
import com.kingdee.shr.formulaplatform.formulaexecutor.AbsFormulaExecutor;
import com.kingdee.shr.formulaplatform.formulaexecutor.DefaultFormulaExecutor;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaExecutorUtile;
import com.kingdee.shr.formulaplatform.formulaexecutor.IFormulaExecutor;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FormulaDynamicClass
extends DynamicClass {
    public static final String PREFIX_DEF_VAR = "__";
    private static Pattern returnPattern = Pattern.compile("return\\s+(true|false)\\s*;(\\r\\n)*$");
    public static final String FUN_COMPARE = "4i4AAAAr8gAkATlo";
    public static final String superClass = AbsFormulaExecutor.class.getName();
    public static final String compareSuper = AbsCompareTo.class.getName();
    public static final String packageName = AbsFormulaExecutor.class.getPackage().getName();
    public static final String packageName_fun = AbsFormulaExecutor.class.getPackage().getName() + "Fn";
    public static final String clearDir = TextClassLoader.getClsPath() + File.separator + "simulate";
    private String fullFormulaContent;
    private boolean generateCallMethod;

    public FormulaDynamicClass() {
        TextClassLoader.deleOldFile(clearDir);
        this.addImportPackage(TypeUtils.class.getName());
        this.addImportPackage(BigDecimal.class.getName());
        this.addImportPackage(SimpleDateFormat.class.getName());
        this.addImportPackage("java.util.*");
        this.addImportPackage(FormulaDynamicClass.class.getPackage().getName() + ".*");
        this.addImportPackage(DefaultFormulaExecutor.class.getPackage().getName() + ".*");
        this.addImportPackage("com.kingdee.eas.framework.CoreBaseInfo");
        this.setSuperClass(superClass);
    }

    protected void initFormula(String fullName) {
        int lastDotInd = fullName.lastIndexOf(".");
        this.setName(StringUtils.capitalize((String)fullName.substring(lastDotInd + 1)));
        this.setPackageName(fullName.substring(0, lastDotInd));
        DynamicMethod method = new DynamicMethod();
        method.setName("execute");
        method.setType("boolean");
        String methodBody = this.formulaBodyProcess(this.fullFormulaContent);
        method.setMethodBody(methodBody);
        this.addMethod(method);
    }

    protected void initFormulaFun() {
        this.setGenerateCallMethod(true);
        this.setPackageName(packageName_fun);
        DynamicMethod method = this.addMethod(this.fullFormulaContent);
        this.setName(StringUtils.capitalize((String)method.getName()));
    }

    public Class<IFormulaExecutor> getFormulaCls(Context ctx, FormulaItemInfo formulaItemInfo, boolean isSimulate) throws FormulaException {
        AgeClass<?> ageCls;
        String fullClsName = this.getFormulaClsName(ctx, formulaItemInfo, isSimulate);
        long lastUpdateTime = System.currentTimeMillis();
        if (formulaItemInfo.getLastUpdateTime() != null && !isSimulate) {
            lastUpdateTime = formulaItemInfo.getLastUpdateTime().getTime();
        }
        if ((ageCls = TextClassLoader.getAgeCls(fullClsName)) == null || ageCls.getLastUpdateTime() < lastUpdateTime) {
            FormulaDynamicClass dynamicClass = new FormulaDynamicClass();
            dynamicClass.setCtx(ctx);
            dynamicClass.setFullFormulaContent(formulaItemInfo.getScript());
            dynamicClass.initFormula(fullClsName);
            ageCls = TextClassLoader.loadCls(dynamicClass.getContent(), lastUpdateTime);
        }
        return (Class)ageCls.getModel();
    }

    protected FormulaExprProcessor getFormulaExprProcess() {
        return new FormulaExprProcessor();
    }

    public String getFormulaClsName(Context ctx, FormulaItemInfo formulaItemInfo, boolean isSimulate) {
        String entityName = formulaItemInfo.getFormula();
        if (BOSUuid.isValid((String)entityName, (boolean)true)) {
            BOSObjectType bosType = BOSUuid.read((String)formulaItemInfo.getFormula()).getType();
            EntityObjectInfo formulaEntity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            entityName = formulaEntity.getName();
        } else if (StringUtils.isBlank((String)entityName)) {
            SimpleDateFormat sdf = new SimpleDateFormat("MMDDHHmmss");
            entityName = "_" + sdf.format(Calendar.getInstance().getTime());
            formulaItemInfo.setFormula(entityName);
        }
        String userId = "";
        if (isSimulate) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            userId = "_" + this.encodeSpecialSign(userInfo.getString("id"));
        }
        return FormulaExecutorUtile.joinWithDot(isSimulate ? "simulate" : "", packageName, entityName, this.encodeSpecialSign(formulaItemInfo.getFormula()), StringUtils.capitalize((String)formulaItemInfo.getNumber()) + userId);
    }

    protected String getFormulaFunName(Context ctx, FormulaFuncInfo formulaFuncInfo, boolean isSimulate) {
        return FormulaExecutorUtile.joinWithDot(packageName_fun, StringUtils.capitalize((String)formulaFuncInfo.getDefine()));
    }

    public Class<IFormulaExecutor> getFormulaFunCls(Context ctx, FormulaFuncInfo formulaFuncInfo, boolean isSimulate) {
        AgeClass<?> ageCls;
        long lastUpdateTime = System.currentTimeMillis();
        if (formulaFuncInfo.getLastUpdateTime() != null && !isSimulate) {
            lastUpdateTime = formulaFuncInfo.getLastUpdateTime().getTime();
        }
        if ((ageCls = TextClassLoader.getAgeCls(this.getFormulaFunName(ctx, formulaFuncInfo, isSimulate))) == null || ageCls.getLastUpdateTime() < lastUpdateTime) {
            FormulaDynamicClass dynamicClass = new FormulaDynamicClass();
            if (FUN_COMPARE.equals(formulaFuncInfo.getString("id"))) {
                dynamicClass.setSuperClass(AbsCompareTo.class.getName());
            } else if (ageCls != null) {
                dynamicClass.setSuperClass(((Class)ageCls.getModel()).getName());
            }
            dynamicClass.setCtx(ctx);
            dynamicClass.setFullFormulaContent(formulaFuncInfo.getContent());
            dynamicClass.initFormulaFun();
            ageCls = TextClassLoader.loadCls(dynamicClass.getContent(), lastUpdateTime);
        }
        return (Class)ageCls.getModel();
    }

    protected String encodeSpecialSign(String id) {
        if (id == null) {
            return "";
        }
        return "_" + id.replaceAll("\\+", "_p").replaceAll("=", "_e").replaceAll("/", "_s").replaceAll("\\-", "_m");
    }

    protected String decodeSpecialSign(String id) {
        return id.substring(1).replaceAll("_p", "+").replaceAll("_e", "=").replaceAll("_s", "/");
    }

    @Override
    public String getContent() {
        if (this.isGenerateCallMethod()) {
            for (DynamicMethod method : this.getMethods().values()) {
                DynamicMethod callMethod = method.generateCallMethod("_innerExecute");
                if (AbsCompareTo.class.getName().equals(this.getSuperClass()) && !"compareTo".equals(method.getName())) {
                    callMethod.setName("compareTo");
                }
                callMethod.insertBefore("this.beforeExecute();");
                int returnInd = callMethod.getMethodBody().lastIndexOf("return ");
                callMethod.getMethodBody().insert(returnInd, "this.afterExecute();\r\n");
                this.addMethod(callMethod);
            }
        }
        this.addGetSchemeFieldMethod(this.fullFormulaContent);
        this.addRefFuncsMethod(this.fullFormulaContent);
        return super.getContent();
    }

    public Set<String> getSelectSchemeFields(String content) {
        HashSet<String> selectedFields = new HashSet<String>();
        Matcher matcher = DefaultFormulaExecutor.P_FIELD_GET.matcher(content);
        while (matcher.find()) {
            selectedFields.add(matcher.group(3));
        }
        matcher = DefaultFormulaExecutor.P_CUNSTON_FUN.matcher(content);
        while (matcher.find()) {
            selectedFields.add(matcher.group(3));
        }
        return selectedFields;
    }

    protected void addGetSchemeFieldMethod(String clsContent) {
        Set<String> selectFields = this.getSelectSchemeFields(clsContent);
        if (selectFields == null || selectFields.size() == 0) {
            return;
        }
        DynamicMethod method = new DynamicMethod();
        method.setName("getSchemeField");
        method.setType("String[]");
        method.getMethodBody().append("return new String[]{\"");
        method.getMethodBody().append(StringUtils.join(selectFields.iterator(), (String)"\",\""));
        method.getMethodBody().append("\"};");
        this.addMethod(method);
    }

    protected void addRefFuncsMethod(String clsContent) {
        HashSet<String> selectedFuncs = new HashSet<String>();
        Matcher matcher = DefaultFormulaExecutor.P_FORMULA_ID.matcher(clsContent);
        while (matcher.find()) {
            selectedFuncs.add(matcher.group(1));
        }
        DynamicMethod method = new DynamicMethod();
        method.setName("getRefFuncs");
        method.setType("String[]");
        method.getMethodBody().append("return new String[]{\"");
        method.getMethodBody().append(StringUtils.join(selectedFuncs.iterator(), (String)"\",\""));
        method.getMethodBody().append("\"};");
        this.addMethod(method);
    }

    protected String formulaBodyProcess(String content) {
        String varDefName;
        String clsName;
        StringBuffer varDef = new StringBuffer();
        varDef.append("this.beforeExecute();\r\n");
        varDef.append("CoreBaseInfo model = getFormulaCtx().getCurCalModel();\r\n");
        varDef.append("Map<String,Object> dataSource = getFormulaCtx().getCurSchemeDataSorces();\r\n");
        Matcher matcher = DefaultFormulaExecutor.P_FORMULA_ID.matcher(content);
        HashMap<String, String> funMap = new HashMap<String, String>();
        while (matcher.find()) {
            if (funMap.containsKey(matcher.group())) continue;
            String funName = matcher.group(1);
            IFormulaExecutor executor = FormulaExecutorUtile.getFuncExecutorInst(funName, null);
            this.addImportPackage(executor.getClass().getName());
            clsName = executor.getClass().getSimpleName();
            varDefName = this.getVarDefName(clsName, content, varDef);
            varDef.append(executor.getClass().getSimpleName()).append(" ").append(varDefName);
            varDef.append(" = (").append(executor.getClass().getSimpleName()).append(")");
            varDef.append("FormulaExecutorUtile.getFuncExecutorInst(\"").append(funName).append("\",null);\r\n");
            varDef.append(varDefName).append(".initExecutor(this);\r\n");
            funMap.put(matcher.group(), varDefName + "._innerExecute");
        }
        varDef.append("\r\n\r\n");
        matcher = DefaultFormulaExecutor.P_FIELD_GET.matcher(content);
        while (matcher.find()) {
            if (funMap.containsKey(matcher.group())) continue;
            varDefName = this.getVarDefName(matcher.group(3).replaceAll("\\.", "_"), content, varDef);
            clsName = FormulaExecutorUtile.getSchemeDataType(matcher.group(2));
            if (clsName.equals(Date.class.getName())) {
                clsName = String.class.getName();
            }
            varDef.append(clsName).append(" ").append(varDefName);
            varDef.append(" = (").append(clsName).append(")");
            varDef.append("FormulaExecutorUtile.getFieldVal").append(matcher.group(1)).append(";\r\n");
            funMap.put(matcher.group(), varDefName);
        }
        for (String key : funMap.keySet()) {
            while (content.indexOf(key) >= 0) {
                content = content.replace(key, (CharSequence)funMap.get(key));
            }
        }
        varDef.append("\r\n").append(content);
        varDef.append("\r\nthis.afterExecute();\r\n");
        if (!returnPattern.matcher(content.trim()).find()) {
            varDef.append("return true;\r\n");
        }
        return varDef.toString();
    }

    protected String getVarDefName(String defName, String content, StringBuffer varDef) {
        defName = PREFIX_DEF_VAR + StringUtils.uncapitalize((String)defName);
        String tempDef = defName;
        if (content.contains(tempDef) || varDef.indexOf(tempDef) > -1) {
            for (int i = 0; i < 10000 && (content.contains(tempDef = defName + i) || varDef.indexOf(tempDef) >= 0); ++i) {
            }
        }
        return tempDef;
    }

    public boolean isGenerateCallMethod() {
        return this.generateCallMethod;
    }

    public FormulaDynamicClass setGenerateCallMethod(boolean generateCallMethod) {
        this.generateCallMethod = generateCallMethod;
        return this;
    }

    public String getFullFormulaContent() {
        return this.fullFormulaContent;
    }

    public FormulaDynamicClass setFullFormulaContent(String fullFormulaContent) {
        this.fullFormulaContent = fullFormulaContent;
        return this;
    }
}

