/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.formulaplatform.compile.formulaexpr.operator;

import com.alibaba.fastjson.util.TypeUtils;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.FormulaExpr;
import com.kingdee.shr.formulaplatform.compile.formulaexpr.OperatorExpr;
import com.kingdee.shr.formulaplatform.formulaexecutor.AbsCompareTo;
import com.kingdee.shr.formulaplatform.formulaexecutor.FormulaExecutorUtile;
import com.kingdee.shr.formulaplatform.formulaexecutor.IFormulaExecutor;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class OperatorLogic
extends OperatorExpr {
    public OperatorLogic() {
    }

    public OperatorLogic(String expr, String operatorName) {
        this.setExpr(expr);
        this.setOperatorName(operatorName);
    }

    public static void initOperator() {
        OperatorLogic.addOperatorExpr("==", OperatorLogic.class, "equal");
        OperatorLogic.addOperatorExpr("!=", OperatorLogic.class, "notEqual");
        OperatorLogic.addOperatorExpr("<>", OperatorLogic.class, "notEqual");
        OperatorLogic.addOperatorExpr(">=", OperatorLogic.class, "bigEqual");
        OperatorLogic.addOperatorExpr(">", OperatorLogic.class, "bigThan");
        OperatorLogic.addOperatorExpr("<", OperatorLogic.class, "lessThan");
        OperatorLogic.addOperatorExpr("<=", OperatorLogic.class, "lessEqual");
    }

    @Override
    public void processOperand(List<FormulaExpr> processedExprs, ListIterator<FormulaExpr> processedExprsIt) {
        processedExprsIt.remove();
        FormulaExpr leftExpr = processedExprsIt.previous();
        processedExprsIt.next();
        leftExpr.setExpr(MessageFormat.format("{0}.{1}({2},{3})", this.getClass().getName(), this.getOperatorName(), leftExpr.getExpr(), processedExprsIt.next().getExpr()));
        processedExprsIt.previous();
        processedExprsIt.remove();
        System.out.println(2);
    }

    public static <T1, T2> boolean equal(T1 comparable1, T2 comparable2) {
        Integer compareRes = OperatorLogic.compareTo(comparable1, comparable2, 1);
        return compareRes != null && compareRes == 0;
    }

    public static <T1, T2> boolean notEqual(T1 comparable1, T2 comparable2) {
        Integer compareRes = OperatorLogic.compareTo(comparable1, comparable2, 2);
        return compareRes != null && compareRes != 0;
    }

    public static <T1, T2> boolean lessThan(T1 comparable1, T2 comparable2) {
        Integer compareRes = OperatorLogic.compareTo(comparable1, comparable2, 3);
        return compareRes != null && compareRes < 0;
    }

    public static <T1, T2> boolean lessEqual(T1 comparable1, T2 comparable2) {
        Integer compareRes = OperatorLogic.compareTo(comparable1, comparable2, 4);
        return compareRes != null && compareRes <= 0;
    }

    public static <T1, T2> boolean bigThan(T1 comparable1, T2 comparable2) {
        Integer compareRes = OperatorLogic.compareTo(comparable1, comparable2, 5);
        return compareRes != null && compareRes > 0;
    }

    public static <T1, T2> boolean bigEqual(T1 comparable1, T2 comparable2) {
        Integer compareRes = OperatorLogic.compareTo(comparable1, comparable2, 6);
        return compareRes != null && compareRes >= 0;
    }

    public static Object[] formateCompareObj(Object comparable1, Object comparable2) {
        Object[] returnVal = new Object[2];
        if (comparable1 instanceof Date || comparable2 instanceof Date) {
            returnVal[0] = TypeUtils.castToDate((Object)comparable1);
            returnVal[1] = TypeUtils.castToDate((Object)comparable2);
        } else if (comparable1 instanceof Number || comparable2 instanceof Number) {
            returnVal[0] = new BigDecimal(OperatorLogic.convertBoolearStr2Num(comparable1).toString());
            returnVal[1] = new BigDecimal(OperatorLogic.convertBoolearStr2Num(comparable2).toString());
        } else {
            returnVal[0] = comparable1.toString();
            returnVal[1] = comparable2.toString();
        }
        return returnVal;
    }

    private static Object convertBoolearStr2Num(Object value) {
        if ("true".equalsIgnoreCase(value.toString())) {
            return 1;
        }
        if ("false".equalsIgnoreCase(value.toString())) {
            return 0;
        }
        return value;
    }

    public static Integer compareTo(Object comparable1, Object comparable2, int operation) {
        IFormulaExecutor executor = null;
        executor = FormulaExecutorUtile.getFuncExecutorInst("4i4AAAAr8gAkATlo", null);
        if (executor instanceof AbsCompareTo) {
            return ((AbsCompareTo)executor).compareTo(comparable1, comparable2, operation);
        }
        if (comparable1 == comparable2) {
            return 0;
        }
        if (comparable1 == null || comparable2 == null) {
            return null;
        }
        if (comparable1.equals(comparable2)) {
            return 0;
        }
        Object[] formatVals = OperatorLogic.formateCompareObj(comparable1, comparable2);
        return !((comparable1 = formatVals[0]) instanceof Comparable) ? null : Integer.valueOf(((Comparable)comparable1).compareTo(formatVals[1]));
    }
}

