/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.cloudservice.ICloudServiceURLConfig;
import com.kingdee.shr.recuritment.CloudServiceURLConfigCollection;
import com.kingdee.shr.recuritment.CloudServiceURLConfigFactory;
import com.kingdee.shr.recuritment.app.util.HttpUtil;
import com.kingdee.shr.recuritment.utils.RecBaseUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CloudServiceUtil {
    private static Logger logger = Logger.getLogger(CloudServiceUtil.class);
    private static ThreadLocal<Integer> threadPool = new ThreadLocal();
    private static final String notRegister = "\u60a8\u5c1a\u672a\u6ce8\u518c\u4e91\u670d\u52a1\uff0c\u8bf7\u5148\u6ce8\u518c\uff01";
    private static final String tokenNotExist = "\u60a8\u5c1a\u672a\u7533\u8bf7\u4e91\u670d\u52a1\u5bc6\u94a5\uff0c\u8bf7\u5728\u4e91\u670d\u52a1\u8bbe\u7f6e\u4e2d\u70b9\u51fb\u3010\u8fde\u63a5\u3011\u6309\u94ae\uff01";
    private static final String autoRefreshTokenInvalid = "\u81ea\u52a8\u5237\u65b0\u4e91\u670d\u52a1\u5bc6\u94a5\u5931\u6548\uff0c\u8bf7\u5728\u4e91\u670d\u52a1\u8bbe\u7f6e\u4e2d\u70b9\u51fb\u3010\u8fde\u63a5\u3011\u6309\u94ae\uff01";

    public static String getServiceUrl(Context ctx, String serviceType) throws BOSException {
        String serviceURL = null;
        try {
            CloudServiceURLConfigCollection urlColl = CloudServiceURLConfigFactory.getLocalInstance(ctx).getCloudServiceURLConfigCollection(" where state='1' and serviceType='" + serviceType + "'");
            if (!RecBaseUtils.isEmpty((IObjectCollection)urlColl)) {
                serviceURL = urlColl.get(0).getServiceURL();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank(serviceURL)) {
            throw new BOSException("\u9884\u7f6e\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38\uff0cserviceType\uff1a" + serviceType + "\u5bf9\u5e94serviceURL\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\uff01");
        }
        return serviceURL == null ? "" : serviceURL.trim();
    }

    public static String getServiceUrl2(Context ctx, String serviceType) throws BOSException {
        String serviceURL = "";
        try {
            ICloudServiceURLConfig icUrlConfig = com.kingdee.shr.cloudservice.CloudServiceURLConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceURLConfigInfo csConfigInfo = icUrlConfig.getCloudServiceURLConfigInfo(" where state='1' and serviceType=" + serviceType);
            serviceURL = csConfigInfo.getServiceURL();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)serviceURL)) {
            throw new BOSException("\u9884\u7f6e\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38\uff0cserviceType\uff1a" + serviceType + "\u5bf9\u5e94serviceURL\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\uff01");
        }
        return serviceURL;
    }

    public static String getToken(Context ctx) throws BOSException {
        CloudServiceConfigInfo recConfigInfo = null;
        CloudServiceConfigCollection configColl = null;
        try {
            configColl = CloudServiceConfigFactory.getLocalInstance((Context)ctx).getCloudServiceConfigCollection();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u6821\u9a8c\u4e91\u670d\u52a1\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        if (RecBaseUtils.isEmpty((IObjectCollection)configColl)) {
            throw new BOSException(notRegister);
        }
        recConfigInfo = configColl.get(0);
        String token = recConfigInfo.getAccessToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new BOSException(tokenNotExist);
        }
        if (!CloudServiceUtil.checkTokenIsValid(recConfigInfo.getStopTime())) {
            CloudServiceUtil.refreshToken(ctx, recConfigInfo);
            return CloudServiceUtil.getToken(ctx);
        }
        threadPool.remove();
        return token;
    }

    public static Map<String, Object> tokenCheckforAnalysis(Context ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            CloudServiceUtil.getToken(ctx);
            map.put("state", true);
            map.put("info", "\u4e91\u670d\u52a1\u8fde\u63a5\u6709\u6548");
        }
        catch (BOSException e) {
            map.put("state", false);
            map.put("info", e.getMessage());
        }
        return map;
    }

    private static boolean checkTokenIsValid(Date date) {
        if (date == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u4e91\u670d\u52a1\u662f\u5426\u8fc7\u671f\u65f6\u95f4\u4e3a\u7a7a\uff0c\u91cd\u65b0\u83b7\u53d6\u4e91\u670d\u52a1token!");
            }
            return false;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u6821\u9a8c\u4e91\u670d\u52a1\u662f\u5426\u8fc7\u671f\uff0c\u4e91\u670d\u52a1\u8fc7\u671f\u65f6\u95f4\uff1a" + format.format(date)));
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, -2);
        Date now = new Date();
        return now.getTime() - c.getTime().getTime() <= 0L;
    }

    private static void refreshToken(Context ctx, CloudServiceConfigInfo recConfigInfo) throws BOSException {
        Integer refreshCount = threadPool.get();
        if (refreshCount == null) {
            refreshCount = 1;
        } else {
            if (refreshCount > 3) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"\u5df2\u81ea\u52a8\u5237\u65b0token3\u6b21\uff0c\u81ea\u52a8\u5237\u65b0\u5931\u8d25\uff01");
                }
                threadPool.remove();
                throw new BOSException(autoRefreshTokenInvalid);
            }
            Integer n = refreshCount;
            Integer n2 = refreshCount = Integer.valueOf(refreshCount + 1);
        }
        threadPool.set(refreshCount);
        StringBuffer param = new StringBuffer("from=1");
        param.append("&redirect_url=");
        param.append(recConfigInfo.getEnterPubNetwork());
        param.append("&service_id=");
        param.append(recConfigInfo.getServiceID());
        param.append("&service_key=");
        param.append(recConfigInfo.getServiceKey());
        String requestUrl = null;
        try {
            requestUrl = CloudServiceUtil.getServiceUrl2(ctx, "1");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u4e91\u670d\u52a1\u83b7\u53d6token\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458 \uff01");
        }
        if (StringUtils.isEmpty((CharSequence)requestUrl)) {
            throw new BOSException("\u4e91\u670d\u52a1\u83b7\u53d6token\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458 \uff01");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*********\u81ea\u52a8\u66f4\u65b0token\uff0c\u5f00\u59cb\u8bf7\u6c42\u4e91\u670d\u52a1-\u8fde\u63a5->\u63a5\u53e3,\u8bf7\u6c42\u7684URL\uff1a" + requestUrl));
            logger.debug((Object)("s-HR\u8bf7\u6c42\u53c2\u6570----" + param.toString()));
        }
        String result = null;
        try {
            result = HttpUtil.get((Context)ctx, (String)requestUrl, (String)param.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u4e91\u670d\u52a1\u8fde\u63a5\u8fd4\u56de\u7ed3\u679c:" + result));
        }
        Gson gson = new Gson();
        JsonElement JE = (JsonElement)gson.fromJson(result, JsonElement.class);
        JsonObject jsonObj = null;
        if (JE != null && JE.isJsonObject()) {
            jsonObj = JE.getAsJsonObject();
        }
        if (jsonObj == null || jsonObj.get("code") == null || !"0".equals(jsonObj.get("code").getAsString())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u4e91\u670d\u52a1\u83b7\u53d6token\u5931\u8d25\uff01");
            }
            threadPool.remove();
            throw new BOSException(autoRefreshTokenInvalid);
        }
    }

    public static String getRedirectUrl(Context ctx) throws BOSException {
        String redirectUrl = "";
        try {
            ICloudServiceConfig iConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceConfigCollection recCollection = iConfig.getCloudServiceConfigCollection();
            if (RecBaseUtils.isEmpty((IObjectCollection)recCollection)) {
                throw new BOSException("\u5c1a\u672a\u6ce8\u518c\u4e91\u670d\u52a1\uff01");
            }
            CloudServiceConfigInfo recConfigInfo = recCollection.get(0);
            redirectUrl = recConfigInfo.getEnterPubNetwork();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u83b7\u53d6\u4e91\u670d\u52a1\u516c\u7f51\u5730\u5740\u5931\u8d25\uff01");
        }
        return redirectUrl.trim();
    }

    public static CloudServiceConfigInfo getCloudServiceConfig(Context ctx) throws BOSException {
        CloudServiceConfigInfo recConfigInfo = null;
        ICloudServiceConfig iConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
        CloudServiceConfigCollection recCollection = iConfig.getCloudServiceConfigCollection();
        if (RecBaseUtils.isEmpty((IObjectCollection)recCollection)) {
            throw new BOSException("\u5c1a\u672a\u6ce8\u518c\u4e91\u670d\u52a1\uff01");
        }
        recConfigInfo = recCollection.get(0);
        return recConfigInfo;
    }

    public static String getShrOfferUrl(String pubNetWork) {
        pubNetWork = CloudServiceUtil.replaceLast(pubNetWork, "shr", "shrOffer");
        return pubNetWork + "/dist/index.html#";
    }

    public static String replaceLast(String text, String strToReplace, String replaceWithThis) {
        return text.replaceFirst("(?s)" + strToReplace + "(?!.*?" + strToReplace + ")", replaceWithThis);
    }
}

