/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.org.HRJobCollection;
import com.kingdee.eas.hr.org.HRJobFactory;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.IHRJob;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.shr.base.syssetting.DomainFilterFacadeFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.domain.DomainParser;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailDiathesisInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailEvaluateInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailResultInfo;
import com.kingdee.shr.recuritment.IPInterviewStructureDetailWriteInfo;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewStructureData;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewStructureElement;
import com.kingdee.shr.recuritment.app.bo.interviewGo.InterviewStructureGroupData;
import com.kingdee.shr.recuritment.app.util.OrgUnitUtil;
import com.kingdee.shr.recuritment.utils.RecMetaUtil;
import com.kingdee.shr.recuritment.utils.RecUIViewUtil;
import com.kingdee.shr.recuritment.vo.FieldInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InterGOUtil {
    private static Logger logger = LoggerFactory.getLogger(InterGOUtil.class);
    private static ThreadLocal<Map<String, InterviewStructureElement>> threadMap = new ThreadLocal();

    public static InterviewStructureData doSetInterResult(Context ctx, IPInterviewStructureDetailResultInfo info, List<FieldInfo> fields, Map<String, ColumnInfo> colMap, String eleName) {
        List<Object> list = InterGOUtil.processElement(ctx, (CoreBaseInfo)info, fields, colMap, info.getInterviewPlanId());
        if (list.size() == 0) {
            return null;
        }
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        ArrayList<InterviewStructureGroupData> groupData = new ArrayList<InterviewStructureGroupData>();
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(list, "base", "");
        groupData.add(baseGroupData);
        interviewStructureData.setGroupData(groupData);
        interviewStructureData.setStruClass("interviewer");
        interviewStructureData.setStruName(eleName);
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailResult.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        return interviewStructureData;
    }

    private static List<Object> processElement(Context ctx, CoreBaseInfo info, List<FieldInfo> fields, Map<String, ColumnInfo> colMap, String interviewPlanId) {
        ArrayList list = Lists.newArrayList();
        for (FieldInfo field : fields) {
            if (InterGOUtil.skipField(field)) continue;
            InterviewStructureElement element = InterGOUtil.processSpecialElement(ctx, field, interviewPlanId, info);
            if (element == null) {
                element = InterGOUtil.getCommonElement(ctx, info, field, colMap);
            }
            list.add(element);
        }
        return list;
    }

    private static InterviewStructureElement getCommonElement(Context ctx, CoreBaseInfo info, FieldInfo field, Map<String, ColumnInfo> colMap) {
        logger.error("process common element:" + field.getName());
        logger.error("process common element:" + field);
        InterviewStructureElement element = new InterviewStructureElement();
        element.setColName(field.getName());
        if (element.getColName().equalsIgnoreCase("sureResult")) {
            element.setValue(info.get("result"));
        } else {
            element.setValue(info.get(field.getName()));
        }
        element.setShowName(field.getAlias());
        element.setFieldType(InterGOUtil.getFieldType(field));
        element.setReadOnly(InterGOUtil.getReadOnly(field));
        if ((element.getFieldType().equalsIgnoreCase("Text") || element.getFieldType().equalsIgnoreCase("LongText")) && !element.isReadOnly()) {
            element.setMaxLength((Object)InterGOUtil.getFieldLength(field, colMap));
        }
        element.setRequired(InterGOUtil.getRequired(field));
        if (element.getFieldType().equalsIgnoreCase("Number")) {
            InterGOUtil.setNumber(element, field, colMap);
        }
        if (element.getFieldType().equalsIgnoreCase("Select")) {
            element.setOptions(InterGOUtil.getOptions(ctx, field));
        }
        element.setAssociatedField(InterGOUtil.getAssociatedField(field));
        return element;
    }

    private static void setNumber(InterviewStructureElement element, FieldInfo field, Map<String, ColumnInfo> colMap) {
        PropertyInfo propertyInfo = field.getProperty();
        ColumnInfo mappingField = propertyInfo.getMappingField();
        ColumnInfo columnInfo = colMap.get(mappingField.getName());
        if (columnInfo != null) {
            element.setScale(Integer.valueOf(columnInfo.getScale()));
            element.setPrecision(Integer.valueOf(columnInfo.getPrecision()));
        }
    }

    private static InterviewStructureElement processSpecialElement(Context ctx, FieldInfo field, String interviewPlanId, CoreBaseInfo coreBaseInfo) {
        if (StringUtils.isEmpty((CharSequence)interviewPlanId)) {
            logger.error("\u7ec4\u88c5\u7279\u6b8a\u5c5e\u6027\u51fa\u9519\uff0cinterviewPlanId \u4e3a\u7a7a");
            return null;
        }
        String fieldName = field.getName();
        if (fieldName.equalsIgnoreCase("jobGrade")) {
            String key;
            InterviewStructureElement element;
            HashMap map = threadMap.get();
            if (map == null) {
                map = Maps.newHashMap();
                threadMap.set(map);
            }
            if ((element = (InterviewStructureElement)map.get(key = interviewPlanId + "jobGrade")) == null) {
                element = InterGOUtil.getJobGradeElement(ctx, (JobGradeInfo)coreBaseInfo.get("jobGrade"), interviewPlanId, field);
                map.put(key, element);
            }
            return element;
        }
        if (field.getDataType() != null && field.getDataType().getName().equalsIgnoreCase("OBJECTVALUE")) {
            try {
                FilterInfo domainFilter1;
                UIViewInfo uiViewInfo;
                PropertyInfo property = field.getProperty();
                logger.error("process \u5bf9\u8c61\u5c5e\u6027" + fieldName);
                String entityName = ((LinkPropertyInfo)property).getRelationship().getSupplierObject().getFullName();
                logger.error("process \u5bf9\u8c61\u5c5e\u6027" + entityName);
                logger.error("process \u5bf9\u8c61" + coreBaseInfo);
                String value = null;
                if (coreBaseInfo != null) {
                    Object o = coreBaseInfo.get(fieldName);
                    CoreBaseInfo columnObj = (CoreBaseInfo)o;
                    value = o == null ? "" : columnObj.get("id");
                }
                InterviewStructureElement element = new InterviewStructureElement(value, fieldName, field.getAlias(), null, "Select", false, false);
                element.setReadOnly(InterGOUtil.getReadOnly(field));
                element.setRequired(InterGOUtil.getRequired(field));
                String uipk = field.getAttributes().get("uipk");
                if (StringUtils.isEmpty((CharSequence)uipk)) {
                    uipk = entityName + ".f7";
                    uiViewInfo = RecUIViewUtil.getUIViewFromDB(ctx, uipk);
                    if (uiViewInfo == null) {
                        uipk = entityName + ".list";
                        uiViewInfo = RecUIViewUtil.getUIViewFromDB(ctx, uipk);
                    }
                    if (uiViewInfo == null) {
                        logger.error("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027" + fieldName + "\u65e0\u5bf9\u5e94\u7684list/f7\u89c6\u56fe");
                        element.setOptions((List)Lists.newArrayList());
                        return element;
                    }
                } else {
                    uiViewInfo = RecUIViewUtil.getUIViewFromDB(ctx, uipk);
                    if (uiViewInfo == null) {
                        logger.error("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027" + fieldName + "\u5bf9\u5e94\u7684\u89c6\u56fe" + uipk + "\u4e0d\u5b58\u5728");
                        element.setOptions((List)Lists.newArrayList());
                        return element;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)uipk)) {
                    logger.error("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027" + fieldName + "\u65e0\u5bf9\u5e94\u7684\u89c6\u56fe");
                    element.setOptions((List)Lists.newArrayList());
                    return element;
                }
                logger.error("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027" + fieldName + "\u5bf9\u5e94\u7684\u89c6\u56fe" + uipk);
                String oql = "select id ,name where 1=1 and state =1 ";
                String domain = RecUIViewUtil.getDomain(ctx, uipk);
                if (StringUtils.isNotEmpty((CharSequence)domain) && !domain.contains("$") && (domainFilter1 = DomainFilterFacadeFactory.getLocalInstance((Context)ctx).getDomainFilter(entityName, domain, null)) != null && StringUtils.isNotEmpty((CharSequence)domainFilter1.toSql())) {
                    oql = oql + " and " + domainFilter1.toSql();
                }
                logger.error("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027" + fieldName + "\u5bf9\u5e94\u7684\u67e5\u8be2\uff1a" + oql);
                MetaDataPK toMetaPk = MetaDataPK.create((String)entityName);
                ICoreBase toCoreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)toMetaPk);
                CoreBaseCollection collection = toCoreBase.getCollection();
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < collection.size(); ++i) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("key", collection.get(i).getId());
                    hashMap.put("value", collection.get(i).get("name"));
                    arrayList.add(hashMap);
                }
                element.setOptions(arrayList);
                return element;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private static InterviewStructureElement getJobGradeElement(Context ctx, JobGradeInfo jobGradeInfo, String interviewPlanId, FieldInfo field) {
        logger.error("\u5904\u7406\u804c\u7b49\u9009\u9879\uff1ainterviewPlanId:" + interviewPlanId);
        InterviewStructureElement element = new InterviewStructureElement((Object)(jobGradeInfo == null ? "" : jobGradeInfo.getId()), "jobGrade", "\u804c\u7b49", null, "Select", false, false);
        ArrayList arrayList = new ArrayList();
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)interviewPlanId, CompareType.EQUALS));
            EntityViewInfo entityView = new EntityViewInfo();
            entityView.setFilter(filterInfo);
            entityView.getSelector().add(new SelectorItemInfo("interview.resumeBaseRec.recuritmentDemand.hrJob"));
            entityView.getSelector().add(new SelectorItemInfo("interview.resumeBaseRec.recuritmentDemand.recuritPosition"));
            entityView.getSelector().add(new SelectorItemInfo("interview.resumeBaseRec.recuritmentDemand.department"));
            InterviewPlanCollection coll = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanCollection(entityView);
            if (coll.size() > 0) {
                InterviewPlanInfo planInfo = coll.get(0);
                RecuritmentDemandInfo recuritmentDemand = planInfo.getInterview().getResumeBaseRec().getRecuritmentDemand();
                HRJobInfo hrJob = recuritmentDemand.getHrJob();
                PositionInfo recuritPosition = recuritmentDemand.getRecuritPosition();
                JobGradeInfo highJobGrade = null;
                JobGradeInfo lowJobGrade = null;
                String filter = "";
                if (recuritPosition != null) {
                    IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
                    FilterInfo positionFilter = new FilterInfo();
                    positionFilter.getFilterItems().add(new FilterItemInfo("id", (Object)recuritPosition.getId().toString(), CompareType.EQUALS));
                    EntityViewInfo positionView = new EntityViewInfo();
                    positionView.setFilter(positionFilter);
                    positionView.getSelector().add(new SelectorItemInfo("highJobGrade"));
                    positionView.getSelector().add(new SelectorItemInfo("highJobGrade.name"));
                    positionView.getSelector().add(new SelectorItemInfo("highJobGrade.JobGradeModule"));
                    positionView.getSelector().add(new SelectorItemInfo("highJobGrade.JobGradeModule.name"));
                    positionView.getSelector().add(new SelectorItemInfo("highJobGrade.grade"));
                    positionView.getSelector().add(new SelectorItemInfo("lowJobGrade"));
                    positionView.getSelector().add(new SelectorItemInfo("lowJobGrade.name"));
                    positionView.getSelector().add(new SelectorItemInfo("lowJobGrade.JobGradeModule"));
                    positionView.getSelector().add(new SelectorItemInfo("lowJobGrade.JobGradeModule.name"));
                    positionView.getSelector().add(new SelectorItemInfo("lowJobGrade.grade"));
                    PositionCollection positionCollection = iPosition.getPositionCollection(positionView);
                    if (positionCollection != null && positionCollection.size() > 0) {
                        highJobGrade = positionCollection.get(0).getHighJobGrade();
                        lowJobGrade = positionCollection.get(0).getLowJobGrade();
                    }
                } else if (hrJob != null) {
                    IHRJob iHrJob = HRJobFactory.getLocalInstance((Context)ctx);
                    FilterInfo jobFilter = new FilterInfo();
                    jobFilter.getFilterItems().add(new FilterItemInfo("id", (Object)hrJob.getId().toString(), CompareType.EQUALS));
                    EntityViewInfo jobView = new EntityViewInfo();
                    jobView.setFilter(jobFilter);
                    jobView.getSelector().add(new SelectorItemInfo("highJobGrade"));
                    jobView.getSelector().add(new SelectorItemInfo("highJobGrade.name"));
                    jobView.getSelector().add(new SelectorItemInfo("highJobGrade.JobGradeModule"));
                    jobView.getSelector().add(new SelectorItemInfo("highJobGrade.JobGradeModule.name"));
                    jobView.getSelector().add(new SelectorItemInfo("highJobGrade.grade"));
                    jobView.getSelector().add(new SelectorItemInfo("lowJobGrade"));
                    jobView.getSelector().add(new SelectorItemInfo("lowJobGrade.name"));
                    jobView.getSelector().add(new SelectorItemInfo("lowJobGrade.JobGradeModule"));
                    jobView.getSelector().add(new SelectorItemInfo("lowJobGrade.JobGradeModule.name"));
                    jobView.getSelector().add(new SelectorItemInfo("lowJobGrade.grade"));
                    HRJobCollection jobCollection = iHrJob.getHRJobCollection(jobView);
                    if (jobCollection != null && jobCollection.size() > 0) {
                        highJobGrade = jobCollection.get(0).getHighJobGrade();
                        lowJobGrade = jobCollection.get(0).getLowJobGrade();
                    }
                }
                if (highJobGrade != null && lowJobGrade != null) {
                    if (lowJobGrade != null) {
                        filter = " grade >= " + lowJobGrade.getGrade();
                    }
                    if (highJobGrade != null) {
                        filter = StringUtils.isEmpty((CharSequence)filter) ? " grade <= " + highJobGrade.getGrade() : filter + " and grade <= " + highJobGrade.getGrade();
                    }
                    if (lowJobGrade.getJobGradeModule() != null && highJobGrade.getJobGradeModule() != null && lowJobGrade.getJobGradeModule().getId().toString().equalsIgnoreCase(highJobGrade.getJobGradeModule().getId().toString())) {
                        filter = StringUtils.isEmpty((CharSequence)filter) ? " jobGradeModule.id = '" + lowJobGrade.getJobGradeModule().getId() + "' " : filter + " and jobGradeModule.id = '" + lowJobGrade.getJobGradeModule().getId().toString() + "'";
                    }
                } else {
                    AdminOrgUnitInfo department = recuritmentDemand.getDepartment();
                    HROrgUnitInfo hrOrgUnit = OrgUnitUtil.getManageHrOrgUnit((Context)ctx, (String)"SGuJm3nXW0GshQfKRXenomWJ1dE=", (String)department.getId().toString());
                    if (hrOrgUnit != null) {
                        filter = " jobGradeModule.hrOrgUnit ='" + hrOrgUnit.getId().toString() + "' ";
                    }
                }
                Map<String, String> attributes = field.getAttributes();
                String uipk = attributes.get("uipk");
                String domain = RecUIViewUtil.getDomain(ctx, uipk);
                DomainParser parser = new DomainParser();
                HashMap param = new HashMap();
                FilterInfo domainFilter = parser.parseFilter(ctx, null, domain, param);
                String oql = "select id ,name where ";
                oql = StringUtils.isEmpty((CharSequence)filter) ? oql + domainFilter.toSql() : oql + filter + " and " + domainFilter.toSql();
                JobGradeCollection jobGradeCollection = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(oql);
                for (int i = 0; i < jobGradeCollection.size(); ++i) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("key", jobGradeCollection.get(i).getId());
                    hashMap.put("value", jobGradeCollection.get(i).getName());
                    arrayList.add(hashMap);
                }
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        element.setOptions(arrayList);
        element.setId(jobGradeInfo == null ? "" : String.valueOf(jobGradeInfo.getId()));
        logger.error("\u5904\u7406\u804c\u7b49\u9009\u9879:" + element);
        return element;
    }

    private static List<Object> getOptions(Context ctx, FieldInfo field) {
        ArrayList res = Lists.newArrayList();
        Map<String, String> attributes = field.getAttributes();
        String enumOptions = attributes.get("enumOptions");
        if (StringUtils.isNotEmpty((CharSequence)enumOptions)) {
            JSONArray array = JSONArray.parseArray((String)enumOptions);
            for (Object o : array) {
                JSONObject object = (JSONObject)o;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("key", object.get((Object)"value"));
                hashMap.put("value", object.get((Object)"alias"));
                res.add(hashMap);
            }
            return res;
        }
        String enumSource = attributes.get("enumSource");
        if (StringUtils.isEmpty((CharSequence)enumSource)) {
            enumSource = ((OwnPropertyInfo)field.getProperty()).getMetaDataRef();
        }
        try {
            BizEnumValueCollection enumValue;
            logger.error("get enumSource " + enumSource);
            PropertyInfo property = field.getProperty();
            BizEnumInfo bizEnumInfo = RecMetaUtil.getBizEnumInfo((Context)ctx, (PropertyInfo)property);
            if (bizEnumInfo != null && (enumValue = bizEnumInfo.getEnumValue()) != null && enumValue.size() > 0) {
                for (int i = 0; i < enumValue.size(); ++i) {
                    BizEnumValueInfo valueInfo = enumValue.get(i);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("key", valueInfo.getValue());
                    hashMap.put("value", valueInfo.getAlias());
                    res.add(hashMap);
                }
            }
            logger.error("get enumSource result" + res);
        }
        catch (Exception e) {
            logger.error("get " + enumSource + " error !!");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private static boolean getRequired(FieldInfo field) {
        Map<String, String> attributes = field.getAttributes();
        String required = attributes.get("required");
        return !StringUtils.isEmpty((CharSequence)required) && !"false".equalsIgnoreCase(required);
    }

    private static boolean getReadOnly(FieldInfo field) {
        Map<String, String> attributes = field.getAttributes();
        String readOnly = attributes.get("readonly");
        if (StringUtils.isEmpty((CharSequence)readOnly)) {
            readOnly = attributes.get("readOnly");
        }
        return StringUtils.isNotEmpty((CharSequence)readOnly) && "true".equalsIgnoreCase(readOnly);
    }

    private static Integer getFieldLength(FieldInfo field, Map<String, ColumnInfo> colMap) {
        String colName;
        Map<String, String> attributes = field.getAttributes();
        String length = attributes.get("maxlength");
        if (StringUtils.isEmpty((CharSequence)length)) {
            length = attributes.get("maxLength");
        }
        Integer uiviewLength = 0;
        if (StringUtils.isNotEmpty((CharSequence)length)) {
            try {
                uiviewLength = Integer.parseInt(length);
            }
            catch (Exception e) {
                logger.error("\u8f6c\u5b57\u6bb5\u957f\u5ea6\u51fa\u9519\uff01" + length, (Throwable)e);
            }
        }
        PropertyInfo propertyInfo = field.getProperty();
        String fieldName = field.getName();
        ColumnInfo columnInfo = null;
        if (propertyInfo != null) {
            columnInfo = propertyInfo.getMappingField();
        }
        if (columnInfo == null) {
            colName = "F" + fieldName.substring(0, 1).toUpperCase().concat(fieldName.substring(1));
            columnInfo = colMap.get(colName);
        }
        if (columnInfo == null) {
            colName = "CF" + fieldName.substring(0, 1).toUpperCase().concat(fieldName.substring(1));
            columnInfo = colMap.get(colName);
        }
        Integer tableLength = 0;
        if (columnInfo == null) {
            if (propertyInfo == null) {
                return 10;
            }
            if (propertyInfo instanceof OwnPropertyInfo) {
                tableLength = ((OwnPropertyInfo)propertyInfo).getLength();
            } else if (propertyInfo instanceof LinkPropertyInfo) {
                tableLength = 44;
            }
        } else {
            tableLength = columnInfo.getLength();
        }
        uiviewLength = uiviewLength == 0 ? tableLength : Integer.valueOf(Math.min(uiviewLength, tableLength));
        return uiviewLength;
    }

    public static String getFieldType(FieldInfo field) {
        DataType dataType = field.getDataType();
        if (dataType != null) {
            String dataTypeName = dataType.getName();
            String javaTypeName = dataType.getJavaTypeName();
            if (javaTypeName.equalsIgnoreCase("String")) {
                Map<String, String> attributes = field.getAttributes();
                String ctrl = attributes.get("ctrl");
                if (StringUtils.isNotEmpty((CharSequence)ctrl) && ("code".equalsIgnoreCase(ctrl) || "textarea".equalsIgnoreCase(ctrl))) {
                    return "LongText";
                }
                return "Text";
            }
            if (javaTypeName.equalsIgnoreCase("Enum") || dataTypeName.equalsIgnoreCase("Enum")) {
                return "Select";
            }
            if (dataTypeName.equalsIgnoreCase("TimeStamp") || dataTypeName.equalsIgnoreCase("Date") || dataTypeName.equalsIgnoreCase("Time") || StringUtils.isNotEmpty((CharSequence)javaTypeName) && javaTypeName.contains("Date")) {
                return dataTypeName;
            }
            if (javaTypeName.equalsIgnoreCase("Boolean") || dataTypeName.equalsIgnoreCase("Boolean")) {
                return "Boolean";
            }
            if (dataTypeName.equalsIgnoreCase("BigDecimal") || javaTypeName.equalsIgnoreCase("Double") || dataTypeName.equalsIgnoreCase("Integer") || javaTypeName.equalsIgnoreCase("int")) {
                return "Number";
            }
        } else {
            logger.error("field has no dataType:" + field.getName());
        }
        return "Text";
    }

    public static List<InterviewStructureData> doSetInterForm(Context ctx, CoreBaseCollection coreBaseCollection, List<FieldInfo> detailFields, Map<String, ColumnInfo> colMap, List<FieldInfo> groups, int value) {
        detailFields = InterGOUtil.processRepeatField(detailFields, groups);
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < coreBaseCollection.size(); ++i) {
            IPInterviewStructureDetailEvaluateInfo info = (IPInterviewStructureDetailEvaluateInfo)coreBaseCollection.get(i);
            ArrayList<InterviewStructureGroupData> list = new ArrayList<InterviewStructureGroupData>();
            InterviewStructureGroupData base = InterGOUtil.processBaseEvaludate(ctx, info, value, detailFields, colMap);
            list.add(base);
            list.addAll(InterGOUtil.processEvaluateGroup(ctx, groups, colMap, info));
            InterviewStructureData interviewStructureData = new InterviewStructureData();
            interviewStructureData.setGroupData(list);
            interviewStructureData.setStruClass("evaluate");
            interviewStructureData.setStruName("\u9762\u8bd5\u8bc4\u4ef7\u8868");
            interviewStructureData.setSaveState(info.getSaveState());
            interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailEvaluate.form");
            interviewStructureData.setFileName(info.getFileName());
            interviewStructureData.setBillid(info.getId().toString());
            res.add(interviewStructureData);
            if (info.getSaveState() == 1) break;
        }
        return res;
    }

    private static List<InterviewStructureGroupData> processEvaluateGroup(Context ctx, List<FieldInfo> groups, Map<String, ColumnInfo> colMap, IPInterviewStructureDetailEvaluateInfo info) {
        ArrayList list = Lists.newArrayList();
        for (FieldInfo group : groups) {
            List<FieldInfo> fields;
            InterviewStructureGroupData groupData = new InterviewStructureGroupData();
            list.add(groupData);
            String groupName = group.getName();
            groupData.setGroupClass(groupName);
            groupData.setGroupName(group.getAlias());
            ArrayList data = Lists.newArrayList();
            groupData.setData((List)data);
            Map<String, String> attributes = group.getAttributes();
            String percentage = attributes.get("percentage");
            String groupPer = null;
            if (StringUtils.isNotEmpty((CharSequence)percentage)) {
                groupPer = groupName.equalsIgnoreCase("fullQuality") ? groupName + "Per" : groupName + "Percentage";
            }
            if ((fields = group.getFields()) == null || fields.size() <= 0) continue;
            for (FieldInfo field : fields) {
                if (InterGOUtil.skipField(field)) continue;
                InterviewStructureElement element = InterGOUtil.processSpecialElement(ctx, field, info.getInterviewPlanId(), (CoreBaseInfo)info);
                if (element == null) {
                    String name = field.getName();
                    element = new InterviewStructureElement();
                    if (name.equalsIgnoreCase(groupPer)) {
                        element.setValue((Object)percentage);
                        element.setColName(groupPer);
                        element.setShowName("\u5360\u6bd4");
                        element.setFieldType("Text");
                        element.setReadOnly(true);
                        element.setNoPass(true);
                    } else {
                        element = InterGOUtil.getCommonElement(ctx, (CoreBaseInfo)info, field, colMap);
                    }
                }
                data.add(element);
            }
        }
        return list;
    }

    private static InterviewStructureGroupData processBaseEvaludate(Context ctx, IPInterviewStructureDetailEvaluateInfo info, Integer value, List<FieldInfo> detailFields, Map<String, ColumnInfo> colMap) {
        InterviewStructureGroupData base = new InterviewStructureGroupData();
        base.setGroupClass("base");
        base.setGroupName("\u57fa\u7840\u4fe1\u606f");
        ArrayList baseElement = Lists.newArrayList();
        base.setData((List)baseElement);
        for (FieldInfo field : detailFields) {
            if (InterGOUtil.skipField(field)) continue;
            InterviewStructureElement element = InterGOUtil.processSpecialElement(ctx, field, info.getInterviewPlanId(), (CoreBaseInfo)info);
            if (element == null) {
                element = InterGOUtil.getCommonElement(ctx, (CoreBaseInfo)info, field, colMap);
            }
            baseElement.add(element);
        }
        if (value != null) {
            baseElement.add(InterGOUtil.countElement(value));
        }
        return base;
    }

    private static InterviewStructureElement countElement(int value) {
        InterviewStructureElement countScoreElement = new InterviewStructureElement((Object)value, "countScore", "\u5206\u6570\u7edf\u8ba1", null, "Select", true, false);
        HashMap<String, Object> hashMapResult = new HashMap<String, Object>();
        HashMap<String, Object> hashMapResult1 = new HashMap<String, Object>();
        hashMapResult.put("key", 0);
        hashMapResult.put("value", "\u8bb0\u603b\u5206");
        hashMapResult1.put("key", 1);
        hashMapResult1.put("value", "\u8bb0\u5e73\u5747\u5206");
        ArrayList<HashMap<String, Object>> arrayListResult = new ArrayList<HashMap<String, Object>>();
        arrayListResult.add(hashMapResult);
        arrayListResult.add(hashMapResult1);
        countScoreElement.setOptions(arrayListResult);
        return countScoreElement;
    }

    private static String getAssociatedField(FieldInfo field) {
        Map<String, String> attributes = field.getAttributes();
        String res = null;
        if (attributes.containsKey("associatedField")) {
            res = attributes.get("associatedField");
        }
        return res;
    }

    private static List<FieldInfo> processRepeatField(List<FieldInfo> detailFields, List<FieldInfo> groups) {
        ArrayList groupFieldNames = Lists.newArrayList();
        if (CollectionUtils.isEmpty(groups)) {
            return detailFields;
        }
        for (FieldInfo group : groups) {
            List<FieldInfo> fields = group.getFields();
            if (fields == null || fields.size() <= 0) continue;
            for (FieldInfo field : fields) {
                String fieldName = field.getName();
                if (groupFieldNames.contains(fieldName)) continue;
                groupFieldNames.add(fieldName);
            }
        }
        ArrayList res = Lists.newArrayList();
        for (FieldInfo detailField : detailFields) {
            String fieldName = detailField.getName();
            if (groupFieldNames.contains(fieldName)) continue;
            res.add(detailField);
        }
        return res;
    }

    public static List<InterviewStructureData> doSetWriteExam(Context ctx, CoreBaseInfo coreBaseInfo, List<FieldInfo> detailFields, Map<String, ColumnInfo> colMap) {
        ArrayList res = Lists.newArrayList();
        IPInterviewStructureDetailWriteInfo info = (IPInterviewStructureDetailWriteInfo)coreBaseInfo;
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        List<Object> list = InterGOUtil.processElement(ctx, (CoreBaseInfo)info, detailFields, colMap, info.getInterviewPlanId());
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(list, "base", "");
        ArrayList<InterviewStructureGroupData> groupData = new ArrayList<InterviewStructureGroupData>();
        groupData.add(baseGroupData);
        interviewStructureData.setGroupData(groupData);
        interviewStructureData.setStruClass("write");
        interviewStructureData.setStruName("\u7b14\u8bd5");
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailWrite.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        res.add(interviewStructureData);
        return res;
    }

    public static List<InterviewStructureData> doSetQualityEvaluation(Context ctx, CoreBaseInfo coreBaseInfo, List<FieldInfo> detailFields, Map<String, ColumnInfo> colMap) {
        ArrayList res = Lists.newArrayList();
        IPInterviewStructureDetailDiathesisInfo info = (IPInterviewStructureDetailDiathesisInfo)coreBaseInfo;
        InterviewStructureData interviewStructureData = new InterviewStructureData();
        List<Object> list = InterGOUtil.processElement(ctx, (CoreBaseInfo)info, detailFields, colMap, info.getInterviewPlanId());
        InterviewStructureGroupData baseGroupData = new InterviewStructureGroupData(list, "base", "");
        ArrayList<InterviewStructureGroupData> groupData = new ArrayList<InterviewStructureGroupData>();
        groupData.add(baseGroupData);
        interviewStructureData.setGroupData(groupData);
        interviewStructureData.setStruClass("diathesis");
        interviewStructureData.setStruName("\u7d20\u8d28\u6d4b\u8bc4");
        interviewStructureData.setSaveState(info.getSaveState());
        interviewStructureData.setUipk("com.kingdee.shr.recuritment.app.IPInterviewStructureDetailDiathesis.form");
        interviewStructureData.setFileName(info.getFileName());
        interviewStructureData.setBillid(info.getId().toString());
        res.add(interviewStructureData);
        return res;
    }

    public static List<InterviewStructureData> doSetOther(Context ctx, CoreBaseCollection coreBaseCollection, List<FieldInfo> detailFields, Map<String, ColumnInfo> colMap, List<FieldInfo> groups, UIViewInfo uiViewInfo) {
        if (coreBaseCollection.size() == 0) {
            return null;
        }
        detailFields = InterGOUtil.processRepeatField(detailFields, groups);
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < coreBaseCollection.size(); ++i) {
            CoreBaseInfo info = coreBaseCollection.get(i);
            ArrayList<InterviewStructureGroupData> list = new ArrayList<InterviewStructureGroupData>();
            InterviewStructureGroupData base = InterGOUtil.processBaseGroup(ctx, info, detailFields, colMap);
            list.add(base);
            list.addAll(InterGOUtil.processGroups(ctx, groups, colMap, info));
            InterviewStructureData interviewStructureData = new InterviewStructureData();
            interviewStructureData.setGroupData(list);
            interviewStructureData.setStruClass(uiViewInfo.getModel());
            interviewStructureData.setStruName(uiViewInfo.getName());
            interviewStructureData.setUipk(uiViewInfo.getUipk());
            interviewStructureData.setBillid(info.getId().toString());
            res.add(interviewStructureData);
        }
        return res;
    }

    private static InterviewStructureGroupData processBaseGroup(Context ctx, CoreBaseInfo info, List<FieldInfo> detailFields, Map<String, ColumnInfo> colMap) {
        InterviewStructureGroupData base = new InterviewStructureGroupData();
        base.setGroupClass("base");
        base.setGroupName("\u57fa\u7840\u4fe1\u606f");
        ArrayList baseElement = Lists.newArrayList();
        base.setData((List)baseElement);
        String interviewPlanId = "";
        Object o = info.get("interviewPlanId");
        if (null != o) {
            interviewPlanId = o.toString();
        }
        for (FieldInfo field : detailFields) {
            if (InterGOUtil.skipField(field)) continue;
            InterviewStructureElement element = InterGOUtil.processSpecialElement(ctx, field, interviewPlanId, info);
            if (element == null) {
                element = InterGOUtil.getCommonElement(ctx, info, field, colMap);
            }
            baseElement.add(element);
        }
        return base;
    }

    private static boolean skipField(FieldInfo field) {
        Map<String, String> attributes = field.getAttributes();
        if (attributes == null || attributes.size() == 0) {
            return false;
        }
        if (field.getType() != null && "hidden".equalsIgnoreCase(field.getType())) {
            return true;
        }
        String type = attributes.get("type");
        if (StringUtils.isNotEmpty((CharSequence)type) && "hidden".equalsIgnoreCase(type)) {
            return true;
        }
        String visible = attributes.get("visible");
        return StringUtils.isNotEmpty((CharSequence)visible) && "false".equalsIgnoreCase(visible);
    }

    private static List<InterviewStructureGroupData> processGroups(Context ctx, List<FieldInfo> groups, Map<String, ColumnInfo> colMap, CoreBaseInfo info) {
        ArrayList list = Lists.newArrayList();
        for (FieldInfo group : groups) {
            InterviewStructureGroupData groupData = new InterviewStructureGroupData();
            list.add(groupData);
            String groupName = group.getName();
            groupData.setGroupClass(groupName);
            groupData.setGroupName(group.getAlias());
            ArrayList data = Lists.newArrayList();
            groupData.setData((List)data);
            List<FieldInfo> fields = group.getFields();
            String interviewPlanId = "";
            Object o = info.get("interviewPlanId");
            if (null != o) {
                interviewPlanId = o.toString();
            }
            if (fields == null || fields.size() <= 0) continue;
            for (FieldInfo field : fields) {
                if (InterGOUtil.skipField(field)) continue;
                InterviewStructureElement element = InterGOUtil.processSpecialElement(ctx, field, interviewPlanId, info);
                if (element == null) {
                    element = InterGOUtil.getCommonElement(ctx, info, field, colMap);
                }
                data.add(element);
            }
        }
        return list;
    }
}

