/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.shr.base.syssetting.util.CloudHubUtil;
import com.kingdee.shr.recuritment.utils.RecCacheUtil;
import com.kingdee.shr.recuritment.utils.RecSettingUtil;
import com.kingdee.util.ConfigurationItem;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecCloudHubUtil {
    public static final String talentRec = "talentRec";
    public static final String talentRecEmpSelf = "talentRecEmpSelf";
    public static final String interviewGo = "interGo";
    private static final String APP_SECRET = "appsecret";
    private static final String DEFAULT_APP_SECRET = "7d62753e3bd2040fe2f23f5b19f9a972";
    private static final String TIME_HELPER_SECRET = "secret";
    private static final String APP_ID = "appId";
    private static final String STORE_ID = "storeEid";
    private static final String DB_EID = "dbEid";
    private static final String DEFAULT_APP_ID = "10738";
    private static final String DEFAULT_STORE_EID = "4000148";
    private static final String CLOUD_HUB_SERVER = "CloudHubServerUrl";
    private static final String DEFAULT_CLOUD_HUB_SERVER = "http://mbos.kdeascloud.com/mbos/page/loadPage?";
    private static final String CLOUD_HUB_APP_VERSION = "CloudHubAppVersion";
    private static final String DEFAULT_CLOUD_HUB_APP_VERSION = "88sp1";
    private static Logger logger = LoggerFactory.getLogger(RecCloudHubUtil.class);

    public static String getCloudHubEid(Context ctx) {
        String eid = RecCacheUtil.getString("eid");
        if (StringUtils.isEmpty((CharSequence)eid)) {
            try {
                eid = CloudHubUtil.getIntegrationEid((Context)ctx);
            }
            catch (BOSException e) {
                logger.error("\u672a\u96c6\u6210\u4e91\u4e4b\u5bb6");
            }
            if (StringUtils.isNotEmpty((CharSequence)eid)) {
                RecCacheUtil.put("eid", eid);
            }
        }
        return eid;
    }

    public static String getAppId(String eid, String pubAcctName) {
        String key = RecCloudHubUtil.getCacheKey(pubAcctName, APP_ID);
        String appId = RecCacheUtil.getString(key);
        if (StringUtils.isEmpty((CharSequence)appId)) {
            String path;
            XTServiceConfig xtServiceConfig = XTServiceConfig.getInstance();
            ConfigurationItem item = xtServiceConfig.getConfigurationItemByPath(path = "PubAcct/" + eid + "/" + pubAcctName);
            if (item == null) {
                appId = DEFAULT_APP_ID;
            } else {
                String appid = item.getProperty("appid");
                String string = appId = StringUtils.isEmpty((CharSequence)appid) ? DEFAULT_APP_ID : appid;
            }
            if (StringUtils.isNotEmpty((CharSequence)appId)) {
                RecCacheUtil.put(key, appId);
            }
        }
        return appId;
    }

    private static String getCacheKey(String pubAcctName, String suffix) {
        String res = null;
        if (StringUtils.isNotEmpty((CharSequence)pubAcctName)) {
            if (interviewGo.equalsIgnoreCase(pubAcctName)) {
                res = interviewGo + suffix;
            } else if (talentRec.equalsIgnoreCase(pubAcctName)) {
                res = talentRec + suffix;
            } else if (talentRecEmpSelf.equalsIgnoreCase(pubAcctName)) {
                res = talentRecEmpSelf + suffix;
            }
        }
        return res;
    }

    public static String getStoreEid(String eid, String pubAcctName) {
        String path;
        XTServiceConfig xtServiceConfig;
        ConfigurationItem item;
        String key = RecCloudHubUtil.getCacheKey(pubAcctName, STORE_ID);
        String storeEid = RecCacheUtil.getString(key);
        if (StringUtils.isEmpty((CharSequence)storeEid) && StringUtils.isNotEmpty((CharSequence)(storeEid = (item = (xtServiceConfig = XTServiceConfig.getInstance()).getConfigurationItemByPath(path = "PubAcct/" + eid + "/" + pubAcctName)) == null ? "" : item.getProperty(STORE_ID)))) {
            RecCacheUtil.put(key, storeEid);
        }
        return StringUtils.isNotEmpty((CharSequence)storeEid) ? storeEid : DEFAULT_STORE_EID;
    }

    public static String getDbInfoEid() {
        String key = DB_EID;
        String dbEid = RecCacheUtil.getString(key);
        if (StringUtils.isEmpty((CharSequence)dbEid)) {
            try {
                ConfigurationItem item;
                ConfigurationItem ct = XTServiceConfig.getInstance().getConfigurationItemByPath("DbInfo");
                List cl = ct.getAllChildren();
                if (cl.size() > 0 && StringUtils.isNotEmpty((CharSequence)(dbEid = (item = (ConfigurationItem)cl.get(0)).getName()))) {
                    RecCacheUtil.put(key, dbEid);
                }
            }
            catch (Exception e) {
                logger.error("cann't find the properties:DbMap");
            }
        }
        return dbEid;
    }

    public static String getCloudHubServerUrl(Context ctx) {
        try {
            String cloudHubServerUrl = RecSettingUtil.getByKey(ctx, CLOUD_HUB_SERVER);
            if (StringUtils.isNotEmpty((CharSequence)cloudHubServerUrl)) {
                return cloudHubServerUrl;
            }
        }
        catch (Exception e) {
            logger.error("\u62db\u8058\u540e\u53f0\u914d\u7f6e---\u4e91\u4e4b\u5bb6\u670d\u52a1\u5730\u5740\u914d\u7f6e\u9519\u8bef");
        }
        return DEFAULT_CLOUD_HUB_SERVER;
    }

    public static String getCloudHubAppVersion(Context ctx) {
        try {
            String version = RecSettingUtil.getByKey(ctx, CLOUD_HUB_APP_VERSION);
            if (StringUtils.isNotEmpty((CharSequence)version)) {
                return version;
            }
        }
        catch (Exception e) {
            logger.error("\u62db\u8058\u540e\u53f0\u914d\u7f6e---\u4e91\u4e4b\u5bb6\u8f7b\u5e94\u7528\u7248\u672c\u914d\u7f6e\u9519\u8bef");
        }
        return DEFAULT_CLOUD_HUB_APP_VERSION;
    }

    public static boolean isPrivateServer() {
        Map xtInfoMap = XTServiceConfig.getInstance().getXTInfoProperties();
        String serverUrl = (String)xtInfoMap.get("xt.pubacct.private.server.url");
        return !StringUtils.isEmpty((CharSequence)serverUrl);
    }

    public static String getTimeHelperSecret(String eid, String pubAcctName) {
        String key = RecCloudHubUtil.getCacheKey(pubAcctName, TIME_HELPER_SECRET);
        String secret = RecCacheUtil.getString(key);
        if (StringUtils.isEmpty((CharSequence)secret)) {
            String path = "PubAcct/" + eid + "/" + pubAcctName;
            ConfigurationItem item = XTServiceConfig.getInstance().getConfigurationItemByPath(path);
            if (item != null && StringUtils.isNotEmpty((CharSequence)(secret = item.getProperty(TIME_HELPER_SECRET)))) {
                RecCacheUtil.put(key, secret);
            }
        }
        return secret;
    }

    public static String getAppSecret(String eid, String pubAcctName) {
        String key = RecCloudHubUtil.getCacheKey(pubAcctName, APP_SECRET);
        String secret = RecCacheUtil.getString(key);
        if (StringUtils.isEmpty((CharSequence)secret)) {
            String path = "PubAcct/" + eid + "/" + pubAcctName;
            ConfigurationItem item = XTServiceConfig.getInstance().getConfigurationItemByPath(path);
            if (item != null && StringUtils.isNotEmpty((CharSequence)(secret = item.getProperty(APP_SECRET)))) {
                RecCacheUtil.put(key, secret);
            }
        }
        return StringUtils.isNotEmpty((CharSequence)secret) ? secret : DEFAULT_APP_SECRET;
    }

    public static String getServerUrl() {
        String defaultSerVerUrl = "https://www.yunzhijia.com";
        Map xtInfoMap = XTServiceConfig.getInstance().getXTInfoProperties();
        String serverUrl = (String)xtInfoMap.get("xt.pubacct.private.server.url");
        if (!StringUtils.isEmpty((CharSequence)serverUrl)) {
            return serverUrl;
        }
        return defaultSerVerUrl;
    }
}

