/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.utils;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecMetaUtil
extends BaseMetaDataUtil {
    private static Logger logger = LoggerFactory.getLogger(RecMetaUtil.class);
    private static Map<String, Map<String, PropertyInfo>> metaPropertyMap = Maps.newHashMap();

    public static Map<String, Integer> getFieldLength(Context ctx, BOSObjectType bosType) {
        if (bosType == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        DataTableInfo dataTableInfo = objectInfo.getTable();
        ColumnCollection columnCollection = dataTableInfo.getColumns();
        for (int j = 0; j < columnCollection.size(); ++j) {
            ColumnInfo columnInfo = columnCollection.get(j);
            result.put(columnInfo.getName(), columnInfo.getLength());
        }
        return result;
    }

    public static Map<String, ColumnInfo> getFieldMap(Context ctx, BOSObjectType bosType) {
        if (bosType == null) {
            return null;
        }
        HashMap result = Maps.newHashMap();
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        DataTableInfo dataTableInfo = objectInfo.getTable();
        ColumnCollection columnCollection = dataTableInfo.getColumns();
        for (int j = 0; j < columnCollection.size(); ++j) {
            ColumnInfo columnInfo = columnCollection.get(j);
            result.put(columnInfo.getName(), columnInfo);
        }
        return result;
    }

    public static String validateFieldLength(Map<String, PropertyInfo> propertyInfoMap, Map<String, Integer> colMap, CoreBaseInfo info) {
        if (propertyInfoMap == null || propertyInfoMap.size() == 0) {
            return "\u5143\u6570\u636e\u4e3a\u7a7a";
        }
        if (colMap == null || colMap.size() == 0) {
            return "\u8868\u5c5e\u6027\u4e3a\u7a7a";
        }
        if (info == null) {
            return "\u5bf9\u8c61\u4e3a\u7a7a";
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (Map.Entry<String, PropertyInfo> entry : propertyInfoMap.entrySet()) {
                String colName;
                Integer maxLength;
                DataType dataType;
                String typeName;
                PropertyInfo value;
                Object o = info.get(entry.getKey());
                if (o == null || !((value = entry.getValue()) instanceof OwnPropertyInfo) || !"String".equalsIgnoreCase(typeName = (dataType = ((OwnPropertyInfo)value).getDataType()).getJavaTypeName()) || (maxLength = colMap.get(colName = value.getMappingField().getName())) >= o.toString().length()) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(entry.getKey() + "\u503c\uff1a" + o.toString() + " \u957f\u5ea6\u8d85\u8fc7\u9650\u5236" + maxLength);
            }
        }
        catch (Exception e) {
            logger.error("validate entity error:" + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public static String validateFieldLength(Map<String, PropertyInfo> propertyInfoMap, Map<String, Integer> colMap, IObjectCollection info) {
        if (propertyInfoMap == null || propertyInfoMap.size() == 0) {
            return "\u5143\u6570\u636e\u4e3a\u7a7a";
        }
        if (colMap == null || colMap.size() == 0) {
            return "\u8868\u5c5e\u6027\u4e3a\u7a7a";
        }
        if (info == null || info.size() == 0) {
            return "\u5bf9\u8c61\u4e3a\u7a7a";
        }
        StringBuffer sb = new StringBuffer();
        for (Object next : info) {
            sb.append(RecMetaUtil.validateFieldLength(propertyInfoMap, colMap, (CoreBaseInfo)next));
        }
        return sb.toString();
    }

    public static String validateCollection(Context ctx, CoreBaseCollection baseCollection) throws BOSException {
        if (baseCollection == null || baseCollection.size() == 0) {
            return null;
        }
        CoreBaseInfo coreBaseInfo = baseCollection.get(0);
        Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, coreBaseInfo);
        Map<String, Integer> result = RecMetaUtil.getFieldLength(ctx, coreBaseInfo.getBOSType());
        return RecMetaUtil.validateFieldLength(propertyMap, result, (IObjectCollection)baseCollection);
    }

    public static String validateEntity(Context ctx, CoreBaseInfo coreBaseInfo) throws BOSException {
        if (coreBaseInfo == null) {
            return null;
        }
        Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(ctx, coreBaseInfo);
        Map<String, Integer> result = RecMetaUtil.getFieldLength(ctx, coreBaseInfo.getBOSType());
        return RecMetaUtil.validateFieldLength(propertyMap, result, coreBaseInfo);
    }

    public static Map<String, PropertyInfo> getMetaProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return null;
        }
        if (metaPropertyMap.containsKey(entityName)) {
            return metaPropertyMap.get(entityName);
        }
        EntityObjectInfo entityObjectInfo = RecMetaUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
        Map<String, PropertyInfo> propertyMap = RecMetaUtil.getPropertyMap(entityObjectInfo);
        metaPropertyMap.put(entityName, propertyMap);
        return propertyMap;
    }

    public static Map<String, PropertyInfo> getPropertyMap(Context ctx, CoreBaseInfo coreBaseInfo) {
        if (coreBaseInfo == null || coreBaseInfo.getBOSType() == null) {
            return null;
        }
        String bosType = coreBaseInfo.getBOSType().toString();
        if (metaPropertyMap.containsKey(bosType)) {
            return metaPropertyMap.get(bosType);
        }
        Map propertyMap = RecMetaUtil.getProperties((Context)ctx, (BOSObjectType)coreBaseInfo.getBOSType());
        metaPropertyMap.put(bosType, propertyMap);
        return propertyMap;
    }

    private static Map<String, PropertyInfo> getPropertyMap(EntityObjectInfo entityObjectInfo) {
        PropertyCollection collection = entityObjectInfo.getPropertiesRuntime();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            map.put(propertyInfo.getName(), propertyInfo);
        }
        return map;
    }

    public static CoreBaseInfo getDynValueClass(Context ctx, String entityFullName) throws BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo eoInfo = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entityFullName));
        String valueClassName = eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(null);
            info = (CoreBaseInfo)cst.newInstance(null);
            if (info instanceof DataBaseCustomInfo) {
                ((DataBaseCustomInfo)info).setBOSType(eoInfo.getType());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return info;
    }
}

