/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewExtCollection;
import com.kingdee.shr.base.syssetting.UIViewExtFactory;
import com.kingdee.shr.base.syssetting.UIViewExtInfo;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.recuritment.app.util.XmlUtil;
import com.kingdee.shr.recuritment.utils.RecMetaUtil;
import com.kingdee.shr.recuritment.vo.FieldInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecUIViewUtil {
    private static Logger logger = LoggerFactory.getLogger(RecUIViewUtil.class);
    private static final String EMPTY_STRING = "";
    private Context ctx;

    public static UIViewInfo getUIViewFromDB(Context ctx, String uipk) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("extend"));
        sic.add(new SelectorItemInfo("uipk"));
        try {
            UIViewExtCollection collection;
            UIViewInfo viewInfo = UIViewFactory.getLocalInstance((Context)ctx).getValueByUipk(uipk, sic);
            if (viewInfo != null && (collection = UIViewExtFactory.getLocalInstance((Context)ctx).getUIViewExtCollection("where uipk ='" + uipk + "'")).size() > 0) {
                UIViewExtInfo uiViewExtInfo = collection.get(0);
                viewInfo.setExtend(uiViewExtInfo.getContent());
            }
            return viewInfo;
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static UIViewCollection getUIViewFromDB(Context ctx, Set<String> uipks) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("extend"));
        sic.add(new SelectorItemInfo("uipk"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("uipk", uipks, CompareType.INCLUDE));
        try {
            return UIViewFactory.getLocalInstance((Context)ctx).getUIViewCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static UIViewCollection getUIViewFromDB(Context ctx, Set<String> uipks, SelectorItemCollection sic) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("uipk", uipks, CompareType.INCLUDE));
        try {
            return UIViewFactory.getLocalInstance((Context)ctx).getUIViewCollection(viewInfo);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<FieldInfo> getFields(Context ctx, UIViewInfo viewInfo) throws BOSException {
        Document doc = StringUtils.isNotEmpty((CharSequence)viewInfo.getExtend()) ? XmlUtil.parseXML((String)viewInfo.getExtend()) : XmlUtil.parseXML((String)viewInfo.getContent());
        Element root = doc.getRootElement();
        if (root == null || root.getChildren() == null) {
            return null;
        }
        List children = root.getChildren();
        String entityName = viewInfo.getModel();
        Map<String, PropertyInfo> properties = RecMetaUtil.getMetaProperties(ctx, entityName);
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Element element = null;
        String elementName = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            elementName = element.getName();
            if (("list".equalsIgnoreCase(elementName) || "grid".equalsIgnoreCase(elementName)) && "form".equals(viewInfo.getType())) continue;
            if ("field".equalsIgnoreCase(elementName) || "fieldValue".equalsIgnoreCase(elementName)) {
                FieldInfo f = RecUIViewUtil.assembleFieldInfo(ctx, element, entityName, properties, viewInfo);
                if (null == f) continue;
                fields.add(f);
                continue;
            }
            if ("editGrid".equalsIgnoreCase(elementName)) continue;
            if (element.getChildren() != null && element.getChildren().size() > 0) {
                fields.addAll(RecUIViewUtil.getFields(ctx, element, viewInfo));
                continue;
            }
            if (!"group".equalsIgnoreCase(elementName)) continue;
            fields.addAll(RecUIViewUtil.getFields(ctx, element, viewInfo));
        }
        return fields;
    }

    private static List<FieldInfo> getFields(Context ctx, Element root, UIViewInfo viewInfo) {
        if (root == null || root.getChildren() == null) {
            return null;
        }
        List children = root.getChildren();
        String entityName = viewInfo.getModel();
        Map<String, PropertyInfo> properties = RecMetaUtil.getMetaProperties(ctx, entityName);
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        Element element = null;
        String elementName = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            elementName = element.getName();
            if (("list".equalsIgnoreCase(elementName) || "grid".equalsIgnoreCase(elementName)) && "form".equals(viewInfo.getType())) continue;
            if ("input".equalsIgnoreCase(elementName)) {
                Element parent = element.getParentElement();
                parent.setAttribute("percentage", element.getAttributeValue("value"));
            }
            if ("field".equalsIgnoreCase(elementName) || "fieldValue".equalsIgnoreCase(elementName)) {
                FieldInfo f = RecUIViewUtil.assembleFieldInfo(ctx, element, entityName, properties, viewInfo);
                if (null == f) continue;
                fields.add(f);
                continue;
            }
            if (element.getChildren() == null || element.getChildren().size() <= 0) continue;
            fields.addAll(RecUIViewUtil.getFields(ctx, element, viewInfo));
        }
        return fields;
    }

    private static PropertyInfo getPropertyInfo(Map<String, PropertyInfo> properties, String name) {
        for (Map.Entry<String, PropertyInfo> e : properties.entrySet()) {
            if (!name.equalsIgnoreCase(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public static FieldInfo assembleFieldInfo(Context ctx, Element element, String entityName, Map<String, PropertyInfo> properties, UIViewInfo viewInfo) {
        String _sortable_;
        String defaultValueExpression;
        String defaultValue;
        String name = element.getAttributeValue("name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        PropertyInfo propertyInfo = null;
        if (!StringUtils.isEmpty((CharSequence)entityName)) {
            if (name.contains(".")) {
                propertyInfo = RecMetaUtil.getPropertyInfo((Context)ctx, (String)entityName, (String)name);
            } else if (properties != null && null == (propertyInfo = properties.get(name))) {
                propertyInfo = RecUIViewUtil.getPropertyInfo(properties, name);
            }
        }
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setName(name);
        fieldInfo.setProperty(propertyInfo);
        String label = element.getAttributeValue("label");
        if (StringUtils.isEmpty((CharSequence)label) && propertyInfo != null) {
            label = propertyInfo.getAlias();
        }
        if (StringUtils.isEmpty((CharSequence)label)) {
            label = name;
        }
        fieldInfo.setAlias(label);
        String formatter = element.getAttributeValue("formatter");
        if (StringUtils.isEmpty((CharSequence)formatter)) {
            formatter = EMPTY_STRING;
        }
        fieldInfo.setFormatter(formatter);
        String formatoptions = element.getAttributeValue("formatoptions");
        if (StringUtils.isEmpty((CharSequence)formatoptions)) {
            formatoptions = EMPTY_STRING;
        }
        fieldInfo.setFormatoptions(formatoptions);
        String schemeField = element.getAttributeValue("schemeField");
        if (StringUtils.isEmpty((CharSequence)schemeField)) {
            formatter = EMPTY_STRING;
        }
        fieldInfo.setSchemeField(schemeField);
        RecUIViewUtil.setDataType(element, fieldInfo, viewInfo, propertyInfo);
        String type = element.getAttributeValue("type");
        if (!StringUtils.isEmpty((CharSequence)type)) {
            fieldInfo.setType(type);
        }
        if (!StringUtils.isEmpty((CharSequence)(defaultValue = element.getAttributeValue("defaultValue")))) {
            fieldInfo.setDefaultValue(defaultValue);
        }
        if (!StringUtils.isEmpty((CharSequence)(defaultValueExpression = element.getAttributeValue("defaultValueExpression")))) {
            fieldInfo.setDefaultValueExpression(defaultValueExpression);
        }
        if ("false".equals(_sortable_ = element.getAttributeValue("sortable"))) {
            fieldInfo.setSortable(false);
        }
        RecUIViewUtil.initFieldAttribute(element, fieldInfo);
        return fieldInfo;
    }

    private static void initFieldAttribute(Element element, FieldInfo fieldInfo) {
        List attrs = element.getAttributes();
        if (null == attrs || attrs.size() <= 0) {
            return;
        }
        HashMap<String, String> attributes = new HashMap<String, String>(attrs.size());
        for (Attribute attr : attrs) {
            attributes.put(attr.getName(), attr.getValue());
        }
        fieldInfo.setAttributes(attributes);
    }

    private static void setDataType(Element element, FieldInfo fieldInfo, UIViewInfo viewInfo, PropertyInfo propertyInfo) {
        String dataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((CharSequence)dataType)) {
            fieldInfo.setDataType(dataType);
        } else if (propertyInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
            fieldInfo.setDataType(ownPropertyInfo.getDataType().getName());
        } else if (propertyInfo instanceof LinkPropertyInfo) {
            RelationshipType relationshipType = ((LinkPropertyInfo)propertyInfo).getRelationship().getType();
            if (RelationshipType.COMPOSITION.equals((Object)relationshipType)) {
                fieldInfo.setDataType(DataType.OBJECTCOLLECTION.getName());
            } else {
                fieldInfo.setDataType(DataType.OBJECTVALUE.getName());
            }
        }
    }

    public static List<String> getFieldNames(List<FieldInfo> fields) {
        ArrayList res = Lists.newArrayList();
        if (fields != null) {
            for (FieldInfo field : fields) {
                if (res.contains(field.getName())) continue;
                res.add(field.getName());
            }
            return res;
        }
        return res;
    }

    public static List<FieldInfo> getGroups(Context ctx, UIViewInfo viewInfo) throws BOSException {
        Document doc = StringUtils.isNotEmpty((CharSequence)viewInfo.getExtend()) ? XmlUtil.parseXML((String)viewInfo.getExtend()) : XmlUtil.parseXML((String)viewInfo.getContent());
        Element root = doc.getRootElement();
        if (root == null || root.getChildren() == null) {
            return null;
        }
        List children = root.getChildren();
        List<Object> fields = Lists.newArrayList();
        Element element = null;
        String elementName = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            elementName = element.getName();
            if ("header".equalsIgnoreCase(elementName)) continue;
            fields = RecUIViewUtil.getGroupElement(ctx, element.getChildren(), viewInfo);
        }
        return fields;
    }

    private static List<FieldInfo> getGroupElement(Context ctx, List children, UIViewInfo viewInfo) {
        ArrayList res = Lists.newArrayList();
        if (children == null || children.size() == 0) {
            return res;
        }
        for (Object child : children) {
            Element element = (Element)child;
            String elementName = element.getName();
            if (elementName.equalsIgnoreCase("group")) {
                FieldInfo group = new FieldInfo();
                group.setName(element.getAttributeValue("name"));
                group.setAlias(element.getAttributeValue("caption"));
                group.setFields(RecUIViewUtil.getFields(ctx, element, viewInfo));
                if (StringUtils.isNotEmpty((CharSequence)element.getAttributeValue("percentage"))) {
                    HashMap attributes = group.getAttributes();
                    if (attributes.size() == 0) {
                        attributes = Maps.newHashMap();
                    }
                    attributes.put("percentage", element.getAttributeValue("percentage"));
                    group.setAttributes(attributes);
                }
                res.add(group);
                continue;
            }
            res.addAll(RecUIViewUtil.getGroupElement(ctx, element.getChildren(), viewInfo));
        }
        return res;
    }

    public static Integer getCountScore(UIViewInfo viewInfo) throws BOSException {
        List children1;
        Document doc = StringUtils.isNotEmpty((CharSequence)viewInfo.getExtend()) ? XmlUtil.parseXML((String)viewInfo.getExtend()) : XmlUtil.parseXML((String)viewInfo.getContent());
        Element root = doc.getRootElement();
        if (root == null || root.getChildren() == null) {
            return null;
        }
        List children = root.getChildren();
        Element element = null;
        Element res = null;
        int size = children.size();
        for (int i = 0; i < size && ((children1 = (element = (Element)children.get(i)).getChildren()) == null || children1.size() <= 0 || (res = RecUIViewUtil.getCountScore(children1)) == null); ++i) {
        }
        if (res != null) {
            return Integer.parseInt(res.getAttributeValue("value"));
        }
        return 0;
    }

    private static Element getCountScore(List children) {
        if (children == null || children.size() == 0) {
            return null;
        }
        Element res = null;
        for (Object child : children) {
            Element element = (Element)child;
            List children1 = element.getChildren();
            if (children1 != null && children1.size() > 0) {
                res = RecUIViewUtil.getCountScore(children1);
                if (res == null) continue;
                break;
            }
            if (element.getAttributeValue("name") == null || !element.getAttributeValue("name").equalsIgnoreCase("countScore") || element.getAttributeValue("checked") == null || !element.getAttributeValue("checked").equalsIgnoreCase("checked")) continue;
            return element;
        }
        return res;
    }

    public static String getDomain(Context ctx, String uipk) throws BOSException {
        UIViewInfo viewInfo = RecUIViewUtil.getUIViewFromDB(ctx, uipk);
        Document doc = StringUtils.isNotEmpty((CharSequence)viewInfo.getExtend()) ? XmlUtil.parseXML((String)viewInfo.getExtend()) : XmlUtil.parseXML((String)viewInfo.getContent());
        Element root = doc.getRootElement();
        if (root == null || root.getChildren() == null) {
            return null;
        }
        Element res = XMLUtil.getElement((Element)root, (String)"domain");
        if (res != null) {
            String sourceElement = res.getTextNormalize().toString();
            sourceElement = sourceElement.replaceAll("&amp;", "&");
            return sourceElement;
        }
        return EMPTY_STRING;
    }

    public static String getDomain(Context ctx, UIViewInfo viewInfo) throws BOSException {
        Document doc = StringUtils.isNotEmpty((CharSequence)viewInfo.getExtend()) ? XmlUtil.parseXML((String)viewInfo.getExtend()) : XmlUtil.parseXML((String)viewInfo.getContent());
        Element root = doc.getRootElement();
        if (root == null || root.getChildren() == null) {
            return null;
        }
        Element res = XMLUtil.getElement((Element)root, (String)"domain");
        if (res != null) {
            String sourceElement = res.getTextNormalize().toString();
            sourceElement = sourceElement.replaceAll("&amp;", "&");
            return sourceElement;
        }
        return EMPTY_STRING;
    }

    public static boolean hasAttch(UIViewInfo viewInfo) throws BOSException {
        boolean res = false;
        Document doc = StringUtils.isNotEmpty((CharSequence)viewInfo.getExtend()) ? XmlUtil.parseXML((String)viewInfo.getExtend()) : XmlUtil.parseXML((String)viewInfo.getContent());
        Element root = doc.getRootElement();
        if (root == null || root.getChildren() == null) {
            return res;
        }
        List children = root.getChildren();
        Element element = null;
        String elementName = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            elementName = element.getName();
            if ("header".equalsIgnoreCase(elementName)) continue;
            res = RecUIViewUtil.hasAttch(element.getChildren());
        }
        return res;
    }

    private static boolean hasAttch(List children) {
        boolean res = false;
        for (Object child : children) {
            Element element = (Element)child;
            String elementName = element.getName();
            List children1 = element.getChildren();
            if (children1 != null && children1.size() > 0) {
                res = RecUIViewUtil.hasAttch(children1);
                if (!res) continue;
                break;
            }
            if (!elementName.equalsIgnoreCase("attachment")) continue;
            return true;
        }
        return res;
    }
}

