/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceURLConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceURLConfig;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsHttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(SmsHttpUtils.class);
    public static final String SIGN_DELETE = "/message/smssign/del";
    public static final String TEMP_DELETE = "/message/smstemplate/del";
    public static final String SIGN_QUERY = "/message/smssign/query";
    public static final String TEMP_QUERY = "/message/smstemplate/query";
    public static final String SIGN_CREATE = "/message/smssign/create";
    public static final String TEMP_CREATE = "/message/smstemplate/create";
    public static final String SIGN_UPDATE = "/message/smssign/upd";
    public static final String TEMP_UPDATE = "/message/smstemplate/upd";
    public static final String TEMP_CONTENT_UPLOAD = "/message/smstemplate/upload_content";
    public static final String SIGN_HISTORY_DATA = "/message/smscustom/query_sign";
    public static final String TEMP_HISTORY_DATA = "/message/smscustom/query";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, Map<String, String> params) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("accept", "*/*");
        httpPost.addHeader("content-Type", "application/json");
        if (!header.isEmpty()) {
            Set<Map.Entry<String, String>> headEntrys = header.entrySet();
            for (Map.Entry<String, String> entry : headEntrys) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!params.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            Set<Map.Entry<String, String>> paramEntrys = params.entrySet();
            for (Map.Entry<String, String> entry : paramEntrys) {
                jsonObject.put(entry.getKey(), (Object)entry.getValue());
            }
            StringEntity stringEntity = new StringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String result = "";
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONObject successObject = new JSONObject();
            successObject.put("code", (Object)response.getStatusLine().getStatusCode());
            successObject.put("data", (Object)string);
            result = successObject.toJSONString();
            logger.error("result:" + result);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"400");
            result = jSONObject.toJSONString();
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
        }
        return result;
    }

    public static String getServiceUrl(Context ctx) {
        String serviceURL = "";
        try {
            ICloudServiceURLConfig icUrlConfig = CloudServiceURLConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceURLConfigInfo csConfigInfo = icUrlConfig.getCloudServiceURLConfigInfo(" where state = '1' and serviceType= 'BASE'");
            serviceURL = csConfigInfo.getServiceURL();
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return serviceURL;
    }
}

