/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bsf.service.api;

import com.kingdee.eas.base.license.LicenseConfigFileException;
import com.kingdee.eas.base.license.ModuleLicenseInfo;
import com.kingdee.eas.base.license.file.EASLicenseReader;
import com.kingdee.eas.base.license.file.License;
import com.kingdee.eas.base.license.file.LicenseFileErrorException;
import com.kingdee.eas.base.license.file.LicenseUtil;
import com.kingdee.eas.base.license.file.config.LicenseFileConfigInfo;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LicenseServer {
    private static final Logger logger = Logger.getLogger(LicenseServer.class);

    public boolean isContainEasModel() {
        boolean flag = false;
        try {
            LicenseFileConfig fileConfig = new LicenseFileConfig();
            List allLicensFile = fileConfig.getlicenseFileList();
            int n = allLicensFile.size();
            for (int i = 0; i < n; ++i) {
                Object licenseFile = allLicensFile.get(i);
                if (licenseFile instanceof LicenseFileConfigInfo) {
                    LicenseFileConfigInfo info = (LicenseFileConfigInfo)licenseFile;
                    EASLicenseReader reader = new EASLicenseReader();
                    try {
                        String uri = info.getUri();
                        reader.readLicenseFromFile(uri);
                        System.out.println(" license uri : " + uri);
                    }
                    catch (LicenseFileErrorException e) {
                        System.out.println(" shr reader.readLicenseFromFile LicenseFileErrorException : " + e.getMessage());
                        continue;
                    }
                    License licenseInfo = reader.getLicenseFileRefrence();
                    flag = this.isContainEasModel0(licenseInfo);
                    if (!flag) continue;
                    break;
                }
                System.out.println("shr licenseFile instanceof LicenseFileConfigInfo false : ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(" shr invoke isContainEasModel  Exception: " + e.getMessage());
            flag = true;
        }
        System.out.println("[ license isContainEasModel  ] : " + flag);
        return flag;
    }

    private boolean isContainEasModel0(License licenseInfo) {
        boolean flag = false;
        List licenseModules = licenseInfo.getModuleDetails();
        if (null == licenseModules) {
            return flag;
        }
        block0: for (ModuleLicenseInfo moduleLicenseInfo : licenseModules) {
            String[] modules;
            for (String modelNumber : modules = moduleLicenseInfo.getSubModules()) {
                if (!"GL".equals(modelNumber) && !"FSSC_GL".equals(modelNumber)) continue;
                System.out.println("[ license  modelNumber is ] : " + modelNumber);
                flag = true;
                continue block0;
            }
        }
        return flag;
    }

    class LicenseFileConfig {
        Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.license.file.config.LicenseFileConfig");
        private static final String LICENSEFILE = "licensefile";
        private static final String LICENSEFILE_NAME = "name";
        private static final String LICENSEFILE_URI = "uri";
        private static final String LICENSEFILE_IMPORTDATE = "importdate";
        private static final String LICENSEFILE_ENABLE = "enable";
        private static final String LICENSEFILE_REGISTED = "registed";
        private static final String LICENSEFILE_ID = "licenseID";
        private static final String LICENSEFILE_TRIAL = "isTrial";
        private static final String EDITION_TYPE = "editionType";
        private static final String LICENSEFILE_COUNTER = "counter";
        private static final String LICENSEFILE_INITDATE = "initDate";
        private static final String LICENSEFILE_LASTRUDATE = "lastRunDate";
        private static final String LICENSEFILE_CHECKSUM = "checksum";
        private final String EAS_DEPLOY = "eas.deploy";
        private final String LICENSE_CONFIG_FILE = "licensefile.xml";
        private final String DEFAULT_PATH = "w:/eas/server/deploy/";
        private List _licenseFileList = new ArrayList();
        private Element _elementRoot;
        private String filePath = "";

        public LicenseFileConfig() {
            this.initial();
        }

        public void initial() {
            try {
                int serverCount;
                String eashome = FilenameUtils.normalize((String)System.getProperty("EAS_HOME"));
                this.filePath = eashome + File.separator + "server" + File.separator + "profiles" + File.separator + "server1" + File.separator + "config" + File.separator + "licensefile.xml";
                File f = new File(SHRCheck.checkFilePath(this.filePath));
                if (!f.exists() && (serverCount = this.getServerInstanceCount()) > 1) {
                    String destFileFileName = "";
                    for (int i = 1; i <= serverCount; ++i) {
                        destFileFileName = this.assembleLicensefileFileName(i);
                        f = new File(SHRCheck.checkFilePath(destFileFileName));
                        if (!f.exists()) continue;
                        this.filePath = destFileFileName;
                        break;
                    }
                }
                this.parseLicenseFileConfig(this.filePath);
            }
            catch (Throwable e) {
                this.logger.info((Object)("can't read" + this.filePath), e);
            }
        }

        public String assembleLicensefileFileName(int server) {
            return this.getProfielsPath() + File.separator + "server" + server + File.separator + "config" + File.separator + "licensefile.xml";
        }

        public int getServerInstanceCount() {
            File f = new File(SHRCheck.checkFilePath(this.getProfielsPath()));
            File[] filelist = f.listFiles();
            int serverCount = 0;
            if (filelist != null) {
                for (File files : f.listFiles()) {
                    if (!files.isDirectory() || !this.isServerInstancePattern(files.getName())) continue;
                    ++serverCount;
                }
            }
            return serverCount == 0 ? 1 : serverCount;
        }

        private boolean isServerInstancePattern(String name) {
            String pattern = "^server[1-9]*$";
            return name.matches(pattern);
        }

        public String getProfielsPath() {
            String eas_home = FilenameUtils.normalize((String)System.getProperty("EAS_HOME"));
            return eas_home + File.separator + "server" + File.separator + "profiles";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseLicenseFileConfig(String file) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(new File(SHRCheck.checkFilePath(file)));
                Document doc = new SAXBuilder().build((InputStream)input);
                this._elementRoot = doc.getRootElement();
                List licenseFileList = this._elementRoot.getChildren();
                int length = licenseFileList.size();
                for (int i = 0; i < length; ++i) {
                    Element ele = (Element)licenseFileList.get(i);
                    LicenseFileConfigInfo info = this.parseElement(ele);
                    File f = new File(info.getUri());
                    if (!f.exists()) {
                        this.removeFromRootElement(info);
                        try {
                            this.store();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (this._licenseFileList.contains(info)) continue;
                    this._licenseFileList.add(info);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"parse licensefile.xml error!");
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e);
                    }
                }
            }
        }

        public LicenseFileConfigInfo getLicenseFileCfgInfo(String licenseId) {
            List allLicensFile = this.getlicenseFileList();
            for (LicenseFileConfigInfo info : allLicensFile) {
                String id = info.getFileID();
                if (!licenseId.equals(licenseId)) continue;
                return info;
            }
            return null;
        }

        public LicenseFileConfigInfo parseElement(Element element) {
            assert (element != null);
            LicenseFileConfigInfo info = new LicenseFileConfigInfo();
            String name = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_NAME));
            String licenseId = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_ID));
            String uri = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_URI));
            String importDate = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_IMPORTDATE));
            String enable = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_ENABLE));
            String registed = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_REGISTED));
            String isTrial = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_TRIAL));
            String editionType = StringUtils.cnulls((String)element.getChildTextTrim(EDITION_TYPE));
            String counter = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_COUNTER));
            String initDate = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_INITDATE));
            String lastRunDate = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_LASTRUDATE));
            String checkSum = StringUtils.cnulls((String)element.getChildTextTrim(LICENSEFILE_CHECKSUM));
            info.setName(name);
            info.setFileID(licenseId);
            info.setUri(uri);
            info.setImportDate(importDate);
            info.setEnable(Boolean.valueOf(enable).booleanValue());
            info.setRegisted(Boolean.valueOf(registed).booleanValue());
            info.setTrial(Boolean.valueOf(isTrial).booleanValue());
            info.setEditionType(editionType);
            try {
                info.setCounter(LicenseUtil.decryptAES((String)counter));
                info.setInitDate(LicenseUtil.decryptAES((String)initDate));
                info.setLastRunDate(LicenseUtil.decryptAES((String)lastRunDate));
                info.setChecksum(LicenseUtil.decryptAES((String)checkSum));
            }
            catch (LicenseFileErrorException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return info;
        }

        public Element parseLicenseFileInfo(LicenseFileConfigInfo info) {
            Element eleLicenseFile = new Element(LICENSEFILE);
            assert (!(info == null || StringUtils.isEmpty((String)info.getFileID()) || StringUtils.isEmpty((String)info.getName()) || StringUtils.isEmpty((String)info.getUri()) || StringUtils.isEmpty((String)info.getImportDate())));
            Element ele = new Element(LICENSEFILE_NAME);
            ele.setText(info.getName());
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(LICENSEFILE_ID);
            ele.setText(info.getFileID());
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(LICENSEFILE_URI);
            ele.setText(info.getUri());
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(LICENSEFILE_IMPORTDATE);
            ele.setText(info.getImportDate());
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(LICENSEFILE_ENABLE);
            ele.setText(String.valueOf(info.isEnable()));
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(LICENSEFILE_REGISTED);
            ele.setText(String.valueOf(info.isRegisted()));
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(LICENSEFILE_TRIAL);
            ele.setText(String.valueOf(info.isTrial()));
            eleLicenseFile.addContent((Content)ele);
            ele = new Element(EDITION_TYPE);
            ele.setText(String.valueOf(info.getEditionType()));
            eleLicenseFile.addContent((Content)ele);
            try {
                ele = new Element(LICENSEFILE_COUNTER);
                String counter = LicenseUtil.encryptAES((String)info.getCounter());
                ele.setText(counter);
                eleLicenseFile.addContent((Content)ele);
                ele = new Element(LICENSEFILE_INITDATE);
                String initDate = LicenseUtil.encryptAES((String)info.getInitDate());
                ele.setText(initDate);
                eleLicenseFile.addContent((Content)ele);
                ele = new Element(LICENSEFILE_LASTRUDATE);
                String lastRunDate = LicenseUtil.encryptAES((String)info.getLastRunDate());
                ele.setText(lastRunDate);
                eleLicenseFile.addContent((Content)ele);
                ele = new Element(LICENSEFILE_CHECKSUM);
                String checkSum = LicenseUtil.encryptAES((String)info.getChecksum());
                ele.setText(checkSum);
                eleLicenseFile.addContent((Content)ele);
            }
            catch (LicenseFileErrorException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return eleLicenseFile;
        }

        private synchronized void store() throws IOException {
            try (FileOutputStream fileOut = null;){
                fileOut = new FileOutputStream(this.filePath);
                XMLOutputter outter = new XMLOutputter();
                outter.setFormat(Format.getPrettyFormat());
                outter.output(this._elementRoot, (OutputStream)fileOut);
            }
        }

        public void removeLicenseFileOnLine() {
            this._licenseFileList.clear();
            List list = this._elementRoot.getChildren();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Element ele = (Element)it.next();
                it.remove();
                this._elementRoot.removeContent((Content)ele);
            }
            try {
                this.store();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }

        public synchronized void removeLicenseFile(int i) {
            this._licenseFileList.remove(i);
            List list = this._elementRoot.getChildren();
            Element _eleRemove = (Element)list.get(i);
            this._elementRoot.removeContent((Content)_eleRemove);
            try {
                this.store();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }

        public synchronized void removeLicenseFile(LicenseFileConfigInfo licenseFileInfo) throws LicenseConfigFileException {
            this._licenseFileList.remove(licenseFileInfo);
            this.removeFromRootElement(licenseFileInfo);
            try {
                this.store();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                throw new LicenseConfigFileException((Throwable)e);
            }
        }

        private synchronized void removeFromRootElement(LicenseFileConfigInfo info) {
            assert (info != null);
            List list = this._elementRoot.getChildren();
            int size = list.size();
            Element eleToRemove = null;
            for (int i = 0; i < size; ++i) {
                Element ele = (Element)list.get(i);
                if (!this.parseElement(ele).equals((Object)info)) continue;
                eleToRemove = ele;
                break;
            }
            if (eleToRemove != null) {
                this._elementRoot.removeContent(eleToRemove);
            }
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public List getlicenseFileList() {
            return this._licenseFileList;
        }

        public void clear() {
            this._licenseFileList.clear();
        }

        public synchronized void addLicenseFile(LicenseFileConfigInfo licenseFileInfo) throws LicenseConfigFileException {
            if (licenseFileInfo == null) {
                throw new LicenseConfigFileException("licenseFileInfo is null");
            }
            if (!this._licenseFileList.contains(licenseFileInfo)) {
                this._licenseFileList.add(licenseFileInfo);
            }
            List licenseFileList = this._elementRoot.getChildren();
            int length = licenseFileList.size();
            for (int i = 0; i < length; ++i) {
                Element ele1 = (Element)licenseFileList.get(i);
                LicenseFileConfigInfo info = this.parseElement(ele1);
                if (licenseFileInfo != null && !info.equals((Object)licenseFileInfo)) continue;
                throw new LicenseConfigFileException("this license is already exist!");
            }
            Element ele = this.parseLicenseFileInfo(licenseFileInfo);
            this._elementRoot.addContent((Content)ele);
            try {
                this.store();
            }
            catch (IOException e) {
                this.logger.error((Object)("can't store config,please checkout : " + e));
                throw new LicenseConfigFileException((Throwable)e);
            }
        }
    }
}

