/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.BaseDataChangeType;
import com.kingdee.shr.base.syssetting.BaseInfoChangeFactory;
import com.kingdee.shr.base.syssetting.BaseInfoChangeInfo;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.HandleState;
import com.kingdee.shr.base.syssetting.ISHRBaseInfomationFacade;
import com.kingdee.shr.base.syssetting.SHRBaseInfomationFacadeFactory;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public abstract class BaseInfoChangeUtil {
    private static Logger logger = Logger.getLogger(BaseInfoChangeUtil.class);

    public static IObjectPK addBaseInfoChangeInfo(Context ctx, String shrBaseItemId, String objectId, BaseDataChangeType baseDataChangeType, HandleState handleState, UsePolicy usePolicy) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("");
        if (StringUtils.isEmpty((String)shrBaseItemId)) {
            sb.append(SHRSysSettingResourceUtil.getResource("baseitem_id_not_null", ctx));
        }
        if (StringUtils.isEmpty((String)objectId)) {
            sb.append(";" + SHRSysSettingResourceUtil.getResource("user_id_not_null", ctx));
        }
        if (null == baseDataChangeType) {
            sb.append(";" + SHRSysSettingResourceUtil.getResource("change_type_not_null", ctx));
        }
        if (null == handleState) {
            sb.append(";" + SHRSysSettingResourceUtil.getResource("handle_state_not_null", ctx));
        }
        if (null == usePolicy) {
            sb.append(";" + SHRSysSettingResourceUtil.getResource("use_policy_not_null", ctx));
        }
        if (!StringUtils.isEmpty((String)sb.toString())) {
            logger.info((Object)sb.toString());
            throw new SyssettinException(SyssettinException.CUSTOM_EXCEPTION, new Object[]{sb.toString()});
        }
        BaseInfoChangeInfo baseInfoChangeInfo = new BaseInfoChangeInfo();
        baseInfoChangeInfo.setBaseInfoId(shrBaseItemId);
        if (BaseDataChangeType.HRORG.equals((Object)baseDataChangeType)) {
            HROrgUnitInfo hrOrgUnit = new HROrgUnitInfo();
            hrOrgUnit.setId(BOSUuid.read((String)objectId));
            baseInfoChangeInfo.setHrOrgUnit(hrOrgUnit);
        }
        baseInfoChangeInfo.setUsePolicy(usePolicy);
        baseInfoChangeInfo.setChangeType(baseDataChangeType);
        baseInfoChangeInfo.setState(handleState);
        baseInfoChangeInfo.setChangDate(new Timestamp(System.currentTimeMillis()));
        return BaseInfoChangeFactory.getLocalInstance(ctx).addnew(baseInfoChangeInfo);
    }

    public static IObjectPK[] handlerAddChangeSHRBaseItemInfo(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        return SHRBaseInfomationFacadeFactory.getLocalInstance(ctx).baseInfoAddNew(baseInfoChangePK);
    }

    public static IObjectPK[] handlerUpdateChangeSHRBaseItemInfo(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        return SHRBaseInfomationFacadeFactory.getLocalInstance(ctx).baseInfoUpdate(baseInfoChangePK);
    }

    public static void handlerBaseInfoOrgRefState(Context ctx, IObjectPK baseInfoChangePK, BaseItemStateEnum state) throws BOSException, EASBizException {
        ISHRBaseInfomationFacade iSHRBaseInfomationFacade = SHRBaseInfomationFacadeFactory.getLocalInstance(ctx);
        if (BaseItemStateEnum.ENABLE.equals((Object)state)) {
            iSHRBaseInfomationFacade.baseInfoEnabled(baseInfoChangePK);
        } else if (BaseItemStateEnum.DISABLE.equals((Object)state)) {
            iSHRBaseInfomationFacade.baseInfoDisabled(baseInfoChangePK);
        }
    }

    public static IObjectPK[] handlerBaseInfoOrgRefDelete(Context ctx, IObjectPK baseInfoChangePK) throws EASBizException, BOSException {
        return SHRBaseInfomationFacadeFactory.getLocalInstance(ctx).baseInfoDeleted(baseInfoChangePK);
    }
}

