/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import com.kingdee.shr.base.syssetting.util.HTMLUtil;
import com.kingdee.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public final class XssFilterUtil {
    private static final String SRC_SCRIPT = "(src\\s*(=|\\())|(src\\s*[\r\n]\\s*(=|\\())";
    private static final String[] ON_EVENTS = new String[]{"ondragend", "onunload", "onsubmit", "onscroll", "onchange", "onblur", "onbefore", "onafter", "onactivate", "onselect", "onload", "onkeydown", "onkeypress", "onkeyup", "onfocus", "onhelp", "ondrop", "onfinish", "onerror", "ontoggle", "eval", "alert", "e-xpression", "onclick", "ondblclick", "onmousedown", "onmousemove", "onmouseover", "onmouseleave", "onmouseup", "prompt", "confirm"};
    private static final String[] FULL_MATCH_PATTENS = new String[]{"javascript:", "vbscript:", "set.constructor", "fscommand", "seeksegmenttime", "background:"};
    private static final String[] TAG_PATTERNS = new String[]{"iframe", "xss", "script", "details", "img", "a", "div", "input", "body", "bgsound", "style", "meta", "link", "xml", "frameset", "svg", "form", "isindex", "applet", "video", "embed", "object", "base", "table", "button", "textarea", "h1", "h2", "h3", "h4", "h5", "h6"};
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u(\\p{XDigit}{4})");

    public static String stripXSS(String value, String parameter) {
        if (value == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)parameter) && ("id".equalsIgnoreCase(parameter) || "billid".equalsIgnoreCase(parameter) || "taskid".equalsIgnoreCase(parameter))) {
            return value;
        }
        String tempValue = value;
        value = StringEscapeUtils.unescapeHtml((String)XssFilterUtil.normalizeUnicode(value));
        if ((value = XssFilterUtil.doMatcher(SRC_SCRIPT, value)).contains("=") || value.contains("(")) {
            for (String onEvent : ON_EVENTS) {
                value = XssFilterUtil.doMatcher("\\b" + onEvent + "(\\s*?)(=|\\()", value);
            }
        }
        for (String fullMatch : FULL_MATCH_PATTENS) {
            value = XssFilterUtil.doMatcher("\\b" + fullMatch, value);
        }
        if (value.contains("<")) {
            for (String tagPattern : TAG_PATTERNS) {
                value = XssFilterUtil.doMatcher("</" + tagPattern + ">", value);
                value = XssFilterUtil.doMatcher("<" + tagPattern + "(.*?)", value);
            }
        }
        return tempValue;
    }

    private static String doMatcher(String reqex, String value) {
        Pattern pattern = Pattern.compile(reqex, 2);
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            throw new IllegalArgumentException("Illegal input exists, please check illegal character : " + HTMLUtil.escape(matcher.group()));
        }
        return value;
    }

    private static String normalizeUnicode(String input) {
        if (!input.contains("\\u") && !input.contains("\\\\u")) {
            return input;
        }
        input = input.replace("\\\\u", "\\u");
        Matcher matcher = UNICODE_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            int unicodeValue = Integer.parseInt(hexCode, 16);
            matcher.appendReplacement(result, String.valueOf((char)unicodeValue));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

