/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CalFormulaUpToBigUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.util.CalFormulaUpToBigUtil");
    private static final String STR_FILED_PRE = "TEMPSTRREPLACETEMPPRE";
    private static final String FUN_FILED_PRE = "TEMPFUNCREPLACETEMPPRE";
    protected String PREFIX_FIELD_FORMAT = "%06d";
    private static final Integer STR_TYPE = 1;
    private Map<String, String> usedFunsMap = new HashMap<String, String>();
    private Map<String, String> usedStrsMap = new HashMap<String, String>();
    private Map<String, Integer> usedFields = new HashMap<String, Integer>();
    private Map<String, Integer[]> usedFuns = new HashMap<String, Integer[]>();
    private Context ctx;

    private CalFormulaUpToBigUtil() {
    }

    public CalFormulaUpToBigUtil(Context ctx) {
        this.ctx = ctx;
    }

    private void initFieldInfo(BaseFormulaInfo formulaInfo) {
        String usedFunc = formulaInfo.getListFunc();
        String usedItem = formulaInfo.getListItem();
        String usedVar = formulaInfo.getListVar();
        StringBuilder funsIds = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)usedFunc)) {
            String[] usedFuncArr;
            for (String fun : usedFuncArr = usedFunc.split(";")) {
                String[] funArr = fun.split("~");
                this.usedFields.put(funArr[2], Integer.parseInt(funArr[0]));
                funsIds.append(",'").append(funArr[1]).append("'");
                this.usedFuns.put(funArr[2], null);
            }
        }
        if (this.usedFuns.size() > 0) {
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)("SELECT FDEFINE,FPARAMS FROM T_HR_SFORMULAFUNC WHERE FID IN (" + funsIds.toString().replaceFirst(",", "") + ");"));
                String define = "";
                String params = "";
                while (rowSet.next()) {
                    define = rowSet.getString("FDEFINE");
                    params = rowSet.getString("FPARAMS");
                    if (StringUtils.isEmpty((CharSequence)params)) continue;
                    String[] paramsStrArr = params.split(",");
                    Integer[] paramsIntArr = new Integer[paramsStrArr.length];
                    int length = paramsStrArr.length;
                    for (int i = 0; i < length; ++i) {
                        paramsIntArr[i] = "double".equals(paramsStrArr[i].trim()) ? 0 : 1;
                    }
                    this.usedFuns.put(define, paramsIntArr);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)usedItem)) {
            String[] usedItemArr;
            for (String item : usedItemArr = usedItem.split(";")) {
                String[] itemArr = item.split("~");
                String key = itemArr[1] + "_" + (itemArr.length == 3 ? "" : itemArr[3] + "_") + itemArr[2];
                this.usedFields.put(key, "double".equals(itemArr[0]) ? 0 : STR_TYPE);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)usedVar)) {
            String[] usedVarArr;
            for (String var : usedVarArr = usedVar.split(";")) {
                String[] varArr = var.split("~");
                this.usedFields.put(varArr[2].replace("@", ""), Integer.parseInt(varArr[0]));
            }
        }
    }

    public String convertFormulaBig(BaseFormulaInfo formulaInfo) {
        this.initFieldInfo(formulaInfo);
        String express = formulaInfo.getExpress();
        express = express.replace("\r", "").replace("\n", "").replaceAll("\t", "");
        express = this.replaceStrField(express);
        express = this.handleIfExp(express);
        express = this.handleEqEx(express);
        express = this.rebackPlaceField(this.usedFunsMap, FUN_FILED_PRE, express);
        express = this.rebackPlaceField(this.usedStrsMap, STR_FILED_PRE, express);
        return express;
    }

    private String replaceStrField(String exp) {
        StringBuffer str = new StringBuffer();
        String[] split1 = exp.split("\"");
        for (int i = 0; i < split1.length; ++i) {
            if (i % 2 != 0) {
                String key = STR_FILED_PRE + String.format(this.PREFIX_FIELD_FORMAT, this.usedStrsMap.size());
                str.append(key);
                this.usedStrsMap.put(key, "\"" + split1[i] + "\"");
                this.usedFields.put(key, STR_TYPE);
                continue;
            }
            str.append(split1[i]);
        }
        return str.toString();
    }

    private String handleIfExp(String exp) {
        ArrayList<String> sysFuncList = new ArrayList<String>();
        sysFuncList.add("isEqual");
        sysFuncList.add("isGtOrEql");
        sysFuncList.add("isGtThn");
        sysFuncList.add("isLsOrEql");
        sysFuncList.add("isLsThn");
        sysFuncList.add("include");
        for (String sysFunc : sysFuncList) {
            int indexOf;
            while ((indexOf = exp.indexOf(sysFunc)) >= 0) {
                int nextE = exp.indexOf(")", indexOf + 1);
                int leC = this.numOfStringContainsTheSubStr(exp.substring(indexOf, nextE), "\\(");
                int rigI = this.indexOfNSub(exp.substring(indexOf), "\\)", leC);
                String sub = exp.substring(indexOf, indexOf + rigI + 1);
                String[] funParaArr = this.getFunPara(sub.substring(sysFunc.length() + 1, sub.length() - 1));
                StringBuilder sb = new StringBuilder();
                sb.append(sysFunc);
                sb.append("(");
                int length = funParaArr.length;
                for (int j = 0; j < length; ++j) {
                    String aa = this.getBigDecimalCalStr(funParaArr[j]);
                    sb.append(aa.contains("getBigVal") ? "toDouble(" + aa + ")" : aa);
                    if (j == length - 1) continue;
                    sb.append(",");
                }
                sb.append(")");
                String key = FUN_FILED_PRE + String.format(this.PREFIX_FIELD_FORMAT, this.usedFunsMap.size());
                this.usedFunsMap.put(key, sb.toString());
                sb.setLength(0);
                sb.append(key);
                exp = exp.replace(sub, key);
            }
        }
        return exp;
    }

    private String handleEqEx(String exp) {
        boolean isContinue = true;
        int startIndex = 0;
        int endIndex = 0;
        String tempExp = "";
        String calItem = exp.substring(exp.indexOf("{") < 0 ? 0 : exp.indexOf("{") + 1, exp.indexOf("=")).trim();
        Integer calItemType = this.usedFields.get(calItem);
        boolean isNeedToDouble = STR_TYPE == calItemType;
        String tempExpress = exp;
        while (isContinue) {
            if (tempExpress.indexOf("=", startIndex) < 0) {
                isContinue = false;
                continue;
            }
            tempExp = tempExpress.substring((startIndex = tempExpress.indexOf("=", startIndex)) + 1, endIndex = tempExpress.indexOf(";", startIndex));
            if (calItem.equals(tempExp.trim())) {
                startIndex = endIndex;
                continue;
            }
            String res = this.getBigDecimalCalStr(tempExp);
            res = isNeedToDouble ? res : "getBigVal(" + res + ")";
            tempExpress = tempExpress.substring(0, startIndex) + "=" + res + tempExpress.substring(endIndex);
            startIndex = endIndex += res.length() - tempExp.length();
        }
        exp = tempExpress;
        return exp;
    }

    private String getBigDecimalCalStr(String exp) {
        List<String> list = Arrays.asList("+", "-", "*", "/", "(", ")");
        Stack<String> stack = new Stack<String>();
        int iEnd = 0;
        for (int i = 0; i < exp.length(); ++i) {
            Serializable sb;
            String character = String.valueOf(exp.charAt(i));
            if (character.equals(" ") || i < iEnd) continue;
            if (character.equals(")")) {
                sb = new Stack<String>();
                while (!stack.isEmpty() && !((String)stack.peek()).equals("(")) {
                    ((Stack)sb).push(stack.pop());
                }
                stack.pop();
                stack.push(this.calculate((Stack<String>)sb));
                continue;
            }
            if (stack.isEmpty()) {
                stack.push(character);
                continue;
            }
            if (list.contains(character)) {
                stack.push(character);
                continue;
            }
            if (list.contains(stack.peek())) {
                String pop = (String)stack.pop();
                if ("-".equals(pop) && (stack.size() == 0 || list.contains(stack.peek()))) {
                    pop = pop + character;
                    stack.push(pop);
                    continue;
                }
                stack.push(pop);
                stack.push(character);
                continue;
            }
            sb = new StringBuilder();
            ((StringBuilder)sb).append((String)stack.pop());
            ((StringBuilder)sb).append(character);
            if (i + 1 < exp.length() && "(".equals(String.valueOf(exp.charAt(i + 1)))) {
                String funcName = ((StringBuilder)sb).toString();
                int nexts = exp.indexOf("(", i + 2);
                int nextE = exp.indexOf(")", i + 1);
                if (-1 == nexts || nexts > nextE) {
                    String[] funParaArr = this.getFunPara(exp.substring(i + 1 + 1, nextE + 1 - 1));
                    Integer[] funParaTypeArr = this.usedFuns.get(funcName);
                    ((StringBuilder)sb).append("(");
                    int length = funParaArr.length;
                    for (int j = 0; j < length; ++j) {
                        String aa = this.getBigDecimalCalStr(funParaArr[j]);
                        if (null != funParaTypeArr && STR_TYPE != funParaTypeArr[j] && aa.contains("getBigVal")) {
                            aa = "toDouble(" + aa + ")";
                        }
                        ((StringBuilder)sb).append(aa);
                        if (j == length - 1) continue;
                        ((StringBuilder)sb).append(",");
                    }
                    ((StringBuilder)sb).append(")");
                    String key = FUN_FILED_PRE + String.format(this.PREFIX_FIELD_FORMAT, this.usedFunsMap.size());
                    this.usedFunsMap.put(key, ((StringBuilder)sb).toString());
                    if (this.usedFuns.containsKey(funcName)) {
                        this.usedFields.put(key, this.usedFields.get(funcName));
                    }
                    ((StringBuilder)sb).setLength(0);
                    ((StringBuilder)sb).append(key);
                    iEnd = nextE + 1;
                } else {
                    int leC = this.numOfStringContainsTheSubStr(exp.substring(i, nextE), "\\(");
                    int rigI = this.indexOfNSub(exp.substring(i), "\\)", leC);
                    String sub = exp.substring(i + 1, i + rigI + 1);
                    String[] funParaArr = this.getFunPara(sub.substring(1, sub.length() - 1));
                    ((StringBuilder)sb).append("(");
                    Integer[] funParaTypeArr = this.usedFuns.get(funcName);
                    int length = funParaArr.length;
                    for (int j = 0; j < length; ++j) {
                        String aa = this.getBigDecimalCalStr(funParaArr[j]);
                        if (null != funParaTypeArr && STR_TYPE != funParaTypeArr[j] && aa.contains("getBigVal")) {
                            aa = "toDouble(" + aa + ")";
                        }
                        ((StringBuilder)sb).append(aa);
                        if (j == length - 1) continue;
                        ((StringBuilder)sb).append(",");
                    }
                    ((StringBuilder)sb).append(")");
                    String key = FUN_FILED_PRE + String.format(this.PREFIX_FIELD_FORMAT, this.usedFunsMap.size());
                    this.usedFunsMap.put(key, ((StringBuilder)sb).toString());
                    if (this.usedFuns.containsKey(funcName)) {
                        this.usedFields.put(key, this.usedFields.get(funcName));
                    }
                    ((StringBuilder)sb).setLength(0);
                    ((StringBuilder)sb).append(key);
                    iEnd = i + rigI + 1;
                }
            }
            stack.push(((StringBuilder)sb).toString());
        }
        String result = "";
        if (stack.size() == 1) {
            result = (String)stack.pop();
        } else {
            Stack<String> last = new Stack<String>();
            while (!stack.isEmpty()) {
                last.push((String)stack.pop());
            }
            result = this.calculate(last);
        }
        result = result.trim();
        if (this.usedFields.containsKey(result) && STR_TYPE != this.usedFields.get(result) && !this.usedFunsMap.containsKey(result)) {
            result = "toDouble(" + result + ")";
        }
        return result;
    }

    private String calculate(Stack<String> exp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (!exp.isEmpty()) {
            if ("*".equals(exp.peek()) || "/".equals(exp.peek())) {
                String fuhao = exp.pop();
                String number = exp.pop();
                if (number.matches("^[1-9]+[0-9]*$")) {
                    number = number + ".0";
                }
                String last = (String)arrayList.remove(arrayList.size() - 1);
                if (fuhao.equals("*")) {
                    arrayList.add("multiply(getBigVal(" + last + "),getBigVal(" + number + "))");
                    continue;
                }
                arrayList.add("divide(getBigVal(" + last + "),getBigVal(" + number + "))");
                continue;
            }
            arrayList.add(exp.pop());
        }
        if (arrayList.size() == 0) {
            return "";
        }
        String temp = (String)arrayList.remove(0);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (next.equals("+")) {
                String next1 = (String)iterator.next();
                if (this.usedFields.containsKey(temp) && STR_TYPE == this.usedFields.get(temp) || this.usedFields.containsKey(next1) && STR_TYPE == this.usedFields.get(next1)) {
                    temp = temp + "+ " + next1;
                    continue;
                }
                temp = "add(getBigVal(" + temp + "), getBigVal(" + next1 + "))";
                continue;
            }
            if (!next.equals("-")) continue;
            temp = "subtract(getBigVal(" + temp + "), getBigVal(" + (String)iterator.next() + "))";
        }
        return temp;
    }

    private String[] getFunPara(String strExpress) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        String regex = "[^\\*\\+-/=]\\(";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(strExpress);
        if (this.getMatchCount(matcher) > 0) {
            int iEnd = 0;
            while (matcher.find()) {
                if (matcher.start() < iEnd) continue;
                int iS = 0;
                int iE = strExpress.length() - 1;
                for (int i2 = matcher.start() - 1; i2 >= 0; --i2) {
                    if (",><=+-*/(".indexOf(strExpress.charAt(i2)) == -1) continue;
                    iS = i2 + 1;
                    break;
                }
                Stack<Character> sk = new Stack<Character>();
                for (int i3 = matcher.start() + 1; i3 < strExpress.length(); ++i3) {
                    if (strExpress.charAt(i3) == '(') {
                        sk.push(Character.valueOf('('));
                        continue;
                    }
                    if (strExpress.charAt(i3) != ')') continue;
                    if (sk.size() == 1) {
                        iE = i3;
                        break;
                    }
                    if (sk.size() > 1) {
                        sk.pop();
                        continue;
                    }
                    iE = strExpress.length() - 1;
                    break;
                }
                iEnd = iS + iE - iS + 1;
                String sValue = strExpress.substring(iS, iEnd);
                list.add(sValue);
            }
            int size = list.size();
            for (i = 0; i < size; ++i) {
                String key = "@FUN" + String.format(this.PREFIX_FIELD_FORMAT, i);
                String value = (String)list.get(i);
                strExpress = strExpress.replace(value, key);
            }
        }
        String[] strs = strExpress.split(",");
        for (i = 0; i < strs.length; ++i) {
            if (strs[i].indexOf("@FUN") == -1) continue;
            int size = list.size();
            for (int k = 0; k < size; ++k) {
                String key = "@FUN" + String.format(this.PREFIX_FIELD_FORMAT, k);
                String value = (String)list.get(k);
                strs[i] = strs[i].replace(key, value);
            }
        }
        return strs;
    }

    private int getMatchCount(Matcher matcher) {
        int c = 0;
        while (matcher.find()) {
            ++c;
        }
        matcher.reset();
        return c;
    }

    private int numOfStringContainsTheSubStr(String inputStr, String subStr) {
        Pattern p = Pattern.compile(subStr, 2);
        Matcher m = p.matcher(inputStr);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    private int indexOfNSub(String inputStr, String subStr, int n) {
        Pattern p = Pattern.compile(subStr, 2);
        Matcher m = p.matcher(inputStr);
        int count = 0;
        int index = 0;
        while (m.find()) {
            int n2;
            if (n != ++count) continue;
            index = m.start();
            int n1 = this.numOfStringContainsTheSubStr(inputStr.substring(0, index + 1), "\\(");
            if (n1 == (n2 = this.numOfStringContainsTheSubStr(inputStr.substring(0, index + 1), "\\)"))) break;
            ++n;
        }
        return index;
    }

    private String rebackPlaceField(Map<String, String> mapper, String prefixStr, String exp) {
        if (null == mapper || mapper.size() == 0) {
            return exp;
        }
        int size = mapper.size();
        for (int i = size - 1; i >= 0; --i) {
            String key = prefixStr + String.format(this.PREFIX_FIELD_FORMAT, i);
            String value = mapper.get(key);
            exp = exp.replace(key, value);
        }
        return exp;
    }

    public void upgradeFormula(String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FID,FEXPRESS,FBIGEXPRESS,FLISTITEM,FLISTFUNC,FLISTVAR ");
        sb.append(" FROM  ").append(tableName);
        sb.append(" WHERE FBIGEXPRESS IS NULL and fiscal = 1 ");
        HashMap<String, String> upErrMap = new HashMap<String, String>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            String updateSql = "update " + tableName + " set FBIGEXPRESS = ? where fid = ?";
            while (rowSet.next()) {
                String fid = rowSet.getString("FID");
                String express = rowSet.getString("FEXPRESS");
                String bigExpress = rowSet.getString("FBIGEXPRESS");
                String listItem = rowSet.getString("FLISTITEM");
                String listFunc = rowSet.getString("FLISTFUNC");
                String listVar = rowSet.getString("FLISTVAR");
                BaseFormulaInfo formulaInfo = new BaseFormulaInfo();
                formulaInfo.setId(BOSUuid.read((String)fid));
                formulaInfo.setExpress(express);
                formulaInfo.setListItem(listItem);
                formulaInfo.setListFunc(listFunc);
                formulaInfo.setListVar(listVar);
                if (!StringUtils.isEmpty((CharSequence)bigExpress)) continue;
                try {
                    this.usedFunsMap.clear();
                    this.usedStrsMap.clear();
                    this.usedFields.clear();
                    this.usedFuns.clear();
                    bigExpress = this.convertFormulaBig(formulaInfo);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    upErrMap.put(fid, e.getMessage());
                    continue;
                }
                Object[] param = new Object[]{bigExpress, fid};
                params.add(param);
            }
            if (params.size() > 0) {
                DbUtil.executeBatch((Context)this.ctx, (String)updateSql, params);
            }
            if (upErrMap.size() > 0) {
                logger.error((Object)(" update formula express failed : " + upErrMap));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

