/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CurrentAccountType;
import com.kingdee.eas.tm.common.invoicePool.ICheckInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.NotDeductibleTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.app.TMBillImport;
import com.kingdee.eas.tm.common.utils.CheckAbsUtil;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CheckInvoiceBaseImport
extends TMBillImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseImport");
    String curKey = null;
    private Map infoMap = new HashMap();

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        CheckInvoiceBaseInfo head = this.createNewData(ctx);
        String invoiceCode = this.getString(hsData, "FInvoiceCode");
        if (StringUtils.isEmpty((String)invoiceCode)) {
            throw new TaskExternalException(this.getResource(ctx, "InvoiceCodeNotNull"));
        }
        String invoiceNo = this.getString(hsData, "FInvoiceNo");
        if (StringUtils.isEmpty((String)invoiceNo)) {
            throw new TaskExternalException(this.getResource(ctx, "InvoiceNumberNotNull"));
        }
        int datataskMode = (Integer)this.getContextParameter("DATATASKMODE");
        this.curKey = invoiceCode.concat("_").concat(invoiceNo);
        if (this.infoMap.containsKey(this.curKey)) {
            head = (CheckInvoiceBaseInfo)this.infoMap.get(this.curKey);
        } else {
            head = this.getHeadInfo(ctx, datataskMode, invoiceCode, invoiceNo);
            head.setSourceType(TMSourceType.EXCEL);
            this.infoMap.put(this.curKey, head);
        }
        return head;
    }

    private CheckInvoiceBaseInfo getHeadInfo(Context ctx, int datataskMode, String invoiceCode, String invoiceNumber) throws TaskExternalException {
        CheckInvoiceBaseInfo info = this.createNewData(ctx);
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNumber, CompareType.EQUALS));
            view.setFilter(filter);
            if (datataskMode == 16 || datataskMode == 128) {
                view.setSelector(this.getSelector());
                CheckInvoiceBaseCollection coll = ((ICheckInvoiceBase)this.getController(ctx)).getCheckInvoiceBaseCollection(view);
                if (coll != null && coll.size() > 0) {
                    info = coll.get(0);
                    if (TMSourceType.PWYDOWNLOAD.equals((Object)info.getSourceType()) || TMSourceType.OCR.equals((Object)info.getSourceType())) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceSrcValid"));
                    }
                    if (info.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)info.getCheckAbs().getCheckType())) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasAuthenticate"));
                    }
                    if (info.isIsAccept()) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasAccept"));
                    }
                    if (info.isIsReceive()) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasReceive"));
                    }
                    return info;
                }
                return info;
            }
            if (datataskMode == 8) {
                if (this.getController(ctx).exists(filter)) {
                    throw new TaskExternalException(this.getResource(ctx, "InvoiceHasExists"));
                }
                return info;
            }
            return info;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CheckInvoiceBaseInfo parseHead(Map hsData, Context ctx, CheckInvoiceBaseInfo head) throws TaskExternalException {
        String confirmTime;
        String confirmState;
        String proxyMark;
        String salerName;
        String invoiceCode = this.getString(hsData, "FInvoiceCode");
        if (null == invoiceCode || invoiceCode.length() <= 0) {
            throw new TaskExternalException(this.getResource(ctx, "InvoiceCodeNotNull"));
        }
        head.setInvoiceCode(invoiceCode);
        String invoiceNumber = this.getString(hsData, "FInvoiceNo");
        if (null == invoiceNumber || invoiceNumber.length() <= 0) {
            throw new TaskExternalException(this.getResource(ctx, "InvoiceNumberNotNull"));
        }
        head.setInvoiceNo(invoiceNumber);
        head.setNumber(head.getInvoiceCode() + "_" + head.getInvoiceNo());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = this.getString(hsData, "FInvoiceDate");
        if (o == null || o.toString().length() <= 0) throw new TaskExternalException(this.getResource(ctx, "InvoiceDateNotNull"));
        try {
            o = df.parse(o.toString());
            Date value = (Date)o;
            if (value != null) {
                head.setInvoiceDate(value);
            }
        }
        catch (ParseException pex) {
            logger.error((Object)pex.getMessage(), (Throwable)pex);
            throw new TaskExternalException(this.getResource(ctx, "DateFormatError"));
        }
        String currentAccountNumber = this.getString(hsData, "FCurrAcctSupplier_number");
        if (currentAccountNumber != null && !currentAccountNumber.equals("")) {
            String FSupplierNumber = this.getString(hsData, "FCurrAcctSupplier_number");
            SupplierInfo supplierInfo = this.getSupplier(ctx, FSupplierNumber);
            if (supplierInfo == null) throw new TaskExternalException(this.getResource(ctx, "CurrAcctSupplierNumberValid"));
            head.setCurrAcctSupplier(supplierInfo);
            head.put("salerName", supplierInfo.getName());
            head.put("salerTaxNo", supplierInfo.getTaxRegisterNo());
        }
        if ((salerName = this.getString(hsData, "FSalerName")) != null && salerName.length() > 0) {
            head.put("salerName", salerName);
        } else if (StringUtils.isEmpty((String)currentAccountNumber)) {
            throw new TaskExternalException(this.getResource(ctx, "SalerNameNotNull"));
        }
        String salerTaxNo = this.getString(hsData, "FSalerTaxNo");
        if (null != salerTaxNo && salerTaxNo.length() > 0) {
            head.put("salerTaxNo", salerTaxNo);
        } else if (StringUtils.isEmpty((String)head.getString("salerTaxNo"))) {
            throw new TaskExternalException(this.getResource(ctx, "SalerTaxNoNotNull"));
        }
        String currentAccountType = this.getString(hsData, "FCurrentAccountType");
        if (null != currentAccountType && currentAccountType.length() > 0) {
            if (!currentAccountType.equals(CurrentAccountType.SUPPLIER.getAlias()) && !currentAccountType.equals("2")) throw new TaskExternalException(this.getResource(ctx, "CurrentAccountTypeError"));
            head.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        } else {
            head.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        String FProjectNumber = this.getString(hsData, "FProject_number");
        ProjectInfo project = this.getProject(ctx, FProjectNumber);
        head.setProject(project);
        String invoiceStatus = this.getString(hsData, "FInvoiceStatus");
        if (null != invoiceStatus && invoiceStatus.length() > 0) {
            TMInvoiceStatus status = null;
            if (invoiceStatus.equals(TMInvoiceStatus.NORMAL.getAlias())) {
                status = TMInvoiceStatus.NORMAL;
            } else if (invoiceStatus.equals(TMInvoiceStatus.OUT_OF_CONTROL.getAlias())) {
                status = TMInvoiceStatus.OUT_OF_CONTROL;
            } else if (invoiceStatus.equals(TMInvoiceStatus.CANCEL.getAlias())) {
                status = TMInvoiceStatus.CANCEL;
            } else if (invoiceStatus.equals(TMInvoiceStatus.RED.getAlias())) {
                status = TMInvoiceStatus.RED;
            } else if (invoiceStatus.equals(TMInvoiceStatus.ABNORMAL.getAlias())) {
                status = TMInvoiceStatus.ABNORMAL;
            } else if (invoiceStatus.equals(TMInvoiceStatus.UNNORMAL.getAlias())) {
                status = TMInvoiceStatus.UNNORMAL;
            } else if (invoiceStatus.equals(TMInvoiceStatus.UNCONFIRMRED.getAlias())) {
                status = TMInvoiceStatus.UNCONFIRMRED;
            } else if (invoiceStatus.equals(TMInvoiceStatus.PARTLYRED.getAlias())) {
                status = TMInvoiceStatus.PARTLYRED;
            } else if (invoiceStatus.equals(TMInvoiceStatus.FULLRED.getAlias())) {
                status = TMInvoiceStatus.FULLRED;
            } else {
                status = TMInvoiceStatus.getEnum(invoiceStatus);
                if (status == null) {
                    throw new TaskExternalException(this.getResource(ctx, "StatusTip"));
                }
            }
            head.put("invoiceStatus", (Object)status);
        }
        if (null != (proxyMark = this.getString(hsData, "FProxyMark"))) {
            if (proxyMark.equals(this.getResource(ctx, "TRUE")) || proxyMark.equals("1")) {
                head.put("proxyMark", true);
            } else if (proxyMark.equals(this.getResource(ctx, "FALSE")) || proxyMark.equals("0")) {
                head.put("proxyMark", false);
            }
        }
        String FCompanyNumber = this.getString(hsData, "FCompany_number");
        CompanyOrgUnitInfo company = this.getCompany(ctx, FCompanyNumber);
        head.setCompany(company);
        CheckAbsInfo checkAbs = head.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(head);
            head.setCheckAbs(checkAbs);
        }
        checkAbs.setEffectiveTaxAmt(this.getBigDecimal(ctx, hsData, "FTotalTaxAmount"));
        String checkState = this.getString(hsData, "FCheckAbs_checkState");
        if (!StringUtils.isEmpty((String)checkState)) {
            CheckStateEnum checkStateEnum = (CheckStateEnum)TMCommonUtil.getEnumByValueOrAlias(CheckStateEnum.getEnumList(), checkState);
            if (checkStateEnum == null) {
                throw new TaskExternalException(this.getResource(ctx, "checkStateValid"));
            }
            checkAbs.setCheckState(checkStateEnum);
        } else {
            checkAbs.setCheckState(CheckStateEnum.Unchecked);
        }
        String checkTime = this.getString(hsData, "FCheckAbs_checkTime");
        if (!StringUtils.isEmpty((String)checkTime)) {
            Date checkDate = this.getDate(checkTime);
            if (checkDate == null) {
                throw new TaskExternalException(this.getResource(ctx, "checkTimeFormat"));
            }
            checkAbs.setCheckTime(checkDate);
            head.put("selectTime", checkTime);
        }
        String checkUser_number = this.getString(hsData, "FCheckAbs$checkUser_number");
        checkAbs.setCheckUser(this.getUserFromNumber(ctx, checkUser_number));
        if (!StringUtils.isEmpty((String)checkUser_number) && checkAbs.getCheckUser() == null) {
            throw new TaskExternalException(this.getResource(ctx, "checkUserValid"));
        }
        String checkPurpose = this.getString(hsData, "FCheckAbs_checkPurpose");
        checkAbs.setCheckPurpose((CheckPurposeEnum)IMUtils.getEnumByValueOrAlias((List)CheckPurposeEnum.getEnumList(), (String)checkPurpose));
        String notDeductibleType = this.getString(hsData, "FCheckAbs_notDeductibleType");
        checkAbs.setNotDeductibleType((NotDeductibleTypeEnum)IMUtils.getEnumByValueOrAlias((List)NotDeductibleTypeEnum.getEnumList(), (String)notDeductibleType));
        if (CheckPurposeEnum.NonDeduct.equals((Object)checkAbs.getCheckPurpose()) && checkAbs.getNotDeductibleType() == null) {
            throw new TaskExternalException(this.getResource(ctx, "SetNotDeductibleTypeError"));
        }
        String checkWay = this.getString(hsData, "FCheckAbs_checkWay");
        if (!StringUtils.isEmpty((String)checkWay)) {
            CheckWayEnum checkWayEnum = (CheckWayEnum)TMCommonUtil.getEnumByValueOrAlias(CheckWayEnum.getEnumList(), checkWay);
            if (checkWayEnum == null) {
                throw new TaskExternalException(this.getResource(ctx, "checkWayValid"));
            }
            checkAbs.setCheckWay(checkWayEnum);
        }
        if (!StringUtils.isEmpty((String)(confirmState = this.getString(hsData, "FCheckAbs_confirmState")))) {
            ConfirmStateEnum confirmStateEnum = (ConfirmStateEnum)TMCommonUtil.getEnumByValueOrAlias(ConfirmStateEnum.getEnumList(), confirmState);
            if (confirmStateEnum == null) {
                throw new TaskExternalException(this.getResource(ctx, "confirmStateValid"));
            }
            checkAbs.setConfirmState(confirmStateEnum);
        } else {
            checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
        }
        if (ConfirmStateEnum.Confirmed.equals((Object)checkAbs.getConfirmState()) && checkAbs.getCheckType() == null) {
            checkAbs.setCheckType(CheckTypeEnum.OFFLINE);
        }
        if (!StringUtils.isEmpty((String)(confirmTime = this.getString(hsData, "FCheckAbs_confirmTime")))) {
            Date confirmDate = this.getDate(confirmTime);
            if (confirmDate == null) {
                throw new TaskExternalException(this.getResource(ctx, "confirmTimeFormat"));
            }
            checkAbs.setConfirmTime(confirmDate);
        }
        String confirmUserNumber = this.getString(hsData, "FCheckAbs$confirmUser_number");
        checkAbs.setConfirmUser(this.getUserFromNumber(ctx, confirmUserNumber));
        if (!StringUtils.isEmpty((String)confirmUserNumber) && checkAbs.getConfirmUser() == null) {
            throw new TaskExternalException(this.getResource(ctx, "confirmUserValid"));
        }
        String taxPeriodNumber = this.getString(hsData, "FCheckAbs$taxPeriod_number");
        if (null != taxPeriodNumber && taxPeriodNumber.length() > 0) {
            if (taxPeriodNumber.length() != 6) {
                throw new TaskExternalException(this.getResource(ctx, "SetPeriodFormatError"));
            }
            try {
                int year = Integer.parseInt(taxPeriodNumber.substring(0, 4));
                int number = Integer.parseInt(taxPeriodNumber.substring(4, 6));
                PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)company);
                if (periodInfo == null || periodInfo.getId() == null) {
                    throw new TaskExternalException(this.getResource(ctx, "PeriodNotExists"));
                }
                checkAbs.setTaxPeriod(periodInfo);
            }
            catch (Exception e) {
                throw new TaskExternalException(this.getResource(ctx, "SetPeriodFormatError"));
            }
        }
        String remark = this.getString(hsData, "FRemark");
        head.setRemark(remark);
        return head;
    }

    private ProjectInfo getProject(Context ctx, String projectNumber) throws TaskExternalException {
        ProjectInfo project = null;
        String sql = "select top 1 fid,FNAME_l2  from T_BD_PROJECT  where FNUMBER = ?";
        if (projectNumber != null && projectNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{projectNumber});
                if (rs != null && rs.next()) {
                    project = new ProjectInfo();
                    project.setId(BOSUuid.read((String)rs.getString("fid")));
                    project.setNumber(projectNumber);
                    project.setName(rs.getString("fname_l2"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TaskExternalException(e.getMessage());
            }
            if (project == null) {
                throw new TaskExternalException(this.getResource(ctx, "ProjectNumberValid"));
            }
        }
        return project;
    }

    private SupplierInfo getSupplier(Context ctx, String supplierNumber) throws TaskExternalException {
        SupplierInfo supplierInfo = null;
        String sql = "select top 1 fid,fnumber,fname_l2,FTaxRegisterNo from t_bd_supplier where fnumber = ?";
        if (supplierNumber != null && supplierNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplierNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(this.getResource(ctx, "CurrAcctSupplierNumberValid"));
                }
                supplierInfo = new SupplierInfo();
                supplierInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                supplierInfo.setName(rs.getString("fname_l2"));
                supplierInfo.setTaxRegisterNo(rs.getString("FTaxRegisterNo"));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (UuidException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return supplierInfo;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String companyNumber) throws TaskExternalException {
        CompanyOrgUnitInfo company = null;
        if (companyNumber != null && companyNumber.length() > 0) {
            String sql = "select top 1 fid,FAccountPeriodID,fnumber,fname_l2,fisbizunit from T_ORG_COMPANY where fnumber = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyNumber});
                if (rs.next() && rs.getString("fisbizunit").equals("1")) {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("fid")));
                    company.setNumber(rs.getString("fnumber"));
                    company.setName(rs.getString("fname_l2"));
                    PeriodTypeInfo pt = new PeriodTypeInfo();
                    pt.setId(BOSUuid.read((String)rs.getString("FAccountPeriodID")));
                    company.setAccountPeriodType(pt);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (company == null) {
            throw new TaskExternalException(this.getResource(ctx, "CompanyNotExists"));
        }
        return company;
    }

    private UserInfo getUserFromNumber(Context ctx, String number) throws TaskExternalException {
        UserInfo personInfo = null;
        if (number != null && number.trim().length() > 0) {
            try {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where number='" + number + "'");
                if (users != null && users.size() > 0) {
                    personInfo = users.get(0);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return personInfo;
    }

    protected abstract SelectorItemCollection getSelector();

    protected abstract CheckInvoiceBaseInfo createNewData(Context var1);
}

