/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseImport;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CurrentAccountType;
import com.kingdee.eas.tm.common.invoicePool.NotDeductibleTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class VehicleInvoiceDataImport
extends CheckInvoiceBaseImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceDataImport");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return VehicleInvoiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    @Override
    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        VehicleInvoiceInfo head = (VehicleInvoiceInfo)super.transmit(hsData, ctx);
        this.parseHead(hsData, ctx, head);
        return head;
    }

    @Override
    protected CheckInvoiceBaseInfo parseHead(Map hsData, Context ctx, CheckInvoiceBaseInfo head) throws TaskExternalException {
        VehicleInvoiceInfo info = null;
        try {
            BigDecimal decimalRate;
            info = (VehicleInvoiceInfo)super.parseHead(hsData, ctx, head);
            info.setInvoiceType(TMInvoiceType.INVOICETYPE_VEHICLE);
            info.setSalerName(this.getString(hsData, "FSalerName"));
            info.setSalerTaxNo(this.getString(hsData, "FSalerTaxNo"));
            info.setSalerPhone(this.getString(hsData, "FSalerPhone"));
            info.setSalerAddress(this.getString(hsData, "FSalerAddress"));
            info.setSalerBankName(this.getString(hsData, "FSalerBankName"));
            info.setSalerAccount(this.getString(hsData, "FSalerAccount"));
            info.setInvoiceMoney(this.getBigDecimal(ctx, hsData, "FInvoiceMoney"));
            String taxRate = this.getString(hsData, "FTaxRate");
            if (taxRate != null && taxRate.length() > 0) {
                decimalRate = this.getBigDecimal(ctx, hsData, "FTaxRate");
                if (decimalRate.compareTo(new BigDecimal(0)) < 0 || decimalRate.compareTo(new BigDecimal(100)) >= 0) {
                    throw new TaskExternalException(this.getResource(ctx, "TaxRateNotValid"));
                }
            } else {
                throw new TaskExternalException(this.getResource(ctx, "TaxRateNotNull"));
            }
            info.setTaxRate(decimalRate.divide(new BigDecimal(100)));
            info.setTotalTaxAmount(this.getBigDecimal(ctx, hsData, "FTotalTaxAmount"));
            info.setTotalAmount(this.getBigDecimal(ctx, hsData, "FTotalAmount"));
            info.setRemark(this.getString(hsData, "FRemark"));
            info.setBuyerName(this.getString(hsData, "FBuyerName"));
            info.setBuyerCardno(this.getString(hsData, "FBuyerCardno"));
            info.setBuyerTaxNo(this.getString(hsData, "FBuyerTaxNo"));
            info.setVehicleType(this.getString(hsData, "FVehicleType"));
            info.setBrandModel(this.getString(hsData, "FBrandModel"));
            info.setProducingArea(this.getString(hsData, "FProducingArea"));
            info.setCertificateNum(this.getString(hsData, "FCertificateNum"));
            info.setImportCertificate(this.getString(hsData, "FImportCertificate"));
            info.setCommodityInspectionNum(this.getString(hsData, "FCommodityInspectionNum"));
            info.setEngineNum(this.getString(hsData, "FEngineNum"));
            info.setVehicleIdentificationCode(this.getString(hsData, "FVehicleIdentificationCode"));
            info.setTotalTon(this.getBigDecimal(ctx, hsData, "FTotalTon"));
            info.setLimitePeople(this.getBigDecimal(ctx, hsData, "FLimitePeople"));
            info.setTaxAuthorityCode(this.getString(hsData, "FTaxAuthorityCode"));
            info.setTaxAuthorityName(this.getString(hsData, "FTaxAuthorityName"));
            info.setOverTaxCode(this.getString(hsData, "FOverTaxCode"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return info;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("checkAbs.*"));
        return sic;
    }

    @Override
    protected CheckInvoiceBaseInfo createNewData(Context ctx) {
        VehicleInvoiceInfo info = new VehicleInvoiceInfo();
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        info.setSourceType(TMSourceType.EXCEL);
        return info;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putToHashtable(result, "FInvoiceDate", rs.getString("invoiceDate"));
            this.putToHashtable(result, "FInvoiceCode", rs.getString("invoiceCode"));
            this.putToHashtable(result, "FInvoiceNo", rs.getString("invoiceNo"));
            this.putToHashtable(result, "FInvoiceStatus", (Object)TMInvoiceStatus.getEnum(rs.getString("invoiceStatus")));
            this.putToHashtable(result, "FCurrentAccountType", (Object)CurrentAccountType.getEnum(rs.getString("currentAccountType")));
            this.putToHashtable(result, "FCurrAcctSupplier_number", rs.getString("currAcctSupplier.number"));
            this.putToHashtable(result, "FSalerName", rs.getString("salerName"));
            this.putToHashtable(result, "FSalerTaxNo", rs.getString("salerTaxNo"));
            this.putToHashtable(result, "FSalerPhone", rs.getString("salerPhone"));
            this.putToHashtable(result, "FSalerAddress", rs.getString("salerAddress"));
            this.putToHashtable(result, "FSalerBankName", rs.getString("salerBankName"));
            this.putToHashtable(result, "FSalerAccount", rs.getString("salerAccount"));
            this.putToHashtable(result, "FProject_number", rs.getString("project.number"));
            this.putToHashtable(result, "FInvoiceMoney", rs.getString("invoiceMoney"));
            if (rs.getBigDecimal("taxRate") != null) {
                this.putToHashtable(result, "FTaxRate", rs.getBigDecimal("taxRate").multiply(new BigDecimal(100)));
            }
            this.putToHashtable(result, "FTotalTaxAmount", rs.getString("totalTaxAmount"));
            this.putToHashtable(result, "FTotalAmount", rs.getString("totalAmount"));
            this.putToHashtable(result, "FCheckAbs_checkState", (Object)CheckStateEnum.getEnum(rs.getString("checkAbs.checkState")));
            this.putToHashtable(result, "FCheckAbs_checkTime", rs.getString("checkAbs.checkTime"));
            this.putToHashtable(result, "FCheckAbs$checkUser_number", rs.getString("checkUser.number"));
            this.putToHashtable(result, "FCheckAbs_checkPurpose", (Object)CheckPurposeEnum.getEnum(rs.getString("checkAbs.checkPurpose")));
            this.putToHashtable(result, "FCheckAbs_notDeductibleType", (Object)NotDeductibleTypeEnum.getEnum(rs.getString("checkAbs.notDeductibleType")));
            this.putToHashtable(result, "FCheckAbs_checkWay", (Object)CheckWayEnum.getEnum(rs.getString("checkAbs.checkWay")));
            this.putToHashtable(result, "FCheckAbs$taxPeriod_number", rs.getString("taxPeriod.number"));
            this.putToHashtable(result, "FCheckAbs_confirmState", (Object)ConfirmStateEnum.getEnum(rs.getString("checkAbs.confirmState")));
            this.putToHashtable(result, "FCheckAbs_confirmTime", rs.getString("checkAbs.confirmTime"));
            this.putToHashtable(result, "FCheckAbs$confirmUser_number", rs.getString("confirmUser.number"));
            this.putToHashtable(result, "FCompany_number", rs.getString("company.number"));
            this.putToHashtable(result, "FRemark", rs.getString("remark"));
            this.putToHashtable(result, "FBuyerName", rs.getString("buyerName"));
            this.putToHashtable(result, "FBuyerCardno", rs.getString("buyerCardno"));
            this.putToHashtable(result, "FBuyerTaxNo", rs.getString("buyerTaxNo"));
            this.putToHashtable(result, "FVehicleType", rs.getString("vehicleType"));
            this.putToHashtable(result, "FBrandModel", rs.getString("brandModel"));
            this.putToHashtable(result, "FProducingArea", rs.getString("producingArea"));
            this.putToHashtable(result, "FCertificateNum", rs.getString("certificateNum"));
            this.putToHashtable(result, "FImportCertificate", rs.getString("importCertificate"));
            this.putToHashtable(result, "FCommodityInspectionNum", rs.getString("commodityInspectionNum"));
            this.putToHashtable(result, "FEngineNum", rs.getString("engineNum"));
            this.putToHashtable(result, "FVehicleIdentificationCode", rs.getString("vehicleIdentificationCode"));
            this.putToHashtable(result, "FTotalTon", rs.getString("totalTon"));
            this.putToHashtable(result, "FLimitePeople", rs.getString("limitePeople"));
            this.putToHashtable(result, "FTaxAuthorityCode", rs.getString("taxAuthorityCode"));
            this.putToHashtable(result, "FTaxAuthorityName", rs.getString("taxAuthorityName"));
            this.putToHashtable(result, "FOverTaxCode", rs.getString("overTaxCode"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.common.invoicePool.app.VehicleInvoiceQuery";
    }
}

