/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils;

import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceUpdateParams;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMConstant;
import com.kingdee.eas.tm.common.utils.TMDateUtil;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;

public class InvoicePoolSql {
    public static String getPiaozoneUrl() {
        return "SELECT FDescription From T_DT_DTTempParam WHERE FKey = 'piaozoneUrl'";
    }

    public static String getBotpSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_BOT_Relation ");
        sql.append(" (FID, ");
        sql.append(" FSrcEntityID, ");
        sql.append(" FSrcObjectID, ");
        sql.append(" FDestEntityID, ");
        sql.append(" FDestObjectID, ");
        sql.append(" FOperatorID, ");
        sql.append(" FisEffected, ");
        sql.append(" FType) ");
        sql.append(" values(?,?,?,?,?,?,1,0) ");
        return sql.toString();
    }

    public static String getBizBillSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FBillBosType FROM T_TM_BizBillType ");
        sql.append(" WHERE FID = ?");
        return sql.toString();
    }

    public static String getInvoiceInfo(String tableName, boolean isEntry) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FCompanyID, FID FROM ");
        sql.append(tableName);
        if (isEntry) {
            sql.append(" WHERE FBizBillEntryID = ?");
        } else {
            sql.append(" WHERE FBizBillID = ?");
        }
        return sql.toString();
    }

    public static String getDestIDsSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FDestEntityID, FDestObjectID FROM T_BOT_Relation ");
        sql.append(" WHERE FSrcObjectID = ?");
        sql.append(" AND ");
        sql.append(" FDestEntityID in ");
        sql.append(InvoicePoolSql.getDestEntityID());
        return sql.toString();
    }

    public static String getDestIDsBatchSql(String bizBillID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FDestEntityID, FDestObjectID,FSrcObjectID FROM T_BOT_Relation ");
        sql.append(" WHERE FSrcObjectID = '");
        sql.append(bizBillID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FDestEntityID in ");
        sql.append(InvoicePoolSql.getDestEntityID());
        return sql.toString();
    }

    public static String getSrcIDsSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FSRCENTITYID, FSRCOBJECTID FROM T_BOT_Relation ");
        sql.append(" WHERE FDestOBJECTID in ({0})");
        return sql.toString();
    }

    public static String getSortVoucherInfos() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID, FPeriodID, FVoucherTypeID, FNumber, FBookedDate FROM T_GL_Voucher ");
        sql.append(" WHERE FID in ( ");
        sql.append(" SELECT FDestObjectID FROM T_BOT_Relation ");
        sql.append(" WHERE FSrcObjectID = ?");
        sql.append(" AND ");
        sql.append(" FDestEntityID = '2652E01E' ");
        sql.append(" ) Order By FBookedDate ");
        return sql.toString();
    }

    public static String getSortVoucherInfos(String bizBillID) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID, FPeriodID, FVoucherTypeID, FNumber ,FBookedDate FROM T_GL_Voucher ");
        sql.append(" WHERE FID in ( ");
        sql.append(" SELECT FDestObjectID FROM T_BOT_Relation ");
        sql.append(" WHERE FSrcObjectID = '");
        sql.append(bizBillID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FDestEntityID = '2652E01E' ");
        sql.append(" ) Order By FBookedDate ");
        return sql.toString();
    }

    public static String getUpdatePoolSql(InvoiceUpdateParams invoiceUpdateParams, List<Object> paramList) {
        boolean needUpdate = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ");
        sql.append(invoiceUpdateParams.getTableName());
        sql.append(" SET ");
        if (invoiceUpdateParams.getIsPayment() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FIsPayment = ?");
            needUpdate = true;
            paramList.add(Integer.parseInt(invoiceUpdateParams.getIsPayment()));
        }
        if (invoiceUpdateParams.getIsDeduct() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            String isDeduct = invoiceUpdateParams.getIsDeduct();
            if (TMConstant.UPDATE_POOL_TABLE_MAP.containsValue(invoiceUpdateParams.getTableName())) {
                if ("0".equals(isDeduct)) {
                    isDeduct = "2";
                }
                sql.append(" fiDeduct = ?");
            } else {
                sql.append(" FIsDeduct = ?");
            }
            needUpdate = true;
            paramList.add(isDeduct);
        }
        if (invoiceUpdateParams.getDeductTaxAmt() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FDeductTaxAmt = ?");
            needUpdate = true;
            paramList.add(invoiceUpdateParams.getDeductTaxAmt());
        }
        if (TMConstant.UPDATE_POOL_TABLE_MAP.containsValue(invoiceUpdateParams.getTableName())) {
            if (invoiceUpdateParams.getIncomeTypeID() != null) {
                if (needUpdate) {
                    sql.append(", ");
                }
                sql.append(" FIncomeTypeID = ?");
                needUpdate = true;
                paramList.add(invoiceUpdateParams.getIncomeTypeID());
            }
            if (invoiceUpdateParams.getTransferAmount() != null) {
                if (needUpdate) {
                    sql.append(", ");
                }
                sql.append(" FUnTransferTaxAmt = ?");
                needUpdate = true;
                paramList.add(invoiceUpdateParams.getTransferAmount());
            }
            if (invoiceUpdateParams.getTransferItemID() != null) {
                if (needUpdate) {
                    sql.append(", ");
                }
                sql.append(" FTaxTransferItemID = ?");
                needUpdate = true;
                paramList.add(invoiceUpdateParams.getTransferItemID());
            }
            if (invoiceUpdateParams.getIsAccept() != null) {
                if (needUpdate) {
                    sql.append(", ");
                }
                sql.append(" FIsAccept = ?");
                needUpdate = true;
                paramList.add(Integer.parseInt(invoiceUpdateParams.getIsAccept()));
            }
            if (invoiceUpdateParams.getAcceptInvoiceDate() != null) {
                if (needUpdate) {
                    sql.append(", ");
                }
                sql.append(" FAcceptInvoiceDate = ?");
                needUpdate = true;
                paramList.add(TMDateUtil.getSqlDate(invoiceUpdateParams.getAcceptInvoiceDate()));
            }
            if (invoiceUpdateParams.getAcceptUserID() != null) {
                if (needUpdate) {
                    sql.append(", ");
                }
                sql.append(" FAcceptUserID = ? ");
                needUpdate = true;
                paramList.add(invoiceUpdateParams.getAcceptUserID());
            }
        }
        sql.append("\r\n");
        sql.append(" WHERE FID = ?");
        paramList.add(invoiceUpdateParams.getInvoiceID());
        return needUpdate ? sql.toString() : null;
    }

    public static String getDeleteBOTPSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM T_BOT_Relation");
        sql.append(" WHERE FSrcObjectID = ?");
        sql.append(" AND ");
        sql.append(" FDestEntityID in ");
        sql.append(InvoicePoolSql.getDestEntityID());
        return sql.toString();
    }

    public static String getDestEntityID() {
        List<String> ids = TMPwyHelperUtils.getInvoiePoolBosType();
        return TMCommonUtil.getInStringFromList(ids);
    }

    public static String getClearIncomeInfoSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_INCOMEINVOICE SET  ");
        sql.append(" FBizBillID = null,");
        sql.append(" FBizBillEntryID = null,");
        sql.append(" FBizBillNumber = null,");
        sql.append(" FBizBillTypeID = null,");
        sql.append(" FIsPayment = null,");
        sql.append(" FIsDeduct = null,");
        sql.append(" FDeductTaxAmt = null,");
        sql.append(" FUnTransferTaxAmt = null,");
        sql.append(" FTaxTransferItemID = null,");
        sql.append(" FReBusiness = null,");
        sql.append(" FBizVoucherID = null,");
        sql.append(" FBizVoucherNumber = null,");
        sql.append(" FBizVoucherPeriodID = null,");
        sql.append(" FBizVoucherTypeID = null");
        sql.append("\r\n");
        sql.append(" WHERE FID in ({0})");
        return sql.toString();
    }

    public static String getClearPoolInfoSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE " + tableName + " SET  ");
        sql.append(" FBizBillID = null,");
        sql.append(" FBizBillEntryID = null,");
        sql.append(" FBizBillNumber = null,");
        sql.append(" FBizBillTypeID = null,");
        sql.append(" FIsPayment = 0,");
        sql.append(" FIsDeduct = 0,");
        sql.append(" FDeductTaxAmt = null,");
        if (TMConstant.UPDATE_POOL_TABLE_MAP.containsValue(tableName)) {
            sql.append(" FUnTransferTaxAmt = null,");
            sql.append(" FTaxTransferItemNumber = null,");
            sql.append(" FTaxTransferItemName = null,");
            sql.append(" FTaxTransferItemID = null,");
        }
        sql.append(" FIsBusiness = 0,");
        sql.append(" FVoucherID = null,");
        sql.append(" FVoucherNumber = null,");
        sql.append(" FVoucherPeriodID = null,");
        sql.append(" FVoucherTypeID = null");
        sql.append("\r\n");
        sql.append(" WHERE FID in ({0})");
        return sql.toString();
    }

    public static String getUpdateIncomeSql(InvoiceUpdateParams invoiceUpdateParams, List<Object> paramList) {
        boolean needUpdate = false;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_INCOMEINVOICE SET  ");
        if (invoiceUpdateParams.getIsPayment() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FIsPayment = ?");
            needUpdate = true;
            paramList.add(Integer.parseInt(invoiceUpdateParams.getIsPayment()));
        }
        if (invoiceUpdateParams.getIsDeduct() != null) {
            String isDeduct;
            if (needUpdate) {
                sql.append(", ");
            }
            if ("0".equals(isDeduct = invoiceUpdateParams.getIsDeduct())) {
                isDeduct = "2";
            }
            sql.append(" FIsDeduct = ? ");
            needUpdate = true;
            paramList.add(isDeduct);
        }
        if (invoiceUpdateParams.getDeductTaxAmt() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FDeductTaxAmt = ?");
            needUpdate = true;
            paramList.add(invoiceUpdateParams.getDeductTaxAmt());
        }
        if (invoiceUpdateParams.getIncomeTypeID() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FIncomeTypeID = ? ");
            needUpdate = true;
            paramList.add(invoiceUpdateParams.getIncomeTypeID());
        }
        if (invoiceUpdateParams.getTransferAmount() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FUnTransferTaxAmt = ? ");
            needUpdate = true;
            paramList.add(invoiceUpdateParams.getTransferAmount());
        }
        if (invoiceUpdateParams.getTransferItemID() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FTaxTransferItemID = ?");
            needUpdate = true;
            paramList.add(invoiceUpdateParams.getTransferItemID());
        }
        if (invoiceUpdateParams.getIsAccept() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FIsAccept = ? ");
            needUpdate = true;
            paramList.add(Integer.parseInt(invoiceUpdateParams.getIsAccept()));
        }
        if (invoiceUpdateParams.getAcceptInvoiceDate() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FAcceptInvoiceDate = ? ");
            needUpdate = true;
            paramList.add(TMDateUtil.getSqlDate(invoiceUpdateParams.getAcceptInvoiceDate()));
        }
        if (invoiceUpdateParams.getAcceptUserID() != null) {
            if (needUpdate) {
                sql.append(", ");
            }
            sql.append(" FAcceptUserID = ? ");
            needUpdate = true;
            paramList.add(invoiceUpdateParams.getAcceptUserID());
        }
        sql.append("\r\n");
        sql.append(" WHERE FID = ?");
        paramList.add(invoiceUpdateParams.getInvoiceID());
        return needUpdate ? sql.toString() : null;
    }

    public static String getUpdateIncomeVoucherSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_INCOMEINVOICE ");
        sql.append(" SET ");
        sql.append(" FReBusiness = {0}");
        sql.append(" , FBizVoucherID = {1}");
        sql.append(" , FBizVoucherPeriodID = {2}");
        sql.append(" , FBizVoucherTypeID = {3}");
        sql.append(" , FBizVoucherNumber = {4}");
        sql.append(" WHERE FID in ({5})");
        return sql.toString();
    }

    public static String getUpdateVoucherSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        sql.append(" FIsBusiness = {0}, ");
        sql.append(" FVoucherID = {1}, ");
        sql.append(" FVoucherPeriodID = {2}, ");
        sql.append(" FVoucherTypeID = {3}, ");
        sql.append(" FVoucherNumber = {4} ");
        sql.append(" WHERE FID in ({5})");
        return sql.toString();
    }

    public static String getVoucherNumberSql(String tableName) {
        String fVoucherNumber = "FVoucherNumber";
        if ("T_IM_INCOMEINVOICE".equalsIgnoreCase(tableName)) {
            fVoucherNumber = "FBizVoucherNumber";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  ");
        sql.append(fVoucherNumber).append(" FVoucherNumber");
        sql.append(" FROM ").append(tableName);
        sql.append(" WHERE FID = ?");
        return sql.toString();
    }

    public static String getVoucherNumberSql(String tableName, String id) {
        String fVoucherNumber = "FVoucherNumber";
        if ("t_im_incomeinvoice".equalsIgnoreCase(tableName)) {
            fVoucherNumber = "FBizVoucherNumber";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  ");
        sql.append(fVoucherNumber).append(" as FVoucherNumber ");
        sql.append(" FROM ").append(tableName);
        sql.append(" WHERE FID = ");
        sql.append(" '").append(id).append("'");
        return sql.toString();
    }

    public static String getBillVoucherSql(String tableName, String id) {
        String fvoucherId = "FVoucherID";
        String fVoucherNumber = "FVoucherNumber";
        if ("t_im_incomeinvoice".equalsIgnoreCase(tableName)) {
            fvoucherId = "FBizVoucherID";
            fVoucherNumber = "FBizVoucherNumber";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  ");
        sql.append(fvoucherId).append(" as FVoucherID, ");
        sql.append(fVoucherNumber).append(" as FVoucherNumber ");
        sql.append(" FROM ").append(tableName);
        sql.append(" WHERE FID = ");
        sql.append(" '").append(id).append("'");
        return sql.toString();
    }

    public static String getVoucherInfoByNumber() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  FID, FPeriodID, FVoucherTypeID, FNumber FROM T_GL_Voucher ");
        sql.append(" WHERE FNumber = ?");
        return sql.toString();
    }

    public static String getUpdateIncomeInfoSql(String idStr, Map sqlParams) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_INCOMEINVOICE SET  ");
        if (sqlParams != null && sqlParams.containsKey("incomeTypeID")) {
            sql.append(" FIsDeduct = (").append("CASE FInvoiceType WHEN '1' THEN '1' WHEN '3' THEN '1' ELSE '2' END").append("),");
            sql.append(" FDeductTaxAmt = (").append("CASE FInvoiceType WHEN '1' THEN FTax WHEN '3' THEN FTax ELSE null END").append("),");
            sql.append(" FIncomeTypeID = '").append(sqlParams.get("incomeTypeID")).append("'");
        } else {
            sql.append(" FIsDeduct = null,");
            sql.append(" FDeductTaxAmt = null,");
            sql.append(" FIncomeTypeID = null");
        }
        sql.append("\r\n");
        sql.append(" WHERE FID in ");
        sql.append(idStr);
        return sql.toString();
    }

    public static String getUpdatePoolInfoSql(String tableName, String idStr, Map sqlParams) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE " + tableName + " SET  ");
        if (sqlParams != null && sqlParams.containsKey("incomeTypeID")) {
            sql.append(" FIDeduct = (").append("CASE FInvoiceType WHEN '26' THEN '2' ELSE '1' END").append("),");
            sql.append(" FDeductTaxAmt = (").append("CASE FInvoiceType WHEN '26' THEN null ELSE FTotalTaxAmount END").append("),");
            sql.append(" FIncomeTypeID = '").append(sqlParams.get("incomeTypeID")).append("',");
            if (!StringUtils.isEmpty((String)((String)sqlParams.get("incomeTypeID")))) {
                sql.append(" FIncomeTypeName = (").append("select FName from T_TM_IncomeType where FID = '").append(sqlParams.get("incomeTypeID")).append("'),");
                sql.append(" FIncomeTypeNumber = (").append("select FNumber from T_TM_IncomeType where FID = '").append(sqlParams.get("incomeTypeID")).append("')");
            } else {
                sql.append(" FIncomeTypeName = null,");
                sql.append(" FIncomeTypeNumber = null");
            }
        } else {
            sql.append(" FIDeduct = null,");
            sql.append(" FDeductTaxAmt = null,");
            sql.append(" FIncomeTypeID = null,");
            sql.append(" FIncomeTypeName = null,");
            sql.append(" FIncomeTypeNumber = null");
        }
        sql.append("\r\n");
        sql.append(" WHERE FID in ");
        sql.append(idStr);
        return sql.toString();
    }
}

