/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.IncomeInvoiceHelper;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceBizParams;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolSql;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceUpdateParams;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMConstant;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InvoicePoolSqlExecutor {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("InvoicePoolSqlExecutor");
    private static final String FOPERATORID = "InvoicePool";
    private Context ctx;
    private Connection conn = null;
    private Statement statement = null;
    private PreparedStatement pstmt = null;
    private ResultSet rs = null;
    private ArrayList<Object[]> botpList = new ArrayList();

    public InvoicePoolSqlExecutor(Context ctx) throws BOSException {
        this.ctx = ctx;
        try {
            this.conn = EJBFactory.getConnection((Context)this.ctx);
            this.statement = this.conn.createStatement();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), e);
            SQLUtils.cleanup((Connection)this.conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
    }

    public void execute(String sql) {
        try {
            this.statement.execute(sql);
        }
        catch (SQLException e) {
            logger.error(e);
        }
    }

    public String getBaseURL() {
        String baseURL = "https://api.piaozone.com";
        try {
            IRowSet rs = TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getPiaozoneUrl());
            if (rs.next()) {
                baseURL = rs.getString("FDescription");
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return baseURL;
    }

    public String getBizBillBosType(String bizBillTypeID) {
        try {
            IRowSet rs = TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getBizBillSql(), new Object[]{bizBillTypeID});
            if (rs.next()) {
                return rs.getString("FBillBosType");
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return "unknow";
    }

    public Map<String, ArrayList> getAllInvoiceIds(String bizBillID) {
        HashMap<String, ArrayList> result = new HashMap<String, ArrayList>();
        try {
            IRowSet rs = TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getDestIDsSql(), new Object[]{bizBillID});
            ArrayList<String> ids = null;
            while (rs.next()) {
                String bosType = rs.getString("FDestEntityID");
                if (result.containsKey(bosType)) {
                    ((ArrayList)result.get(bosType)).add(rs.getString("FDestObjectID"));
                    continue;
                }
                ids = new ArrayList<String>();
                ids.add(rs.getString("FDestObjectID"));
                result.put(bosType, ids);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return result;
    }

    public Map<String, String> getInvoiceInfo(String tableName, InvoiceBizParams bizParams) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            IRowSet rs = null;
            String bizBillID = bizParams.getBizBillID();
            String entryID = bizParams.getEntryID();
            rs = entryID != null ? TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getInvoiceInfo(tableName, true), new Object[]{entryID}) : TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getInvoiceInfo(tableName, false), new Object[]{bizBillID});
            while (rs.next()) {
                result.put("invoiceID", rs.getString("FID"));
                result.put("companyID", rs.getString("FCompanyID"));
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return result;
    }

    public void deleteInvoiceAndBOTP(String srcObjectID, Map<String, ArrayList> invoiceIdMap) {
        try {
            ArrayList ids = null;
            for (String bosType : invoiceIdMap.keySet()) {
                ids = invoiceIdMap.get(bosType);
                if (IncomeInvoiceHelper.isSupport() && PoolConstant.BOSTYPE_INCOMEINVOICE.equals(bosType)) {
                    TMSqlUtil.executeNotInject(this.ctx, InvoicePoolSql.getClearIncomeInfoSql(), new Object[]{ids});
                    continue;
                }
                String tableName = TMConstant.INVOICE_TABLE_MAP.get(bosType);
                TMSqlUtil.executeNotInject(this.ctx, InvoicePoolSql.getClearPoolInfoSql(tableName), new Object[]{ids});
            }
            TMSqlUtil.execute(this.ctx, InvoicePoolSql.getDeleteBOTPSql(), new Object[]{srcObjectID});
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public void batchUpdateInvoice(List<InvoiceUpdateParams> updateParamsList) throws BOSException {
        InvoiceUpdateParams invoiceUpdateParams = null;
        ArrayList<Object> updateParamList = null;
        String updateInvoiceSql = null;
        for (int i = 0; i < updateParamsList.size(); ++i) {
            invoiceUpdateParams = updateParamsList.get(i);
            if ("T_IM_IncomeInvoice".equals(invoiceUpdateParams.getTableName())) {
                if (!IncomeInvoiceHelper.isSupport() || (updateInvoiceSql = InvoicePoolSql.getUpdateIncomeSql(invoiceUpdateParams, updateParamList = new ArrayList())) == null) continue;
                TMSqlUtil.execute(this.ctx, updateInvoiceSql, updateParamList.toArray());
                continue;
            }
            updateParamList = new ArrayList<Object>();
            updateInvoiceSql = InvoicePoolSql.getUpdatePoolSql(invoiceUpdateParams, updateParamList);
            if (updateInvoiceSql == null) continue;
            TMSqlUtil.execute(this.ctx, updateInvoiceSql, updateParamList.toArray());
        }
    }

    public Map<String, VoucherInfo> getVoucherInfos(String bizBillID) {
        LinkedHashMap<String, VoucherInfo> voucherMap = new LinkedHashMap<String, VoucherInfo>();
        try {
            this.rs = this.statement.executeQuery(InvoicePoolSql.getSortVoucherInfos(bizBillID));
            VoucherInfo voucherInfo = null;
            PeriodInfo periodInfo = null;
            VoucherTypeInfo voucherTypeInfo = null;
            while (this.rs.next()) {
                voucherInfo = new VoucherInfo();
                voucherInfo.setId(BOSUuid.read((String)this.rs.getString("FID")));
                voucherInfo.setNumber(this.rs.getString("FNumber"));
                voucherInfo.setBookedDate((Date)this.rs.getDate("FBookedDate"));
                periodInfo = new PeriodInfo();
                periodInfo.setId(BOSUuid.read((String)this.rs.getString("FPeriodID")));
                voucherInfo.setPeriod(periodInfo);
                voucherTypeInfo = new VoucherTypeInfo();
                voucherTypeInfo.setId(BOSUuid.read((String)this.rs.getString("FVoucherTypeID")));
                voucherInfo.setVoucherType(voucherTypeInfo);
                voucherMap.put(voucherInfo.getId().toString(), voucherInfo);
            }
        }
        catch (SQLException e) {
            logger.error(e);
        }
        return voucherMap;
    }

    public IRowSet getSrcBills(Set destIDSet) {
        IRowSet rs = null;
        try {
            rs = TMSqlUtil.executeQueryNotInject(this.ctx, InvoicePoolSql.getSrcIDsSql(), new Object[]{destIDSet});
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return rs;
    }

    public void updateVoucherInfo(Map<String, ArrayList> invoiceIds, InvoiceUpdateParams params) {
        try {
            for (String bosType : invoiceIds.keySet()) {
                ArrayList ids = invoiceIds.get(bosType);
                if (IncomeInvoiceHelper.isSupport() && PoolConstant.BOSTYPE_INCOMEINVOICE.equals(bosType)) {
                    TMSqlUtil.executeNotInject(this.ctx, InvoicePoolSql.getUpdateIncomeVoucherSql(), new Object[]{params.getIsBusiness(), params.getVoucherID(), params.getVoucherPeriodID(), params.getVoucherTypeID(), params.getVoucherNumber(), ids});
                    continue;
                }
                String tableName = TMConstant.INVOICE_TABLE_MAP.get(bosType);
                if (tableName.isEmpty()) continue;
                TMSqlUtil.executeNotInject(this.ctx, InvoicePoolSql.getUpdateVoucherSql(tableName), new Object[]{params.getIsBusiness(), params.getVoucherID(), params.getVoucherPeriodID(), params.getVoucherTypeID(), params.getVoucherNumber(), ids});
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    public String getVoucherNumber(Map<String, ArrayList> invoiceIds) {
        String voucherNumber = "";
        try {
            IRowSet rs = null;
            for (String bosType : invoiceIds.keySet()) {
                String tableName;
                ArrayList ids = invoiceIds.get(bosType);
                if (!(IncomeInvoiceHelper.isSupport() && PoolConstant.BOSTYPE_INCOMEINVOICE.equals(bosType) ? (rs = TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getVoucherNumberSql("T_IM_INCOMEINVOICE"), new Object[]{ids.get(0).toString()})).next() : !(tableName = TMConstant.INVOICE_TABLE_MAP.get(bosType)).isEmpty() && (rs = TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getVoucherNumberSql(tableName), new Object[]{ids.get(0).toString()})).next())) continue;
                return rs.getString("FVoucherNumber");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return voucherNumber;
    }

    public Map<String, String> getBillVoucherMap(Map<String, ArrayList> invoiceIds) {
        HashMap<String, String> vourcherMap = new HashMap<String, String>();
        try {
            String voucherId = null;
            String voucherNumber = null;
            for (String bosType : invoiceIds.keySet()) {
                ArrayList ids = invoiceIds.get(bosType);
                if (IncomeInvoiceHelper.isSupport() && PoolConstant.BOSTYPE_INCOMEINVOICE.equals(bosType)) {
                    this.rs = this.statement.executeQuery(InvoicePoolSql.getBillVoucherSql("t_im_incomeinvoice", ids.get(0).toString()));
                    if (!this.rs.next()) continue;
                    voucherId = this.rs.getString("FVoucherID");
                    voucherNumber = this.rs.getString("FVoucherNumber");
                    break;
                }
                String tableName = this.getTableNameByBosType(bosType);
                if (tableName.isEmpty()) continue;
                this.rs = this.statement.executeQuery(InvoicePoolSql.getBillVoucherSql(tableName, ids.get(0).toString()));
                if (!this.rs.next()) continue;
                voucherId = this.rs.getString("FVoucherID");
                voucherNumber = this.rs.getString("FVoucherNumber");
                break;
            }
            vourcherMap.put("voucherId", voucherId);
            vourcherMap.put("voucherNumber", voucherNumber);
        }
        catch (SQLException e) {
            logger.error(e);
        }
        return vourcherMap;
    }

    public Map<String, String> getVoucherInfoByNumber(String voucherNumber) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            IRowSet rs = TMSqlUtil.executeQuery(this.ctx, InvoicePoolSql.getVoucherInfoByNumber(), new Object[]{voucherNumber});
            if (rs.next()) {
                resultMap.put("FID", rs.getString("FID"));
                resultMap.put("FPeriodID", rs.getString("FPeriodID"));
                resultMap.put("FVoucherTypeID", rs.getString("FVoucherTypeID"));
                resultMap.put("FNumber", rs.getString("FNumber"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return resultMap;
    }

    public void addBotpList(String srcEntityID, String srcObjectID, String destEntityID, String destObjectID) {
        Object[] botpFields = new Object[]{BOSUuid.create((String)"59302EC6").toString(), srcEntityID, srcObjectID, destEntityID, destObjectID, FOPERATORID};
        this.botpList.add(botpFields);
    }

    public void buildBotpRelations() {
        if (this.botpList.size() > 0) {
            try {
                TMSqlUtil.executeBatch(this.ctx, InvoicePoolSql.getBotpSql(), this.botpList);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public void updateInvoiceFields(String srcObjectID, Map<String, Set> bosTypeIDMap, Map sqlParams) {
        try {
            ArrayList<String> sqls = new ArrayList<String>();
            for (String bosType : bosTypeIDMap.keySet()) {
                Set ids = bosTypeIDMap.get(bosType);
                if (IncomeInvoiceHelper.isSupport() && PoolConstant.BOSTYPE_INCOMEINVOICE.equals(bosType)) {
                    sqls.add(InvoicePoolSql.getUpdateIncomeInfoSql(TMCommonUtil.getInStringFromSet(ids), sqlParams));
                    continue;
                }
                if (!"1343913D".equals(bosType) && !"AF83503C".equals(bosType) && !"8F9D8961".equals(bosType)) continue;
                String tableName = TMConstant.INVOICE_TABLE_MAP.get(bosType);
                sqls.add(InvoicePoolSql.getUpdatePoolInfoSql(tableName, TMCommonUtil.getInStringFromSet(ids), sqlParams));
            }
            TMSqlUtil.executeBatch(this.ctx, sqls.toArray(new String[sqls.size()]));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private String getTableNameByBosType(String bosType) {
        return TMPwyHelperUtils.getTableNameByBosType(bosType);
    }

    private String getEntryTableNameByBosType(String bosType) {
        return TMPwyHelperUtils.getEntryTableNameByBosType(bosType);
    }

    public void updateInvoiceFields(String billId, Map<String, Set> bosTypeIDMap) {
        this.updateInvoiceFields(billId, bosTypeIDMap, null);
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.pstmt != null) {
                this.pstmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), e);
        }
    }
}

