/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolService;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PoolDownloadInvoiceHelper {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("PoolDownloadInvoiceHelper");

    public static List parseDownLoadInvoice(Context ctx, String queryResult, DownloadInvoiceParams downloadParams) throws BOSException {
        ArrayList<IObjectValue> invoiceList = new ArrayList<IObjectValue>();
        try {
            JSONObject queryResultJson = new JSONObject(queryResult);
            String errorCode = PoolDownloadInvoiceHelper.getErrorCode(queryResultJson);
            if ("0000".equals(errorCode)) {
                JSONArray invoiceArray = queryResultJson.getJSONArray("data");
                if (invoiceArray != null && invoiceArray.length() > 0) {
                    IObjectValue obj = null;
                    int size = invoiceArray.length();
                    for (int i = 0; i < size; ++i) {
                        JSONObject jsonObject = invoiceArray.getJSONObject(i);
                        String invoiceType = jsonObject.getString("invoiceType");
                        if (PoolDownloadInvoiceHelper.filterInvoice(jsonObject, downloadParams)) continue;
                        AbstractConverter converter = InvoicePoolService.getConverter(ctx, downloadParams, jsonObject, invoiceType);
                        converter.parseInvoice();
                        if (converter.getModel() == null) continue;
                        obj = converter.getModel();
                        invoiceList.add(obj);
                    }
                } else {
                    logger.error(" downLoadInvoice: no data " + queryResultJson);
                }
            }
        }
        catch (Exception e) {
            logger.error(" downLoadInvoice: parse error " + queryResult, e);
        }
        try {
            Map imTempParams = TMCommonUtil.getIMTempParamByKey(ctx, new String[]{"isSendBMCMessage"});
            BillBaseInfo invoiceInfo = null;
            Object statusChaged = null;
            if (imTempParams != null && "1".equals((String)imTempParams.get("isSendBMCMessage"))) {
                int i;
                String title = TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "INVOICESTATUS_CHANGE_WARNING", ctx);
                StringBuffer bmcMsg = new StringBuffer();
                HashSet<String> companyIds = new HashSet<String>();
                HashMap<String, String> compangCache = new HashMap<String, String>();
                int size = invoiceList.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    invoiceInfo = (BillBaseInfo)invoiceList.get(i2);
                    companyIds.add(invoiceInfo.getCompany().getId().toString());
                }
                CompanyOrgUnitInfo company = null;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(viewInfo);
                int size2 = coll.size();
                for (i = 0; i < size2; ++i) {
                    company = coll.get(i);
                    compangCache.put(company.getId().toString(), company.getName());
                }
                size2 = invoiceList.size();
                for (i = 0; i < size2; ++i) {
                    invoiceInfo = (BillBaseInfo)invoiceList.get(i);
                    statusChaged = invoiceInfo.get("statusChaged");
                    if (statusChaged == null || !Boolean.parseBoolean(statusChaged.toString())) continue;
                    if (invoiceInfo instanceof InvoiceBaseInfo) {
                        bmcMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "STATUS_WARNING_CONTENT", ctx.getLocale(), new Object[]{compangCache.get(invoiceInfo.getCompany().getId().toString()), invoiceInfo.get("invoiceCode") + "_" + invoiceInfo.get("invoiceNo"), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
                        continue;
                    }
                    bmcMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "STATUS_WARNING_CONTENT", ctx.getLocale(), new Object[]{compangCache.get(invoiceInfo.getCompany().getId().toString()), invoiceInfo.get("invoiceCode") + "_" + invoiceInfo.get("invoiceNumber"), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
                }
                if (bmcMsg.length() > 0) {
                    TMCommonUtil.sendBMCMsg(ctx, bmcMsg.toString(), title, MsgBizType.FORWARN, ctx.getCaller().toString());
                    if (!"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(ctx.getCaller().toString())) {
                        TMCommonUtil.sendBMCMsg(ctx, bmcMsg.toString(), title, MsgBizType.FORWARN, "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(" downLoadInvoice: sendBMCMsg error " + e);
        }
        return invoiceList;
    }

    private static String getErrorCode(JSONObject queryResultJson) throws JSONException {
        String errcode = queryResultJson.optString("errcode");
        if (!StringUtils.isEmpty((String)errcode)) {
            return errcode;
        }
        return queryResultJson.optString("errorCode");
    }

    public static IObjectValue parseCheckInvoice(Context ctx, String queryResult, DownloadInvoiceParams downloadParams) throws BOSException {
        IObjectValue value = null;
        try {
            JSONObject queryResultJson = new JSONObject(queryResult);
            String errorCode = queryResultJson.getString("errcode");
            if ("0000".equals(errorCode)) {
                JSONObject jsonObject = queryResultJson.getJSONObject("data");
                String invoiceType = jsonObject.getString("invoiceType");
                AbstractConverter converter = InvoicePoolService.getConverter(ctx, downloadParams, jsonObject, invoiceType);
                converter.parseInvoice();
                value = converter.getModel();
            }
        }
        catch (Exception e) {
            logger.error(" checkInvoice: parse error " + queryResult, e);
        }
        return value;
    }

    private static boolean filterInvoice(JSONObject jsonObject, DownloadInvoiceParams downloadParams) throws JSONException {
        return PoolDownloadInvoiceHelper.filterInvoiceStatus(jsonObject, downloadParams) || PoolDownloadInvoiceHelper.filterInvoiceType(jsonObject, downloadParams);
    }

    private static boolean filterInvoiceStatus(JSONObject jsonObject, DownloadInvoiceParams downloadParams) throws JSONException {
        if (DownloadInvoiceType.PWYHELP.equals((Object)downloadParams.getSrcType())) {
            return false;
        }
        if (jsonObject.has("invoiceStatus")) {
            String invoiceStatus = jsonObject.getString("invoiceStatus");
            String status = (String)downloadParams.get("status");
            HashMap pwyData = new HashMap();
            if (downloadParams.get("pwyData") != null && downloadParams.get("pwyData") instanceof HashMap) {
                pwyData = (HashMap)downloadParams.get("pwyData");
            } else if (downloadParams.get("pwyData") != null && downloadParams.get("pwyData") instanceof LinkedTreeMap) {
                pwyData = (LinkedTreeMap)downloadParams.get("pwyData");
            }
            if (!StringUtils.isEmpty((String)((String)pwyData.get("invoiceNo"))) || !StringUtils.isEmpty((String)((String)pwyData.get("invoiceNumber")))) {
                return false;
            }
            if (!StringUtils.isEmpty((String)status)) {
                List statusList = new ArrayList();
                statusList = Arrays.asList((Object[])status.split(","));
                if (!statusList.contains(invoiceStatus)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean filterInvoiceType(JSONObject jsonObject, DownloadInvoiceParams downloadParams) throws JSONException {
        if (jsonObject.has("invoiceType")) {
            List invoiceTypeList;
            String invoiceType = jsonObject.getString("invoiceType");
            if (downloadParams.isNeedFilterSave() && !StringUtils.isEmpty((String)downloadParams.getInvoiceType()) && !(invoiceTypeList = Arrays.asList((Object[])downloadParams.getInvoiceType().split(","))).contains(invoiceType)) {
                return true;
            }
        }
        return false;
    }
}

