/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.common.invoicePool.CheckInvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMCheckStatus;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMJsonParser;

public abstract class AbstractCheckConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("AbstractCheckConverter");
    protected DownloadInvoiceParams params;

    public AbstractCheckConverter(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
        this.params = params;
    }

    @Override
    protected void init() {
        try {
            String invoiceCode = this.parser.getString("invoiceCode");
            String invoiceNo = this.parser.getString("invoiceNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    protected void innerParse() {
        if (!(this.model instanceof CheckInvoiceBaseInfo)) {
            return;
        }
        String serialNo = this.parser.getString("serialNo");
        this.model.setSerialNo(serialNo);
        this.model.setInvoiceType((TMInvoiceType)this.parser.getEnum(TMInvoiceType.class, "invoiceType"));
        String invoiceCode = this.parser.getString("invoiceCode");
        this.model.setInvoiceCode(invoiceCode);
        String invoiceNo = this.parser.getString("invoiceNo");
        this.model.setInvoiceNo(invoiceNo);
        this.model.setInvoiceDate(this.parser.getDate("invoiceDate"));
        this.model.setCheckStatus(TMCheckStatus.PASS);
        this.model.setNumber(invoiceCode + "_" + invoiceNo);
        String remark = TMJsonParser.handleDescription(this.parser.getString("remark"));
        this.model.setDescription(remark);
    }
}

