/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.ExtendInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.ExtendInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceStatusCollection;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceStatusFactory;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceStatusInfo;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeCollection;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeFactory;
import com.kingdee.eas.tm.common.invoicePool.ExtendTMInvoiceTypeInfo;
import com.kingdee.eas.tm.common.invoicePool.IExtendTMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.IExtendTMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class ExtendInvoiceConverter
extends AbstractConverter {
    public ExtendInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        super.init();
        if (this.model == null) {
            this.model = new ExtendInvoiceInfo();
        }
        this.logger = TMLoggerFactory.getTraceLogger("ExtendInvoiceConverter");
    }

    @Override
    public void parse() {
        ExtendInvoiceInfo invoice = (ExtendInvoiceInfo)this.model;
        invoice.setCheckCode(this.parser.getString("checkCode"));
        invoice.setSalerName(this.parser.getString("salerName"));
        invoice.setSalerTaxNo(this.parser.getString("salerTaxNo"));
        invoice.setBuyerName(this.parser.getString("buyerName"));
        invoice.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoice.setInvoiceAmount(this.parser.getBigDecimal("invoiceAmount"));
        invoice.setTotalTaxAmount(this.parser.getBigDecimal("totalTaxAmount"));
        if (invoice.getBizDate() == null) {
            invoice.setBizDate(new Date());
        }
        invoice.setIsDeduct(this.parser.getBoolean("canBeDeduction"));
        this.handleSpecialField(invoice);
        this.parseCheckAbs(invoice);
        String customDeclarationNo = this.parser.getString("customDeclarationNo");
        if (StringUtils.isEmpty((String)invoice.getInvoiceNo()) && !StringUtils.isEmpty((String)customDeclarationNo)) {
            invoice.setInvoiceNo(customDeclarationNo);
            invoice.setNumber(customDeclarationNo);
        }
    }

    private void handleSpecialField(ExtendInvoiceInfo invoice) {
        String invoiceStatus = this.parser.getString("invoiceStatus");
        String invoiceStatusDes = this.parser.getString("invoiceStatusDes");
        String invoiceType = this.parser.getString("invoiceType");
        String invoiceTypeDes = this.parser.getString("invoiceTypeDes");
        try {
            if (!StringUtils.isEmpty((String)invoiceStatus)) {
                IExtendTMInvoiceStatus iExtendTMInvoiceStatus = ExtendTMInvoiceStatusFactory.getLocalInstance(this.ctx);
                ExtendTMInvoiceStatusCollection statusCol = iExtendTMInvoiceStatus.getExtendTMInvoiceStatusCollection("where number='" + invoiceStatus + "'");
                ExtendTMInvoiceStatusInfo curStatusInfo = null;
                ExtendTMInvoiceStatusInfo oldStatusInfo = null;
                if (invoice.getExtendInvoiceStatus() != null && invoice.getExtendInvoiceStatus().getId() != null) {
                    oldStatusInfo = iExtendTMInvoiceStatus.getExtendTMInvoiceStatusInfo((IObjectPK)new ObjectUuidPK(invoice.getExtendInvoiceStatus().getId()));
                }
                if (statusCol.isEmpty()) {
                    if (oldStatusInfo != null) {
                        invoice.put("statusChaged", true);
                        invoice.put("oldStatus", oldStatusInfo.getName());
                        invoice.put("CurStatus", invoiceStatusDes);
                    }
                    curStatusInfo = new ExtendTMInvoiceStatusInfo();
                    curStatusInfo.setName(invoiceStatusDes);
                    curStatusInfo.setNumber(invoiceStatus);
                    IObjectPK statusPk = iExtendTMInvoiceStatus.addnew(curStatusInfo);
                    curStatusInfo.setId(BOSUuid.read((String)statusPk.toString()));
                    invoice.setExtendInvoiceStatus(curStatusInfo);
                } else {
                    curStatusInfo = statusCol.get(0);
                    if (!(oldStatusInfo == null || oldStatusInfo.getId().toString().equals(curStatusInfo.getId().toString()) && oldStatusInfo.getName().equals(invoiceStatusDes))) {
                        invoice.put("statusChaged", true);
                        invoice.put("oldStatus", oldStatusInfo.getName());
                        invoice.put("CurStatus", invoiceStatusDes);
                    }
                    if (!curStatusInfo.getName().equals(invoiceStatusDes)) {
                        curStatusInfo.setName(invoiceStatusDes);
                        iExtendTMInvoiceStatus.update((IObjectPK)new ObjectUuidPK(curStatusInfo.getId()), curStatusInfo);
                    }
                    invoice.setExtendInvoiceStatus(curStatusInfo);
                }
            }
            IExtendTMInvoiceType iExtendTMInvoiceType = ExtendTMInvoiceTypeFactory.getLocalInstance(this.ctx);
            ExtendTMInvoiceTypeCollection typeCol = iExtendTMInvoiceType.getExtendTMInvoiceTypeCollection("where number='" + invoiceType + "'");
            ExtendTMInvoiceTypeInfo typeInfo = null;
            if (typeCol.isEmpty()) {
                typeInfo = new ExtendTMInvoiceTypeInfo();
                typeInfo.setName(invoiceTypeDes);
                typeInfo.setNumber(invoiceType);
                IObjectPK typePk = iExtendTMInvoiceType.addnew(typeInfo);
                typeInfo.setId(BOSUuid.read((String)typePk.toString()));
                invoice.setExtendInvoiceType(typeInfo);
            } else {
                typeInfo = typeCol.get(0);
                if (!typeInfo.getName().equals(invoiceTypeDes)) {
                    typeInfo.setName(invoiceTypeDes);
                    iExtendTMInvoiceType.update((IObjectPK)new ObjectUuidPK(typeInfo.getId()), typeInfo);
                }
                invoice.setExtendInvoiceType(typeInfo);
            }
        }
        catch (Exception e) {
            this.logger.error(e);
        }
    }

    @Override
    protected String addnew() {
        String id = null;
        try {
            if (StringUtils.isEmpty((String)this.model.getInvoiceCode()) && StringUtils.isEmpty((String)this.model.getInvoiceNo())) {
                this.logger.error(" [parseError] : invoiceNo is Empty.serialNo=" + this.model.getSerialNo());
                this.model = null;
            } else {
                IObjectPK pk = ExtendInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
                id = pk.toString();
            }
        }
        catch (Exception e) {
            this.logger.error(e);
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "3BD7326E";
    }
}

