/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.invoicePool.utils.converter;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.IInvoiceBase;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMAuthenticateFlag;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceStatus;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceFactory;
import com.kingdee.eas.tm.common.invoicePool.VehicleInvoiceInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class VehicleInvoiceConverter
extends AbstractConverter {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger("VehicleInvoiceConverter");

    public VehicleInvoiceConverter(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) {
        super(ctx, params, jsonObject);
    }

    @Override
    protected void init() {
        try {
            String invoiceCode = this.parser.getString("invoiceCode");
            String invoiceNo = this.parser.getString("invoiceNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("company.*"));
            viewInfo.setSelector(sic);
            BOSObjectType bosObjectType = BOSObjectType.create((String)this.getBosType());
            IInvoiceBase iInvoiceBase = (IInvoiceBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
            CoreBaseCollection colls = iInvoiceBase.getCollection(viewInfo);
            if (colls != null && colls.size() > 0) {
                this.model = (InvoiceBaseInfo)colls.get(0);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        if (this.model == null) {
            this.model = new VehicleInvoiceInfo();
        }
    }

    @Override
    public void parse() {
        VehicleInvoiceInfo invoice = (VehicleInvoiceInfo)this.model;
        invoice.setType(this.parser.getBoolean("type"));
        invoice.setOriginalInvoiceCode(this.parser.getString("originalInvoiceCode"));
        invoice.setOriginalInvoiceNo(this.parser.getString("originalInvoiceNo"));
        invoice.setMachineNo(this.parser.getString("machineNo"));
        invoice.setBuyerName(this.parser.getString("buyerName"));
        invoice.setBuyerCardno(this.parser.getString("buyerCardno"));
        invoice.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoice.setSalerName(this.parser.getString("salerName"));
        invoice.setSalerTaxNo(this.parser.getString("salerTaxNo"));
        invoice.setSalerAccount(this.parser.getString("salerAccount"));
        invoice.setSalerPhone(this.parser.getString("salerPhone"));
        invoice.setSalerAddress(this.parser.getString("salerAddress"));
        invoice.setSalerBankName(this.parser.getString("salerBankName"));
        invoice.setVehicleType(this.parser.getString("vehicleType"));
        invoice.setBrandModel(this.parser.getString("brandModel"));
        invoice.setProducingArea(this.parser.getString("producingArea"));
        invoice.setCertificateNum(this.parser.getString("certificateNum"));
        invoice.setImportCertificate(this.parser.getString("importCertificate"));
        invoice.setCommodityInspectionNum(this.parser.getString("commodityInspectionNum"));
        invoice.setEngineNum(this.parser.getString("engineNum"));
        invoice.setVehicleIdentificationCode(this.parser.getString("vehicleIdentificationCode"));
        invoice.setTaxRate(this.parser.getBigDecimal("taxRate"));
        invoice.setTotalTaxAmount(this.parser.getBigDecimal("totalTaxAmount"));
        invoice.setOverTaxCode(this.parser.getString("overTaxCode"));
        invoice.setTaxAuthorityCode(this.parser.getString("taxAuthorityCode"));
        invoice.setTaxAuthorityName(this.parser.getString("taxAuthorityName"));
        invoice.setInvoiceMoney(this.parser.getBigDecimal("invoiceAmount"));
        invoice.setTotalTon(this.parser.getBigDecimal("totalTon"));
        invoice.setLimitePeople(this.parser.getBigDecimal("limitePeople"));
        invoice.setProxyMark(this.parser.getBoolean("proxyMark"));
        invoice.setDrawer(this.parser.getString("drawer"));
        TMInvoiceStatus tmInvoiceStatus = (TMInvoiceStatus)this.parser.getEnum(TMInvoiceStatus.class, "invoiceStatus");
        if (invoice.getInvoiceStatus() != null && !invoice.getInvoiceStatus().equals((Object)tmInvoiceStatus)) {
            invoice.put("statusChaged", true);
            invoice.put("oldStatus", invoice.getInvoiceStatus().getAlias());
            invoice.put("CurStatus", tmInvoiceStatus.getAlias());
        }
        invoice.setInvoiceStatus(tmInvoiceStatus);
        invoice.setSelectTime(this.parser.getString("selectTime"));
        invoice.setAuthenticateFlag((TMAuthenticateFlag)this.parser.getEnum(TMAuthenticateFlag.class, "authenticateFlag"));
        invoice.setSelectAuthenticateTime(this.parser.getString("selectAuthenticateTime"));
        invoice.setScanAuthenticateTime(this.parser.getString("scanAuthenticateTime"));
        invoice.setBizDate(new Date());
        invoice.setCheckCode(this.parser.getString("checkCode"));
        invoice.setInvalidDate(this.parser.getDate("invalidDate"));
        invoice.setIsDeduct(this.parser.getBoolean("canBeDeduction"));
        this.parseCheckAbs(invoice);
        if (this.params.get("batchNo") != null) {
            invoice.setBatchNo((String)this.params.get("batchNo"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String addnew() {
        String id = null;
        try {
            this.ctx.put((Object)"disablePermissionForKScript", (Object)true);
            this.ctx.put((Object)"isFromCPBC", (Object)true);
            IObjectPK pk = VehicleInvoiceFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.model);
            id = pk.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            String addNewFail = (String)this.params.getResultMap().get("addNewFail");
            Integer addNewFailNum = (Integer)this.params.getResultMap().get("addNewFailNum");
            if (StringUtils.isEmpty((String)addNewFail)) {
                this.params.getResultMap().put("addNewFail", this.model.getInvoiceCode() + "_" + this.model.getInvoiceNo() + ":" + e.getMessage());
                this.params.getResultMap().put("addNewFailNum", 1);
            } else {
                StringBuffer totalBuffer = new StringBuffer();
                totalBuffer.append(addNewFail).append("\n");
                totalBuffer.append(this.model.getInvoiceCode() + "_" + this.model.getInvoiceNo() + ":");
                totalBuffer.append(e.getMessage());
                this.params.getResultMap().put("addNewFail", totalBuffer.toString());
                Integer n = addNewFailNum;
                Integer n2 = addNewFailNum = Integer.valueOf(addNewFailNum + 1);
                this.params.getResultMap().put("addNewFailNum", n);
            }
        }
        finally {
            this.ctx.remove((Object)"disablePermissionForKScript");
            this.ctx.remove((Object)"isFromCPBC");
        }
        return id;
    }

    @Override
    public String getBosType() {
        return "8F9D8961";
    }
}

