/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.logger;

import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.eas.tm.common.utils.Log4j2Util;
import com.kingdee.eas.tm.common.utils.LogCheckUtil;
import com.kingdee.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;

public abstract class AbstractLogger {
    private static CustomCacheService loggerMap = new CustomCacheService("TM.LoggerMap");
    protected static final int ERROR = 0;
    protected static final int INFO = 1;
    protected static final int DEBUG = 2;
    public static int level = 0;
    private static final String LEFT = "[";
    private static final String RIGHT = "]";
    private String clazzName = "";
    private Logger logger = null;

    public AbstractLogger(String clazzName) {
        this.clazzName = clazzName;
        this.initLogger();
    }

    protected void initLogger() {
        this.logger = (Logger)loggerMap.get(this.getAppenderName());
        if (this.logger == null) {
            String fileName = "tm/" + this.getFileName();
            Log4j2Util.addRollFileLogConfig(this.getAppenderName(), this.getLoggerName(), fileName, this.getLevel(), this.getFileSize(), this.getFileCount());
            this.logger = Logger.getLogger((String)this.getLoggerName());
            loggerMap.put(this.getAppenderName(), (Object)this.logger);
        }
    }

    public void error(Object message) {
        this.logger.error((Object)this.handleMessage(message));
    }

    public void error(String message, Throwable e) {
        this.logger.error((Object)this.handleMessage(message, e));
    }

    public void info(Object message) {
        if (level < 1) {
            return;
        }
        this.logger.info((Object)this.handleMessage(message));
    }

    public void debug(Object message) {
        if (level < 2) {
            return;
        }
        this.logger.debug((Object)this.handleMessage(message));
    }

    protected Level getLevel() {
        return Level.DEBUG;
    }

    public String getFileSize() {
        return "10MB";
    }

    public String getFileCount() {
        return "10";
    }

    protected abstract String getAppenderName();

    protected abstract String getFileName();

    protected abstract String getLoggerName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleMessage(String message, Throwable e) {
        StringBuffer errorMsg = new StringBuffer();
        if (!StringUtils.isEmpty((String)message)) {
            String error = LogCheckUtil.validLog(message);
            errorMsg.append(error);
        }
        if (e != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                e.printStackTrace(pw);
                errorMsg.append(sw.toString());
            }
        }
        return LEFT + this.clazzName + RIGHT + errorMsg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleMessage(Object message) {
        String error;
        if (message == null) {
            error = "";
        } else if (message instanceof Throwable) {
            Throwable t = (Throwable)message;
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                error = sw.toString();
            }
        } else {
            error = LogCheckUtil.validLog(message.toString());
        }
        return LEFT + this.clazzName + RIGHT + error;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

