/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.common.TMTaxTransLogInfo;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.utils.CollectionUtil;
import com.kingdee.eas.tm.common.utils.TMResourceUtil;
import com.kingdee.eas.tm.common.utils.TMTaxTransLogUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TMCommonUtil {
    public static final String NEWLINE = ";\r\n";
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    private static Map<String, EntityObjectInfo> entityCache = new HashMap<String, EntityObjectInfo>();
    public static Map<String, String> apiUrlMap = new HashMap<String, String>();
    public static Map<String, String> webUrlMap = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.common.utils.TMCommonUtil");
    public static final String SERVICE_NAME = "com.kingdee.eas.tm.im.app.incomeinvoice.action.AcceptCheckInvoiceAction";
    private static Map<String, Class> classMap = new HashMap<String, Class>();

    public static Map getAccessToken(Context ctx, String baseURL, String id, String secret, FullOrgUnitInfo companyInfo, boolean isWriteLog) throws EASBizException, BOSException {
        HashMap<String, String> tokenMap;
        block12: {
            tokenMap = new HashMap<String, String>();
            JSONObject resultJson = null;
            TMTaxTransLogInfo tmPwyLog = null;
            UserInfo user = null;
            if (ctx != null) {
                user = ContextUtil.getCurrentUserInfo((Context)ctx);
            }
            try {
                String errcode;
                Map sfrz = TMCommonUtil.getSfrz(id, secret);
                String tokenParam = Kson.getGson().toJson((Object)sfrz);
                if (apiUrlMap.containsKey(baseURL)) {
                    baseURL = apiUrlMap.get(baseURL);
                }
                String tokenURL = baseURL + "/base/oauth/token";
                if (isWriteLog) {
                    HashMap<String, Context> param = new HashMap<String, Context>();
                    param.put("ctx", ctx);
                    Map tmPwyLogMap = TMTaxTransLogUtil.createPwyLog(param);
                    if (tmPwyLogMap != null && tmPwyLogMap.get("tmPwyLog") != null) {
                        tmPwyLog = (TMTaxTransLogInfo)tmPwyLogMap.get("tmPwyLog");
                        tmPwyLog.setCompany(companyInfo);
                        tmPwyLog.setUrl(tokenURL);
                        tmPwyLog.setOperType("2");
                        tmPwyLog.setSendMsg(tokenParam);
                        Timestamp ts = new Timestamp(System.currentTimeMillis());
                        tmPwyLog.setSendTime(ts);
                        tmPwyLog.setLogType("9004");
                        tmPwyLog.setSrcSystem("1");
                        tmPwyLog.setDestSystem("1");
                        tmPwyLog.setModifer(user == null ? null : user);
                        tmPwyLog.setUpdateTime(ts);
                        tmPwyLogMap.put("tmPwyLog", tmPwyLog);
                        TMTaxTransLogUtil.updatePwyLog(tmPwyLogMap);
                    }
                }
                String result = HttpClientUtil.doPost(tokenURL, tokenParam);
                if (tmPwyLog != null) {
                    tmPwyLog.setRevMsg(result);
                    tmPwyLog.setRevTime(new Timestamp(System.currentTimeMillis()));
                }
                if ("0000".equals(errcode = (resultJson = new JSONObject(result)).getString("errcode"))) {
                    tokenMap.put("access_token", resultJson.getString("access_token"));
                }
                if (tmPwyLog != null) {
                    if ("0000".equals(errcode)) {
                        tmPwyLog.setLogStatus("4");
                    } else {
                        tmPwyLog.setLogStatus("3");
                    }
                    tmPwyLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("ctx", ctx);
                    param.put("tmPwyLog", tmPwyLog);
                    TMTaxTransLogUtil.updatePwyLog(param);
                }
            }
            catch (Exception e) {
                tokenMap.put("errMsg", e.getMessage());
                if (resultJson != null) {
                    tokenMap.put("resultJson", (String)resultJson);
                }
                if (tmPwyLog == null) break block12;
                tmPwyLog.setLogStatus("3");
                tmPwyLog.setUpdateTime(new Timestamp(System.currentTimeMillis()));
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("ctx", ctx);
                param.put("tmPwyLog", tmPwyLog);
                TMTaxTransLogUtil.updatePwyLog(param);
            }
        }
        return tokenMap;
    }

    public static Map getSfrz(String id, String secret) throws Exception {
        HashMap<String, String> sfrzMap = new HashMap<String, String>();
        String timestamp = String.valueOf(new Date().getTime());
        timestamp = timestamp.substring(0, 10);
        String sign = TMCommonUtil.StringToMD5(id + secret + timestamp);
        sfrzMap.put("client_id", id);
        sfrzMap.put("sign", sign);
        sfrzMap.put("timestamp", timestamp);
        return sfrzMap;
    }

    public static String StringToMD5(String input) throws Exception {
        String md5str = "";
        if (input == null) {
            return md5str;
        }
        byte[] bytes = input.getBytes();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] buff = md.digest(bytes);
        md5str = TMCommonUtil.bytesToHex(buff);
        return md5str;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString();
    }

    public static String getInStringFromList(List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String buildIn(String name, Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        int size = set.length;
        int num = size / 800;
        int j = 0;
        sb.append("(");
        for (int i = 0; i < num; ++i) {
            sb.append(" ");
            sb.append(name);
            sb.append(" ");
            sb.append(" in (");
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
            ++j;
            while (j < (i + 1) * 800) {
                sb.append(",");
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
                ++j;
            }
            sb.append(")\n ");
            sb.append(" or ");
        }
        if (j == size) {
            sb.delete(sb.length() - 4, sb.length());
            sb.append(" )");
            return sb.toString();
        }
        sb.append(" " + name + " ");
        sb.append(" in (");
        StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
        ++j;
        while (j < size) {
            sb.append(",");
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[j]);
            ++j;
        }
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    public static String buildErrorMsg(List errors, String enterStr) {
        StringBuffer msg = new StringBuffer();
        if (enterStr == null) {
            enterStr = "\r\n";
        }
        if (errors != null) {
            for (int i = 0; i < errors.size(); ++i) {
                msg.append(errors.get(i)).append(enterStr);
            }
        }
        return msg.toString();
    }

    public static boolean isSupport() {
        Class<?> clazz = classMap.get(SERVICE_NAME);
        if (clazz == null) {
            try {
                clazz = Class.forName(SERVICE_NAME);
                classMap.put(SERVICE_NAME, clazz);
            }
            catch (Exception e) {
                logger.error((Object)"className:com.kingdee.eas.tm.im.app.incomeinvoice.action.AcceptCheckInvoiceAction  ClassNotFound");
            }
        }
        return clazz != null;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, String value, CompanyOrgUnitInfo company) {
        try {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            int period = Integer.valueOf(value);
            if (ctx == null) {
                return PeriodUtils.getPeriodInfo((int)(period / 100), (int)(period % 100), (CompanyOrgUnitInfo)company);
            }
            return PeriodUtils.getPeriodInfo((Context)ctx, (int)(period / 100), (int)(period % 100), (CompanyOrgUnitInfo)company);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitByTaxNo(Context ctx, String taxNo) throws BOSException {
        EntityViewInfo cview = new EntityViewInfo();
        FilterInfo cfilter = new FilterInfo();
        cfilter.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)taxNo));
        cview.setFilter(cfilter);
        CompanyOrgUnitInfo company = null;
        CompanyOrgUnitCollection col = null;
        col = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(cview) : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(cview);
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        for (int i = 0; i < col.size(); ++i) {
            company = col.get(i);
            if (!company.getId().toString().equals(curCompany.getId().toString())) continue;
            return company;
        }
        if (col != null && col.size() > 0) {
            company = col.get(0);
        }
        if (company == null) {
            company = curCompany;
        }
        return company;
    }

    public static String getInStringFromSet(Set ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static void clearTrimInfo(IObjectValue info, String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            String value = info.getString(fields[i]);
            if (StringUtils.isEmpty((String)value)) continue;
            info.put(fields[i], (Object)value.trim());
        }
    }

    public static void checkEmptyFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : fields) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (billFields.size() > 0) {
            TMCommonUtil.checkBillEmptyFields(ctx, info, billFields, errorMsg);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                TMCommonUtil.checkEntryEmptyFields(ctx, i + 1, entry, entryFields, errorMsg, info.getString("sourceType"));
            }
        }
        if (errorMsg.length() > 0) {
            throw new TMException(TMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    private static void checkBillEmptyFields(Context ctx, IObjectValue info, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = info.getBOSType().toString();
        EntityObjectInfo entity = TMCommonUtil.getEntity(ctx, bosType);
        PropertyInfo property = null;
        StringBuffer emptyFields = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            property = entity.getPropertyByName(field);
            if (!TMCommonUtil.isEmpty(info, field)) continue;
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
        }
        if (emptyFields.length() > 0) {
            errorMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_NOTNULL", ctx.getLocale(), new Object[]{emptyFields.substring(0, emptyFields.length() - 1)})).append(NEWLINE);
        }
    }

    private static void checkEntryEmptyFields(Context ctx, int index, IObjectValue info, List<String> fields, StringBuffer errorMsg, String sourceType) throws EASBizException, BOSException {
        String bosType = info.getBOSType().toString();
        EntityObjectInfo entity = TMCommonUtil.getEntity(ctx, bosType);
        PropertyInfo property = null;
        StringBuffer emptyFields = new StringBuffer();
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            property = entity.getPropertyByName(field);
            if (!TMCommonUtil.isEmpty(info, field)) continue;
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
        }
        if (emptyFields.length() > 0) {
            if (!"4".equals(sourceType)) {
                errorMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_INDEX", ctx.getLocale(), new Object[]{index}));
            }
            errorMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_ENTRY_NOTNULL", ctx.getLocale(), new Object[]{emptyFields.substring(0, emptyFields.length() - 1)})).append(NEWLINE);
        }
    }

    private static boolean isEmpty(IObjectValue value, String field) {
        return value.get(field) == null || value.get(field) instanceof String && StringUtils.isEmpty((String)value.get(field).toString());
    }

    public static void checkLengthFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : fields) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (billFields.size() > 0) {
            TMCommonUtil.checkBillOverLengthFields(ctx, info, billFields, errorMsg);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                TMCommonUtil.checkEntryOverLengthFields(ctx, i + 1, entry, entryFields, errorMsg, info.getString("sourceType"));
            }
        }
        if (errorMsg.length() > 0) {
            throw new TMException(TMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    private static void checkBillOverLengthFields(Context ctx, IObjectValue model, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = model.getBOSType().toString();
        EntityObjectInfo entity = TMCommonUtil.getEntity(ctx, bosType);
        String field = null;
        int maxLength = 0;
        int strLength = 0;
        PropertyInfo property = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            String value = model.getString(field);
            if (StringUtils.isEmpty((String)value) || (maxLength = TMCommonUtil.getMaxLength(ctx, model, field)) == -1 || (strLength = value.getBytes().length) <= maxLength) continue;
            property = entity.getPropertyByName(field);
            String fieldName = property.getAlias(ctx.getLocale());
            String error = TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_OVER_LENGTH", ctx.getLocale(), new Object[]{fieldName, maxLength, strLength});
            errorMsg.append(error).append(NEWLINE);
        }
    }

    private static void checkEntryOverLengthFields(Context ctx, int index, IObjectValue entry, List<String> fields, StringBuffer errorMsg, String sourceType) throws EASBizException, BOSException {
        String bosType = entry.getBOSType().toString();
        EntityObjectInfo entity = TMCommonUtil.getEntity(ctx, bosType);
        String field = null;
        int maxLength = 0;
        int strLength = 0;
        PropertyInfo property = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            String value = entry.getString(field);
            if (StringUtils.isEmpty((String)value) || (maxLength = TMCommonUtil.getMaxLength(ctx, entry, field)) == -1 || (strLength = value.getBytes().length) <= maxLength) continue;
            property = entity.getPropertyByName(field);
            String fieldName = property.getAlias(ctx.getLocale());
            if (!"4".equals(sourceType)) {
                errorMsg.append(TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_INDEX", ctx.getLocale(), new Object[]{index}));
            }
            String error = TMResourceUtil.getString("com.kingdee.eas.tm.common.TMResource", "MSG_ENTRY_OVER_LENGTH", ctx.getLocale(), new Object[]{fieldName, maxLength, strLength});
            errorMsg.append(error).append(NEWLINE);
        }
    }

    private static int getMaxLength(Context ctx, IObjectValue value, String field) {
        DataTableInfo tableInfo;
        ColumnInfo columnInfo;
        String bosType = value.getBOSType().toString();
        EntityObjectInfo entity = TMCommonUtil.getEntity(ctx, bosType);
        PropertyInfo property = entity.getPropertyByName(field);
        if (property != null && property.getMappingField() != null && property.getMappingField().getName() != null) {
            field = property.getMappingField().getName();
        }
        if ((columnInfo = (tableInfo = entity.getTable()).getColumnByName(field)) == null) {
            return -1;
        }
        SQLType sqlType = columnInfo.getTypeName();
        if (!SQLType.NVARCHAR.equals((Object)sqlType) && !SQLType.VARCHAR.equals((Object)sqlType)) {
            return -1;
        }
        return columnInfo.getLength();
    }

    public static EntityObjectInfo getEntity(Context ctx, String bosType) {
        EntityObjectInfo entity = null;
        if (entityCache.containsKey(bosType)) {
            entity = entityCache.get(bosType);
        } else {
            entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)bosType));
            entityCache.put(bosType, entity);
        }
        return entity;
    }

    public static StringEnum getEnumByValueOrAlias(List enumList, String value) {
        for (StringEnum _enum : enumList) {
            if (!_enum.getValue().equals(value) && !_enum.getAlias().equals(value)) continue;
            return _enum;
        }
        return null;
    }

    public static BigDecimal isNullToZero(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)value;
    }

    public static Map getIMTempParamByKey(Context ctx, String[] paramKeys) throws BOSException, EASBizException {
        List<String> keys = Arrays.asList(paramKeys);
        HashMap<String, String> result = new HashMap<String, String>();
        String retKey = null;
        String retValue = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FKey,FValue From T_IM_IMTempParam ");
        if (paramKeys != null && paramKeys.length > 0) {
            sql.append(" WHERE FKey in (").append(CollectionUtil.convertList2String(keys)).append(")");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                retKey = rs.getString("FKey");
                retValue = rs.getString("FValue");
                result.put(retKey, retValue);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, SorterItemCollection sorter) throws BOSException {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return results;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TMCommonUtil.getOrgInfoSelector(orgType));
        switch (orgType.getValue()) {
            case 0: {
                AdminOrgUnitCollection collection;
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                if (sorter != null) {
                    view.setSorter(sorter);
                }
                if ((collection = iAdmin.getAdminOrgUnitCollection(view)) != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 1: {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 2: {
                ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 3: {
                IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 4: {
                IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 24: {
                ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 10: {
                ICtrlUnit ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitCollection collection = ictrlUnit.getCtrlUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
        }
        return null;
    }

    public static SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    public static Timestamp getQueryTime(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        if (d == null) {
            d = new Date();
        }
        calendar.setTime(d);
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.add(2, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            calendar.set(14, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
            calendar.set(14, 999);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static void sendBMCMsg(Context ctx, String msg, String title, MsgBizType msgBizType, String receiver) throws EASBizException, BOSException {
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setType(MsgType.NOTICE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        msgInfo.setBizType(msgBizType);
        msgInfo.setPriority(MsgPriority.MIDDLE);
        msgInfo.setTitle(title);
        msgInfo.setBody(msg);
        msgInfo.setReceiver(receiver);
        BMCMessageFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)msgInfo);
    }

    static {
        apiUrlMap.put("https://www.piaozone.com/test", "https://api-dev.piaozone.com/test");
        apiUrlMap.put("https://www.piaozone.com/dev", "https://api-dev.piaozone.com");
        apiUrlMap.put("https://www.piaozone.com", "https://api.piaozone.com");
        apiUrlMap.put("http://www.piaozone.com/test", "http://api-dev.piaozone.com/test");
        apiUrlMap.put("http://www.piaozone.com/dev", "http://api-dev.piaozone.com");
        apiUrlMap.put("http://www.piaozone.com", "http://api.piaozone.com");
        webUrlMap.put("https://api-dev.piaozone.com/test", "https://www.piaozone.com/test");
        webUrlMap.put("https://api-dev.piaozone.com", "https://www.piaozone.com/dev");
        webUrlMap.put("https://api.piaozone.com", "https://www.piaozone.com");
    }
}

