/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class TMSqlUtil {
    private static Logger logger = Logger.getLogger(TMSqlUtil.class);
    private static final int MAX_DATA_ROW = 8000;

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        ConnectionConfig config = ConnectionConfig.custom().build(ctx);
        conn = config.getConn();
        try {
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            JdbcRowSet jdbcRowSet = rowset;
            return jdbcRowSet;
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql + "  exc:" + exc.getMessage()), (Throwable)exc);
            throw new BOSException("execute exception : " + sql, (Throwable)exc);
        }
        finally {
            if (config.isNeedClose()) {
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
            } else {
                SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
            }
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        block9: {
            ResultSet rs;
            PreparedStatement ps;
            block8: {
                Connection conn = null;
                ps = null;
                rs = null;
                ConnectionConfig config = ConnectionConfig.custom().build(ctx);
                conn = config.getConn();
                try {
                    ps = conn.prepareStatement(sql);
                    for (int i = 0; i < params.length; ++i) {
                        ps.setObject(i + 1, params[i]);
                    }
                    rs = ps.executeQuery();
                    JdbcRowSet rowset = new JdbcRowSet();
                    rowset.populate(rs);
                    jdbcRowSet = rowset;
                    if (!config.isNeedClose()) break block8;
                }
                catch (SQLException exc) {
                    try {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < params.length; ++i) {
                            sb.append("param ").append(i).append(" is:").append(params[i]);
                        }
                        logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                        logger.error((Object)("sql error!" + exc.getMessage()), (Throwable)exc);
                        throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
                    }
                    catch (Throwable throwable) {
                        if (config.isNeedClose()) {
                            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                        } else {
                            SQLUtils.cleanup(rs, (Statement)ps);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
                break block9;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        }
        return jdbcRowSet;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        ConnectionConfig config = ConnectionConfig.custom().build(ctx);
        conn = config.getConn();
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql is:" + sql + " exc:" + exc.getMessage()), (Throwable)exc);
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        finally {
            if (config.isNeedClose()) {
                SQLUtils.cleanup((Statement)statement, (Connection)conn);
            } else {
                SQLUtils.cleanup((Statement)statement);
            }
        }
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        ConnectionConfig config = ConnectionConfig.custom().build(ctx);
        conn = config.getConn();
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("sql is:" + sql + " param is:" + sb.toString() + " exc:" + exc.getMessage()), (Throwable)exc);
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        finally {
            if (config.isNeedClose()) {
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            } else {
                SQLUtils.cleanup((Statement)ps);
            }
        }
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        ConnectionConfig config = ConnectionConfig.custom().build(ctx);
        conn = config.getConn();
        try {
            ps = conn.prepareStatement(sql);
            Object[] params = null;
            int k = 1;
            boolean flag = false;
            for (int i = 0; i < paramsList.size(); ++i) {
                params = (Object[])paramsList.get(i);
                for (int j = 0; j < params.length; ++j) {
                    if (params[j] != null) {
                        ps.setObject(j + 1, params[j]);
                        continue;
                    }
                    ps.setNull(j + 1, 0);
                }
                ps.addBatch();
                if (i == k * 8000) {
                    flag = true;
                }
                if (i <= k * 8000 || !flag) continue;
                ps.executeBatch();
                ++k;
                flag = false;
                ps.clearBatch();
            }
            if (!flag) {
                ps.executeBatch();
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        finally {
            if (config.isNeedClose()) {
                SQLUtils.cleanup((Statement)ps, (Connection)conn);
            } else {
                SQLUtils.cleanup((Statement)ps);
            }
        }
    }

    public static int[] executeBatch(Context ctx, String[] sqls) throws BOSException {
        int[] nArray;
        Connection conn = null;
        Statement stmt = null;
        try {
            ConnectionConfig config = ConnectionConfig.custom().build(ctx);
            conn = config.getConn();
            stmt = conn.createStatement();
            int n = sqls.length;
            for (int i = 0; i < n; ++i) {
                stmt.addBatch(sqls[i]);
            }
            nArray = stmt.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqls, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return nArray;
    }

    public static IRowSet executeQueryNotInject(Context ctx, String formatSql, Object[] params) throws BOSException {
        IRowSet rs = null;
        SqlParamConfig config = null;
        try {
            config = SqlParamConfig.custom().build(ctx, params);
            formatSql = formatSql.replaceAll("'", "''");
            rs = TMSqlUtil.executeQuery(ctx, MessageFormat.format(formatSql, config.getPlaceholderList().toArray()), config.getParamList().toArray());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (config != null) {
                TMSqlUtil.releaseTable(ctx, config.getTempTableList());
            }
        }
        return rs;
    }

    public static void executeNotInject(Context ctx, String formatSql, Object[] params) throws BOSException {
        SqlParamConfig config = null;
        try {
            config = SqlParamConfig.custom().build(ctx, params);
            formatSql = formatSql.replaceAll("'", "''");
            TMSqlUtil.execute(ctx, MessageFormat.format(formatSql, config.getPlaceholderList().toArray()), config.getParamList().toArray());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (config != null) {
                TMSqlUtil.releaseTable(ctx, config.getTempTableList());
            }
        }
    }

    public static String formatStringValue(String value) {
        StringBuilder str = new StringBuilder();
        str.append("'").append(value).append("'");
        return str.toString();
    }

    private static void releaseTable(Context ctx, List<String> tempTableList) throws BOSException {
        if (tempTableList == null) {
            return;
        }
        String tempTableName = null;
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        int size = tempTableList.size();
        for (int i = 0; i < size; ++i) {
            tempTableName = tempTableList.get(i);
            if (StringUtils.isEmpty((String)tempTableName)) continue;
            tmpTblPool.releaseTable(tempTableName);
        }
    }

    private static class SqlParamConfig {
        private List<Object> paramList = null;
        private List<String> placeholderList = null;
        private List<String> tempTableList = null;

        private SqlParamConfig(List<Object> paramList, List<String> placeholderList, List<String> tempTableList) {
            this.paramList = paramList;
            this.placeholderList = placeholderList;
            this.tempTableList = tempTableList;
        }

        public List<Object> getParamList() {
            return this.paramList;
        }

        public List<String> getPlaceholderList() {
            return this.placeholderList;
        }

        public List<String> getTempTableList() {
            return this.tempTableList;
        }

        public static Builder custom() {
            return new Builder();
        }

        private static class Builder {
            public static final int MAX_ID_COUNT = 500;
            public static final String CREATE_TEMP_TABLE_SQL = "CREATE TABLE TEMP_KSQL_TABLE (FID VARCHAR(44)) ";
            public static final String SELECT_TEMP_TBALE_SQL = "SELECT FID FROM {0} ";
            public static final String INSERT_TEMP_TABLE_SQL = "INSERT INTO {0} (FID) VALUES (?) ";
            private List<Object> paramList = new ArrayList<Object>();
            private List<String> placeholderList = new ArrayList<String>();
            private List<String> tempTableList = new ArrayList<String>();

            private Builder() {
            }

            public SqlParamConfig build(Context ctx, Object[] params) throws BOSException {
                Object value2 = null;
                String tempTable = null;
                Collection idColl = null;
                int idSize = 0;
                for (Object value2 : params) {
                    if (value2 instanceof Collection) {
                        idColl = (Collection)value2;
                        idSize = idColl.size();
                        if (idSize <= 500) {
                            this.placeholderList.add(this.getPlaceHolder(idSize));
                            this.paramList.addAll(idColl);
                            continue;
                        }
                        tempTable = this.getIDTempTable(ctx, idColl);
                        this.placeholderList.add(MessageFormat.format(SELECT_TEMP_TBALE_SQL, tempTable));
                        this.tempTableList.add(tempTable);
                        continue;
                    }
                    this.placeholderList.add(this.getPlaceHolder(1));
                    this.paramList.add(value2);
                }
                return new SqlParamConfig(this.paramList, this.placeholderList, this.tempTableList);
            }

            private String getPlaceHolder(int size) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    buf.append("?");
                    if (i == size - 1) continue;
                    buf.append(" , ");
                }
                return buf.toString();
            }

            public String getIDTempTable(Context ctx, Collection idColl) throws BOSException {
                String tempTable = null;
                TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
                try {
                    tempTable = tmpTblPool.createTempTable(CREATE_TEMP_TABLE_SQL);
                    tmpTblPool.createIndex(tempTable, "FID", false, true);
                    String insertSql = MessageFormat.format(INSERT_TEMP_TABLE_SQL, tempTable);
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                    Iterator it = idColl.iterator();
                    while (it.hasNext()) {
                        paramList.add(new Object[]{it.next().toString()});
                    }
                    TMSqlUtil.executeBatch(ctx, insertSql, paramList);
                }
                catch (Exception e) {
                    throw new BOSException("getIdTempTable error ", (Throwable)e);
                }
                return tempTable;
            }
        }
    }

    private static class ConnectionConfig {
        private Connection conn = null;
        private boolean isNeedClose = false;

        private ConnectionConfig(Connection conn, boolean isNeedClose) {
            this.conn = conn;
            this.isNeedClose = isNeedClose;
        }

        public Connection getConn() {
            return this.conn;
        }

        public boolean isNeedClose() {
            return this.isNeedClose;
        }

        public static Builder custom() {
            return new Builder();
        }

        private static class Builder {
            private Connection conn = null;
            private boolean isNeedClose = false;

            private Builder() {
            }

            public ConnectionConfig build(Context ctx) throws BOSException {
                Connection conn = null;
                try {
                    if (conn == null) {
                        conn = EJBFactory.getConnection((Context)ctx);
                        this.isNeedClose = true;
                    }
                }
                catch (SQLException exc) {
                    SQLUtils.cleanup(conn);
                    throw new BOSException("config exception", (Throwable)exc);
                }
                return new ConnectionConfig(conn, this.isNeedClose);
            }
        }
    }
}

