/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TMTaxTransLogUtil {
    private static final Logger logger = Logger.getLogger(TMTaxTransLogUtil.class);
    private static Map<String, Class> classMap = new HashMap<String, Class>();
    private static Map<String, Method> classMethodMap = new HashMap<String, Method>();

    public static boolean isSupportTaxTransLog() {
        Class clazz = TMTaxTransLogUtil.getClass("com.kingdee.eas.tm.im.common.comm.service.TaxTransLogService");
        return clazz != null;
    }

    public static Class getClass(String className) {
        Class<?> clazz = classMap.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                classMap.put(className, clazz);
            }
            catch (Throwable e) {
                logger.error((Object)("className:" + className + "  ClassNotFound"));
            }
        }
        return clazz;
    }

    public static Map invoke(String className, String methodName, Map param) throws EASBizException, BOSException {
        Map ret = new HashMap();
        Class clazz = TMTaxTransLogUtil.getClass(className);
        if (clazz == null) {
            return ret;
        }
        Method method = classMethodMap.get(className + "_" + methodName);
        try {
            if (method == null) {
                method = clazz.getDeclaredMethod(methodName, Map.class);
                classMethodMap.put(className + "_" + methodName, method);
            }
            Object obj = clazz.newInstance();
            ret = (Map)method.invoke(obj, param);
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)("className:" + className + ",methodName:" + methodName + "  invoke error"));
        }
        return ret;
    }

    public static Map createPwyLog(Map param) throws EASBizException, BOSException {
        Map ret = new HashMap();
        try {
            ret = TMTaxTransLogUtil.invoke("com.kingdee.eas.tm.im.common.comm.service.TaxTransLogService", "createPwyLog", param);
        }
        catch (Throwable e) {
            logger.error((Object)("TMTaxTransLogUtil.createPwyLog  ERROR:" + e.getMessage()));
        }
        return ret;
    }

    public static void updatePwyLog(Map param) throws EASBizException, BOSException {
        try {
            TMTaxTransLogUtil.invoke("com.kingdee.eas.tm.im.common.comm.service.TaxTransLogService", "updatePwyLog", param);
        }
        catch (Throwable e) {
            logger.error((Object)("TMTaxTransLogUtil.updatePwyLog  ERROR:" + e.getMessage()));
        }
    }
}

