/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.im.AbstractMakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.basedata.OverLimitAmtSplitTypeEnum;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Map;

public class MakeInvoiceEntryInfo
extends AbstractMakeInvoiceEntryInfo
implements Serializable {
    private BigDecimal realPrice;
    private BigDecimal actualPrice;
    private BigDecimal originRealPriceTax;
    private BigDecimal originRealNoTaxAmt;

    public MakeInvoiceEntryInfo() {
    }

    protected MakeInvoiceEntryInfo(String pkField) {
        super(pkField);
    }

    public static MakeInvoiceEntryInfo createMakeInvoiceEntryInfo(MakeInvoiceInfo makeInvoice) {
        BOSUuid id = BOSUuid.create((String)"5A63A7BA");
        MakeInvoiceEntryInfo makeInvoiceEntryInfo = new MakeInvoiceEntryInfo();
        makeInvoiceEntryInfo.setId(id);
        makeInvoiceEntryInfo.setMakeInvoice(makeInvoice);
        return makeInvoiceEntryInfo;
    }

    public Object clone() {
        MakeInvoiceEntryInfo entry = new MakeInvoiceEntryInfo();
        String key = null;
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            entry.put(key, this.get(key));
        }
        return entry;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id\uff1a" + this.getId()).append("_noTaxAmt:" + this.getNoTaxAmt()).append("_quantity:" + this.getQuantity()).append("_price:" + this.getPrice()).append("_noTaxPrice:" + this.getNoTaxPrice()).append("_taxAmt:" + this.getTaxAmt()).append("_taxRate:" + this.getTaxRate()).append("_priceTax:" + this.getPriceTax()).append("_\u8868\u5934:" + this.getMakeInvoice() != null ? this.getMakeInvoice().getId() : null);
        return sb.toString();
    }

    public BigDecimal getAmtBySplitType(MakeInvoiceInfo invoice) {
        if (invoice != null && OverLimitAmtSplitTypeEnum.PriceIncludingTax.equals((Object)invoice.getSplitType())) {
            return this.getPriceTax();
        }
        return this.getNoTaxAmt();
    }

    public BigDecimal getActualAmtBySplitType(MakeInvoiceInfo invoice, Map<String, BigDecimal> discountAmtMap) {
        if (invoice != null && OverLimitAmtSplitTypeEnum.PriceIncludingTax.equals((Object)invoice.getSplitType())) {
            return this.getActualPriceTax(discountAmtMap);
        }
        return this.getActualNoTaxAmt(discountAmtMap);
    }

    public BigDecimal getActualNoTaxAmt(Map<String, BigDecimal> discountAmtMap) {
        BigDecimal actualNoTaxAmt = this.getNoTaxAmt();
        if (discountAmtMap != null && discountAmtMap.containsKey(this.getId().toString())) {
            actualNoTaxAmt = actualNoTaxAmt.add(discountAmtMap.get(this.getId().toString()));
        }
        return actualNoTaxAmt;
    }

    public BigDecimal getActualPriceTax(Map<String, BigDecimal> discountAmtMap) {
        BigDecimal actualPriceTax = this.getPriceTax();
        if (discountAmtMap != null && discountAmtMap.containsKey(this.getId().toString())) {
            actualPriceTax = actualPriceTax.add(discountAmtMap.get(this.getId().toString()));
        }
        return actualPriceTax;
    }

    public BigDecimal getRealPrice() {
        return this.realPrice;
    }

    public void setRealPrice(BigDecimal realPrice) {
        this.realPrice = realPrice;
    }

    public BigDecimal getActualPrice() {
        return this.actualPrice;
    }

    public void setActualPrice(BigDecimal actualPrice) {
        this.actualPrice = actualPrice;
    }

    @Override
    public void setTaxRate(BigDecimal value) {
        if (value != null) {
            value = value.setScale(4, 4);
        }
        super.setTaxRate(value);
    }

    public BigDecimal getEntryDiffer(int goldenTaxControl, boolean isMultiRate) {
        BigDecimal noTaxAmt = IMUtils.isNullToZero(this.getNoTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(this.getTaxRate());
        BigDecimal taxAmt = IMUtils.isNullToZero(this.getTaxAmt());
        if (isMultiRate && goldenTaxControl == 0) {
            return noTaxAmt.multiply(taxRate).subtract(taxAmt).setScale(2, 4);
        }
        return noTaxAmt.multiply(taxRate).subtract(taxAmt);
    }

    public BigDecimal getEntryDifferAmt() {
        BigDecimal noTaxAmt = IMUtils.isNullToZero(this.getNoTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(this.getTaxRate());
        BigDecimal taxAmt = IMUtils.isNullToZero(this.getTaxAmt());
        BigDecimal deductAmt = IMUtils.isNullToZero(this.getDeductAmt());
        return noTaxAmt.subtract(deductAmt).multiply(taxRate).subtract(taxAmt);
    }

    public BigDecimal getOriginRealPriceTax() {
        return this.originRealPriceTax;
    }

    public void setOriginRealPriceTax(BigDecimal originRealPriceTax) {
        this.originRealPriceTax = originRealPriceTax;
    }

    public BigDecimal getOriginRealNoTaxAmt() {
        return this.originRealNoTaxAmt;
    }

    public void setOriginRealNoTaxAmt(BigDecimal originRealNoTaxAmt) {
        this.originRealNoTaxAmt = originRealNoTaxAmt;
    }
}

