/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.tm.im.client.MakeInvoiceReqEditUI;
import com.kingdee.eas.tm.im.common.calculate.AbstractImAlgorithm;
import com.kingdee.eas.tm.im.common.calculate.PropertyCalculator;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public abstract class MakeInvoiceReqAlgorithm
extends AbstractImAlgorithm {
    protected static final String TOTALTAX = "tax";
    protected static final String LOCALTOTALTAX = "taxLocal";
    protected static final String TOTALAMOUNT = "priceExcludingTax";
    protected static final String LOCALTOTALAMOUNT = "priceExcludingTaxLocal";
    protected static final String TOTALTAXAMOUNT = "priceIncludingTax";
    protected static final String LOCALTOTALTAXAMOUNT = "priceIncludingTaxLocal";
    protected static final String MATERIAL = "material";
    protected static final String UNIT = "unit";
    protected static final String QTY = "qty";
    protected static final String BASEQTY = "baseQty";
    protected static final String PRICE = "noTaxPrice";
    protected static final String TAXPRICE = "price";
    protected static final String ACTUALPRICE = "actualPrice";
    protected static final String ACTUALTAXPRICE = "actualTaxPrice";
    protected static final String TAXRATE = "taxRate";
    protected static final String TAX = "tax";
    protected static final String LOCALTAX = "taxLocal";
    protected static final String AMOUNT = "priceExcludingTax";
    protected static final String LOCALAMOUNT = "priceExcludingTaxLocal";
    protected static final String TAXAMOUNT = "priceIncludingTax";
    protected static final String LOCALTAXAMOUNT = "priceIncludingTaxLocal";
    protected static final String DISCOUNTTYPE = "discountType";
    protected static final String DISCOUNTRATE = "discountRate";
    protected static final String DISCOUNTAMOUNT = "discountAmount";
    protected static final String LOCALDISCOUNTAMOUNT = "discountAmountLocal";
    protected static final String TAXCLASSIFICATIONCODE = "taxClassificationCode";
    protected Map<String, String> fieldMap = new HashMap<String, String>();

    public MakeInvoiceReqAlgorithm() {
        this.init();
    }

    protected void init() {
        this.fieldMap.put(MATERIAL, MATERIAL);
        this.fieldMap.put(UNIT, UNIT);
        this.fieldMap.put(QTY, QTY);
        this.fieldMap.put(BASEQTY, BASEQTY);
        this.fieldMap.put(TAXPRICE, PRICE);
        this.fieldMap.put("taxPrice", TAXPRICE);
        this.fieldMap.put(ACTUALPRICE, ACTUALPRICE);
        this.fieldMap.put(ACTUALTAXPRICE, ACTUALTAXPRICE);
        this.fieldMap.put(TAXRATE, TAXRATE);
        this.fieldMap.put("tax", "tax");
        this.fieldMap.put("localTax", "taxLocal");
        this.fieldMap.put("amount", "priceExcludingTax");
        this.fieldMap.put("localAmount", "priceExcludingTaxLocal");
        this.fieldMap.put("taxAmount", "priceIncludingTax");
        this.fieldMap.put("localTaxAmount", "priceIncludingTaxLocal");
        this.fieldMap.put("discount", DISCOUNTRATE);
        this.fieldMap.put(DISCOUNTAMOUNT, DISCOUNTAMOUNT);
        this.fieldMap.put("localDiscountAmount", LOCALDISCOUNTAMOUNT);
    }

    public void calTotalFields() {
        this.calTotalAmount();
        this.calTotalTax();
        this.calTotalTaxAmount();
        this.calTotalLocalAmount();
        this.calTotalLocalTax();
        this.calTotalLocalTaxAmount();
    }

    protected void calTotalAmount() {
        BigDecimal totalAmount = this.getEntryFieldSum("amount");
        this.setTotalAmount(totalAmount);
    }

    protected void calTotalTax() {
        BigDecimal totalTax = this.getEntryFieldSum("tax");
        this.setTotalTax(totalTax);
    }

    protected void calTotalTaxAmount() {
        BigDecimal totalTaxAmount = this.getEntryFieldSum("taxAmount");
        this.setTotalTaxAmount(totalTaxAmount);
    }

    protected void calTotalLocalAmount() {
        BigDecimal totalLocalAmount = this.getEntryFieldSum("localAmount");
        this.setTotalLocalAmount(totalLocalAmount);
    }

    protected void calTotalLocalTax() {
        BigDecimal totalLocalTax = this.getEntryFieldSum("localTax");
        this.setTotalLocalTax(totalLocalTax);
    }

    protected void calTotalLocalTaxAmount() {
        BigDecimal totalLocalTaxAmount = this.getEntryFieldSum("localTaxAmount");
        this.setTotalLocalTaxAmount(totalLocalTaxAmount);
    }

    protected BigDecimal getEntryFieldSum(String property) {
        BigDecimal totalAmount = SysConstant.BIGZERO;
        PropertyCalculator siCalculator = null;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            siCalculator = this.getPropertyCalculator(i);
            totalAmount = totalAmount.add(siCalculator.getBigDecimal(property));
        }
        return totalAmount;
    }

    @Override
    public int getDiscountRatePrecision(int i) {
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            return this.getDefaultDiscountRatePrecision(i);
        }
        if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            return this.getPricePrecision(i);
        }
        return this.getDefaultDiscountRatePrecision(i);
    }

    public int getDefaultDiscountRatePrecision(int i) {
        return 4;
    }

    @Override
    protected boolean isRowDiscount100(int i) {
        return DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i)) && this.getDiscount(i).compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0;
    }

    protected void calByUnit(int i) throws EASBizException, BOSException {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        this.calQtyByBaseQty(i);
        BigDecimal discountRate = this.getDiscount(i);
        if (null == discountRate || discountRate.compareTo(IMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
            discountRate = new BigDecimal("0.0");
        }
        if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discount=discountAmount/qty", this.getPricePrecision(i));
        }
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(IMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("taxPrice=discountAmount/qty/(discount/100)", this.getPricePrecision(i));
                } else {
                    siCalculator.evalForEntry("taxPrice=taxAmount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty+discount", this.getPricePrecision(i));
            }
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(IMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("price=discountAmount/qty/(1+taxRate/100)", this.getPricePrecision(i));
                } else {
                    siCalculator.evalForEntry("price=amount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("price=amount/qty+discount", this.getPricePrecision(i));
            }
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
            siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    protected void calByQty(int i) throws EASBizException, BOSException {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        this.calBaseQtyByQty(i);
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("actualPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("localTaxAmount=0", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("localAmount=0", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("amount=0", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("taxAmount=0", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByTaxRate(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (this.isInTax()) {
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByDiscountType(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByDiscountRate(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        BigDecimal discountValue = this.getDiscount(i);
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i)) && discountValue.compareTo(IMConstant.BIGDECIMAL_ONEHUNDRED) > 0 || DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i)) && discountValue.compareTo(this.getTaxPrice(i)) > 0) {
            siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
        }
        if (this.isInTax()) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*taxPrice*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
                siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("actualPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else if (this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=0", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i)) && this.getDiscount(i).compareTo(new BigDecimal(100)) == 0) {
            siCalculator.evalForEntry("localTaxAmount=0", this.getPricePrecision(i));
            siCalculator.evalForEntry("localAmount=0", this.getPricePrecision(i));
            siCalculator.evalForEntry("amount=0", this.getPricePrecision(i));
            siCalculator.evalForEntry("taxAmount=0", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByDiscountAmount(int i) throws Exception {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (this.isInTax()) {
            siCalculator.evalForEntry("taxAmount=qty*taxPrice-discountAmount", this.getAmountPrecision());
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/(taxPrice*qty)*100", this.getDiscountRatePrecision(i));
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/qty", this.getPricePrecision(i));
            }
        } else {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/(taxPrice*qty)*100", this.getDiscountRatePrecision(i));
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discount=discountAmount/(qty*(1+taxRate/100))", this.getPricePrecision(i));
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0) {
                    siCalculator.evalForEntry("discount=0", this.getDiscountRatePrecision(i));
                }
                siCalculator.evalForEntry("amount=qty*(price-discount)", this.getAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByTax(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (this.isInTax()) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getAmountPrecision());
        }
    }

    protected boolean ignoreBaseAlgorithm(int i) {
        return false;
    }

    @Override
    public int getDefaultPricePrecision(int i) {
        return 10;
    }

    public void calByPrice(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (!this.ignoreBaseAlgorithm(i)) {
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=qty*price*(1-discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("amount=(price-discount)*qty", this.getAmountPrecision());
            }
        }
        this.calByPriceBase(i, siCalculator);
    }

    protected void calByTaxPrice(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (!this.ignoreBaseAlgorithm(i)) {
            DiscountModeEnum discountMode = this.getDiscountType(i);
            if (null != discountMode && DiscountModeEnum.PERCENT.equals((Object)discountMode)) {
                siCalculator.evalForEntry("taxAmount=qty*taxPrice*(1-discount/100)", this.getAmountPrecision());
            } else {
                siCalculator.evalForEntry("taxAmount=qty*(taxPrice-discount)", this.getAmountPrecision());
            }
        }
        this.calByTaxPriceBase(i, siCalculator);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void calByTaxPriceComputeQty(int i, KDTEditEvent e, MakeInvoiceReqEditUI editUI) throws EASBizException, BOSException {
        PropertyCalculator siCalculator;
        block7: {
            block8: {
                siCalculator = this.getPropertyCalculator(i);
                DiscountModeEnum discountMode = this.getDiscountType(i);
                if (null == discountMode || !DiscountModeEnum.PERCENT.equals((Object)discountMode)) break block8;
                if (siCalculator.getBigDecimal("taxPrice").compareTo(BigDecimal.ZERO) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else if (siCalculator.getBigDecimal("discount").compareTo(new BigDecimal(100)) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else {
                    siCalculator.evalForEntry("qty=taxAmount/(taxPrice*(1-discount/100))", this.getQtyPrecision(i));
                }
                break block7;
            }
            if (siCalculator.getBigDecimal("taxPrice").compareTo(siCalculator.getBigDecimal("discount")) < 1) {
                if (siCalculator.getBigDecimal("taxPrice").compareTo(BigDecimal.ZERO) != 0) {
                    String invalidMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"VALUE_VALID", (Object[])new Object[]{siCalculator.getBigDecimal("taxPrice")});
                    editUI.showInvalidMsg(invalidMsg, null, null);
                    siCalculator.evalForEntry("taxPrice=" + e.getOldValue(), this.getPricePrecision(i));
                    return;
                }
                siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
            } else {
                siCalculator.evalForEntry("qty=taxAmount/(taxPrice-discount)", this.getQtyPrecision(i));
            }
        }
        this.calBaseQtyByQty(i);
        this.calByTaxPriceBase(i, siCalculator);
    }

    private void calByTaxPriceBase(int i, PropertyCalculator siCalculator) {
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
        }
        siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
        siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void calByAmountComputeQty(int i, KDTEditEvent e, MakeInvoiceReqEditUI editUI) throws EASBizException, BOSException {
        PropertyCalculator siCalculator;
        block7: {
            block8: {
                siCalculator = this.getPropertyCalculator(i);
                DiscountModeEnum discountMode = this.getDiscountType(i);
                if (null == discountMode || !DiscountModeEnum.PERCENT.equals((Object)discountMode)) break block8;
                if (siCalculator.getBigDecimal(TAXPRICE).compareTo(BigDecimal.ZERO) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else if (siCalculator.getBigDecimal("discount").compareTo(new BigDecimal(100)) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else {
                    siCalculator.evalForEntry("qty=amount/price/(1-discount/100)", this.getQtyPrecision(i));
                }
                break block7;
            }
            if (siCalculator.getBigDecimal(TAXPRICE).compareTo(siCalculator.getBigDecimal("discount")) < 1) {
                if (siCalculator.getBigDecimal(TAXPRICE).compareTo(BigDecimal.ZERO) != 0) {
                    String invalidMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"VALUE_VALID", (Object[])new Object[]{siCalculator.getBigDecimal("amount")});
                    editUI.showInvalidMsg(invalidMsg, null, null);
                    siCalculator.evalForEntry("amount=" + e.getOldValue(), this.getPricePrecision(i));
                    return;
                }
                siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
            } else {
                siCalculator.evalForEntry("qty=amount/(price-discount)", this.getQtyPrecision(i));
            }
        }
        this.calBaseQtyByQty(i);
        this.calByAmountBase(i, siCalculator);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void calByTaxAmountComputeQty(int i, KDTEditEvent e, MakeInvoiceReqEditUI editUI) throws EASBizException, BOSException {
        PropertyCalculator siCalculator;
        block7: {
            block8: {
                siCalculator = this.getPropertyCalculator(i);
                DiscountModeEnum discountMode = this.getDiscountType(i);
                if (null == discountMode || !DiscountModeEnum.PERCENT.equals((Object)discountMode)) break block8;
                if (siCalculator.getBigDecimal("taxPrice").compareTo(BigDecimal.ZERO) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else if (siCalculator.getBigDecimal("discount").compareTo(new BigDecimal(100)) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else {
                    siCalculator.evalForEntry("qty=taxAmount/taxPrice/(1-discount/100)", this.getQtyPrecision(i));
                }
                break block7;
            }
            if (siCalculator.getBigDecimal("taxPrice").compareTo(siCalculator.getBigDecimal("discount")) < 1) {
                if (siCalculator.getBigDecimal("taxPrice").compareTo(BigDecimal.ZERO) != 0) {
                    String invalidMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"VALUE_VALID", (Object[])new Object[]{siCalculator.getBigDecimal("taxAmount")});
                    editUI.showInvalidMsg(invalidMsg, null, null);
                    siCalculator.evalForEntry("taxAmount=" + e.getOldValue(), this.getPricePrecision(i));
                    return;
                }
                siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
            } else {
                siCalculator.evalForEntry("qty=taxAmount/(taxPrice-discount)", this.getQtyPrecision(i));
            }
        }
        this.calBaseQtyByQty(i);
        this.calByTaxAmountBase(i, siCalculator);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void calByPriceComputeQty(int i, KDTEditEvent e, MakeInvoiceReqEditUI editUI) throws EASBizException, BOSException {
        PropertyCalculator siCalculator;
        block7: {
            block8: {
                siCalculator = this.getPropertyCalculator(i);
                DiscountModeEnum discountMode = this.getDiscountType(i);
                if (null == discountMode || !DiscountModeEnum.PERCENT.equals((Object)discountMode)) break block8;
                if (siCalculator.getBigDecimal(TAXPRICE).compareTo(BigDecimal.ZERO) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else if (siCalculator.getBigDecimal("discount").compareTo(new BigDecimal(100)) == 0) {
                    siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                    break block7;
                } else {
                    siCalculator.evalForEntry("qty=amount/price/(1-discount/100)", this.getQtyPrecision(i));
                }
                break block7;
            }
            if (siCalculator.getBigDecimal(TAXPRICE).compareTo(siCalculator.getBigDecimal("discount")) < 1) {
                if (siCalculator.getBigDecimal(TAXPRICE).compareTo(BigDecimal.ZERO) != 0) {
                    String invalidMsg = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"VALUE_VALID", (Object[])new Object[]{siCalculator.getBigDecimal(TAXPRICE)});
                    editUI.showInvalidMsg(invalidMsg, null, null);
                    siCalculator.evalForEntry("price=" + e.getOldValue(), this.getPricePrecision(i));
                    return;
                }
                siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
            } else {
                siCalculator.evalForEntry("qty=amount/(price-discount)", this.getQtyPrecision(i));
            }
        }
        this.calBaseQtyByQty(i);
        this.calByPriceBase(i, siCalculator);
    }

    private void calByPriceBase(int i, PropertyCalculator siCalculator) {
        siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByAmount(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            BigDecimal discountRate;
            BigDecimal bigDecimal = discountRate = null == this.getDiscount(i) ? new BigDecimal("0.0") : this.getDiscount(i);
            if (discountRate.compareTo(IMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                siCalculator.evalForEntry("price=amount/qty", this.getPricePrecision(i));
                siCalculator.evalForEntry("discount=0", this.getPricePrecision(i));
            } else {
                siCalculator.evalForEntry("price=amount/qty/(1-discount/100)", this.getPricePrecision(i));
            }
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("price=amount/qty+discount", this.getPricePrecision(i));
        }
        this.calByAmountBase(i, siCalculator);
    }

    private void calByAmountBase(int i, PropertyCalculator siCalculator) {
        if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
        }
        siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
        if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
        siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected void calByTaxAmount(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            BigDecimal discountRate;
            BigDecimal bigDecimal = discountRate = null == this.getDiscount(i) ? new BigDecimal("0.0") : this.getDiscount(i);
            if (discountRate.compareTo(IMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty", this.getPricePrecision(i));
                siCalculator.evalForEntry("discount=0", this.getPricePrecision(i));
            } else {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty/(1-discount/100)", this.getPricePrecision(i));
            }
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("taxPrice=taxAmount/qty+discount", this.getPricePrecision(i));
        }
        this.calByTaxAmountBase(i, siCalculator);
    }

    private void calByTaxAmountBase(int i, PropertyCalculator siCalculator) {
        if (!this.ignoreCalLocalTaxAmount(i)) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
        }
        siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
        siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
            siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
        siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
        }
        siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax()) {
            siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
        }
        if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
        } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
            siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }

    protected boolean ignoreCalLocalTaxAmount(int i) {
        return false;
    }

    public void calByCurrency(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        BigDecimal discountRate = this.getDiscount(i);
        if (null == discountRate || discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) > 0) {
            discountRate = new BigDecimal("0.0");
        }
        if (this.isInTax()) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("taxAmount=localTaxAmount/" + this.getExchangeRate(), this.getAmountPrecision());
            } else {
                siCalculator.evalForEntry("taxAmount=localTaxAmount*" + this.getExchangeRate(), this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=taxAmount/(1+taxRate/100)*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("amount=taxAmount-tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("taxPrice=0", this.getPricePrecision(i));
                } else if (siCalculator.getBigDecimal(QTY) != null) {
                    siCalculator.evalForEntry("taxPrice=taxAmount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("taxPrice=taxAmount/qty+discount", this.getPricePrecision(i));
            }
            if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) == 0 && this.isInTax() && !this.isRowDiscount100(i)) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty", this.getAmountPrecision());
            }
            siCalculator.evalForEntry("price=taxPrice/(1+taxRate/100)", this.getPricePrecision(i));
        } else {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("amount=localAmount/" + this.getExchangeRate(), this.getAmountPrecision());
            } else {
                siCalculator.evalForEntry("amount=localAmount*" + this.getExchangeRate(), this.getAmountPrecision());
            }
            siCalculator.evalForEntry("tax=amount*(taxRate/100)", this.getAmountPrecision());
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else if (this.getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE && SysConstant.BIGZERO.compareTo(this.getExchangeRate()) != 0) {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("taxAmount=amount+tax", this.getAmountPrecision());
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i)) || DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                    siCalculator.evalForEntry("price=0", this.getPricePrecision(i));
                } else if (siCalculator.getBigDecimal(QTY) != null && siCalculator.getBigDecimal(QTY).compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
                    siCalculator.evalForEntry("price=amount/qty/(1-discount/100)", this.getPricePrecision(i));
                }
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("price=amount/qty+discount", this.getPricePrecision(i));
            }
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) == 0 && !this.isInTax() && !this.isRowDiscount100(i)) {
                siCalculator.evalForEntry("discount=0", this.getDiscount(i).scale());
            }
            siCalculator.evalForEntry("taxPrice=price*(1+taxRate/100)", this.getPricePrecision(i));
            if (DiscountModeEnum.NULL.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERCENT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=taxPrice*qty*(discount/100)", this.getAmountPrecision());
            } else if (DiscountModeEnum.PERUNIT.equals((Object)this.getDiscountType(i))) {
                siCalculator.evalForEntry("discountAmount=discount*qty*(1+taxRate/100)", this.getAmountPrecision());
            }
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualPrice=price", this.getPricePrecision(i));
        } else if (siCalculator.getBigDecimal(QTY) != null && siCalculator.getBigDecimal(QTY).compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            siCalculator.evalForEntry("actualPrice=amount/qty", this.getPricePrecision(i));
        }
        if (this.getDiscount(i).compareTo(SysConstant.BIGZERO) == 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxPrice", this.getPricePrecision(i));
        } else if (siCalculator.getBigDecimal(QTY) != null && siCalculator.getBigDecimal(QTY).compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            siCalculator.evalForEntry("actualTaxPrice=taxAmount/qty", this.getPricePrecision(i));
        }
    }

    public void calByExchangeRate(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        if (this.isInTax()) {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTaxAmount=taxAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTaxAmount=taxAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localAmount=localTaxAmount-localTax", this.getLocalAmountPrecision());
        } else {
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localAmount=amount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localAmount=amount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                siCalculator.evalForEntry("localTax=tax*" + this.getExchangeRate(), this.getLocalAmountPrecision());
            } else {
                siCalculator.evalForEntry("localTax=tax/" + this.getExchangeRate(), this.getLocalAmountPrecision());
            }
            siCalculator.evalForEntry("localTaxAmount=localAmount+localTax", this.getLocalAmountPrecision());
        }
        if (this.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount*" + this.getExchangeRate(), this.getLocalAmountPrecision());
        } else {
            siCalculator.evalForEntry("localDiscountAmount=discountAmount/" + this.getExchangeRate(), this.getLocalAmountPrecision());
        }
    }
}

