/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tm.im.CombinRuleSettingFactory;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.CombinRuleStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractCombinRuleListUI;
import com.kingdee.eas.tm.im.basedata.client.CombinRuleEditUI;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CombinRuleListUI
extends AbstractCombinRuleListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(CombinRuleListUI.class);
    private ListUIHelper uiHelper = new ListUIHelper((ListUI)this);
    private String currentCUID;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setButVisible();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void setButVisible() {
        this.btnLocate.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnQueryScheme.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.btnWorkFlowList.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnCancelCancel.setVisible(true);
        this.btnCancel.setVisible(true);
        this.MenuItemAttachment.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList = CombinRuleSettingFactory.getRemoteInstance().setUnActive(ids);
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\n");
                }
                int errorCount = errorList.size();
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetailMSG.toString(), (int)1);
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        ArrayList errorList = CombinRuleSettingFactory.getRemoteInstance().setActive(ids);
        String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append(errorList.get(i)).append("\n");
            }
            int errorCount = errorList.size();
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
            MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetailMSG.toString(), (int)1);
        } else {
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelSuccess", IMUtils.getLocale());
            MsgBox.showInfo((String)summaryMsg);
        }
        this.actionRefresh_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        String id = this.getSelectedKeyValue();
        CombinRuleSettingInfo info = CombinRuleSettingFactory.getRemoteInstance().getCombinRuleSettingInfo((IObjectPK)new ObjectUuidPK(id));
        if (CombinRuleStatusEnum.USING.equals((Object)info.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"COMBIN_EDITERR"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        super.actionRemove_actionPerformed(e);
    }

    protected void Remove() throws Exception {
        this.uiHelper.batchOperation("delete", this.tblMain, this.getKeyFieldName(), "number", "D4C58B67");
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return CombinRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CombinRuleSettingFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions() && !this.uiHelper.isAddNew(action)) {
            CombinRuleSettingInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue())) && (info = CombinRuleSettingFactory.getRemoteInstance().getCombinRuleSettingInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCU() != null) {
                    pk = new ObjectUuidPK(info.getCU().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }
}

