/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerMailingInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingStatusEnum;
import com.kingdee.eas.tm.im.basedata.MailTypeEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractCustomerMailingEditUI;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.im.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class CustomerMailingEditUI
extends AbstractCustomerMailingEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomerMailingEditUI.class);
    protected boolean isNumberEditable = false;
    public static final String TB_CONTACTS = "contacts";
    public static final String TB_CONTACTSUSER = "contactsUser";
    public static final String TB_ISDEFAULT = "isDefault";
    public static final String TB_ADDRESS = "address";
    public static final String TB_TELEPHONE = "telephone";
    public static final String TB_COMPANYNAME = "companyName";
    private static final String[] ENTRY_CHECK_COLUMN = new String[]{"companyName", "address", "postalcode", "mailbox", "express", "contacts", "contactsUser", "telephone"};
    private KDTEditAdapter entryTableChange = null;
    private DataChangeListener prmtCompanyChange = null;
    private DataChangeListener prmtCustomerChange = null;
    private EditUIHelper uiHelper = new EditUIHelper((EditUI)this);
    private Map btnMap = new HashMap();
    private String currentCUID;

    public CustomerMailingEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSave);
        this.btnMap.put("actionCopy", this.actionCopy);
        this.btnMap.put("actionAddLine", this.actionAddLine);
        this.btnMap.put("actionInsertLine", this.actionInsertLine);
        this.btnMap.put("actionRemoveLine", this.actionRemoveLine);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEntry();
        this.btnAuditResult.setVisible(false);
        this.menuItemCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        this.uiHelper.setMainBizCUFilter();
        this.initBtnStatus();
    }

    private void initNumber() {
        try {
            String companyID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, companyID);
            if (codingRule == null) {
                this.isNumberEditable = true;
                return;
            }
            if (codingRule.isIsModifiable()) {
                this.isNumberEditable = true;
            }
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initComponents() {
        this.txtNumber.setEditable(this.isNumberEditable);
    }

    private void initBtnStatus() {
        this.initComponents();
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        CustomerMailingStatusEnum status = this.editData.getStatus();
        boolean isLight = false;
        if (CustomerMailingStatusEnum.InActive.equals((Object)status)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.kdtEntries.setEnabled(false);
        } else {
            this.kdtEntries.setEnabled(true);
        }
    }

    protected void kdtEntries_ChangedStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_ISDEFAULT.equalsIgnoreCase(fieldName)) {
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (i != rowIndex) {
                    this.getDetailTable().getRow(i).getCell(fieldName).setValue((Object)false);
                    continue;
                }
                this.getDetailTable().getRow(i).getCell(fieldName).setValue((Object)true);
            }
        }
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        UserInfo user;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        String fieldName = this.kdtEntries.getColumnKey(colIndex);
        if (TB_CONTACTSUSER.equalsIgnoreCase(fieldName) && (user = (UserInfo)this.kdtEntries.getCell(rowIndex, colIndex).getValue()) != null) {
            this.kdtEntries.getCell(rowIndex, TB_CONTACTS).setValue((Object)user.getName());
        }
    }

    private void initEntry() {
        KDBizPromptBox kDBizPromptBoxUnit = new KDBizPromptBox();
        kDBizPromptBoxUnit.setEditable(true);
        kDBizPromptBoxUnit.setQueryInfo("com.kingdee.eas.base.permission.app.UserSimpleQuery");
        kDBizPromptBoxUnit.setEnabledMultiSelection(false);
        kDBizPromptBoxUnit.setDisplayFormat("$name$");
        kDBizPromptBoxUnit.setEditFormat("$number$");
        kDBizPromptBoxUnit.setCommitFormat("$number$");
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(TB_CONTACTSUSER).setRenderer((IBasicRender)avr);
        this.getDetailTable().getColumn(TB_CONTACTSUSER).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxUnit));
    }

    @Override
    public void loadFields() {
        this.removeEventLisener();
        super.loadFields();
        this.initNumber();
        this.initComponents();
        this.initBtnStatus();
        this.addEventLisener();
        try {
            this.comboMailType_itemStateChanged(null);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.initCustomerFilter();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    private void addEventLisener() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarting(KDTEditEvent e) {
                    try {
                        CustomerMailingEditUI.this.kdtEntries_ChangedStarting(e);
                    }
                    catch (Exception ex) {
                        CustomerMailingEditUI.this.handUIException(ex);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        CustomerMailingEditUI.this.kdtEntries_editStopped(e);
                    }
                    catch (Exception ex) {
                        CustomerMailingEditUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtCompanyChange == null) {
            this.prmtCompanyChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    CustomerMailingEditUI.this.prmtCompanyChange_dataChanged(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyChange);
        if (this.prmtCustomerChange == null) {
            this.prmtCustomerChange = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    CustomerMailingEditUI.this.prmtCustomerChange_dataChanged(eventObj);
                }
            };
        }
        this.prmtCustomer.addDataChangeListener(this.prmtCustomerChange);
    }

    protected void prmtCompanyChange_dataChanged(DataChangeEvent e) {
        if (IMUtils.objectEquals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.initCustomerFilter();
        this.prmtCustomer.setValue(null);
        this.updateRowsCompanyName();
    }

    protected void prmtCustomerChange_dataChanged(DataChangeEvent e) {
        if (IMUtils.objectEquals(e.getNewValue(), e.getOldValue())) {
            return;
        }
        this.updateRowsCompanyName();
    }

    protected void updateRowsCompanyName() {
        String companyName = this.getCompanyNameByPrmt();
        if (StringUtils.isEmpty((String)companyName)) {
            return;
        }
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.getDetailTable().getRow(i).getCell(TB_COMPANYNAME).setValue((Object)companyName);
        }
    }

    protected void clearRowsCompanyName() {
        int rowCount = this.getDetailTable().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.getDetailTable().getRow(i).getCell(TB_COMPANYNAME).setValue(null);
        }
    }

    protected String getCompanyNameByPrmt() {
        try {
            MailTypeEnum mailType;
            block5: {
                mailType = (MailTypeEnum)((Object)this.comboMailType.getSelectedItem());
                if (!MailTypeEnum.SendMail.equals((Object)mailType)) break block5;
                if (this.prmtCompany.getValue() != null) {
                    return ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getName();
                }
                break block6;
            }
            if (!MailTypeEnum.ReceiveMail.equals((Object)mailType)) break block7;
            if (this.prmtCustomer.getValue() != null) {
                return ((CustomerInfo)this.prmtCustomer.getValue()).getName();
            }
        }
        finally {
            return null;
        }
        {
            block6: {
                block7: {
                }
            }
        }
    }

    private void initCustomerFilter() {
        String companyId = this.prmtCompany.getValue() == null ? "" : ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)companyId)) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        ev.setFilter(filter);
        this.prmtCustomer.setEntityViewInfo(ev);
        this.prmtCustomer.setHasCUDefaultFilter(false);
    }

    private void removeEventLisener() {
        this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
        if (this.prmtCompanyChange != null) {
            this.prmtCompany.removeDataChangeListener(this.prmtCompanyChange);
        }
        if (this.prmtCustomerChange != null) {
            this.prmtCustomer.removeDataChangeListener(this.prmtCustomerChange);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (e != null && e.getSource() != null && (e.getSource() == this.btnSave || e.getSource() == this.menuItemSave)) {
            int i;
            String message = null;
            int rowCount = this.getDetailTable().getRowCount();
            boolean hasVolidEntry = false;
            for (i = 0; i < rowCount; ++i) {
                if (this.isRowBlankOnTable(this.getDetailTable(), i, ENTRY_CHECK_COLUMN)) continue;
                hasVolidEntry = true;
                break;
            }
            if (!hasVolidEntry) {
                message = this.getResource("Entry_NOT_NULL");
                MsgBox.showInfo((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
            for (i = 0; i < rowCount; ++i) {
                if (!this.isRowBlankOnTable(this.getDetailTable(), i, ENTRY_CHECK_COLUMN)) continue;
                this.removeLine(this.getDetailTable(), i);
                --i;
                --rowCount;
            }
            this.setEntryDefaultRow();
        }
    }

    private boolean isRowBlankOnTable(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null) {
            throw new Exception("table is null!");
        }
        if (cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]) == null || detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    protected void removeLine(KDTable table, int rowIndex) {
        if (table == null) {
            return;
        }
        if (table.getRow(rowIndex) != null) {
            table.getSelectManager().select(rowIndex, 0, rowIndex, 0, 2);
            IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
            table.removeRow(rowIndex);
            IObjectCollection collection = (IObjectCollection)table.getUserObject();
            if (collection == null) {
                logger.error((Object)"collection not be binded to table");
            } else if (detailData != null) {
                collection.removeObject(detailData);
            }
            this.afterRemoveLine(table, detailData);
        }
    }

    private void setEntryDefaultRow() {
        if (this.comboMailType.getSelectedItem().equals((Object)MailTypeEnum.SendMail)) {
            int rowCount = this.getDetailTable().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                this.getDetailTable().getRow(i).getCell(TB_ISDEFAULT).setValue((Object)false);
            }
            return;
        }
        boolean hasDefaultRow = false;
        int defaultRowIndex = 0;
        int rowCount = this.getDetailTable().getRowCount();
        boolean rowValue = false;
        for (int i = 0; i < rowCount; ++i) {
            rowValue = (Boolean)this.getDetailTable().getRow(i).getCell(TB_ISDEFAULT).getValue();
            if (rowValue) {
                defaultRowIndex = i;
                hasDefaultRow = true;
            }
            if (!hasDefaultRow || defaultRowIndex == i) continue;
            this.getDetailTable().getRow(i).getCell(TB_ISDEFAULT).setValue((Object)false);
        }
        if (!hasDefaultRow) {
            this.getDetailTable().getRow(defaultRowIndex).getCell(TB_ISDEFAULT).setValue((Object)true);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CustomerMailingEntryInfo entryInfo = new CustomerMailingEntryInfo();
        entryInfo.setIsDefault(false);
        String companyName = this.getCompanyNameByPrmt();
        if (!StringUtils.isEmpty((String)companyName)) {
            entryInfo.setCompanyName(companyName);
        }
        return entryInfo;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getStatus() != null && CustomerMailingStatusEnum.Active.equals((Object)this.editData.getStatus())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getStatus().getValue() == "2") {
            MsgBox.showInfo((String)this.getResource("ActiveNotEdit"));
            SysUtil.abort();
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        super.actionRemove_actionPerformed(e);
        this.initBtnStatus();
    }

    @Override
    protected void comboMailType_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null && e.getStateChange() == 2) {
            return;
        }
        MailTypeEnum mailType = (MailTypeEnum)((Object)this.comboMailType.getSelectedItem());
        if (MailTypeEnum.SendMail.equals((Object)mailType)) {
            this.prmtCustomer.setValue(null);
            this.contCustomer.setVisible(false);
            this.prmtCompany.setRequired(true);
            this.prmtCustomer.setRequired(false);
            this.getDetailTable().getColumn(TB_ISDEFAULT).getStyleAttributes().setWeight(-1.0f);
            this.getDetailTable().getColumn(TB_ISDEFAULT).getStyleAttributes().setHided(true);
        } else if (MailTypeEnum.ReceiveMail.equals((Object)mailType)) {
            this.contCustomer.setVisible(true);
            this.prmtCustomer.setRequired(true);
            this.prmtCompany.setRequired(false);
            this.getDetailTable().getColumn(TB_ISDEFAULT).getStyleAttributes().setWeight(-1.0f);
            this.getDetailTable().getColumn(TB_ISDEFAULT).getStyleAttributes().setHided(false);
        }
        if (e != null) {
            this.clearRowsCompanyName();
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.actionInsertLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        ArrayList<JButton> btnList = new ArrayList<JButton>();
        btnList.add(this.tableContainer.add((Action)this.actionAddLine));
        btnList.add(this.tableContainer.add((Action)this.actionInsertLine));
        btnList.add(this.tableContainer.add((Action)this.actionRemoveLine));
        for (int i = 0; i < btnList.size(); ++i) {
            KDWorkButton btn = (KDWorkButton)btnList.get(i);
            btn.setText(null);
            btn.setSize(new Dimension(22, 19));
            btn.setEnabled(true);
        }
    }

    protected IObjectValue createNewData() {
        CustomerMailingInfo info = new CustomerMailingInfo();
        info.setMailType(MailTypeEnum.ReceiveMail);
        info.setStatus(CustomerMailingStatusEnum.Active);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.getEntries().add((CustomerMailingEntryInfo)this.createNewDetailData(this.getDetailTable()));
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("mailType"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("entries.companyName"));
        sic.add(new SelectorItemInfo("entries.address"));
        sic.add(new SelectorItemInfo("entries.postalcode"));
        sic.add(new SelectorItemInfo("entries.mailbox"));
        sic.add(new SelectorItemInfo("entries.express"));
        sic.add(new SelectorItemInfo("entries.contacts"));
        sic.add(new SelectorItemInfo("entries.telephone"));
        sic.add(new SelectorItemInfo("entries.isDefault"));
        sic.add(new SelectorItemInfo("entries.contactsUser.id"));
        sic.add(new SelectorItemInfo("entries.contactsUser.name"));
        sic.add(new SelectorItemInfo("entries.contactsUser.number"));
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CustomerMailingFactory.getRemoteInstance();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        CustomerMailingInfo info = (CustomerMailingInfo)newData;
        info.setNumber(null);
        info.setStatus(CustomerMailingStatusEnum.Active);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        String cuID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, cuID);
            String number = "";
            if (codingRule != null && codingRule.isIsAddView()) {
                number = iCodingRuleManager.getNumber((IObjectValue)this.editData, cuID);
            }
            this.editData.setNumber(number);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        super.actionCancelCancel_actionPerformed(e);
        if (this.editData.getStatus() != null && CustomerMailingStatusEnum.Active.equals((Object)this.editData.getStatus())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        super.actionCancel_actionPerformed(e);
        this.setOprtState("VIEW");
        this.initBtnStatus();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerMailingResource", (String)key);
    }

    private String getResource(String key, Object[] params) {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerMailingResource", (String)key, (Object[])params);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null && !this.uiHelper.isAddNew(action)) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    @Override
    public String getPermItem(String status) {
        return "bd_customerMailing_new";
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtCompany;
    }
}

