/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.im.basedata.IncomeTypeFactory;
import com.kingdee.eas.tm.im.basedata.IncomeTypeInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractIncomeTypeListUI;
import com.kingdee.eas.tm.im.basedata.client.IncomeTypeEditUI;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class IncomeTypeListUI
extends AbstractIncomeTypeListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeTypeListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    private CommonQueryDialog commonQueryDialog = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public IncomeTypeListUI() throws Exception {
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "name", "status", "CU.name", "creator.name", "createTime", "type"};
        return columns;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.initBtnStatus();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    private void initBtnStatus() {
        this.MenuItemAttachment.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAuditResult.setVisible(false);
    }

    protected String getEditUIName() {
        return IncomeTypeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return IncomeTypeFactory.getRemoteInstance();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        String id = this.getSelectedKeyValue();
        IncomeTypeInfo info = IncomeTypeFactory.getRemoteInstance().getIncomeTypeInfo((IObjectPK)new ObjectUuidPK(id));
        if (IncomeTypeStatusEnum.Active.equals((Object)info.getStatus())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"CANNOTEDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        String errorDetail = "";
        if (!this.confirmRemove()) {
            return;
        }
        ArrayList result = IncomeTypeFactory.getRemoteInstance().batchDelete(this.getSelectedIdValues());
        if (!result.isEmpty()) {
            errorDetail = IMUtils.buildErrorMsg(result);
            int errorCount = result.size();
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_DeleteError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
            MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetail.toString(), (int)1);
        } else {
            String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_DeleteSuccess", IMUtils.getLocale());
            MsgBox.showInfo((String)summaryMsg);
        }
        this.refreshList();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
            for (int i = 0; i < ids.size(); ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(ids.get(i).toString());
                pks.add(pk);
            }
            ArrayList result = IncomeTypeFactory.getRemoteInstance().setUnActive(pks);
            StringBuffer errorDetail = new StringBuffer();
            if (!result.isEmpty()) {
                for (int i = 0; i < result.size(); ++i) {
                    errorDetail.append(result.get(i));
                }
                int errorCount = result.size();
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetail.toString(), (int)1);
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.refreshList();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, ids);
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
            for (int i = 0; i < ids.size(); ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(ids.get(i).toString());
                pks.add(pk);
            }
            ArrayList result = IncomeTypeFactory.getRemoteInstance().setActive(pks);
            StringBuffer errorDetail = new StringBuffer();
            if (!result.isEmpty()) {
                for (int i = 0; i < result.size(); ++i) {
                    errorDetail.append(result.get(i)).append("\r\n");
                }
                int errorCount = result.size();
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetail.toString(), (int)1);
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.refreshList();
        }
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "incomeType";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "incomeType";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        IncomeTypeInfo info = null;
        try {
            if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && !this.uiHelper.isAddNew(action) && (info = IncomeTypeFactory.getRemoteInstance().getIncomeTypeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCU() != null) {
                pk = new ObjectUuidPK(info.getCU().getId().toString());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    protected String getOnloadPermItemName() {
        return "bd_incomeType_view";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(300);
        }
        return this.commonQueryDialog;
    }
}

