/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.common.help.msgHelp.client.TMMsgBox;
import com.kingdee.eas.tm.common.help.msgHelp.client.util.TMMsgURLUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.TMToolTipInfo;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipResourceUtil;
import com.kingdee.eas.tm.common.help.tipHelp.client.util.TMToolTipUtil;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.basedata.client.AbstractProductListUI;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.IMCommonProcessor;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ProductListUI
extends AbstractProductListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductListUI.class);
    private ListUIHelper uiHelper = null;
    private static final String IMPORTUI_CLASS = "com.kingdee.eas.tm.im.basedata.client.ProductImportUI";
    private static final String BATCHEDITUI_CLASS = "com.kingdee.eas.tm.im.basedata.client.ProductBatchEditUI";
    private static final String BATCHEDITTCCUI_CLASS = "com.kingdee.eas.tm.im.basedata.client.ProductBatchEditTCCUI";
    private static final String PRODUCTGENETICMATCHTCCUI_CLASS = "com.kingdee.eas.tm.im.basedata.client.ProductGeneticMatchTccUI";
    private String currentCUID;
    private static final int AMT_PRECISION = 2;
    public static final String strTakeOutZeroFormat = "%{0.##########}f";
    private CommonQueryDialog commonQueryDialog = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public ProductListUI() throws Exception {
        this.uiHelper = new ListUIHelper(this);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        this.qfsi.getSystemSolutionItem().getDefaultFilter().add("status", CompareType.EQUALS, (Object)0);
        return this.qfsi;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.menuImportMaterial.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        KDMenuItem importMaterial = IMUtils.cloneMenuItem(this.menuImportMaterial);
        this.btnAddNew.addAssistMenuItem((JMenuItem)importMaterial);
        this.menuImportExpenseItem.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        KDMenuItem importExpenseItem = IMUtils.cloneMenuItem(this.menuImportExpenseItem);
        this.btnAddNew.addAssistMenuItem((JMenuItem)importExpenseItem);
        this.menuBatchEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        KDMenuItem batchEdit = IMUtils.cloneMenuItem(this.menuBatchEdit);
        this.btnEdit.addAssistMenuItem((JMenuItem)batchEdit);
        this.menuBatchEditTCC.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        KDMenuItem batchEditTCC = IMUtils.cloneMenuItem(this.menuBatchEditTCC);
        this.btnEdit.addAssistMenuItem((JMenuItem)batchEditTCC);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.tblMain.getColumn("taxRate").getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        this.tblMain.getColumn("price").getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
        IMClientUtils.addDataUpgradeListUI((CoreUIObject)this, this.menuEdit, "0");
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        TMToolTipUtil.setToolTipInfo((JComponent)this.btnAddNew, (TMToolTipInfo)new TMToolTipInfo("btnAddNew", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_AddNew"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.menuBatchEditTCC, (TMToolTipInfo)new TMToolTipInfo("menuBatchEditTCC", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_BatchEditTCC"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.btnAddByTaxRate, (TMToolTipInfo)new TMToolTipInfo("btnAddByTaxRate", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_AddByTaxRate"), ""));
        TMToolTipUtil.setToolTipInfo((JComponent)this.btnGeneticMatchTcc, (TMToolTipInfo)new TMToolTipInfo("btnGeneticMatchTcc", (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("PRODUCT_GeneticMatchTcc"), (String)TMToolTipResourceUtil.FIELDTITLE_MAP.get("OPERATIONTITLE") + ";" + "https://vip.kingdee.com/article/256785309931769088?productLineId=8"));
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionAddByTaxRate_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String uiClass = "com.kingdee.eas.tm.im.basedata.client.ProductTaxRateUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.refreshList();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.im.basedata.client.ProductEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProductCodeFactory.getRemoteInstance();
    }

    @Override
    public void actionImportMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"method", (Object)"importMaterial");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IMPORTUI_CLASS, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionImportExpenseItem_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"method", (Object)"importExpenseItem");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(IMPORTUI_CLASS, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        String id = this.getSelectedKeyValue();
        ProductCodeInfo info = ProductCodeFactory.getRemoteInstance().getProductCodeInfo((IObjectPK)new ObjectUuidPK(id));
        if (ProductCodeStatusEnum.USING.equals((Object)info.getStatus())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"CANNOTEDIT"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        int billCount = ids.size();
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (!this.confirmRemove()) {
            return;
        }
        String error = "";
        String errorDetail = "";
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Map idNumMap = this.getSelectedIdNumber();
            Set idSet = map.keySet();
            boolean lockErr = false;
            for (Object id : idSet) {
                if (((Boolean)map.get(id)).booleanValue()) continue;
                error = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_DeleteError", IMUtils.getLocale(), new Object[]{0, billCount});
                errorDetail = idNumMap.get(id) + ":" + EASResource.getString((String)"com.kingdee.eas.scm.common.ActionResource.ERROR_MUTEX");
                lockErr = true;
                break;
            }
            if (!lockErr) {
                ArrayList result = ProductCodeFactory.getRemoteInstance().batchDelete(ids);
                int errorCount = result.size();
                if (errorCount == 0) {
                    error = EASResource.getString((String)"com.kingdee.eas.tm.im.IMBizResource", (String)"Msg_DeleteSuccess");
                } else {
                    error = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_DeleteError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                    errorDetail = IMUtils.buildErrorMsg(result);
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)this.getSelectedIdValues());
        }
        if (errorDetail.length() > 0) {
            TMMsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
        } else {
            MsgBox.showInfo((String)error);
        }
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            ArrayList ids = this.getSelectedIdValues();
            int billCount = ids.size();
            ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
            for (int i = 0; i < ids.size(); ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(ids.get(i).toString());
                pks.add(pk);
            }
            ArrayList result = ProductCodeFactory.getRemoteInstance().setActive(pks);
            int errorCount = result.size();
            StringBuffer errorDetail = new StringBuffer();
            if (result.size() > 0) {
                for (int i = 0; i < result.size(); ++i) {
                    errorDetail.append(result.get(i)).append("\r\n");
                }
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                TMMsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetail.toString(), (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelCancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.refreshList();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            ArrayList ids = this.getSelectedIdValues();
            int billCount = ids.size();
            ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
            for (int i = 0; i < ids.size(); ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(ids.get(i).toString());
                pks.add(pk);
            }
            ArrayList result = ProductCodeFactory.getRemoteInstance().setUnActive(pks);
            int errorCount = result.size();
            if (result.size() > 0) {
                StringBuffer errorDetail = new StringBuffer();
                for (int i = 0; i < result.size(); ++i) {
                    errorDetail.append(result.get(i)).append("\r\n");
                }
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelError", IMUtils.getLocale(), new Object[]{String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                TMMsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorDetail.toString(), (int)1, (Map)TMMsgURLUtil.getMsgURL((String)"IMK"));
            } else {
                String summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_CancelSuccess", IMUtils.getLocale());
                MsgBox.showInfo((String)summaryMsg);
            }
            this.refreshList();
        }
    }

    @Override
    public void actionBatchEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        ArrayList list = this.getSelectedIdValues();
        HashSet idSet = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            idSet.add(list.get(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ProductCodeCollection coll = ProductCodeFactory.getRemoteInstance().getProductCodeCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            if (!ProductCodeStatusEnum.USING.equals((Object)coll.get(i).getStatus())) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"CANNOTEDIT"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"idSet", idSet);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BATCHEDITUI_CLASS, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionBatchEditTCC_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        ArrayList list = this.getSelectedIdValues();
        HashSet idSet = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            idSet.add(list.get(i));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ProductCodeCollection coll = ProductCodeFactory.getRemoteInstance().getProductCodeCollection(view);
        boolean isSelectVehicle = false;
        for (int i = 0; i < coll.size(); ++i) {
            if (ProductCodeStatusEnum.USING.equals((Object)coll.get(i).getStatus())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"CANNOTEDIT"));
                return;
            }
            if (!coll.get(i).isIsVehicle()) continue;
            isSelectVehicle = true;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"idSet", idSet);
        uiContext.put((Object)"isSelectVehicle", (Object)isSelectVehicle);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BATCHEDITTCCUI_CLASS, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionGeneticMatchTcc_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        ArrayList ids = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        ProductCodeCollection coll = ProductCodeFactory.getRemoteInstance().getProductCodeCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            if (!ProductCodeStatusEnum.USING.equals((Object)coll.get(i).getStatus())) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"CANNOTEDIT"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ids", (Object)ids);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PRODUCTGENETICMATCHTCCUI_CLASS, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "productCode";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "productCode";
        param.datataskMode = 1;
        param.alias = EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"ExportExcelName");
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception e) {
            logger.error((Object)"get filter error");
            this.handUIException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            ProductCodeInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && !this.uiHelper.isAddNew(action) && (info = ProductCodeFactory.getRemoteInstance().getProductCodeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCU() != null) {
                    pk = new ObjectUuidPK(info.getCU().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = this.uiHelper.getHasPermissionOrgFilterForQuery();
        return filter;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
    }

    public boolean isAutoIgnoreZero() {
        return false;
    }

    public void refreshList() throws Exception {
        this.saveCurrentLocation();
        super.refreshList();
        this.restoreCurrentLocation();
    }

    public void handUIException(Throwable exc) {
        if (TMMsgBox.handUIException((Component)((Object)this), (Throwable)exc, (String)"IMK")) {
            super.handUIException(exc);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new IMCommonProcessor());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(300);
        }
        return this.commonQueryDialog;
    }
}

