/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.basedata.client.AbstractProductTaxRateUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ProductTaxRateUI
extends AbstractProductTaxRateUI {
    private static final Logger logger = CoreUIObject.getLogger(ProductTaxRateUI.class);
    private static final String TB_OLDTAXRATE = "oldTaxRate";
    private static final String TB_NEWTAXRATE = "newTaxRate";
    private KDTEditAdapter entryTableChange = null;

    public void onLoad() throws Exception {
        this.kDTable.checkParsed();
        KDFormattedTextField rate = new KDFormattedTextField();
        rate.setDataType(1);
        rate.setMaximumValue((Comparable)BigDecimal.ONE);
        rate.setMinimumValue((Comparable)BigDecimal.ZERO);
        rate.setPrecision(4);
        rate.setSupportedEmpty(true);
        rate.setNegatived(false);
        rate.setRemoveingZeroInEdit(false);
        rate.setRemoveingZeroInDispaly(false);
        rate.setHorizontalAlignment(0);
        KDTDefaultCellEditor rateEditor = new KDTDefaultCellEditor((JTextField)rate);
        this.kDTable.getColumn(TB_OLDTAXRATE).setEditor((ICellEditor)rateEditor);
        this.kDTable.getColumn(TB_NEWTAXRATE).setEditor((ICellEditor)rateEditor);
        this.kDTable.addRow();
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        ProductTaxRateUI.this.kdtEntries_ChangedStopped(e);
                    }
                    catch (Exception exc) {
                        ProductTaxRateUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.kDTable.addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void kdtEntries_ChangedStopped(KDTEditEvent e) throws Exception {
        BigDecimal taxRate;
        Object value;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.kDTable.getRow(rowIndex);
        String fieldName = this.kDTable.getColumnKey(colIndex);
        if ((TB_OLDTAXRATE.equals(fieldName) || TB_NEWTAXRATE.equals(fieldName)) && (value = e.getValue()) != null && ((taxRate = (BigDecimal)value).compareTo(BigDecimal.ZERO) < 0 || taxRate.compareTo(BigDecimal.ONE) >= 0)) {
            row.getCell(fieldName).setValue(e.getOldValue());
            return;
        }
    }

    @Override
    public void actionAddByTaxRate_actionPerformed(ActionEvent e) throws Exception {
        HashMap<Object, Object> rateMap = new HashMap<Object, Object>();
        HashMap<BigDecimal, Integer> dataMap = new HashMap<BigDecimal, Integer>();
        String suffix = this.txtSuffix.getText();
        StringBuffer errorMsg = new StringBuffer();
        boolean isEmptyEntry = true;
        if (suffix == null || suffix.trim().isEmpty()) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"SuffixNull"));
            errorMsg.append("\r\n");
        } else {
            rateMap.put("suffix", suffix.trim());
        }
        for (int i = 0; i < this.kDTable.getRowCount3(); ++i) {
            IRow row = this.kDTable.getRow(i);
            BigDecimal oldRate = (BigDecimal)row.getCell(TB_OLDTAXRATE).getValue();
            BigDecimal newRate = (BigDecimal)row.getCell(TB_NEWTAXRATE).getValue();
            if (oldRate == null && newRate == null) continue;
            if (oldRate == null || newRate == null) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"RateNull", (Object[])new Object[]{i + 1}));
                errorMsg.append("\r\n");
                continue;
            }
            if (oldRate.compareTo(newRate) == 0) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"RateEquals", (Object[])new Object[]{i + 1}));
                errorMsg.append("\r\n");
                continue;
            }
            if (dataMap.containsKey(oldRate)) {
                errorMsg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"OldRateEquals", (Object[])new Object[]{i + 1, dataMap.get(oldRate)}));
                errorMsg.append("\r\n");
                continue;
            }
            dataMap.put(oldRate, i + 1);
            rateMap.put(oldRate, newRate);
            isEmptyEntry = false;
        }
        if (isEmptyEntry) {
            errorMsg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"EntryNull"));
            errorMsg.append("\r\n");
        }
        if (errorMsg.length() > 0) {
            MsgBox.showInfo((String)errorMsg.toString());
        } else if (rateMap.size() > 1) {
            Map addByTaxRate = ProductCodeFactory.getRemoteInstance().addByTaxRate(rateMap);
            String msg = addByTaxRate.get("errorMsg").toString();
            if (msg.length() > 0) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"AddByTaxRateError", (Object[])new Object[]{addByTaxRate.get("success"), addByTaxRate.get("error")}), (String)msg, (int)1);
            } else if (Integer.parseInt(String.valueOf(addByTaxRate.get("success"))) == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"NotEligibleData"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"AddByTaxRateSuccess", (Object[])new Object[]{addByTaxRate.get("success")}));
            }
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable.addRow();
        this.btnRemoveLine.setEnabled(true);
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kDTable);
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            this.kDTable.removeRow(selectRows[i]);
        }
        if (this.kDTable.getRowCount() == 0) {
            this.btnRemoveLine.setEnabled(false);
        }
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable == null) {
            return;
        }
        if (this.kDTable.getSelectManager().size() > 0) {
            int top = this.kDTable.getSelectManager().get().getTop();
            if (this.isTableColumnSelected(this.kDTable)) {
                this.kDTable.addRow();
            } else {
                this.kDTable.addRow(top);
            }
        } else {
            this.kDTable.addRow();
        }
        this.btnRemoveLine.setEnabled(true);
    }

    protected boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }
}

