/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.client.AbstractTaxClassificationCodeListUI;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TaxClassificationCodeListUI
extends AbstractTaxClassificationCodeListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxClassificationCodeListUI.class);
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    public static final String strTakeOutZeroFormat = "%{0.##########}f";
    private int invoicePercent = 0;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    public TaxClassificationCodeListUI() throws Exception {
        this.uiHelper = new ListUIHelper((ListUI)this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.tblMainRefresh();
    }

    private void tblMainRefresh() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode().getText().equals(this.getRootName())) {
                this.mainQuery.setFilter(filterInfo);
                this.setTheFirstFillData(true);
                this.tblMain.repaint();
                this.tblMain.removeRows();
            } else if (this.getSelectedTreeNode() != null) {
                TaxClassificationCodeInfo info = (TaxClassificationCodeInfo)this.getSelectedTreeNode().getUserObject();
                try {
                    filterInfo = new FilterInfo("longnumber like '" + info.getLongNumber() + "%'");
                }
                catch (ParserException e) {
                    this.handUIException(e);
                }
                this.mainQuery.setFilter(filterInfo);
            }
            this.setTheFirstFillData(true);
            this.tblMain.repaint();
            this.tblMain.removeRows();
        } else {
            this.mainQuery.setFilter(filterInfo);
            this.setTheFirstFillData(true);
            this.tblMain.repaint();
            this.tblMain.removeRows();
        }
    }

    protected int getTreeInitialLevel() {
        return 6;
    }

    protected void initTree() throws Exception {
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        }
        super.initTree();
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.tm.im.BaseDataResource", (String)"TaxClassificationCode");
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.im.basedata.client.TaxClassificationCodeEditUI";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return TaxClassificationCodeFactory.getRemoteInstance();
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0);
        }
        if (!task.isCanceld()) {
            TaxClassificationCodeFactory.getRemoteInstance().importComplete();
            this.initTree();
            this.tblMainRefresh();
        }
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "taxClassificationCode";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<ArrayList> ids = new ArrayList<ArrayList>();
        ids.add(this.getSelectedIdValues());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (!this.confirmRemove()) {
            return;
        }
        this.doInDeamon(e);
    }

    private void doInDeamon(ActionEvent e) {
        this.invoicePercent = 0;
        String parentTxt = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "DeleteAction", IMUtils.getLocale());
        final MonitorInfo info = new MonitorInfo(parentTxt, null, (Object)this, true);
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    TaxClassificationCodeListUI.this.removeCode();
                }
                catch (Exception ex) {
                    TaxClassificationCodeListUI.this.handUIException(ex);
                }
                catch (Throwable ex) {
                    TaxClassificationCodeListUI.this.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor(info);
                MyThreadPool.destroyPorgressDialog();
            }

            @Override
            public void refreshProgress() {
                MyThreadPool.refreshProgress(TaxClassificationCodeListUI.this.invoicePercent);
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread(info);
        MyThreadPool.setBackgroundRunButtonEnabled(false);
    }

    private void removeCode() throws Exception {
        this.invoicePercent = 10;
        ArrayList result = TaxClassificationCodeFactory.getRemoteInstance().batchDelete(this.getSelectedIdValues());
        this.invoicePercent = 100;
        String error = "";
        String errorDetail = "";
        if (result.isEmpty()) {
            error = EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"REMOVE_SUCCESS");
        } else {
            error = EASResource.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"REMOVE_ERROR");
            errorDetail = IMUtils.buildErrorMsg(result);
        }
        MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
        this.tblMainRefresh();
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "taxClassificationCode";
        param.datataskMode = 1;
        param.alias = this.getRootName();
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            TaxClassificationCodeInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && !this.uiHelper.isAddNew(action) && (info = TaxClassificationCodeFactory.getRemoteInstance().getTaxClassificationCodeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCU() != null) {
                    pk = new ObjectUuidPK(info.getCU().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("taxRate").getStyleAttributes().setNumberFormat(strTakeOutZeroFormat);
    }
}

