/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.RushRedReasonEnum;
import com.kingdee.eas.tm.im.client.AbstractBatchRedUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BatchRedUI
extends AbstractBatchRedUI {
    private static final Logger logger = CoreUIObject.getLogger(BatchRedUI.class);
    private List ids = null;
    private Map numMap = null;
    private ItemListener comboRushRedReasonChange = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() {
        this.initParams();
        this.initDefaultValue();
        this.initListeners();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BatchRedUI.this.btnOK.requestFocus();
            }
        });
    }

    protected void initParams() {
        this.ids = (List)this.getUIContext().get("ids");
        this.numMap = (Map)this.getUIContext().get("numMap");
    }

    private void initDefaultValue() {
        this.comboRushRedReason.removeAllItems();
        this.comboRushRedReason.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboRushRedReason.addItems(RushRedReasonEnum.getEnumList().toArray());
        this.comboRushRedReason.setSelectedItem((Object)RushRedReasonEnum.MakeInvWrong);
        this.chkIsRedBlueSourceBill.setSelected(true);
    }

    private void initListeners() {
        if (this.comboRushRedReasonChange == null) {
            this.comboRushRedReasonChange = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    BatchRedUI.this.comboRushRedReason_dataChanged();
                }
            };
        }
        this.comboRushRedReason.addItemListener(this.comboRushRedReasonChange);
    }

    protected void comboRushRedReason_dataChanged() {
        if (RushRedReasonEnum.MakeInvWrong.equals(this.comboRushRedReason.getSelectedItem())) {
            this.chkIsRedBlueSourceBill.setSelected(true);
        } else {
            this.chkIsRedBlueSourceBill.setSelected(false);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        boolean isRedBlueSourceBill = this.chkIsRedBlueSourceBill.isSelected();
        String rushRedReason = null;
        if (this.comboRushRedReason.getSelectedItem() != null && !this.comboRushRedReason.getSelectedItem().equals((Object)FilterCommonStatusEnum.NULL)) {
            rushRedReason = ((RushRedReasonEnum)((Object)this.comboRushRedReason.getSelectedItem())).getValue();
        }
        Map result = MakeInvoiceFactory.getRemoteInstance().batchRed(this.ids, isRedBlueSourceBill, rushRedReason);
        int billSize = this.ids.size();
        int failed = Integer.parseInt(result.get("ERROR_COUNT").toString());
        String errorMsg = (String)result.get("ERRORMSG");
        this.actionExitCurrent_actionPerformed(e);
        MsgBox.showDetailAndOK((Component)((Object)this), (String)IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BatchRed_MSG", this.getLocale(), new Object[]{billSize - failed, failed}), (String)errorMsg, (int)1);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

