/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.framework.util.KDTableUtil;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tm.im.IncomeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.client.AbstractIncomeInvoiceExchangeUI;
import com.kingdee.eas.tm.im.client.IncomeInvoiceListUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IncomeInvoiceExchangeUI
extends AbstractIncomeInvoiceExchangeUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeInvoiceExchangeUI.class);
    private IncomeInvoiceListUI listUI = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = this.getUIContext();
        uiCtx.put("ExchangeFilter", this.buildBOTPFilter());
        ListUI billListUI = (ListUI)UIFactoryHelper.initUIObject((String)"com.kingdee.eas.tm.im.client.IncomeInvoiceListUI", (Map)uiCtx, null, (String)"FINDVIEW");
        this.viewPanel.setLayout((LayoutManager)new BorderLayout());
        billListUI.getUIContentPane().setSize(new Dimension(780, 527));
        KDTable kdTable = billListUI.getMainTable();
        kdTable.setBounds(new Rectangle(0, 0, 780, 527));
        billListUI.setVisible(true);
        this.viewPanel.add((Component)billListUI, (Object)"Center");
        this.viewPanel.validate();
        this.txtInvoiceCode.setText((String)uiCtx.get("invoiceCode"));
        this.txtInvoiceNumber.setText((String)uiCtx.get("invoiceNumber"));
        this.listUI = (IncomeInvoiceListUI)billListUI;
    }

    private EntityViewInfo buildBOTPFilter() {
        EntityViewInfo botpFilter = new EntityViewInfo();
        String billingCompany = (String)this.getUIContext().get("billcompany");
        BigDecimal amount = new BigDecimal((String)this.getUIContext().get("amount"));
        String companyId = (String)this.getUIContext().get("companyId");
        StringBuffer defaultFilter = new StringBuffer();
        defaultFilter.append(" billingCompany='" + billingCompany + "' and status = '0' and bizBIllTypeID is null and isAccept = 1  and company.id ='" + companyId + "' and id not in (select FDESTOBJECTID from T_BOT_Relation where FDESTENTITYID ='1343913D')");
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            defaultFilter.append(" and amount>0");
        } else if (amount.compareTo(BigDecimal.ZERO) < 0) {
            defaultFilter.append(" and amount<0");
        }
        FilterInfo filterInfo = new FilterInfo();
        try {
            filterInfo = new FilterInfo(defaultFilter.toString());
            botpFilter.setFilter(filterInfo);
        }
        catch (ParserException e) {
            this.handUIException(e);
        }
        return botpFilter;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.listUI.checkSelected();
        Map uiCtx = this.getUIContext();
        BigDecimal amount = new BigDecimal((String)uiCtx.get("amount"));
        BigDecimal nmoney = BigDecimal.ZERO;
        String[] money = KDTableUtil.getSelectRowFieldValue((KDTable)this.listUI.getDetailTable(), (String)"entries.taxTotal");
        for (int i = 0; i < money.length; ++i) {
            nmoney = nmoney.add(new BigDecimal(money[i]));
        }
        if (amount.compareTo(nmoney) != 0) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "UnequalAmount", IMUtils.getLocale()));
            return;
        }
        ArrayList desIdList = this.listUI.getSelectedIdValuesArrayList();
        String[] destCodes = KDTableUtil.getSelectRowFieldValue((KDTable)this.listUI.getDetailTable(), (String)"invoiceCode");
        String[] destNums = KDTableUtil.getSelectRowFieldValue((KDTable)this.listUI.getDetailTable(), (String)"invoiceNumber");
        String srcId = (String)this.getUIContext().get("billId");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("srcId", srcId);
        param.put("destIdList", desIdList);
        param.put("srcCode", this.txtInvoiceCode.getText());
        param.put("srcNum", this.txtInvoiceNumber.getText());
        param.put("destCodes", destCodes);
        param.put("destNums", destNums);
        param.put("companyId", (String)this.getUIContext().get("companyId"));
        Map result = IncomeInvoiceFacadeFactory.getRemoteInstance().exchangeInvoice(param);
        if ("exchangeInvoiceSuccess".equals(result.get("result"))) {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "ExchangeSuccess", IMUtils.getLocale()));
            this.getUIWindow().close();
        } else {
            MsgBox.showInfo((String)IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceHasReturnORExchange", IMUtils.getLocale()));
        }
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

