/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.ColConnFilterElement;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.RangeFilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMQueryFormat;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.FilterCommonStatusEnum;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.client.AbstractMakeInvoiceFilterUI;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MakeInvoiceFilterUI
extends AbstractMakeInvoiceFilterUI {
    private static final String F7_SUPPLIER_QUERY = "com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQueryWithDefaultStandard";
    private static final String F7_CUSTOMER_QUERY = "com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQueryWithDefaultStandard";
    private static final Logger logger = CoreUIObject.getLogger(MakeInvoiceFilterUI.class);
    private ItemListener kdComAsstActTypeChange = null;

    public MakeInvoiceFilterUI() throws Exception {
        this.getElementsInfo();
    }

    private void getElementsInfo() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new RangeFilterElement("number", (Component)this.prmtNumberFrom, (Component)this.prmtNumberTo));
        RangeFilterElement applicateDateElements = new RangeFilterElement("applicateDate", (Component)this.kDDateApplicateDateFrom, (Component)this.kDDateApplicateDateTo);
        applicateDateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)applicateDateElements);
        RangeFilterElement invoiceDateElements = new RangeFilterElement("invoiceDate", (Component)this.kDDateInvoiceDateFrom, (Component)this.kDDateInvoiceDateTo);
        invoiceDateElements.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        elements.add((FilterElement)invoiceDateElements);
        elements.add((FilterElement)new SingleFilterElement("status", (Component)this.kDComboStatus, (Object)FilterCommonStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("currentAccountType", (Component)this.kdComAsstActType, (Object)FilterCommonStatusEnum.NULL));
        elements.add((FilterElement)new SingleFilterElement("invoiceType", (Component)this.kDComboInvoiceType, (Object)PayInvoiceTypeEnum.DEFAULTTYPE));
        ColConnFilterElement mainOrgElement = new ColConnFilterElement("company.id", (Component)this.prmtCompany);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, SCMClientUtils.getResource((String)"MAINBIZORGISNULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, "company.id");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadStatus();
        this.setF7Filter();
        this.setDefaultValue();
        if (this.getMainBizOrgF7().getText() != null) {
            this.mainOrgChanged();
        }
        this.loadAsstActType();
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent arg0) {
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
        Object obj = this.kdComAsstActType.getSelectedItem();
        if (obj == null || obj instanceof FilterCommonStatusEnum) {
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            return;
        }
        this.prmtAcctCussentFrom.setEnabled(true);
        this.prmtAcctCussentTo.setEnabled(true);
        CurrentAccountType asstActType = (CurrentAccountType)((Object)obj);
        if (CurrentAccountType.CUSTOMER == asstActType) {
            this.prmtAcctCussentFrom.setQueryInfo(F7_CUSTOMER_QUERY);
            this.prmtAcctCussentTo.setQueryInfo(F7_CUSTOMER_QUERY);
        } else if (CurrentAccountType.SUPPLIER == asstActType) {
            this.prmtAcctCussentFrom.setQueryInfo(F7_SUPPLIER_QUERY);
            this.prmtAcctCussentTo.setQueryInfo(F7_SUPPLIER_QUERY);
        }
        this.prmtAcctCussentFrom.setHasCUDefaultFilter(false);
        this.prmtAcctCussentTo.setHasCUDefaultFilter(false);
    }

    private void loadAsstActType() {
        this.kdComAsstActType.removeAllItems();
        this.kdComAsstActType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.kdComAsstActType.addItem((Object)CurrentAccountType.CUSTOMER);
        this.kdComAsstActType.addItem((Object)CurrentAccountType.SUPPLIER);
    }

    private void loadStatus() {
        this.kDComboStatus.removeAllItems();
        this.kDComboStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.kDComboStatus.addItems(InvoiceBillStatus.getEnumList().toArray());
    }

    private void setF7Filter() {
        this.setBillNumberF7s(new KDBizPromptBox[]{this.prmtNumberFrom, this.prmtNumberTo});
        this.f7Manager.registerContextChangeF7(this.prmtNumberFrom, this.getPropertyOfMainBizOrg());
        this.f7Manager.registerContextChangeF7(this.prmtNumberTo, this.getPropertyOfMainBizOrg());
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected String getViewPermission() {
        return "im_makeInvoice_view";
    }

    protected String getPropertyOfMainBizOrg() {
        return "company.id";
    }

    protected void setDefaultValue() {
        SCMQueryFormat.formatStartTime((KDDatePicker)this.kDDateApplicateDateFrom);
        SCMQueryFormat.formatEndTime((KDDatePicker)this.kDDateApplicateDateTo);
        this.radioHead.setSelected(true);
        this.kDTextReceiveCompany.setText(null);
        this.kDTextTaxNumber.setText(null);
        this.kDTextInvoiceNo.setText(null);
        this.kdComAsstActType.setSelectedItem((Object)CurrentAccountType.CUSTOMER);
        this.kdComAsstActType_itemStateChanged(null);
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        Object obj;
        FilterItemInfo filterDisplay;
        FilterInfo filterInfo = super.getFilterInfo();
        FilterInfo newFilterInfo = new FilterInfo();
        if (this.radioHead.isSelected()) {
            filterDisplay = new FilterItemInfo("entry.seq", (Object)new Integer(1), CompareType.EQUALS);
            newFilterInfo.getFilterItems().add(filterDisplay);
        } else if (this.radioEntry.isSelected()) {
            filterDisplay = new FilterItemInfo("entry.seq", (Object)new Integer(0), CompareType.NOTEQUALS);
            newFilterInfo.getFilterItems().add(filterDisplay);
        }
        if (!StringUtils.isEmpty((String)this.kDTextReceiveCompany.getText())) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("receiveCompany", (Object)("%" + this.kDTextReceiveCompany.getText() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)this.kDTextTaxNumber.getText())) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)("%" + this.kDTextTaxNumber.getText() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)this.kDTextInvoiceNo.getText())) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)("%" + this.kDTextInvoiceNo.getText() + "%"), CompareType.LIKE));
        }
        if ((obj = this.kdComAsstActType.getSelectedItem()) != null && obj instanceof CurrentAccountType) {
            CurrentAccountType asstActType = (CurrentAccountType)((Object)obj);
            if (CurrentAccountType.CUSTOMER == asstActType) {
                CustomerInfo fromInfo = (CustomerInfo)this.prmtAcctCussentFrom.getValue();
                CustomerInfo toInfo = (CustomerInfo)this.prmtAcctCussentTo.getValue();
                newFilterInfo.getFilterItems().add(new FilterItemInfo("currentAccountType", (Object)asstActType.getValue(), CompareType.EQUALS));
                if (fromInfo != null) {
                    newFilterInfo.getFilterItems().add(new FilterItemInfo("currAcctCustomer.number", (Object)fromInfo.getNumber(), CompareType.GREATER_EQUALS));
                }
                if (toInfo != null) {
                    newFilterInfo.getFilterItems().add(new FilterItemInfo("currAcctCustomer.number", (Object)toInfo.getNumber(), CompareType.LESS_EQUALS));
                }
            } else if (CurrentAccountType.SUPPLIER == asstActType) {
                SupplierInfo fromInfo = (SupplierInfo)this.prmtAcctCussentFrom.getValue();
                SupplierInfo toInfo = (SupplierInfo)this.prmtAcctCussentTo.getValue();
                newFilterInfo.getFilterItems().add(new FilterItemInfo("currentAccountType", (Object)asstActType.getValue(), CompareType.EQUALS));
                if (fromInfo != null) {
                    newFilterInfo.getFilterItems().add(new FilterItemInfo("currAcctSupplier.number", (Object)fromInfo.getNumber(), CompareType.GREATER_EQUALS));
                }
                if (toInfo != null) {
                    newFilterInfo.getFilterItems().add(new FilterItemInfo("currAcctSupplier.number", (Object)toInfo.getNumber(), CompareType.LESS_EQUALS));
                }
            }
        }
        try {
            filterInfo.mergeFilter(newFilterInfo, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        return filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        int intValue;
        super.loadData(entityViewInfo);
        FilterItemCollection filters = entityViewInfo.getFilter().getFilterItems();
        Object obj = IMUtils.getCompareValue(filters, "receiveCompany", CompareType.LIKE);
        if (obj != null) {
            this.kDTextReceiveCompany.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextReceiveCompany.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "taxNumber", CompareType.LIKE);
        if (obj != null) {
            this.kDTextTaxNumber.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextTaxNumber.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "invoiceNo", CompareType.LIKE);
        if (obj != null) {
            this.kDTextInvoiceNo.setText(obj.toString().split("%")[1]);
        } else {
            this.kDTextInvoiceNo.setText(null);
        }
        obj = IMUtils.getCompareValue(filters, "entry.seq", CompareType.EQUALS);
        if (obj == null) {
            this.radioEntry.setSelected(true);
        } else if (obj instanceof Integer && (intValue = ((Integer)obj).intValue()) == 1) {
            this.radioHead.setSelected(true);
        }
        obj = IMUtils.getCompareValue(filters, "currentAccountType", CompareType.EQUALS);
        if (obj == null) {
            this.kdComAsstActType.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
            this.prmtAcctCussentFrom.setEnabled(false);
            this.prmtAcctCussentTo.setEnabled(false);
            this.prmtAcctCussentFrom.setValue(null);
            this.prmtAcctCussentTo.setValue(null);
        } else if ("1".equals(obj)) {
            this.kdComAsstActType.setSelectedItem((Object)CurrentAccountType.CUSTOMER);
            this.prmtAcctCussentFrom.setEnabled(true);
            this.prmtAcctCussentTo.setEnabled(true);
            Object fromObj = IMUtils.getCompareValue(filters, "currAcctCustomer.number", CompareType.GREATER_EQUALS);
            Object toObj = IMUtils.getCompareValue(filters, "currAcctCustomer.number", CompareType.LESS_EQUALS);
            try {
                if (fromObj != null) {
                    this.prmtAcctCussentFrom.setValue((Object)CustomerFactory.getRemoteInstance().getCustomerInfo("select id,number,name where number = '" + fromObj + "'"));
                }
                if (toObj != null) {
                    this.prmtAcctCussentTo.setValue((Object)CustomerFactory.getRemoteInstance().getCustomerInfo("select id,number,name where number = '" + toObj + "'"));
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        } else if ("2".equals(obj)) {
            this.kdComAsstActType.setSelectedItem((Object)CurrentAccountType.SUPPLIER);
            this.prmtAcctCussentFrom.setEnabled(true);
            this.prmtAcctCussentTo.setEnabled(true);
            Object fromObj = IMUtils.getCompareValue(filters, "currAcctSupplier.number", CompareType.GREATER_EQUALS);
            Object toObj = IMUtils.getCompareValue(filters, "currAcctSupplier.number", CompareType.LESS_EQUALS);
            try {
                if (fromObj != null) {
                    this.prmtAcctCussentFrom.setValue((Object)SupplierFactory.getRemoteInstance().getSupplierInfo("select id,number,name where number = '" + fromObj + "'"));
                }
                if (toObj != null) {
                    this.prmtAcctCussentTo.setValue((Object)SupplierFactory.getRemoteInstance().getSupplierInfo("select id,number,name where number = '" + toObj + "'"));
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
    }

    public void afterMainOrgChanged(String ids) {
        super.afterMainOrgChanged(ids);
        this.prmtNumberFrom.setValue(null);
        this.prmtNumberTo.setValue(null);
        if (ids == null) {
            return;
        }
        String[] idStr = ids.split(",");
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < idStr.length; ++i) {
            idSet.add(idStr[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1)));
        view.setFilter(filter);
        this.prmtAcctCussentFrom.setEntityViewInfo(view);
        this.prmtAcctCussentTo.setEntityViewInfo(view);
        this.prmtAcctCussentFrom.setValue(null);
        this.prmtAcctCussentTo.setValue(null);
    }
}

